{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
        Registry
}
unit SoRgstry;

interface
uses Windows, Registry;

{      }
function RegGetStringValue  (aRootKey : HKey; const Key, Name, DefaultValue : string) : string;
{      }
function RegGetIntegerValue (aRootKey : HKey; const Key, Name : string; DefaultValue : LongInt) : LongInt;

implementation

function RegGetStringValue  (aRootKey : HKey; const Key, Name, DefaultValue : string) : string;
var Reg : TRegistry;
begin
  Reg := TRegistry.Create;
  with Reg do begin
    RootKey := aRootKey;
    if OpenKey(Key, false) then
      Result := ReadString(Name)
    else Result := DefaultValue;
    Free;
  end;
end;

function RegGetIntegerValue (aRootKey : HKey; const Key, Name : string; DefaultValue : LongInt) : LongInt;
var Reg : TRegistry;
begin
  Reg := TRegistry.Create;
  with Reg do begin
    RootKey := aRootKey;
    if OpenKey(Key, false) then
      Result := ReadInteger(Name)
    else Result := DefaultValue;
    Free;
  end;
end;

end.
