{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoRghtsF;

{$I SOHOLIB.INC}

interface

uses Windows, Messages, SysUtils, Classes, Controls, Forms, StdCtrls,
     ComCtrls, SohoBtns, SoCtrls;

type
  TsohoDataRightsForm = class(TForm)
    sohoLabel10: TsohoLabel;
    sohoLabel1: TsohoLabel;
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    RecordValue: TTrackBar;
    RecFromL: TLabel;
    RecToL: TLabel;
    ColFromL: TLabel;
    ColumnValue: TTrackBar;
    ColToL: TLabel;
    RecPosE: TsohoEdit;
    ColPosE: TsohoEdit;
    procedure RecordValueChange(Sender: TObject);
    procedure ColumnValueChange(Sender: TObject);
    procedure RecPosEModify(Sender: TObject; OldValue, NewValue: String);
  private
    { Private declarations }
    aMin, aMax : byte;
    function SetDataRights (var FieldRights, RecordRights : byte; EnableRecord : boolean) : boolean;
  public
    { Public declarations }
  end;

var sohoDataRightsForm: TsohoDataRightsForm;

function SetDataRights (var FieldRights, RecordRights : byte; EnableRecord : boolean) : boolean;

implementation
uses SoCtmRgs, SoUtils, SoUnit;

{$R *.DFM}

procedure GetMinMax (var aMin, aMax : byte; Rights : SetOfByte);
var Index : byte;
begin
  for Index := 0 to 255 do
   if Index in Rights then begin
     aMin := Index;
     Break;
   end;
  for Index := 255 downto 0 do
   if Index in Rights then begin
     aMax := Index;
     Break;
   end;
end;

function SetDataRights (var FieldRights, RecordRights : byte; EnableRecord : boolean) : boolean;
begin
  try
    Result := false;
    sohoDataRightsForm := TsohoDataRightsForm.Create(Application);
    Result := sohoDataRightsForm.SetDataRights(FieldRights, RecordRights,
              EnableRecord);
  finally
    sohoDataRightsForm.Free;
  end;
end;

function TsohoDataRightsForm.SetDataRights (var FieldRights, RecordRights : byte; EnableRecord : boolean) : boolean;
var Reg : TsohoCustomRegister;
begin
  Reg := SingleRegister;
  GetMinMax(aMin, aMax, Reg.DataReadRights);
  RecFromL.Caption := IntToStr(aMin);
  RecToL.Caption := IntToStr(aMax);
  ColFromL.Caption := IntToStr(aMin);
  ColToL.Caption := IntToStr(aMax);
  with RecordValue do begin
    Enabled := EnableRecord;
    Min := aMin;
    Max := aMax;
    Position := RecordRights;
    SelEnd := Position;
    RecPosE.AsInteger := Position;
  end;
  with ColumnValue do begin
    Min := aMin;
    Max := aMax;
    Position := FieldRights;
    SelEnd := Position;
    ColPosE.AsInteger := Position;
  end;
  Result := ShowModal = mrOk;
  if not Result then exit;
  FieldRights  := ColumnValue.Position;
  if EnableRecord then RecordRights := RecordValue.Position;
end;

procedure TsohoDataRightsForm.RecordValueChange(Sender: TObject);
begin
  with RecordValue do begin
    SelEnd := Position;
    RecPosE.AsInteger := Position;
  end;
end;

procedure TsohoDataRightsForm.ColumnValueChange(Sender: TObject);
begin
  with ColumnValue do begin
    SelEnd := Position;
    ColPosE.AsInteger := Position;
  end;
end;

procedure TsohoDataRightsForm.RecPosEModify(Sender: TObject; OldValue,
  NewValue: String);
begin
  if (StrToInt(NewValue) > aMax) or
     (StrToInt(NewValue) < aMin) then NewValue := OldValue;
  if Sender=RecPosE then begin
    RecordValue.Position := RecPosE.AsInteger;
    RecordValue.SelEnd   := RecPosE.AsInteger;
  end;
  if Sender=ColPosE then begin
    ColumnValue.Position := ColPosE.AsInteger;
    ColumnValue.SelEnd   := ColPosE.AsInteger;
  end;
end;

end.
