{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoRepPrg;

{$I SOHOLIB.INC}


interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
     StdCtrls, SohoBtns, SoGauges;

type
  TsohoReportProgressForm = class(TForm)
    Gauge: TsohoGauge;
    StopB: TsohoBitBtn;
    MessageL: TLabel;
    procedure StopBClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Stopped : boolean;
    procedure SetMessage(Value : string);
  end;

var sohoReportProgressForm: TsohoReportProgressForm;

function CreateProgressDialog (const aCaption,
         aStartMessage : string) : TsohoReportProgressForm;

implementation

{$R *.DFM}

function CreateProgressDialog (const aCaption,
         aStartMessage : string) : TsohoReportProgressForm;
begin
  try
    Result := TsohoReportProgressForm.Create(Application);
    Result.Stopped := false;
    Result.Show;
    Result.Update;
  except
    Result := nil;
  end;
end;

procedure TsohoReportProgressForm.SetMessage(Value : string);
begin
  MessageL.Caption := Value;
  Update;
end;

procedure TsohoReportProgressForm.StopBClick(Sender: TObject);
begin
  Stopped := true;
  Close;
end;

end.
