{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoRepF;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, ExtCtrls, SoFolder, DB, DBTables, Grids, SoDBGrid, StdCtrls,
     SohoBtns, Placemnt, SoRxTls, SoTools, StrHlder, SoExlRep, SoUnit,
     Menus, SoGauges, DBGrids, RXDBCtrl, SoCtmFld;

type

  TsohoReportOnSummary = procedure (Sender : TObject; DataSet : TDataSet;
    GroupValue : string) of object;

  TsohoSummReportForm = class(TForm)
    Panel1: TPanel;
    sohoBitBtn1: TsohoBitBtn;
    Panel2: TPanel;
    ReportGrid: TsohoDBGrid;
    Folder: TsohoFolder;
    Ini: TsohoFormStorage;
    Field1: TStrHolder;
    Field2: TStrHolder;
    MultiRes: TStrHolder;
    PrintB: TsohoBitBtn;
    SummFields: TStrHolder;
    GroupC: TCheckBox;
    ReportSQL: TStrHolder;
    OnlyGroupC: TCheckBox;
    QuickC: TCheckBox;
    SummEditorMenu: TPopupMenu;
    SummFieldsM: TMenuItem;
    ReportQ: TQuery;
    ReportSource: TDataSource;
    TmpTableT: TTable;
    AddSummM: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure PrintBClick(Sender: TObject);
    procedure ReporterPutRecord(Sender: TObject; DataSet: TDataSet;
      Row: Integer);
    procedure GroupCClick(Sender: TObject);
    procedure OnlyGroupCClick(Sender: TObject);
    procedure SummFieldsMClick(Sender: TObject);
    procedure ReportGridGetCellProps(Sender: TObject; Field: TField;
      AFont: TFont; var Background: TColor);
    procedure TmpTableTFilterRecord(DataSet: TDataSet;
      var Accept: Boolean);
    procedure AddSummMClick(Sender: TObject);
  private
    { Private declarations }
    FOnSummary : TsohoReportOnSummary;
  public
    { Public declarations }
    KeyField: string;
    CommentField: string;
    Reporter: TsohoExcelReporter;
    FBaseDir : string;
    CanAdd: boolean;
    aTemplate: string;
    aTemplateDir: string;
    aSummGroup: boolean;
    ProgressGauge : TsohoGauge;
    procedure PrepareFields;
    procedure NewRecordPrepare;
    procedure NewRecordMultiply;
    procedure AddSummRecord;
    procedure DoRecalc;
    procedure GetLastSumm;
    procedure PrepareCalcReport;
    property OnSummary : TsohoReportOnSummary read FOnSummary write FOnSummary;
  end;

const

  ReportSection = 'Report Additional Fields';
  ReportField   = 'SOREPF';
  GroupField    = 'SOGRPF';

    //  0 - Any
    // -1 - Groupsumm
    // -2 - AllSumm
    // -3 - Spec

implementation
uses SoBDERtn, SoDbRtn, SoUtils, SohoOLE, SoSmRp, SoCtmRgs;

{$R *.DFM}

{           }
procedure TsohoSummReportForm.PrepareFields;
var index: Longint;
  FieldName1, FieldName2: string;
  AddFields             : string;
  AddCount              : Longint;

  procedure AddCalcFields(Fields: string);
  begin
    FieldName1 := AnsiUpperCase(GetSomeWords(Fields, 1, 1));
    FieldName2 := AnsiUpperCase(GetSomeWords(Fields, 2, 2));
    Field1.Strings.Add(FieldName1);
    Field2.Strings.Add(FieldName2);
    if SummFields.Strings.IndexOf(FieldName1) = -1 then SummFields.Strings.Add(FieldName1);
    if SummFields.Strings.IndexOf(FieldName2) = -1 then SummFields.Strings.Add(FieldName2);
    MultiRes.Strings.Add('0');
  end;
begin
  SetDivisers(['|']);
  Field1.Clear;
  Field2.Clear;
  MultiRes.Clear;
  SummFields.Clear;
  with Folder.Ini do begin
    AddCount := ReadInteger(ReportSection, 'FieldsCount', 0);
    if AddCount <> 0 then
      for index := 1 to AddCount do begin
        AddFields := ReadString(ReportSection, 'Fields' + IntToStr(index), '');
        AddCalcFields(AddFields);
      end;
  end;
end;

{    ,      
   }
procedure TsohoSummReportForm.NewRecordPrepare;
var index: Longint;
  Value: Double;
begin
  with TmpTableT do begin
    Edit;
    for index := 0 to pred(Field1.Strings.Count) do begin
      if Field1.Strings[index] <> Field2.Strings[index] then
        Value := ReportQ.FieldByName(Field1.Strings[index]).AsFloat *
        ReportQ.FieldByName(Field2.Strings[index]).AsFloat
      else Value := ReportQ.FieldByName(Field1.Strings[index]).AsFloat;
      MultiRes.Strings[index] := FloatToStr(Value);
      FieldByName(ReportField + IntToStr(index)).AsFloat := Value;
    end;
    Post;
  end;
end;

{    .     }
procedure TsohoSummReportForm.NewRecordMultiply;
var index: Longint;
  Value: Double;
begin
  with TmpTableT do begin
    Edit;
    for index := 0 to pred(Field1.Strings.Count) do begin
      if Field1.Strings[index] <> Field2.Strings[index] then begin
        Value := ReportQ.FieldByName(Field1.Strings[index]).AsFloat *
          ReportQ.FieldByName(Field2.Strings[index]).AsFloat;
        MultiRes.Strings[index] := FloatToStr(
          StrToFloat(MultiRes.Strings[index]) + Value);
        FieldByName(ReportField + IntToStr(index)).AsFloat := Value;
      end
      else begin
        Value := ReportQ.FieldByName(Field1.Strings[index]).AsFloat;
        MultiRes.Strings[index] := FloatToStr(
          StrToFloat(MultiRes.Strings[index]) + Value);
        FieldByName(ReportField + IntToStr(index)).AsFloat := Value;
      end;
    end;
    Post;
  end;
end;

{  ""    }
procedure TsohoSummReportForm.AddSummRecord;
var index: Longint;
    TmpList: TStringList;
    Field  : TField;
    GroupValue : string;
begin
  TmpList := TStringList.Create;
  with TmpTableT do begin
    //      
    for index := 0 to pred(FieldCount) do
      TmpList.Add(Fields[index].AsString);
    GroupValue := FieldByName(KeyField).AsString;
    Append;
    FieldByName(GroupField).AsInteger := -1;
    if OnlyGroupC.Checked then
    else FieldByName(CommentField).AsString := ' :';
    for index := 0 to pred(Field1.Strings.Count) do
      FieldByName(ReportField + IntToStr(index)).AsFloat := StrToFloat(MultiRes.Strings[index]);
    if Assigned(FOnSummary) then FOnSummary(Self, TmpTableT, GroupValue);
    Post;
    //     
    Append;
    for index := 0 to pred(FieldCount) do begin
      Field := Fields[index];
      if Field.FieldName <> GroupField then
        try
          case Field.DataType of
            ftString: Field.AsString := TmpList[index];
            ftInteger: Field.AsInteger := StrToInt(TmpList[index]);
            ftBoolean: Field.AsBoolean := StrToBool(TmpList[index]);
            ftFloat: Field.AsFloat := StrToFloat(TmpList[index]);
            ftDate: Field.AsDateTime := StrToDate(TmpList[index]);
            ftTime: Field.AsDateTime := StrToTime(TmpList[index]);
          end;
        except { nothing to do };
        end;
    end;
    FieldByName(GroupField).AsInteger := -3;
    for index := 0 to pred(Field1.Strings.Count) do
      FieldByName(ReportField + IntToStr(index)).AsFloat := StrToFloat(MultiRes.Strings[index]);
    Post;
    TmpList.Free;
  end;
end;

procedure TsohoSummReportForm.GetLastSumm;
var index: Longint;
  GroupInt: Longint;
begin
  with TmpTableT do begin
    for index := 0 to pred(MultiRes.Strings.Count) do
      MultiRes.Strings[index] := '0';
    First;
    while not EOF do begin
      GroupInt := FieldByName(GroupField).AsInteger;
      if GroupInt = -1 then begin
        for index := 0 to pred(MultiRes.Strings.Count) do
          MultiRes.Strings[index] := FloatToStr(
          StrToFloat(MultiRes.Strings[index]) +
          FieldByName(ReportField + IntToStr(index)).AsFloat);
      end;
      Next;
    end;
    Append;
    FieldByName(GroupField).AsInteger := -2;
    FieldByName(CommentField).AsString := ' :';
    for index := 0 to pred(Field1.Strings.Count) do
      FieldByName(ReportField + IntToStr(index)).AsFloat := StrToFloat(MultiRes.Strings[index]);
    Post;
  end;
end;

procedure TsohoSummReportForm.DoRecalc;
var LastId: string;
begin
  with TmpTableT do begin
    LastId := '';
    if Assigned(ProgressGauge) then
     with ProgressGauge do begin
      MaxValue := ReportQ.RecordCount;
      Progress := 0;
      Caption := '...';
     end;
    repeat
      if not ReportQ.EOF then begin
        if ReportQ.FieldByName(KeyField).AsString <> LastId then begin
          if CanAdd then AddSummRecord;
          LastId := ReportQ.FieldByName(KeyField).AsString;
          CopyRecord(ReportQ, TmpTableT, True);
          NewRecordPrepare;
          CanAdd := True;
        end
        else begin
          CopyRecordWithSumm(ReportQ, TmpTableT, aSummGroup,
            TStringList(SummFields.Strings));
          NewRecordMultiply;
        end;
        if Assigned(ProgressGauge) then ProgressGauge.AddProgress(1);
        ReportQ.Next;
      end;
    until ReportQ.EOF;
    if CanAdd then AddSummRecord;
    GetLastSumm;
    ReportQ.Close;
    EnableControls;
    Folder.LoadDBGridColumns;
    if Assigned(ProgressGauge) then ProgressGauge.Progress := 0;
  end;
end;

procedure TsohoSummReportForm.PrepareCalcReport;
var index: Longint;
  TmpBaseDir: string;
begin
  ReportQ.DataBaseName := FBaseDir;
  ReportQ.SQL.Assign(ReportSQL.Strings);
  ReportSQL.Strings.SaveToFile(GetPathToLocalTemp+'result.sql');
  try
    ReportQ.Open;
  except exit;
  end;
  {  }
  SetCursor(crHourGlass);
  if Folder.Activated then Folder.SaveDBGridColumns;
  TmpTableT.Close;
  TmpBaseDir := GetPathToLocalTemp;
  //   
  SysUtils.DeleteFile(TmpBaseDir + 'REPORT.DB');
  //       ReportQ
  CreateTableByDataSet(ReportQ, TmpBaseDir + 'REPORT.DB');
  //      
  for index := 0 to pred(Field1.Strings.Count) do
    AddFieldToTable(TmpBaseDir, 'REPORT.DB', ReportField + IntToStr(index),
    ftFloat, 0);
  //        
  AddFieldToTable(TmpBaseDir, 'REPORT.DB', GroupField,
    ftInteger, 0);
  with TmpTableT do begin
    DataBaseName := TmpBaseDir;
    TableName := 'REPORT.DB';
    Open;
    ReportQ.First;
    CanAdd := False;
    if KeyField = '' then KeyField := ReportQ.Fields[0].FieldName;
    if CommentField = '' then CommentField := 'Name';
    DoRecalc;
  end;
  RestoreCursor;
  ReportSource.DataSet := TmpTableT;
  Folder.LoadDBGridColumns;
end;


procedure TsohoSummReportForm.FormShow(Sender: TObject);
begin
  Folder.Activate;
end;

procedure TsohoSummReportForm.PrintBClick(Sender: TObject);
var ReportsDir : string;
begin
  {    Excel }
  with Reporter do begin
    //SetValueByName('#', GradientCaption.FormCaption);
    SetValueByName('#', Caption);
    QuickPrint := QuickC.Checked;
    ReportsDir := '';
    if aTemplateDir <> '' then PrintDocuments({ReportsDir + }aTemplateDir, '')
    else PrintDocument({ReportsDir + }aTemplate, '')
  end;
end;

procedure TsohoSummReportForm.ReporterPutRecord(Sender: TObject; DataSet: TDataSet;
    Row: Integer);
var GroupInt: Longint;
begin
  if ReportSource.DataSet <> TmpTableT then exit;
  GroupInt := TmpTableT.FieldByName(GroupField).AsInteger;
  if (GroupInt = -1) or (GroupInt = -2) then
    SetCellsBackground(Reporter.Sheet,
    ExcelRectToStr(Reporter.FromColumn, Row, Reporter.ToColumn, Row),
    clSilver);
end;

procedure TsohoSummReportForm.GroupCClick(Sender: TObject);
begin
  aSummGroup := not GroupC.Checked;
  RefreshDataSetFilter(TmpTableT);
end;

procedure TsohoSummReportForm.OnlyGroupCClick(Sender: TObject);
begin
  GroupC.Enabled := not OnlyGroupC.Checked;
  if not GroupC.Enabled then GroupC.Checked := False;
  GroupCClick(GroupC);
end;

procedure TsohoSummReportForm.SummFieldsMClick(Sender: TObject);
begin
  EditSummFields(Folder);
end;

procedure TsohoSummReportForm.ReportGridGetCellProps(Sender: TObject;
  Field: TField; AFont: TFont; var Background: TColor);
var GroupInt: Longint;
begin
  if ReportSource.DataSet <> TmpTableT then exit;
  GroupInt := TmpTableT.FieldByName(GroupField).AsInteger;
  if (GroupInt = -1) or (GroupInt = -2) then begin
    Background := $00DDDDDD;
    AFont.Color := clBlack;
  end;
end;

procedure TsohoSummReportForm.TmpTableTFilterRecord(DataSet: TDataSet;
  var Accept: Boolean);
var GroupInt: Longint;
begin
  Accept := True;
  if ReportSource.DataSet <> TmpTableT then exit;
  GroupInt := TmpTableT.FieldByName(GroupField).AsInteger;

  if OnlyGroupC.Checked then begin
    Accept := ((GroupInt = -2) or (GroupInt = -3));
  end
  else begin
    //  0 - Any
    // -1 - Groupsumm
    // -2 - AllSumm
    // -3 - Spec
    if GroupC.Checked then Accept := not (GroupInt = -3)
    else Accept := not ((GroupInt = -3) or (GroupInt = -1));
  end;
end;

procedure TsohoSummReportForm.AddSummMClick(Sender: TObject);
var Tmp : TStringList;
    NewLabel : string;
    NewCount : LongInt;
    GridWidth : integer;
begin
  if (ReportGrid.SelectedField = nil) or
     (Pos(ReportField, StrUpper(ReportGrid.SelectedField.FieldName))<>0)  then exit;
  Tmp := TStringList.Create;
  with Folder.Ini do begin
    ReadSection(ReportSection, Tmp);
    NewLabel := ReportGrid.SelectedField.DisplayLabel;
    GridWidth := ReportGrid.ColWidths[ReportGrid.SelectedIndex];
    ReportGrid.SelectedField.DisplayLabel := ReportGrid.SelectedField.DisplayLabel +
      '  ';
    Folder.LoadDBGridColumns;
    ReportGrid.SelectedField.Visible := false;
    NewCount := Tmp.Count + 1;
    if (Tmp.Count>0) and (StrUpper(Tmp[0]) = 'FIELDSCOUNT') then dec(NewCount);
    WriteInteger(ReportSection, 'FieldsCount', NewCount);
    WriteString(ReportSection, 'Fields'+IntToStr(NewCount),
      ReportGrid.SelectedField.FieldName+'|'+ReportGrid.SelectedField.FieldName);

    {NewField := TField.Create(Self);
    NewField :=}

    WriteString(ReportField+IntToStr(NewCount-1), 'DisplayLabel', NewLabel);
    WriteInteger(ReportField+IntToStr(NewCount-1), 'Index', ReportGrid.SelectedField.Index);
    WriteInteger(ReportField+IntToStr(NewCount-1), 'GridWidth', GridWidth);
    WriteString('Fields', ReportField+IntToStr(NewCount-1), 'Stored');
    if IsProperty(ReportGrid.SelectedField, 'DisplayFormat') then
      WriteString(ReportField+IntToStr(NewCount-1), 'DisplayFormat',
      GetStringProperty(ReportGrid.SelectedField, 'DisplayFormat'));
  end;
  Tmp.Free;
  InfoMsg('         ');
end;

end.

