{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                  Written by Allex                     }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoQuickSearch
}
unit SoQSrch;

{$I SOHOLIB.INC}


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DB;

type
  PIndex = ^TIndex;
  TIndex = array[0..100] of PString; {   }

  PIDIndex = ^TIDIndex;
  TIDIndex = array[0..100] of LongInt;{   }

  EQuickSearch = class(Exception);{  }

  { TsohoQuickSearch ""  DataSet.
    RunTime =Activate/Deactivate;   FieldList   
         Deactivate;
    =
      =   
      =  
      =  .  
      =   
     =   
             
  }
  TsohoQuickSearch = class(TEdit)
  private
    { Private declarations }
    Locked:Boolean; { , }
    BookMark:TBookMark; {   }
    IndexMark:LongInt;  {  }
    FActive       : boolean;
    FAutoSearch   : boolean;
    FControl      : TWinControl;
    FDataSet      : TDataSet;
    FFieldsList   : TStrings;
    FAfterOpen    : TDataSetNotifyEvent;
    FAfterPost    : TDataSetNotifyEvent;
    FAfterClose   : TDataSetNotifyEvent;
    FBeforeDelete : TDataSetNotifyEvent;
    FID           : Boolean;
    FKeyField     : string;
  protected
    { Protected declarations }
    SearchSuccess : boolean;
    procedure Change; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure EraseLastSymbol;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure Search(Direct : ShortInt);
    procedure SetActive(Value : boolean);
    procedure SetFieldsList(Value: TStrings);
    procedure AfterOpen(DataSet:TDataSet);
    procedure AfterPost(DataSet:TDataSet);
    procedure AfterClose(DataSet:TDataSet);
    procedure BeforeDelete(DataSet:TDataSet);
    procedure ActivateEvents;
    procedure DeActivateEvents;
    procedure LoadData;
    procedure FreeData;
    procedure Test;
    function FindID(DataSet : TDataSet) : LongInt;
    function GetIndex : string;
  public
    { Public declarations }
    FIndex     : PIndex;
    FIDIndex   : PIDIndex;
    FIndexSize : LongInt;
    FIndexNumb : LongInt;
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure Activate; {    }
    procedure DeActivate;{     }
    procedure GotoNext;{  ,   }
    procedure GotoPrior;{}
    procedure GotoFirst;{}
    procedure GotoLast;{}
    procedure SavePosition;{ }
    procedure RestorePosition;{ }
  published
    { Published declarations }
    property Active     : boolean read FActive write SetActive;{ - Activate & Deactivate}
    property AutoSearch : boolean read FAutoSearch write FAutoSearch;{,      }
    property Control    : TWinControl read FControl write FControl;{    Enter  Esc}
    property DataSet    : TDataSet read FDataSet write FDataSet;{   }
    property FieldsList : TStrings read FFieldsList write SetFieldsList;{ ,    }
    property Use_ID_asIndex:Boolean read fID write fID;{ DataSet=Table     ID   }
    property KeyField : string read FKeyField write FKeyField;
  end;

implementation
uses DBTables;

constructor TsohoQuickSearch.Create(AOwner : TComponent);
begin {    }
  inherited Create(AOwner);
  FFieldsList := TStringList.Create;
  FIndexSize := 0;
  FIndex := nil;
  FIDIndex := nil;
  Locked:=False;
  BookMark:=nil;
  FKeyField := 'Id';
end;

procedure TsohoQuickSearch.SavePosition;
begin
  if Assigned(BookMark) then FDataSet.FreeBookMark(BookMark);
  BookMark:=FDataSet.GetBookMark;
  IndexMark:=FIndexNumb;
end;

procedure TsohoQuickSearch.RestorePosition;
begin
 if Assigned(BookMark) then
    try
     FDataSet.GotoBookMark(BookMArk);
     FIndexNumb:=IndexMark;
    except GotoFirst end
  else GotoFirst;
end;

destructor TsohoQuickSearch.Destroy;
begin {     }
  FFieldsList.Free;
  If Assigned(BookMark) then FDataSet.FreeBookMark(BookMark);
  if FActive then DeActivate;
  inherited Destroy;
end;

procedure TsohoQuickSearch.Activate;
var ws : string;
begin {      }
  if FActive then Exit;
  if not Assigned(FDataSet) then
    raise EQuickSearch.Create('QuickSearch.Activate : DataSet = nil');
  ActivateEvents;
  if FDataSet.Active then LoadData;
  FActive := True;
end;

procedure TsohoQuickSearch.DeActivate;
begin {      }
  if not FActive then exit;
  DeActivateEvents;
  FreeData;
  FActive := False;
  Text:='';
end;

procedure TsohoQuickSearch.GotoNext;
begin {        }
  Search(1);
end;

procedure TsohoQuickSearch.GotoPrior;
begin {        }
  Search(-1);
end;

procedure TsohoQuickSearch.GotoFirst;
begin {        }
  FIndexNumb := -1;
  Search(1);
end;

procedure TsohoQuickSearch.GotoLast;
begin {        }
  FIndexNumb := FIndexSize;
  Search(-1);
end;

procedure TsohoQuickSearch.Change;
begin {     }
  if Locked then Exit;
  inherited Change;
  if not AutoSearch then Exit;
  SavePosition;
  SearchSuccess := True;
  GotoFirst;
  if not SearchSuccess then begin
   RestorePosition;
   EraseLastSymbol;
  end;
end;

procedure TsohoQuickSearch.KeyDown(var Key: Word; Shift: TShiftState);
var wKey:word;
begin {    }
  wKey := Key;
{  if Key in [$6B,$6D] then Exit;}
  inherited KeyDown(Key, Shift);
  Key := 0;
  SearchSuccess := True;
  case wKey of
    vk_Down{,vk_Right} : begin
       GotoNext;
       if not SearchSuccess then GotoFirst;
    end;
    vk_Up : begin
      GotoPrior;
      If not SearchSuccess then GotoLast;
    end;
    vk_Left:begin
      Text:='';
    end;
    vk_Home          : GotoFirst;
    vk_End           : GotoLast;
    vk_Return,vk_Escape: if Assigned(FControl) then begin
     SavePosition;
     Control.SetFocus;
    end;
  else Key := wKey;
  end;
end;

procedure TsohoQuickSearch.EraseLastSymbol;
begin {      }
  Locked:=True;
  Text := Copy(Text,1,Length(Text)-1);
  SelStart := Length(Text);
  SelLength := 0;
  Locked:=False;
end;

procedure TsohoQuickSearch.MouseUp(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin {     }
  inherited MouseUp(Button, Shift, X, Y);
  SelStart := 0;
  SelLength := Length(Text);
end;

procedure TsohoQuickSearch.Search(Direct : ShortInt);
var PrevIndexNumb : LongInt;
    ws : string;
begin {      }
  if not FActive then Exit;
{  SavePosition;}
  PrevIndexNumb := FIndexNumb;
  ws := ANSIUpperCase(Text);
  repeat
    inc(FIndexNumb, Direct);
  until (FIndexNumb < 0) or (FIndexNumb >= FIndexSize) or
    (Pos(ws, FIndex^[FIndexNumb]^)<>0) or (ws='');
  SearchSuccess := (FIndexNumb >= 0) and (FIndexNumb < FIndexSize);
  if not SearchSuccess then begin
    FIndexNumb := PrevIndexNumb;
    Exit;
  end;
  if (FDataSet is TTable) and FID then
    with FDataSet as TTable do begin
      DisableControls;
      SetKey;
      FieldByName(KeyField).AsInteger := FIDIndex^[FIndexNumb];
      GotoKey;
      EnableControls;
    end
  else
    with FDataSet do begin
      DisableControls;
      First;
      MoveBy(FIndexNumb);
      EnableControls;
    end;
end;

procedure TsohoQuickSearch.SetActive(Value : boolean);
begin {     Active}
  if Value then Activate else DeActivate;
end;

procedure TsohoQuickSearch.SetFieldsList(Value: TStrings);
begin {      }
  DeActivate;
  FieldsList.Assign(Value);
end;

procedure TsohoQuickSearch.AfterOpen;
begin {      }
  if Assigned(FAfterOpen) then FAfterOpen(DataSet);
  LoadData;
end;

procedure TsohoQuickSearch.AfterPost(DataSet:TDataSet);
var i : LongInt;
    wFIndex : PIndex;
    wFIDIndex : PIDIndex;
begin {        }
  if Assigned(FAfterPost) then FAfterPost(DataSet);
  i := FindID(DataSet);
  if i >= 0 then begin {Edit}
    DisposeStr(FIndex^[i]);
    FIndex^[i] := NewStr(GetIndex);
  end else begin {Append}
    Inc(FIndexSize);
    GetMem(wFIDIndex, FIndexSize*SizeOf(LongInt));
    GetMem(wFIndex, FIndexSize*SizeOf(Pointer));
    move(FIndex^, wFIndex^, (FIndexSize-1)*SizeOf(Pointer));
    move(FIDIndex^, wFIDIndex^, (FIndexSize-1)*SizeOf(LongInt));
    wFIDIndex^[FIndexSize-1] := DataSet.FieldByName(KeyField).AsInteger;
    wFIndex^[FIndexSize-1] := NewStr(GetIndex);
    FreeMem(FIndex, (FIndexSize-1)*SizeOf(Pointer));
    FreeMem(FIDIndex, (FIndexSize-1)*SizeOf(LongInt));
    FIndex := wFIndex;
    FIDIndex := wFIDIndex;
  end;
end;

procedure TsohoQuickSearch.AfterClose;
begin {      }
  if Assigned(FAfterClose) then FAfterClose(DataSet);
  FreeData;
end;

procedure TsohoQuickSearch.BeforeDelete(DataSet:TDataSet);
var i : LongInt;
begin {       }
  i := FindID(DataSet);
  DisposeStr(FIndex^[i]);
  FIndex^[i] := NewStr('');
  if Assigned(FBeforeDelete) then FBeforeDelete(DataSet);
end;

procedure TsohoQuickSearch.ActivateEvents;
begin {     }
  with FDataSet do begin
    FAfterOpen := AfterOpen;
    FAfterClose := AfterClose;
    FBeforeDelete := BeforeDelete;
    FAfterPost := AfterPost;
  end;
  FDataSet.AfterOpen := AfterOpen;
  FDataSet.AfterClose := AfterClose;
  FDataSet.BeforeDelete := BeforeDelete;
  FDataSet.AfterPost := AfterPost;
end;

procedure TsohoQuickSearch.DeActivateEvents;
begin {     }
  FDataSet.AfterOpen := FAfterOpen;
  FDataSet.AfterClose := FAfterClose;
  FDataSet.BeforeDelete := FBeforeDelete;
  FDataSet.AfterPost := FAfterPost;
end;

procedure TsohoQuickSearch.LoadData;
var i : LongInt;
begin {         }
  try
    Test;
  except
    raise;
  end;
  if FIndex <> nil then FreeData;
  FIndexSize := FDataSet.RecordCount;
  GetMem(FIDIndex, FIndexSize*SizeOf(LongInt));
  GetMem(FIndex, FIndexSize*SizeOf(Pointer));
  with FDataSet do begin
    {   }
    DisableControls;
    First;
    for i:=0 to FIndexSize-1 do begin
      FIndex^[i] := NewStr(GetIndex);
      FIDIndex^[i] := FieldByName(KeyField).AsInteger;
      Next;
    end;
    EnableControls;
    FIndexNumb := 0;
  end;
end;

procedure TsohoQuickSearch.FreeData;
var i : LongInt;
begin {       }
  if FIndex = nil then Exit;
  for i:=0 to FIndexSize-1 do
    DisposeStr(FIndex^[i]);
  FreeMem(FIndex, FIndexSize*SizeOf(Pointer));
  FIndex := nil;
  FreeMem(FIDIndex, FIndexSize*SizeOf(LongInt));
  FIDIndex := nil;
  FIndexSize := 0;
end;

procedure TsohoQuickSearch.Test;
var j : LongInt;
begin {   }
  if not FDataSet.Active then
    raise EQuickSearch.Create('QuickSearch.Activate : DataSet is not Active');
  if FieldsList.Count = 0 then
    raise EQuickSearch.Create('QuickSearch.Activate : FieldsList is empty');
  with FDataSet do begin
    try
      if FieldByName(KeyField).AsInteger=0 then;
    except
      raise EQuickSearch.Create('QuickSearch.Activate : Field '+KeyField+' not found');
    end;
    try
      for j:=0 to FieldsList.Count-1 do
        if FieldByName(FieldsList[j]).AsString ='' then;
    except
      raise EQuickSearch.Create('QuickSearch.Activate : Field '''+
        FieldsList[j]+''' not found');
    end;
  end;
end;

function TsohoQuickSearch.FindID(DataSet : TDataSet) : LongInt;
var i, ID : LongInt;
begin {    }
  result := -1;
  ID := DataSet.FieldByName(KeyField).AsInteger;
  for i:=0 to FIndexSize-1 do
    if FIDIndex^[i] = ID then begin
      result := i; Exit;
    end;
end;

function TsohoQuickSearch.GetIndex : string;
var j : LongInt;
begin {      }
  result := '';
  with FDataSet do
    for j:=0 to FieldsList.Count-1 do
      result := result +
         ANSIUpperCase(FieldByName(FieldsList[j]).AsString) + '|';
end;

end.
