{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit Sonwrcf;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, StdCtrls, SohoBtns, ExtCtrls, SoTools, Menus,
     SoCtrls, StrHlder, Placemnt, SoRxTls, SoFrmEd;

type
  TsohoNewRecordForm = class(TForm)
    sohoEnterTab1: TsohoEnterTab;
    EditMenu: TPopupMenu;
    EditM: TMenuItem;
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    Fields: TStrHolder;
    Ini: TsohoFormStorage;
    Editor: TsohoFormEditor;
    procedure EditMClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EditorExit(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    FieldCount   : LongInt;
    FirstVisible : LongInt;
  public
    { Public declarations }
    aFocusField  : string;
    function  GetStrValueByIndex (Index : integer) : string;
    function  GetLabelByIndex    (Index : integer) : TsohoLabel;
    function  GetControlByIndex  (Index : integer) : TWinControl;
    function  GetControlByFieldName (const FieldName : string) : TWinControl;
    procedure EditExit (Sender : TObject; var AllowExit : boolean);
    procedure AddField (FieldName : string; FieldLabel : TsohoLabel;
              FieldControl : TWinControl);
  end;

var sohoNewRecordForm: TsohoNewRecordForm;

implementation
uses SoUtils;

{$R *.DFM}
type TTmpList = array [0..16384] of boolean;

var TmpList : ^TTmpList;

procedure TsohoNewRecordForm.AddField (FieldName : string; FieldLabel : TsohoLabel;
              FieldControl : TWinControl);
begin
     inc(FieldCount);
     Fields.Strings.AddObject(FieldName, FieldLabel);
     if FieldLabel<>nil then begin
       FieldLabel.FocusControl := FieldControl;
       if FirstVisible = -1 then FirstVisible := pred(FieldCount);
     end;
end;

procedure TsohoNewRecordForm.EditExit (Sender : TObject; var AllowExit : boolean);
begin
     AllowExit := AllowExit or (ActiveControl=CancelB);
end;

function  TsohoNewRecordForm.GetLabelByIndex    (Index : integer) : TsohoLabel;
begin
     Result := TsohoLabel(Fields.Strings.Objects[Index]);
end;

function  TsohoNewRecordForm.GetControlByIndex  (Index : integer) : TWinControl;
var Lbl   : TsohoLabel;
begin
     Result := nil;
     Lbl := GetLabelByIndex(Index);
     if Lbl<>nil then Result := Lbl.FocusControl;
end;

function  TsohoNewRecordForm.GetControlByFieldName (const FieldName : string) : TWinControl;
var  Index : LongInt;
begin
     Result := nil;
     Index := Fields.Strings.IndexOf(FieldName);
     if Index = -1 then exit;
     Result := GetControlByIndex(Index);
end;

function TsohoNewRecordForm.GetStrValueByIndex (Index : integer) : string;
var Control : TWinControl;
begin
     Result := '';
     Control := GetControlByIndex(Index);
     if Control<>nil then begin
        if Control is TsohoEdit then Result := TsohoEdit(Control).AsString;
        if Control is TCheckBox then
            Result := BoolToStr(TCheckBox(Control).Checked);
     end;
end;

procedure TsohoNewRecordForm.EditMClick(Sender: TObject);
var Index   : integer;
    RightC  : boolean;
    Cntrl   : TWinControl;
begin
     if FieldCount=0 then exit;
     with Ini.MinMaxInfo do begin
          MaxSizeHeight  := 0;
          MaxSizeWidth   := 0;
          MaxTrackHeight := 0;
          MaxTrackWidth  := 0;
          MinTrackHeight := 0;
          MinTrackWidth  := 0;
     end;
     GetMem(TmpList,SizeOf(Boolean)*FieldCount);
     for Index := 0 to pred(FieldCount) do begin
      RightC := false;
      Cntrl  := GetControlByIndex(Index);
      if Cntrl is TsohoEdit then begin
         RightC := (Cntrl as TsohoEdit).RightControl;
         (Cntrl as TsohoEdit).RightControl := false;
      end;
      TmpList^[Index] := RightC;
     end;
     Editor.Edit;
end;

procedure TsohoNewRecordForm.FormCreate(Sender: TObject);
begin
    FieldCount   := 0;
    FirstVisible := -1;
end;

procedure TsohoNewRecordForm.EditorExit(Sender: TObject);
var Index   : integer;
    Cntrl   : TWinControl;
begin
     {     }
     Editor.OnExit := nil;
     for Index := 0 to pred(FieldCount) do begin
      Cntrl := GetControlByIndex(Index);
      if Cntrl is TsohoEdit then (Cntrl as TsohoEdit).RightControl := TmpList^[Index];
     end;
     FreeMem(TmpList,SizeOf(Boolean)*FieldCount);
     with Ini,MinMaxInfo do begin
          MaxSizeHeight  := Height;
          MaxSizeWidth   := Width;
          MaxTrackHeight := Height;
          MaxTrackWidth  := Width;
          MinTrackHeight := Height;
          MinTrackWidth  := Width;
     end;
end;

procedure TsohoNewRecordForm.FormShow(Sender: TObject);
var Cntrl : TWinControl;
begin
   if FieldCount>0 then begin
     if aFocusField<>'' then Cntrl := GetControlByFieldName(aFocusField)
     else Cntrl := GetControlByIndex(FirstVisible);
     Cntrl.SetFocus;
   end;
end;

end.
