{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                Written by Allex,VSM                   }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{    TsohoMenuCaptionEditor, ,
          
   
}
unit SoMenuEd;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, Dialogs, Menus, IniFiles, SohoHntC, SoTools;

type

  {      TsohoMenuCaptionEditor. tmHide - 
      ""      
      , tmNormal  -     }
  TsohoToolMode = (tmHide, tmNormal);

  {    OnSelect.   , 
       TsohoMenuCaptionEditor }
  TsohoOnMenuSelect = procedure (Sender : TObject; var Command : string;
                      var Allow : boolean) of object;

  {      
      run-time,  ,        
     ,     .  
      ini- IniFile   "Tools"   :
    "   =    ".  ,  
           Tools.
  }

  TsohoMenuCaptionEditor = class(TsohoMsgGrabber)
  private
    { Private declarations }
    FAuto : boolean;
    FForm: TForm;
    FRealMenuItem,
    FVirtualMenuItem: TMenuItem;
    FActive: boolean;
    FMainMenu: TMainMenu;
    FSelfMainMenu : TMainMenu;
    FOldKeyDown: TKeyEvent;
    FOldMouseDown: TMouseEvent;
    FOldFormKeyPreview: boolean;
    FHint: TSohoHintsCollector;
    FEditing : boolean;
    FTools     : TStringList;
    FIniFile   : TIniFileName;
    FMenuName  : string;
    FIndex     : integer;
    FToolsItem : TMenuItem;
    FStartTag  : LongInt;
    FExecMode  : TsohoToolMode;
    FOnSelect  : TsohoOnMenuSelect;
    procedure SetMainMenu  (Value : TMainMenu);
    procedure SetIniFile   (Value : TIniFileName);
    procedure SetIndex     (Value : integer);
    procedure SetTools     (Value : TStringList);
    procedure SetMenuName  (Value : string);
    procedure EditOnClick  (Sender: TObject);
    procedure OnKeyDown    (Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure OnMouseDown  (Sender: TObject; Button: TMouseButton;
                            Shift: TShiftState; X, Y: Integer);
    procedure ToolMenuClick (Sender : TObject);
  protected
    { Protected declarations }
    procedure Finish       (Sender: TObject);
    function  CopyMenuItem (Parent: TMenuItem): TMenuItem;
    procedure AppendMenuItems;
    procedure Loaded; override;
    procedure WMMENUSELECT (var Message : TMessage); message WM_MENUSELECT;
    procedure Notification  (AComponent : TComponent; Operation : TOperation);override;
    procedure CreateMenu;
    procedure AddMenu;
    procedure RemoveMenu;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy;override;
    {     ini- }
    procedure Save  (IniFileName : string);
    {     ini- }
    procedure Load  (IniFileName : string);
    {     }
    procedure Edit;
    {    ,     }
    property  ToolsMenuItem : TMenuItem read FToolsItem;
  published
    {       
      ini- }
    property Auto : boolean read FAuto write FAuto default true;
    {    TsohoHintCollector,   
           }
    property HintCollector: TSohoHintsCollector read FHint write FHint;
    {    ,       
         }
    property MainMenu       : TMainMenu    read FMainMenu write SetMainMenu;
    {  ini-         }
    property IniFile        : TIniFileName read FIniFile  write SetIniFile;
    {     }
    property ToolsMenuName  : string       read FMenuName write SetMenuName;
    {     }
    property ToolsMenuIndex : integer      read FIndex    write SetIndex;
    {   }
    property Tools          : TStringList  read FTools    write SetTools;
    {     }
    property ExecMode       : TsohoToolMode read FExecMode write FExecMode;
    {        }
    property OnSelect       : TsohoOnMenuSelect read FOnSelect write FOnSelect;
  end;

implementation
uses SoUtils, SoCmnCns;

{ TsohoMenuCaptionEditor }
procedure TsohoMenuCaptionEditor.Notification  (AComponent : TComponent; Operation : TOperation);
begin
   if (AComponent=FMainMenu) and (Operation=opRemove) then  FMainMenu := nil;
   inherited Notification(AComponent, Operation);
end;

procedure TsohoMenuCaptionEditor.SetMenuName  (Value : string);
begin
   FMenuName := Value;
   if FToolsItem<>nil then FToolsItem.Caption := Value;
end;

procedure TsohoMenuCaptionEditor.SetTools (Value : TStringList);
begin
   FTools.Assign(Value);
   if (csLoading in ComponentState) or
      (csDesigning in ComponentState) then exit;
   RemoveMenu;
   AddMenu;
end;

procedure TsohoMenuCaptionEditor.SetIndex (Value : integer);
begin
   FIndex := Value;
   if (csLoading in ComponentState) or
      (csDesigning in ComponentState) then exit;
   if (FToolsItem<>nil) and (FMainMenu<>nil) then begin
      FMainMenu.Items.Remove(FToolsItem);
      if FIndex>FMainMenu.Items.Count-1 then FMainMenu.Items.Add(FToolsItem)
      else FMainMenu.Items.Insert(FIndex,FToolsItem);
   end;
end;

procedure TsohoMenuCaptionEditor.ToolMenuClick (Sender : TObject);
var ItemCommand : string;
    {$IFNDEF Win32}TaskHandle  : THandle;{$ENDIF}
    Allow       : boolean;
begin
   ItemCommand := FTools[(Sender as TMenuItem).Tag-FStartTag];
   if Pos('=',ItemCommand)<>0 then begin
       ItemCommand := copy(ItemCommand,Pos('=',ItemCommand)+1,length(ItemCommand))+#0;
       Allow := true;
       if Assigned(FOnSelect) then FOnSelect(Self, ItemCommand, Allow);
       if not Allow then exit;
       {$IFNDEF Win32} TaskHandle := {$ENDIF}WinExec(@ItemCommand[1],sw_ShowNormal);
       {$IFNDEF Win32}
       if FExecMode = tmHide then begin
           Application.MainForm.Hide;
           while GetModuleUsage(TaskHandle)>0 do Application.ProcessMessages;
           Application.MainForm.Show;
       end;
       {$ENDIF}
   end;
end;

procedure TsohoMenuCaptionEditor.CreateMenu;
var Index : integer;
    ItemCaption : string;
begin
   if FToolsItem<>nil then FToolsItem.Free;
   FToolsItem := NewItem(FMenuName,0,false,true,nil,0,'');
   for Index := 0 to FTools.Count-1 do begin
       ItemCaption := FTools[Index];
       if Pos('=',ItemCaption)<>0 then ItemCaption := Copy(ItemCaption,1,
          Pos('=',ItemCaption)-1);
       FToolsItem.Add(NewItem(ItemCaption,0,false,true,ToolMenuClick,0,''));
       FToolsItem.Items[Index].Tag := Tag+Index;
   end;
   FStartTag := Tag;
end;

procedure TsohoMenuCaptionEditor.AddMenu;
begin
   if csDesigning In ComponentState then exit;
   if FMainMenu = nil then exit;
   if FToolsItem=nil then CreateMenu;
   if FToolsItem.Count<>0 then
     if FIndex>FMainMenu.Items.Count-1 then FMainMenu.Items.Add(FToolsItem)
     else FMainMenu.Items.Insert(FIndex,FToolsItem);
end;

procedure TsohoMenuCaptionEditor.RemoveMenu;
begin
   if FMainMenu = nil then exit;
   FToolsItem.Free;
   FToolsItem := nil;
end;

procedure TsohoMenuCaptionEditor.SetMainMenu (Value : TMainMenu);
begin
   RemoveMenu;
   FMainMenu := Value;
   if (csLoading in ComponentState) or
      (csDesigning in ComponentState) then exit;
   AddMenu;
end;

destructor TsohoMenuCaptionEditor.Destroy;
begin
   if (FMainMenu<>nil) and not (csDestroying in FMainMenu.ComponentState) then
      RemoveMenu;
   inherited Destroy;
end;

procedure TsohoMenuCaptionEditor.SetIniFile;
begin
   if (UpperCase(ExtractFileExt(Value))<>'INI') and (Value<>'') then
      Value:=ChangeFileExt(Value,'.INI');
   if Value=FIniFile then exit;
   FIniFile   := Value;
end;

procedure TsohoMenuCaptionEditor.WMMENUSELECT (var Message : TMessage);
begin
  if (not FActive) or (FEditing) then inherited
  else
    with TWMMenuSelect(Message) do begin
      if MenuFlag and MF_MOUSESELECT = 0 then exit;
      if MenuFlag and MF_POPUP <> 0 then
        {      }
        FVirtualMenuItem := FSelfMainMenu.Items[IDItem]
      else
        FVirtualMenuItem := FSelfMainMenu.FindItem(IdItem, fkCommand);
      inherited;
    end;
end;

procedure TsohoMenuCaptionEditor.EditOnClick(Sender: TObject);
var Ini: TIniFile;
    NewStr : string;
begin
  FEditing := true;
  try
    if FVirtualMenuItem = nil then exit;
    FRealMenuItem := TMenuItem(FVirtualMenuItem.Tag);
    if FRealMenuItem = nil then exit;
    NewStr := FVirtualMenuItem.Caption;
    if not InputQuery(soMenuCaptNewMenuItem, FRealMenuItem.Caption,
       NewStr) then begin
       FEditing := false;
       exit;
    end;

    FRealMenuItem.Caption := NewStr;
    FVirtualMenuItem.Caption := NewStr;
    if FHint <> nil then begin
      NewStr := FVirtualMenuItem.Hint;
      if not InputQuery(soMenuCaptNewMenuItemHint, FRealMenuItem.Hint,
        NewStr) then begin
        FEditing := false;
        exit;
      end;
      if FRealMenuItem.Name<>'' then begin
        Ini := TIniFile.Create(GetRealHintFileName(FHint.HintsFile));
        Ini.WriteString(FHint.Section, FRealMenuItem.Name, NewStr);
        Ini.Free;
      end;  
      FRealMenuItem.Hint := NewStr;
      FVirtualMenuItem.Hint := NewStr;
    end;
  finally
    FEditing := false;
  end;
end;

procedure TsohoMenuCaptionEditor.Loaded;
var Index: Longint;
    Ini : TIniFile;
begin
  inherited Loaded;
  FForm := GetOwnerForm(Self);
  for Index := 0 to pred(FForm.ComponentCount) do
    if FForm.Components[Index] is TMainMenu then begin
      FMainMenu := FForm.Components[Index] as TMainMenu;
      Break;
    end;
  if (FIniFile = '') and not (csDesigning in ComponentState) then
    FIniFile := ExtractFileName(ChangeFileExt(Application.ExeName,'.INI'));
  Ini := TIniFile.Create(FIniFile);
  Ini.ReadSectionValues('Tools',FTools);
  AddMenu;
  if FAuto then Load(FIniFile);
  Ini.Free;
end;

constructor TsohoMenuCaptionEditor.Create;
begin
  inherited Create(AOwner);
  FAuto      := true;
  FMainMenu  := nil;
  FSelfMainMenu := nil;
  FIniFile   := '';
  FMenuName  := 'Tools';
  FTools     := TStringList.Create;
  FToolsItem := nil;
  FIndex     := 0;
end;

procedure TsohoMenuCaptionEditor.AppendMenuItems;
var MenuItem: TMenuItem;
    Index   : Longint;
begin
  if FActive then exit else FActive := true;

  for Index := 0 to pred(FMainMenu.Items.Count) do
    FSelfMainMenu.Items.Add(CopyMenuItem(FMainMenu.Items[Index]));
  MenuItem := TMenuItem.Create(FForm);
  MenuItem.Break := MBBarBreak;
  MenuItem.Caption := soMenuCaptStopEdit;
  MenuItem.Visible := True;
  MenuItem.OnClick := Finish;
  MenuItem.Hint := '';
  FSelfMainMenu.Items.Add(MenuItem);
end;

function TsohoMenuCaptionEditor.CopyMenuItem(Parent: TMenuItem): TMenuItem;
var Index: Longint;
begin
  Result            := TMenuItem.Create(FForm);
  Result.Break      := Parent.Break;
  Result.Caption    := Parent.Caption;
  Result.Checked    := Parent.checked;
  Result.Enabled    := Parent.Enabled;
  Result.GroupIndex := Parent.GroupIndex;
  Result.Visible    := Parent.Visible;
  Result.ShortCut   := Parent.ShortCut;
  Result.Tag        := LongInt(Parent);
  Result.Hint       := Parent.Hint;
  Result.OnClick    := nil;
  for Index := 0 to pred(Parent.Count) do
    Result.Add(CopyMenuItem(Parent.Items[Index]));
end;

procedure TsohoMenuCaptionEditor.Edit;
begin
  FEditing := false;
  FSelfMainMenu := TMainMenu.Create(GetOwnerForm(Self));
  AppendMenuItems;
  FForm.Menu := FSelfMainMenu;

  FOldKeyDown := FForm.OnKeyDown;
  FForm.OnKeyDown := OnKeyDown;

  FOldMouseDown := FForm.OnMouseDown;
  FForm.OnMouseDown := OnMouseDown;

  FOldFormKeyPreview := FForm.KeyPreview;
  FForm.KeyPreview := True;
  FActive := true;
end;

procedure TsohoMenuCaptionEditor.Load(IniFileName: string);
var Index : Longint;
    Ini   : TIniFile;
begin
  if IniFileName = '' then IniFileName := FIniFile;
  with FForm do begin
    Ini := TIniFile.Create(IniFileName);
    for Index := 0 to pred(ComponentCount) do
      if Components[Index] is TMenuItem then
        with Components[Index] as TMenuItem do
         if Name<>'' then Caption := Ini.ReadString('Menu', Name, Caption);
    Ini.Free;
  end
end;

procedure TsohoMenuCaptionEditor.Save(IniFileName: string);
var Index : Longint;
    Ini   : TIniFile;
begin
  if IniFileName = '' then IniFileName := FIniFile;
  with FForm do begin
    Ini := TIniFile.Create(IniFileName);
    for Index := 0 to pred(ComponentCount) do
      if Components[Index] is TMenuItem then
        with Components[Index] as TMenuItem do
         if Visible and (Name<>'') then Ini.WriteString('Menu', Name, Caption);
    Ini.Free;
  end
end;

procedure TsohoMenuCaptionEditor.Finish(Sender: TObject);
begin
  Application.MainForm.Menu := FMainMenu;
  FForm.KeyPreview := FOldFormKeyPreview;
  FForm.OnKeyDown := FOldKeyDown;
  FForm.OnMouseDown := FOldMouseDown;
  FSelfMainMenu.Free;
  FSelfMainMenu := nil;
  FActive := false;
  if FAuto then Save(FIniFile);
end;

procedure TsohoMenuCaptionEditor.OnKeyDown(Sender: TObject; var KEY: Word;
    Shift: TShiftState);
begin
  if (KEY = VK_RETURN) and (ssCtrl in Shift) then EditOnClick(Sender);
end;

procedure TsohoMenuCaptionEditor.OnMouseDown(Sender: TObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbRight then EditOnClick(Sender);
end;

end.

