unit SoMdlFrm;

interface

uses Classes, Forms, Messages, Controls;

type
  TsohoModalForm = class( TForm )
  private
    procedure WMSize( var Message: TWMSize ); message WM_SIZE;
  public
    procedure KeyPress(var Key: Char);override;
    constructor Create(AOwner : TComponent);override;
  end;

implementation
uses Windows;

{ TModalForm }

procedure TsohoModalForm.KeyPress(var Key: Char);
begin
  if Key = #27 then ModalResult := mrCancel;
  inherited KeyPress(Key);  
end;

constructor TsohoModalForm.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  KeyPreview := true;
end;

procedure TsohoModalForm.WMSize(var Message: TWMSize);
begin
  Inherited;
  case Message.SizeType of
    SIZE_MINIMIZED:
    begin
      Application.Minimize;
    end;
    SIZE_RESTORED:
    begin
      Application.Restore;
    end;
  end;
end;

end.
