{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                Written by VSM, Allex                  }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoIntrpr;

{$I SOHOLIB.INC}


interface
uses SysUtils,SoUtils;
const StackSize = 20;
type TWordType = (Unknown, lp, RP, Constant, name, Operation);

  type TCalcObj = class(TObject)
    Divider: Char;
    ResultName: string;
    CompiledPData: Longint;
    CompiledDataNameStack: array[0..StackSize] of string[60];
    {Main Methods}
    constructor Create(C: Char);
    procedure Free;
    procedure Compile(Formula: string); virtual; {Syntax check}
    function Calculate: Pointer; virtual; {Do interpretation}
    function DoCalculation(Formula: string): Pointer; virtual;
    {Do calculation is equal to Compile+Calculate}
    {Virtual methods-you MUST Override them}
    function ValueOfString(S: string): Pointer; virtual; {Create new number from CONST}
    function ValueOfName(S: string): Pointer; virtual; {Create new number from NAME}
    function ValueToString(P: Pointer): string; virtual;
    procedure ReleaseNumber(var P: Pointer); virtual; {Release memory,used by number or name}
    function IsName(S: string): boolean; virtual;
    function IsOperation(S: string): boolean; virtual;
    function DoOperation(Operation: string; Left, Right: Pointer): Pointer; virtual; {Do operation}
    function OperationLevel(Operation: string): Longint; {f.e +- is 0; */ is 10 etc.}
  private
    DataStack: array[0..StackSize] of Pointer;
    DataNameStack: array[0..StackSize] of string[40];
    DataType: array[0..StackSize] of TWordType;
    CompiledDataType: array[0..StackSize] of TWordType;
    OperStack: array[0..StackSize] of string[10];
    CompiledOperStack: array[0..StackSize] of string[10];
    PData: Longint;
    POper: Longint;
    CompiledPOper: Longint;
    procedure ExecuteOperationFromStack(APdata: Longint);
    procedure LoadData;
  end;


const Digits:LongInt=-1;  

implementation
constructor TCalcObj.Create;
begin
  Divider := C; {Special char, which divide names and operation signs}
end;

procedure TCalcObj.Free;
begin
  inherited Free;
end;

{Example of TCalcOBJ methods, NAMES NOT SUPPORTED!}
function TCalcObj.ValueOfString(S: string): Pointer;
begin Result := NewStr(S) end;

function TCalcObj.ValueOfName(S: string): Pointer;
begin Result := NewStr(''); end;

function TCalcObj.ValueToString(P: Pointer): string;
begin Result := PString(P)^; end;

procedure TCalcObj.ReleaseNumber(var P: Pointer);
begin
  if Assigned(P) then begin
    DisposeStr(P);
    P := nil;
  end;
end;

function TCalcObj.DoOperation(Operation: string; Left, Right: Pointer): Pointer;
var
  S: string;
  L,R:Extended;
  ErrorPos:Integer;
Label Error;
begin
  S := '';
  if Operation<>'|' then begin

     Val(ChangeChars(PString(Left)^,  DecimalSeparator,'.'),L,ErrorPos);
     if ErrorPos<>0 then S:='?';
     Val(ChangeChars(PString(Right)^,  DecimalSeparator, '.'),R,ErrorPos);
     if ErrorPos<>0 then S:='?';
     if S='?' then GOTO ERROR;
  end;
    if Operation = '|' then S := PString(Left)^ + '~' + PString(Right)^; {CONCAT}
    if Operation = '+' then S := FloatToStr(L + R); {Summ}
    if Operation = '-' then S := FloatToStr(L - R); {Difference}
    if Operation = '*' then S := FloatToStr(L * R); {Product}
    if Operation = '/' then S := FloatToStr(L / R); {DIV}
    if Operation = '%' then S := FloatToStr(L * R / 100); {PERCENT}
    if Operation = '^' then S := FloatToStr(EXP(R) * LN(L)); {POWER}
    if Operation = '@' then S := IntToStr(Round(L) mod Round(R));
    if Operation = '\' then S := IntToStr(Round(L) div Round(R));
Error:
  Result := NewStr(S);
end;

function TCalcObj.IsOperation;
begin
  IsOperation := S[1] in ['+', '-', '*', '/', '%', '|', '^', '@', '\'];
end;

function TCalcObj.IsName;
begin
  IsName := False;
end;

function TCalcObj.OperationLevel;
begin
  Result := -1; {Unknown function}
  case Operation[1] of
    '+', '-': Result := 0;
    '*', '/', '%', '\', '@': Result := 10;
    '^', '|': Result := 20;
  end;
end;


procedure TCalcObj.Compile;
var
  I            : Longint;                                                    
  Word         : string;                                                     
  WordType     : TWordType;                                                  
  TotalWords   : Longint;                                                    
  StringByWords: array[0..StackSize * 2] of string;                          
  TypeByWords  : array[Low(StringByWords)..High(StringByWords)] of TWordType;
begin
  {Phase 0 - define ResultName}
  I := Pos(':=', Formula);
  ResultName := Copy(Formula, 1, I - 1);
  if I <> 0 then Delete(Formula, 1, I + 1);
  {Phase 1 - Erase special symbols and glue constants}
  TotalWords := 0;
  if Formula[1] <> Divider then Formula := Divider + Formula;
  
  for I := 0 to High(StringByWords) do begin
    StringByWords[I] := '0';
    TypeByWords[I] := Unknown;
  end;
  
  for I := 0 to High(DataStack) do begin
    DataStack[I] := nil;
    DataNameStack[I] := '0';
    OperStack[I] := ')';
  end;
  
  
  repeat
    {1.1 - Find next word}
    Delete(Formula, 1, Pos(Divider, Formula));
    I := Pos(Divider, Formula);
    if I = 0 then I := Length(Formula) + 1;
    Word := Copy(Formula, 1, I - 1);
    Delete(Formula, 1, I);
    {1.2 - Define it's type}
    WordType := Constant;
    if Word = '(' then WordType := lp;
    if Word = ')' then WordType := RP;
    if IsName(Word) then WordType := name;
    if IsOperation(Word) then WordType := Operation;
    
    {1.3 - if prerviously was constant then glue else new word}
    if (WordType = Constant) and (TypeByWords[TotalWords] = Constant)
      then StringByWords[TotalWords] := StringByWords[TotalWords] + Word
    else begin
      inc(TotalWords);
      StringByWords[TotalWords] := Word;
      TypeByWords[TotalWords] := WordType;
    end;
  until Formula = '';
  
  {Phase 2 - convert to POLISH (STACK)}
  PData := 0; POper := 0;
  for I := 1 to TotalWords do
    case TypeByWords[I] of
      Constant, name: begin {Push Value to Data stack}
        inc(PData);
        DataNameStack[PData] := StringByWords[I];
        DataType[PData] := TypeByWords[I];
      end;
      Operation, lp, RP: begin {Push to Oper stack}
        inc(POper);
        OperStack[POper] := StringByWords[I];
      end;
    end;
  {  }
  for I := 0 to StackSize do begin
    CompiledDataNameStack[I] := DataNameStack[I];
    CompiledDataType[I] := DataType[I];
    CompiledOperStack[I] := OperStack[I];
  end;
  CompiledPOper := POper;
  CompiledPData := PData;
end;

procedure TCalcObj.LoadData;
var I: Longint;
begin
  for I := 1 to PData do
    if DataType[I] = Constant
      then DataStack[I] := ValueOfString(DataNameStack[I])
    else DataStack[I] := ValueOfName(DataNameStack[I]);
end;

procedure TCalcObj.ExecuteOperationFromStack;
var
  Temp: Pointer;
  I   : Longint;
  op  : string;
begin
  {
       
     3   ,   
     ,   -   

        -  ,
        
         ,     
         ,     
         !
   }
  op := OperStack[1];
  for I := 1 to POper do OperStack[I] := OperStack[I + 1];
  Dec(POper);

  if op = ')' then Exit;

  if op = '(' then begin
    op := OperStack[1];
    {      For i:=1 to POper do OperStack[i]:=OperStack[i+1];
      Dec(Poper);}
    ExecuteOperationFromStack(APdata);
    Exit;
  end;


  if (OperStack[1] = '(')
    then begin
    for I := 1 to POper do OperStack[I] := OperStack[I + 1];
    Dec(POper);
    ExecuteOperationFromStack(APdata + 1);
  end;

  if (OperationLevel(OperStack[1]) > OperationLevel(op))
    then ExecuteOperationFromStack(APdata + 1);
  {Now continue current operation}

  {Do operation}
  Temp := DoOperation(op, DataStack[APdata], DataStack[APdata + 1]);
  {Release Loaded Data from stack}
  ReleaseNumber(DataStack[APdata]);
  ReleaseNumber(DataStack[APdata + 1]);
  {Replace Top value}
  DataStack[APdata] := Temp;
  {Pop down other data from stack}
  for I := APdata + 1 to PData do DataStack[I] := DataStack[I + 1];
  Dec(PData);
end;

function TCalcObj.Calculate;
var I: Longint;
    wStr:String;
    wExt:Extended;
    ErrorPos:Integer;
begin
  {  }
  for I := 0 to StackSize do begin
    DataNameStack[I] := CompiledDataNameStack[I];
    DataType[I] := CompiledDataType[I];
    OperStack[I] := CompiledOperStack[I];
  end;
  POper := CompiledPOper;
  PData := CompiledPData;
  {  }
  LoadData;
  {  }
  repeat ExecuteOperationFromStack(1); until POper <= 0;
  Result := DataStack[1]; { !}
  // , .     
  // , , ,  Digits
  if Digits>=0 then begin
   wStr:=PString(Result)^;
   Val(wStr,wExt,ErrorPos);
   wStr:=SysUtils.FloatToStrF(wExt,ffFixed,20,Digits);
   PString(Result)^:=wStr;
  end;
end;


function TCalcObj.DoCalculation; {Syntax analysys and operating}
begin
  Compile(Formula);
  Result := Calculate;
end;

end.

