{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
       TRxHintWindow.
}
unit SoHints;

{$I SOHOLIB.INC}

interface
uses Windows, RxHints, Classes, Graphics, Forms, Controls;

type

  {  .     
        ,   "" }
  TsohoHintWindow = class(TRxHintWindow)
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  end;

{     }
procedure SetSohoHint;

const
  ScrollSteps : LongInt = 100;
  {      }
  HorizontalScroll : boolean = true;
  {    ? }
  HintAlign : TAlignment = taLeftJustify;
  {     }

implementation
uses SoUtils, VCLUtils;

type

{$HINTS OFF}
  THackRxHintWindow = class(THintWindow)
  private
    FSrcImage: TBitmap;
    FImage: TBitmap;
    FPos: THintPos;
    FRect: TRect;
    FTextRect: TRect;
    FTileSize: TPoint;
    FRoundFactor: Integer;
  end;
{$HINTS ON}

procedure SetSohoHint;
begin
  RxHints.SetHintStyle(hsRectangle, 0, false, taLeftJustify);
  SetStandardHints;
  RegisterHintWindow(TsohoHintWindow);
end;

procedure TsohoHintWindow.Paint;
var
  R, Rect: TRect;
  SrcImage, Image : TBitmap;
  W, Index : LongInt;
  StOffset : Double;
  ScreenDC : HDC;

  procedure PaintText(R: TRect);
  const
    Flag: array[TAlignment] of Longint = (DT_LEFT, DT_RIGHT, DT_CENTER);
  var TmpR : TRect;
  begin
    TmpR := R;
    if HintAlign = taLeftJustify then OffsetRect(TmpR, -2, 0);
    Image.Canvas.Brush.Color := Application.HintColor;
    Image.Canvas.FillRect(TmpR);
    Image.Canvas.Rectangle(TmpR.Left, TmpR.Top, TmpR.Right, TmpR.Bottom);
    Image.Canvas.Brush.Style := bsClear;
    DrawText(Image.Canvas.Handle, PChar(Caption),
      -1, R, DT_NOPREFIX or DT_WORDBREAK or Flag[HintAlign]);
    Image.Canvas.Brush.Style := bsSolid;
  end;

begin
  if Caption = '' then exit;
  Image := THackRxHintWindow(Self).FImage;
  SrcImage := THackRxHintWindow(Self).FSrcImage;
  GetWindowRect(Handle, Rect);
  R := CalcHintRect(Screen.Width, Caption, nil);
  OffsetRect(R, Rect.Left - R.Left, Rect.Top - R.Top);
  ScreenDC := GetDC(0);
  try
    with SrcImage do begin
      Width := WidthOf(BoundsRect);
      Height := HeightOf(BoundsRect);
      BitBlt(Canvas.Handle, 0, 0, Width, Height, ScreenDC, R.Left,
        R.Top, SRCCOPY);
    end;
  finally
    ReleaseDC(0, ScreenDC);
  end;

  Image.Handle := CreateCompatibleBitmap(Canvas.Handle,
                  WidthOf(ClientRect), HeightOf(ClientRect));
  Image.Canvas.Font := Self.Canvas.Font;

  if HorizontalScroll then
    W := WidthOf(THackRxHintWindow(Self).FTextRect)
  else
    W := HeightOf(THackRxHintWindow(Self).FTextRect);

  StOffset := W/ScrollSteps;
  for Index := 1 to ScrollSteps do begin
    Image.Canvas.Draw(0, 0, SrcImage);
    R := THackRxHintWindow(Self).FTextRect;
    if HorizontalScroll then begin
      R.Left := R.Left - W + SoUtils.Round(Index*StOffset);
      R.Right := R.Left + W;
    end
    else begin
      R.Top := R.Top - W + SoUtils.Round(Index*StOffset);
      R.Bottom := R.Top + W;
    end;
    if HintAlign = taLeftJustify then inc(R.Left,2);
    PaintText(R);
    Canvas.Draw(0, 0, Image);
  end;
end;

constructor TsohoHintWindow.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

destructor TsohoHintWindow.Destroy;
begin
  inherited Destroy;
end;

end.
