{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoGuidF;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, SohoBtns, SoDBGrid, ExtCtrls, SoVLbl,
  DB, DBTables, SoFolder, Grids, SohoRec, Menus, Placemnt, SoRxTls,
  SoTools, DBGrids, RXDBCtrl, SoCtmRec, SoCtmFld;

type
  TsohoGuideForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BtnsPanel: TPanel;
    GuideGrid: TsohoDBGrid;
    GuideFolder: TsohoFolder;
    GuideRecord: TsohoRecordForm;
    GuidePopupMenu: TPopupMenu;
    CheckM: TMenuItem;
    UnCheckM: TMenuItem;
    N1: TMenuItem;
    OkM: TMenuItem;
    CancelM: TMenuItem;
    GuideStorage: TsohoFormStorage;
    N2: TMenuItem;
    SaveIdsM: TMenuItem;
    LoadIdsM: TMenuItem;
    SaveD: TSaveDialog;
    OpenD: TOpenDialog;
    ClearMarkedM: TMenuItem;
    GuideQ: TQuery;
    GuideSource: TDataSource;
    procedure CheckMClick(Sender: TObject);
    procedure OkMClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelMClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure GuideGridKeyPress(Sender: TObject; var KEY: Char);
    procedure SaveIdsMClick(Sender: TObject);
    procedure LoadIdsMClick(Sender: TObject);
    procedure ClearMarkedMClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    KeyField: string;
    ItemID: Longint;
    ModalMode: boolean;
  end;

var sohoGuideForm: TsohoGuideForm;

implementation
uses SoUtils;

{$R *.DFM}

procedure TsohoGuideForm.CheckMClick(Sender: TObject);
begin
  with GuideQ do begin
    case (Sender as TMenuItem).Tag of
      1: GuideGrid.Results.Add(FieldByName(KeyField).AsInteger);
      2: GuideGrid.Results.Remove(FieldByName(KeyField).AsInteger);
    end;
  end;
end;

procedure TsohoGuideForm.OkMClick(Sender: TObject);
begin
  if not ModalMode then Close
  else ModalResult := mrOk;
end;

procedure TsohoGuideForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if FormStyle = fsNormal then Action := caHide
  else Action := caNone;
end;

procedure TsohoGuideForm.CancelMClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TsohoGuideForm.FormCreate(Sender: TObject);
begin
  ICON.Handle := LoadIcon(HInstance, 'MAINICON');
end;

procedure TsohoGuideForm.GuideGridKeyPress(Sender: TObject; var KEY: Char);
var ItemID: Longint;
begin
  with GuideGrid do
    if (KEY = #32) and (not EditorMode) then begin
      ItemID := GuideQ.FieldByName(KeyField).AsInteger;
      if Results.IndexOf(ItemID) = -1 then Results.Add(ItemID)
      else Results.Remove(ItemID);
    end;
end;

procedure TsohoGuideForm.SaveIdsMClick(Sender: TObject);
begin
  if not SaveD.Execute then exit;
  try
    GuideGrid.Results.SaveToFile(SaveD.Filename);
  except
  end;
end;

procedure TsohoGuideForm.LoadIdsMClick(Sender: TObject);
begin
  if not OpenD.Execute then exit;
  try
    GuideGrid.Results.LoadFromFile(OpenD.Filename);
  except
  end;
end;

procedure TsohoGuideForm.ClearMarkedMClick(Sender: TObject);
begin
  GuideGrid.Results.Clear;
end;

end.

