{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{            Written by VSM, Allex, MVL                 }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoGrdEd;

{$I SOHOLIB.INC}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Grids, SoGrids, StdCtrls, Buttons, ExtCtrls, SoTools,
  Menus, SohoBtns, Placemnt;

type
  TGridEditorForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    vGrid: TsohoStringGrid;
    AlignMenu: TPopupMenu;
    Left1: TMenuItem;
    Right1: TMenuItem;
    Center1: TMenuItem;
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    Ini: TFormStorage;
    procedure Left1Click(Sender: TObject);
    procedure Right1Click(Sender: TObject);
    procedure Center1Click(Sender: TObject);
    procedure vGridColumnMoved(Sender: TObject; FromIndex,
      ToIndex: Longint);
    procedure vGridRowMoved(Sender: TObject; FromIndex, ToIndex: Longint);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Renumber;
    procedure CopyFrom (Source : TsohoStringGrid);
    procedure CopyTo   (Destination : TsohoStringGrid);
    procedure Prepare  (aColCount, aRowCount : LongInt);
  end;

var GridEditorForm: TGridEditorForm;

implementation

{$R *.DFM}

procedure TGridEditorForm.CopyFrom (Source : TsohoStringGrid);
var aCol,aRow : LongInt;
begin
     with vGrid do begin
       for aCol := 0 to pred(Source.ColCount) do begin
           ColAligns[aCol+1] := Source.ColAligns[aCol];
           ColWidths[aCol+1] := Source.ColWidths[aCol];
           for aRow := 0 to pred(Source.RowCount) do
            Cells[aCol+1,aRow+1] := Source.Cells[aCol,aRow];
       end;
       for aRow := 0 to pred(Source.RowCount) do
         RowHeights[aRow+1] := Source.RowHeights[aRow];
     end;
end;

procedure TGridEditorForm.CopyTo (Destination : TsohoStringGrid);
var aCol,aRow : LongInt;
begin
     with vGrid do begin
        for aCol := 0 to pred(Destination.ColCount) do begin
            Destination.ColAligns[aCol] := ColAligns[aCol+1];
            Destination.ColWidths[aCol] := ColWidths[aCol+1];
            for aRow := 0 to pred(Destination.RowCount) do
             Destination.Cells[aCol,aRow] := Cells[aCol+1,aRow+1];
        end;
        for aRow := 0 to pred(Destination.RowCount) do
          Destination.RowHeights[aRow] := RowHeights[aRow+1];
     end;
end;

procedure TGridEditorForm.Renumber;
var Index : LongInt;
begin
     with vGrid do begin
       for Index := 1 to pred(RowCount) do Cells[0,Index] := IntToStr(pred(Index));
       for Index := 1 to pred(ColCount) do Cells[Index,0] := IntToStr(pred(Index));
     end;
end;

procedure TGridEditorForm.Prepare (aColCount, aRowCount : LongInt);
begin
     with vGrid do begin
          ColCount := aColCount + 1;
          RowCount := aRowCount + 1;
          ColWidths[0] := 20;
          ColAligns[0] := taCenter;
     end;
     Renumber;
end;

procedure TGridEditorForm.Left1Click(Sender: TObject);
begin
     vGrid.ColAligns[vGrid.Col] := taLeftJustify;
end;

procedure TGridEditorForm.Right1Click(Sender: TObject);
begin
     vGrid.ColAligns[vGrid.Col] := taRightJustify;
end;

procedure TGridEditorForm.Center1Click(Sender: TObject);
begin
     vGrid.ColAligns[vGrid.Col] := taCenter;
end;

procedure TGridEditorForm.vGridColumnMoved(Sender: TObject; FromIndex,
  ToIndex: Longint);
begin
     Renumber;
end;

procedure TGridEditorForm.vGridRowMoved(Sender: TObject; FromIndex,
  ToIndex: Longint);
begin
     Renumber;
end;

end.
