{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoFormActive
}
unit SoFrmAct;

{$I SOHOLIB.INC}

interface

uses WinTypes, WinProcs, Messages, Classes, SoTools;

const
  {      }
  WM_REALACTIVATE = WM_USER + 11111;

type

  {      "" 
    ,  TForm.OnActivate     .
         OnRealActivate
  }
  TsohoFormActive = class(TsohoMsgGrabber)
  private
    { Private declarations }
    FOnActivate: TNotifyEvent;
    FOnCreate: TNotifyEvent;
  protected
    { Protected declarations }
    procedure DoFormCreate(Sender: TObject);
    procedure RealActivate(var message: TMessage); message WM_REALACTIVATE;
  public
    procedure Loaded; override;
    destructor Destroy; override;
  published
    {       }
    property OnRealActivate: TNotifyEvent read FOnActivate write FOnActivate;
  end;

implementation
uses SoUtils, Forms;

procedure TsohoFormActive.DoFormCreate(Sender: TObject);
var Form: TForm;
begin
  Form := GetOwnerForm(Self);
  {   ,  , . , 
               . -
          ! }
  if Form <> nil then PostMessage(Form.Handle, WM_REALACTIVATE, 0, 0);
  if Assigned(FOnCreate) then FOnCreate(Sender);
end;

procedure TsohoFormActive.RealActivate(var message: TMessage);
begin
  if Assigned(FOnActivate) then FOnActivate(Self);
end;

procedure TsohoFormActive.Loaded;
var Form: TForm;
begin
  inherited Loaded;
  if csDesigning in ComponentState then exit;
  Form := GetOwnerForm(Self);
  if Form <> nil then begin
    FOnCreate := Form.OnCreate;
    Form.OnCreate := DoFormCreate;
  end;
end;

destructor TsohoFormActive.Destroy;
var Form: TForm;
begin
  if not (csDesigning in ComponentState) then begin
    Form := GetOwnerForm(Self);
    if Form <> nil then Form.OnCreate := FOnCreate;
  end;
  inherited Destroy;
end;

end.

