{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{            Written by VSM, Allex, MVL                 }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
     TsohoFolder.    
    TsohoDBGrid  run-time 
}
unit SoFolder;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Controls, SoCtmFld;

type

  {        TsohoDBGrid 
    run-time .      
       TsohoDBGrid,     
      .    "" TsohoDBGrid ( Grid),
     ini- (FolderName  FolderDir  ).  Auto = true
    ,        DataSet,
      .    DisplayLabel, DisplayFormat 
     , TsohoCustomFolder      
    Calculated-,       .  DataSet
     TsohoDBGrid   ,     
        ,     TableName
  }
  TsohoFolder = class(TsohoCustomFolder)
  private
    FDataBaseName : string;
  protected
    procedure CreateRealField; override;
    procedure DeleteRealField; override;
    procedure ChangeVisible; override;
  public  
    procedure SetEvents;override;
  published
    {   ""   DataSet.   true
    TsohoFolder      
            "Protect".
      ,     false  
      }
    property ProtectView default true;
    {     }
    property DataBaseName : string read FDataBaseName write FDataBaseName;
    {   ,      }
    property Grid;
    {      DataSet',  
      Grid  DataSource }
    property Auto;
    {   - }
    property FolderName;
    { ,      }
    property FolderDir;
    {    .   ,    
          }
    property TableName;
    {     }
    property EnabledMenus;
    {      DataSet }
    property OnSaveDataSet;
    {      DataSet }
    property OnLoadDataSet;
    {       Grid }
    property OnChange;
  end;

implementation
uses SoUtils, DBTables, SoDBRtn, SoCrFldF, SoRghtsF, SoCtmRgs, SoUnit, SoDBCns;

procedure TsohoFolder.CreateRealField;
var SQLCommand: string;
    TmpQuery: TQuery;
begin
  if not CreateNewField(SQLCommand) then exit;
  TmpQuery := nil;
  try
    TmpQuery := TQuery.Create(Self);
    with TmpQuery, SQL do begin
      if ExtractFileExt(TableName) = '' then
        Add('ALTER TABLE ' + TableName + ' ADD ' + SQLCommand)
      else
        Add('ALTER TABLE "' + TableName + '" ADD ' + SQLCommand);
      try
        DataSet.Close;
        SetCursor(crHourGlass);
        DataBaseName := FDataBaseName;
        ExecSQL;
        ReOpen;
      except ErrorMsg(Format(sohoFolderColumnCreateError, [Self.Name]));
      end;
    end;
  finally
    if TmpQuery <> nil then TmpQuery.Free;
    RestoreCursor;
  end;
end;

procedure TsohoFolder.DeleteRealField;
var TmpQuery: TQuery;
begin
  if not YesNoMsg(Format(sohoFolderBeforeColumnDelete,
    [Grid.SelectedField.FieldName])) then exit;
  TmpQuery := nil;
  try
    TmpQuery := TQuery.Create(Self);
    with TmpQuery, SQL do begin
      if ExtractFileExt(TableName) = '' then
        Add('ALTER TABLE ' + TableName + ' DROP ' + Grid.SelectedField.FieldName)
      else
        Add('ALTER TABLE "' + TableName + '" DROP ' + Grid.SelectedField.FieldName);
      try
        DataSet.Close;
        SetCursor(crHourGlass);
        DataBaseName := FDataBaseName;
        ExecSQL;
        ReOpen;
      except ErrorMsg(Format(sohoFolderColumnDeleteError, [Self.Name]));
      end;
    end;
  finally
    if TmpQuery <> nil then TmpQuery.Free;
    RestoreCursor;
  end;
end;

procedure TsohoFolder.ChangeVisible;
var FieldRights, aOld, RecordRights : byte;
    IsRightsField : boolean;
begin
  {     ,     }
  if SingleRegister = nil then exit;
  IsRightsField := DataSet.FindField('Protect')<>nil;
  aOld := 0;
  if IsRightsField then
    aOld := DataSet.FieldByName('Protect').AsInteger;
  RecordRights := aOld;
  if not SetDataRights(FieldRights, RecordRights, IsRightsField) then exit;
  if (FieldRights in DataReadRights) or
    (FieldRights in DataWriteRights) then
    Grid.SelectedField.Tag := FieldRights
  else InfoMsg(Format(sohoFolderYouCanUse, [SetToStr(DataReadRights + DataWriteRights)]));

  FIni.WriteInteger(Grid.SelectedField.FieldName, 'Tag', Grid.SelectedField.Tag);
  if (aOld<>RecordRights) and (DataSet.FindField('Protect')<>nil) then
    if (RecordRights in DataReadRights) or
       (RecordRights in DataWriteRights) then begin
       with TQuery.Create(nil) do begin
         DataBaseName := FDataBaseName;
         if ExtractFileExt(TableName) <> '' then
           SQL.Add('update "'+TableName+'" set Protect='+IntToStr(RecordRights)+
              ' where '+KeyField+'='+DataSet.FieldByName(KeyField).AsString)
         else
           SQL.Add('update '+TableName+' set Protect='+IntToStr(RecordRights)+
              ' where '+KeyField+'='+DataSet.FieldByName(KeyField).AsString);
         try
           ExecSQL;
         except
           on E: Exception do ErrorMsg(Name+': '+E.Message);
         end;
         Free;
       end;
       RefreshDataSetWithId(DataSet, KeyField);
    end
    else InfoMsg(Format(sohoFolderYouCanUse, [SetToStr(DataReadRights + DataWriteRights)]));
  Changed;
end;

procedure TsohoFolder.SetEvents;
begin
  if FDataBaseName='' then
    if SingleRegister <> nil then FDataBaseName := SingleRegister.PathToData;
  inherited SetEvents;
end;

end.
