{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoFldMnF;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, SoTools, StdCtrls, SohoBtns, SoUnit;

type
  
  TItemsBounds = 0..16;
  
  TFolderMenusForm = class(TForm)
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    sohoEnterTab1: TsohoEnterTab;
  private
    { Private declarations }
    FItems: array[TItemsBounds] of TCheckBox;
    function GetNewEnabledMenus(OldMenus: string; var NewMenus: string): boolean;
  public
    { Public declarations }
  end;
  
var FolderMenusForm: TFolderMenusForm;
  
function GetNewEnabledMenus(OldMenus: string; var NewMenus: string): boolean;

implementation
uses SoCtmFld;

{$R *.DFM}


const MenusIndexes: array[TItemsBounds] of Integer =
  (mDisplaylabel, mDisplayWidth, mDisplayFormat, mFieldAlign, mHideField, mCreateField,
    mDeleteField, mChangeField, mChangeVisible, mSaveFolder, mLoadFolder, mTitleLines,
    mTitleAlign, mCreateRField, mDeleteRField, mAddLink, mDeleteLink);
  
function GetNewEnabledMenus(OldMenus: string; var NewMenus: string): boolean;
begin
  Result := False;
  try
    FolderMenusForm := TFolderMenusForm.Create(Application);
    Result := FolderMenusForm.GetNewEnabledMenus(OldMenus, NewMenus);
  finally
    FolderMenusForm.Free;
  end;
end;

function TFolderMenusForm.GetNewEnabledMenus(OldMenus: string; var NewMenus: string): boolean;
var index: Longint;
  ResSet: SetOfByte;
begin
  ResSet := StrToSet(OldMenus);
  for index := Low(FItems) to High(FItems) do begin
    FItems[index] := TCheckBox.Create(Self);
    FItems[index].Parent := Self;
    FItems[index].Top := 10 + index * 20;
    FItems[index].Width := 260;
    FItems[index].Left := 10;
    FItems[index].Caption := GetMenuCaption(MenusIndexes[index]);
    FItems[index].Checked := (MenusIndexes[index] + 1) in ResSet;
  end;
  Result := ShowModal = mrOk;
  if Result then begin
    ResSet := [];
    for index := Low(FItems) to High(FItems) do
      if FItems[index].Checked then ResSet := ResSet + [MenusIndexes[index] + 1];
    NewMenus := SetToStr(ResSet);
  end;
  for index := Low(FItems) to High(FItems) do FItems[index].Free;
end;

end.

