{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{            Written by VSM, Allex, MVL                 }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit Sofldfrm;

{$I SOHOLIB.INC}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, StdCtrls, SohoBtns, SohoTabs, ExtCtrls, SoCtrls, SoTools,
  Db, SoUnit, SoDBGrid;

type
  TsohoFolderForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Notebook1: TNotebook;
    TabSet: TsohoTabSet;
    CancelB: TsohoBitBtn;
    OkB: TsohoBitBtn;
    sohoLabel1: TsohoLabel;
    sohoLabel2: TsohoLabel;
    AlignGroup: TRadioGroup;
    FormatE: TsohoEdit;
    WidthE: TsohoEdit;
    TitleM: TMemo;
    sohoLabel3: TsohoLabel;
    sohoLabel4: TsohoLabel;
    AlignTitle: TRadioGroup;
    TitleHeightE: TsohoEdit;
    ShowTitleC: TCheckBox;
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    FunctionNumber : integer;
  end;

var sohoFolderForm: TsohoFolderForm;

function SetField (Field : TField; EnabledMenus : SetOfByte; Grid : TsohoDBGrid;
         TabIndex : integer; FuncNumber : integer) : boolean;

implementation
uses SoCtmFld, SoUtils, DBGrids;

{$R *.DFM}

procedure PrepareForm (Field : TField; EnabledMenus : SetOfByte; Grid : TsohoDBGrid);
var aIndex : integer;
begin
     with Field, sohoFolderForm do begin
       AlignGroup.ItemIndex := integer(Alignment);
       if IsProperty(Field,'DisplayFormat') then
         FormatE.AsString := GetStringProperty(Grid.SelectedField,'DisplayFormat')
       else FormatE.Enabled := false;
       WidthE.AsInteger := Grid.ColWidthsByFieldIndex[Grid.SelectedIndex];
       SetDivisers(['~']);
       with TitleM, Lines do begin
         Clear;
         for aIndex := 1 to WordsInString(DisplayLabel) do
          Add(GetSomeWords(DisplayLabel,aIndex,aIndex));
       end;
       AlignTitle.ItemIndex   := integer(Grid.TitleAlignment);
       TitleHeightE.AsInteger := Grid.TitleLines;
       ShowTitleC.Checked     := dgTitles in Grid.Options;

       {  ,   ! }
       TitleM.Enabled       := (mDisplaylabel+1 in EnabledMenus);
       WidthE.Enabled       := (mDisplayWidth+1 in EnabledMenus);
       TsohoBitBtn(WidthE.Button).Enabled  := (mDisplayWidth+1 in EnabledMenus);
       FormatE.Enabled      := FormatE.Enabled and (mDisplayFormat+1 in EnabledMenus);
       AlignGroup.Enabled   := (mFieldAlign+1 in EnabledMenus);
       TitleHeightE.Enabled := (mTitleLines+1 in EnabledMenus);
       TsohoBitBtn(WidthE.Button).Enabled := (mTitleLines+1 in EnabledMenus);
       AlignTitle.Enabled   := (mTitleAlign+1 in EnabledMenus);
       ShowTitleC.Enabled   := AlignTitle.Enabled and TitleHeightE.Enabled;
     end;
end;

procedure ChangeField (Field : TField; EnabledMenus : SetOfByte; Grid : TsohoDBGrid);
var TmpTitle : string;
    aIndex   : integer;
begin
     with Field, sohoFolderForm do begin
       {  ,   ! }
       if TitleM.Enabled then begin
          TmpTitle := '';
          for aIndex := 0 to pred(TitleM.Lines.Count) do
            TmpTitle := TmpTitle + TitleM.Lines.Strings[aIndex]+'~';
          if TmpTitle[length(TmpTitle)]='~' then TmpTitle := Copy(TmpTitle,1,length(TmpTitle)-1);
          DisplayLabel := TmpTitle;
       end;
       if WidthE.Enabled then Grid.ColWidthsByFieldIndex[Grid.SelectedIndex] := WidthE.AsInteger;
       if FormatE.Enabled then
         SetStringProperty(Grid.SelectedField,'DisplayFormat',FormatE.AsString);
       if AlignGroup.Enabled then Alignment := TAlignment(AlignGroup.ItemIndex);
       if TitleHeightE.Enabled and (TitleHeightE.AsInteger>0) then
          Grid.TitleLines := TitleHeightE.AsInteger;
       if AlignTitle.Enabled then
          Grid.TitleAlignment := TAlignment(AlignTitle.ItemIndex);
       if ShowTitleC.Enabled then begin
         if ShowTitleC.Checked then Grid.Options := Grid.Options + [dgTitles]
         else Grid.Options := Grid.Options - [dgTitles];
       end;
     end;
end;

function SetField (Field : TField; EnabledMenus : SetOfByte; Grid : TsohoDBGrid;
         TabIndex : integer; FuncNumber : integer) : boolean;
begin
     Result := false;
     try
        sohoFolderForm := TsohoFolderForm.Create(Application);
        PrepareForm(Field, EnabledMenus, Grid);
        with sohoFolderForm do begin
          TabSet.TabIndex := TabIndex;
          FunctionNumber := FuncNumber;
          Result := ShowModal=mrOk;
        end;
        if Result then ChangeField(Field, EnabledMenus, Grid);
     finally
        sohoFolderForm.Free;
     end;
end;

procedure TsohoFolderForm.FormShow(Sender: TObject);
begin
     case FunctionNumber of
       mDisplaylabel   : begin
         TitleM.SetFocus;
         TitleM.SelStart := 0;
       end;
       mDisplayWidth   : WidthE.SetFocus;
       mDisplayFormat  : FormatE.SetFocus;
       mFieldAlign     : AlignGroup.SetFocus;
       mTitleLines     : TitleHeightE.SetFocus;
       mTitleAlign     : AlignTitle.SetFocus;
     end;
end;

end.
