{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoExcelReporter -   
  MicroSoft Excel
}
unit SoExlRep;

{$I SOHOLIB.INC}


interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
     SoCtmFld, Db, SoRepPrg;

const

  {          }
  erGridLeftColumnMark  = '#BEGINTABLE';
  {          }
  erGridRightColumnMark = '#ENDTABLE';

type

  PsohoExcelField = ^TsohoExcelField;
  {     TsohoExcelReporter }
  { FieldIndex -  Index  TDataSet }
  { DisplayLabel -       }
  { ExcelColumn -    ,    
    .   -1,   ,       }
  TsohoExcelField = record
    FieldIndex: Longint;
    DisplayLabel: string;
    ExcelColumn: Longint;
  end;


  {    OnPutRecord. Row -    }
  TsohoExcelOnPutRecord = procedure (Sender: TObject; DataSet: TDataSet; Row: Longint) of object;

  {    OnGetText.   Field,   
        (Column, Row)    Text }
  TsohoExcelOnGetText = procedure (Sender: TObject; Field: TField; Column, Row: Longint;
    var Text: string) of object;

  {    BeforePrint.    ,  Allow
      false }
  TsohoExcelAllowNotify = procedure (Sender: TObject; var Allow: Boolean) of object;

  {  TsohoExcelReporter:
    erGridFields -     ,
    erListFields -     PrintFields
  }
  TsohoExcelReporterOption = (erGridFields, erListFields);
  {    TsohoExcelReporter }
  TsohoExcelReporterOptions = set of TsohoExcelReporterOption;

  {   ,       
    :
    paPreview   -   
    paPrint     -      
    paShowExcel -   Excel
    paNone      -   
  }
  TsohoExcelPrintAction = (paPreview, paPrint, paShowExcel, paNone);

  {      :   ,
      ,     }
  TsohoExcelReporterTempFree = (tfOnCreate, ftOnDestroy, tfNone);


  {     .   OLE-Automation,
      MicroSoft Excel.    *.XLS,    
    : #_        : #__
    (DisplayLabel).      TsohoDBGrid 
     '~',          '_'.  
    PrintDocument    .    PrintDocuments 
        ,   ,   
      -       
          .    
      ,     .
  }
  TsohoExcelReporter = class(TComponent)
  private
    { Private declarations }
    FBookClosed: Boolean;
    FSheet,
      FWorkBook: Variant;
    FFolder: TsohoCustomFolder;
    FAutoClose: Boolean;
    FHiddenExcel: Boolean;
    FFields: TList;
    FFromCol, FToCol: Longint;
    FRecCount: Longint;
    FRow: Longint;

    FParams: TStringList;
    FValues: TStringList;

    FTemplate: string;
    FSaveFile: string;
    FGenSaveFile : string;
    FBlankRange: string;
    FVer70: boolean;

    FOptions: TsohoExcelReporterOptions;
    FTempFree : TsohoExcelReporterTempFree;
    FPrintAction : TsohoExcelPrintAction;
    FPrintFields: TStringList;

    FOnPutRecord: TsohoExcelOnPutRecord;
    FOnGetText: TsohoExcelOnGetText;
    FBeforePrint,
    FAfterTransfer: TsohoExcelAllowNotify;
    FAfterPrint,
    FOnPreview  : TNotifyEvent;

    FProgress: TsohoReportProgressForm;

    FEndRow: Longint;
    FQuickPrint : boolean;
    FCopies : Integer;
    FPrintToFile : boolean;
    FPrintDialog : boolean;

    function GetExcelActivated: Boolean;
    procedure SetPrintFields(Value: TStringList);
    procedure SetCopies (Value : integer);
  protected
    { Protected declarations }
    procedure FreeFields;
    function PrepareFields: Boolean;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    function GetField(index: Longint): TsohoExcelField;
    procedure Loaded;override;
    procedure DeleteSavedFiles;virtual;
  public
    {      }
    function SelectTemplate (TemplatesDir: string) : string;
    {          Ms Excel.  
         Excel    }
    function ExlRange (aRange : string) : Variant;
    {         Ms Excel.  
         Excel     }
    function ExlCells (aRow, aCol : LongInt) : Variant;
    {  true,    Ms Office - '7.0'}
    function IsVersion70 : boolean;
    {  ,     .    
      SaveFile,     }
    property GeneratedSaveFile : string read FGenSaveFile;
    {    }
    procedure ClearParams;
    {    }
    function ParamsCount: Longint;
    {      }
    procedure SetValueByName(const ParamName, Value: string);
    {      }
    procedure SetValueByIndex(ParamIndex: Longint; const Value: string);
    {      }
    function GetValueByName(const ParamName: string): string;
    {      }
    function GetValueByIndex(ParamIndex: Longint): string;

    {  "" .    }
    function PrintTitle: Boolean;
    {  .     }
    function PrintTable : Boolean;
    {  .    PrintTitle, PrintTable, 
       Excel    Preview }
    function PrintDocument  (TemplateName: string; SaveFileName: string): Boolean;
    {    ,    .   
         ,     
        }
    function PrintDocuments (TemplatesDir: string; SaveFileName: string): Boolean;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    {   ,    }
    procedure CloseWorkBook;
    {  Excel.         Excel,
         .   Excel    SohoOLE }
    procedure CloseExcel;
    {   Excel }
    function OpenExcel: Boolean;
    {     }
    property Sheet: Variant read FSheet write FSheet {04/10/98};
    {    ,    }
    property WorkBook: Variant read FWorkBook write FWorkBook {04/10/98};
    {    }
    property RecordCount: Longint read FRecCount;
    {   Excel -    }
    property Activated: Boolean read GetExcelActivated;
    {      }
    property Fields[index: Longint]: TsohoExcelField read GetField;
    {    }
    property FromColumn: Longint read FFromCol;
    {    }
    property ToColumn: Longint read FToCol;
    {  ,         }
    property EndRow: Longint read FEndRow;
    {     }
    property BookClosed : boolean read FBookClosed write FBookClosed; {04/10/98}
  published
    {   ,  PrintAction = paPrint }
    property PrintToFile : boolean read FPrintToFile write FPrintToFile default false;
    {    TsohoExcelReporter   }
    property PrintDialog : boolean read FPrintDialog write FPrintDialog default false;
    {       }
    property PrintCopies : integer read FCopies write SetCopies default 1;
    {  ,       }
    property PrintAction : TsohoExcelPrintAction read FPrintAction write FPrintAction default paPreview;
    {      }
    property TempFree : TsohoExcelReporterTempFree read FTempFree write FTempFree default ftOnDestroy;
    {  ""  Clipboard }
    property QuickPrint : boolean read FQuickPrint write FQuickPrint default true;
    {   }
    property Options: TsohoExcelReporterOptions read fOptions write fOptions default[erGridFields];
    {  ,      erListFields   }
    property PrintFields: TStringList read FPrintFields write SetPrintFields;
    {   Excel    }
    property AutoClose: Boolean read FAutoClose write FAutoClose default True;
    {  Excel     Preview }
    property HiddenExcel: Boolean read FHiddenExcel write FHiddenExcel default True;
    {     TsohoCustomFolder }
    property Folder: TsohoCustomFolder read FFolder write FFolder;
    {   - *.XLS }
    property Template: string read FTemplate write FTemplate;
    {  ,      "".  
       ,       }
    property SaveFile: string read FSaveFile write FSaveFile;
    {    -,       
       }
    property BlankRange: string read FBlankRange write FBlankRange;
    {       Excel }
    property OnPutRecord: TsohoExcelOnPutRecord read FOnPutRecord write FOnPutRecord;
    {        Excel }
    property OnGetText: TsohoExcelOnGetText read FOnGetText write FOnGetText;
    {     }
    property OnBeforePrint: TsohoExcelAllowNotify read FBeforePrint write FBeforePrint;
    {     }
    property OnAfterPrint : TNotifyEvent read FAfterPrint write FAfterPrint;
    {      }
    property OnPreview  : TNotifyEvent read FOnPreview write FOnPreview;
    {        }
    property OnAfterTransfer: TsohoExcelAllowNotify read FAfterTransfer write FAfterTransfer;
  end;

implementation
uses SoUtils, ComObj, SohoOLE, StdCtrls, FileCtrl, SohoBtns, SoCtrls,
     Clipbrd, SoExRepD, SoExlCst, SoDBCns;

const

  erFromCol = 1001;
  erToCol   = -1;

{       2:5020/400 }
function TextToClipboard (const Text : WideString) : boolean;
var swHandle : THandle;
    swSize   : integer;
    psw      : pointer;
begin
  if Win32Platform = VER_PLATFORM_WIN32_NT then  begin
     swSize := (Length(Text)+1)*SizeOf(WideChar);
     ClipBoard.Open;
     try
       Clipboard.Clear;
       Sleep(500);
       swHandle := GlobalAlloc(GMEM_MOVEABLE, swSize);
       try
         psw := GlobalLock(swHandle);
         Move(Text[1], psw^, swSize);
         Clipboard.SetAsHandle(CF_UNICODETEXT, swHandle);
         GlobalUnlock(swHandle);
       finally
         GlobalFree(swHandle);
       end;
     finally
       Clipboard.Close;
     end;
   end
   else begin
     Clipboard.SetTextBuf(PChar(WideCharToString(@Text[1])));
     Clipboard.Close;
   end;
   Sleep(400);
end;

function TsohoExcelReporter.IsVersion70 : boolean;
begin
  Result := FVer70;
end;

function TsohoExcelReporter.ExlRange (aRange : string) : Variant;
begin
  if FVer70 then Result := FSheet.Range(aRange)
  else Result := FSheet.Range[aRange];
end;

function TsohoExcelReporter.ExlCells (aRow, aCol : LongInt) : Variant;
begin
  if FVer70 then Result := FSheet.Cells(aRow, aCol)
  else Result := FSheet.Cells[aRow, aCol];
end;

procedure TsohoExcelReporter.SetCopies (Value : integer);
begin
  if Value<0 then exit;
  FCopies := Value;
end;

procedure TsohoExcelReporter.SetPrintFields(Value: TStringList);
var Index: Longint;
begin
  FPrintFields.Assign(Value);
  if FPrintFields <> nil then
    for index := 0 to pred(FPrintFields.Count) do
      FPrintFields[index] := AnsiUpperCase(FPrintFields[index]);
end;

function TsohoExcelReporter.GetField(index: Longint): TsohoExcelField;
begin
  Result := PsohoExcelField(FFields[index])^;
end;

function TsohoExcelReporter.GetExcelActivated: Boolean;
begin
  Result := ExcelOpened;
end;

function TsohoExcelReporter.PrepareFields: Boolean;
var index: Longint;
  NewField: PsohoExcelField;
  Col     : Longint;
  AddField: Boolean;
  Field   : TField;
  Found : Variant;
begin
  Result := False;
  if not Activated then exit;
  if FFolder = nil then begin
    ErrorMsg(Format(sohoExlRepFolderUnknown, [Name]));
    exit;
  end;
  if FFolder.DataSet = nil then begin
    ErrorMsg(Format(sohoExlRepFolderDataSetUnknown, [Name]));
    exit;
  end;
  if not FFolder.DataSet.Active then begin
    ErrorMsg(Format(sohoExlRepFolderDataSetInactive, [Name]));
    exit;
  end;

  {08/10/98 >>}
  //    
  for Index := 0 to pred(FFields.Count) do
    Dispose(PsohoExcelField(FFields[index]));
  FFields.Clear;
  {08/10/98 <<}

  //    
  for Index := 0 to pred(FFolder.DataSet.FieldCount) do begin
    Field := FFolder.DataSet.Fields[index];
    AddField := Field.Visible and (erGridFields in fOptions);
    AddField := ((FPrintFields.IndexOf(AnsiUpperCase(Field.FieldName)) <> -1)
      and (erListFields in fOptions))
      or AddField;
    if AddField then begin
      New(NewField);
      NewField.FieldIndex := index;
      NewField.DisplayLabel := ChangeChars('#' + Field.DisplayLabel, '~', '_');
      FFields.Add(NewField);
    end;
  end;

  FFromCol := erFromCol;
  FToCol := erToCol;

  FRow := -1;

  if VarIsEmpty(FSheet) then exit;

  for Index := 0 to pred(FFields.Count) do
    try
      NewField := PsohoExcelField(FFields[index]);
      Found := ExlRange(BlankRange).Find(What := NewField^.DisplayLabel, lookAt := 1);
      if TVarData(Found).VDispatch <> nil then begin
        Col := Found.Column;
        if Col < FFromCol then FFromCol := Col;
        if Col > FToCol then FToCol := Col;

        NewField^.ExcelColumn := Col;
        if Found.Row <> FRow then
          if FRow = -1 then FRow := Found.Row
          else InfoMsg(sohoExlRepStupidTemplate);
      end
      else NewField^.ExcelColumn := -1;
    except
      NewField^.ExcelColumn := -1;
    end;

  //   ,   ,     
  //  ?   !
  try
    Found := ExlRange(BlankRange).Find(What := erGridRightColumnMark, lookAt := 1);
    if TVarData(Found).VDispatch <> nil then FToCol := Found.Column;
  except
  end;
  try
    Found := ExlRange(BlankRange).Find(What := erGridLeftColumnMark, lookAt := 1);
    if TVarData(Found).VDispatch <> nil then FFromCol := Found.Column;
  except
  end;

  Result := True;
end;

procedure TsohoExcelReporter.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (AComponent = FFolder) and (Operation = opRemove) then FFolder := nil;
  inherited Notification(AComponent, Operation);
end;

function TsohoExcelReporter.ParamsCount: Longint;
begin
  Result := FParams.Count;
end;

procedure TsohoExcelReporter.SetValueByName(const ParamName, Value: string);
var Index: Longint;
begin
  Index := FParams.IndexOf(AnsiUpperCase(ParamName));
  if index = -1 then begin
    //    
    FParams.Add(AnsiUpperCase(ParamName));
    FValues.Add(Value);
  end
  else SetValueByIndex(index, Value);
end;

procedure TsohoExcelReporter.SetValueByIndex(ParamIndex: Longint; const Value: string);
begin
  FValues[ParamIndex] := Value;
end;

function TsohoExcelReporter.GetValueByName(const ParamName: string): string;
var index: Longint;
begin
  index := FParams.IndexOf(AnsiUpperCase(ParamName));
  if index = -1 then begin
    ErrorMsg(Format(sohoExlRepParamNotFound, [Name, ParamName]));
    exit;
  end;
  Result := FValues[index];
end;

function TsohoExcelReporter.GetValueByIndex(ParamIndex: Longint): string;
begin
  Result := FValues[ParamIndex];
end;

procedure TsohoExcelReporter.ClearParams;
begin
  FValues.Clear;
  FParams.Clear;
end;

function TsohoExcelReporter.PrintTitle: Boolean;
var Index: Longint;
begin
  //        -  
  Result := false;
  if VarIsEmpty(FSheet) then exit;
  try
    for Index := 0 to pred(ParamsCount) do
      ExlRange(BlankRange).Replace(What := FParams[index],
        Replacement := FValues[index], lookAt := xlPart,
        SearchOrder := xlByRows, MatchCase := False);
  except
  end;
  Result := true;
end;

function TsohoExcelReporter.PrintTable : Boolean;
var Index_1, RecIndex, index: Longint;
    Field    : PsohoExcelField;
    PrintText: string;
    {11/10/98 >>}
    //BufferText : PString;
    BufferText : PString;
    BufferFields : TList;
    //WideBufferFields
    MainClip : TClipboard;
    {11/10/98 <<}
    Allow : boolean; {12/10/98}
begin
  Result := false;
  if VarIsEmpty(FSheet) then exit;
  if not Activated then exit;
  if not PrepareFields then exit;
  FRecCount := FFolder.DataSet.RecordCount;
  FEndRow := FRow;
  if FRecCount = 0 then exit;
  //    Progress
  // RestoreCursor;
  FProgress := CreateProgressDialog(sohoExlRepPrint, sohoExlRepPrinting);
  FProgress.Gauge.MaxValue := 10*FFields.Count+FRecCount + 3; //    -   
  FProgress.Show;
  FProgress.SetMessage(sohoExlRepTablePreparing);
  if FRecCount>1 then
     ExlRange(ExcelRectToStr(FFromCol, FRow, FToCol,
         FRow + FRecCount-2)).Insert (Shift := xlDown);
  FProgress.SetMessage(sohoExlRepTableFormating);
  FProgress.Gauge.AddProgress(2);
  //           
  //   !
  MainClip := Clipboard;
  if FRecCount > 1 then begin
    ExlRange( ExcelRectToStr(FFromCol, FRow + FRecCount-1,
                                 FToCol, FRow + FRecCount-1)).Copy;
    ExlRange( ExcelRectToStr(FFromCol, FRow, FToCol, FRow + FRecCount-2)).Select;
    FSheet.Paste;
    MainClip.Clear;
    FProgress.Gauge.AddProgress(3);
    FEndRow := FRow + FRecCount - 1;
  end
  else FEndRow := FRow;

  try
    FFolder.DataSet.DisableControls;
    FFolder.DataSet.First;
    if not FQuickPrint then begin
       //  
       FProgress.SetMessage(sohoExlRepRecordsCopying);
       for RecIndex := 1 to FRecCount do begin
         for index := 0 to pred(FFields.Count) do begin
           //  ,  
           Application.ProcessMessages;
           if FProgress.Stopped then begin
             FProgress.Free;
             FFolder.DataSet.EnableControls;
             HideExcel;
             exit;
           end;
           Field := PsohoExcelField(FFields[index]);
           if Field^.ExcelColumn <> -1 then begin
             PrintText := FFolder.DataSet.Fields[Field^.FieldIndex].AsString;
             if Assigned(FOnGetText) then FOnGetText(Self, FFolder.DataSet.Fields[Field^.FieldIndex],
               Field^.ExcelColumn, pred(FRow + RecIndex), PrintText);
             ExlCells(pred(FRow + RecIndex), Field^.ExcelColumn).Value := PrintText;
           end;
         end;
         if Assigned(OnPutRecord) then OnPutRecord(Self, FFolder.DataSet, pred(FRow + RecIndex));
         FFolder.DataSet.Next;
         FProgress.Gauge.AddProgress(1);
       end;
    end
    {11/10/98 >>}
    else begin
       //   Clipboard
       FProgress.SetMessage(sohoExlRepRecordsPreparing);
       BufferFields := TList.Create;
       for Index := 0 to pred(FFields.Count) do begin
         New(BufferText);
         BufferFields.Add(BufferText);
       end;

       for RecIndex := 1 to FRecCount do begin {Record begin}
         for Index := 0 to pred(FFields.Count) do begin
           //  ,  
           Application.ProcessMessages;
           if FProgress.Stopped then begin
             FProgress.Free;
             FFolder.DataSet.EnableControls;
             HideExcel;
             for Index_1 := 0 to pred(FFields.Count) do
               Dispose(PString(BufferFields[Index_1]));
             BufferFields.Free;
             Exit;
           end;
           Field := PsohoExcelField(FFields[index]);
           if Field^.ExcelColumn <> -1 then begin
             PrintText := FFolder.DataSet.Fields[Field^.FieldIndex].AsString;
             if Assigned(FOnGetText) then FOnGetText(Self, FFolder.DataSet.Fields[Field^.FieldIndex],
               Field^.ExcelColumn, pred(FRow + RecIndex), PrintText);
             // ClipBoard
             BufferText := BufferFields[Index];
             BufferText^ := BufferText^ + PrintText + #13;
           end;
         end;
         if Assigned(OnPutRecord) then OnPutRecord(Self, FFolder.DataSet, pred(FRow + RecIndex));
         FFolder.DataSet.Next;
         FProgress.Gauge.AddProgress(1);
       end; {Record end}

       // SwitchToRussian;{13/11/98}
       FProgress.SetMessage(sohoExlRepRecordsCopying);
       if not FVer70 then Sleep(100);
       // MainClip := Clipboard;
       for Index := 0 to pred(FFields.Count) do begin
         Field := PsohoExcelField(FFields[Index]);
         if Field^.ExcelColumn <> -1 then begin
         (*
           MainClip.Clear;
           MainClip.Open;
           MainClip.SetTextBuf(PChar(PString(BufferFields[Index])^));
           MainClip.Close;

           if not FVer70 then begin
             MainClip.Clear;
             MainClip.Open;
             MainClip.SetTextBuf(PChar(PString(BufferFields[Index])^));
             MainClip.Close;

             MainClip.Clear;
             MainClip.Open;
             MainClip.SetTextBuf(PChar(PString(BufferFields[Index])^));
             MainClip.Close;
             Sleep(400);
           end;
          *)
           TextToClipboard(PString(BufferFields[Index])^);
           ExlCells(FRow, Field^.ExcelColumn).Select;

           if not FVer70 then Sleep(100);
           FSheet.Paste;
           MainClip.Clear;
           FProgress.Gauge.AddProgress(10);
         end;
       end;
       // RestoreLayout; {13/11/98}
       for Index := 0 to pred(FFields.Count) do
         Dispose(PString(BufferFields[Index]));
       BufferFields.Free;
    end;
    {11/10/98 <<}
    FProgress.Free;
    {12/10/98 >>}
    Allow := true;
    if Assigned(FAfterTransfer) then FAfterTransfer(Self, Allow);
    if not Allow then exit;
    case FPrintAction of
      paPreview : begin
        ShowExcel;
        if Assigned(FOnPreview) then FOnPreview(Self);
        FSheet.PrintPreview;
      end;
      paPrint :
         try
          FSheet.PrintOut (Copies := FCopies, PrintToFile := FPrintToFile);
         except
           on E: Exception do ErrorMsg(E.Message);
         end;
      paShowExcel : ShowExcel; {25/10/98}
    end;
    {12/10/98 <<}
    Result := True;
  finally
    FFolder.DataSet.EnableControls;
  end;
end;

function TsohoExcelReporter.OpenExcel: Boolean;
var TmpName, TmpPath: string;
  TmpCount            : Longint;
  Hour, Min, Sec, MSec: Word;
begin
  Result := false;
  try
    if not Activated then SohoOLE.OpenExcel;
    if not FHiddenExcel then ShowExcel;
    if not FBookClosed then CloseWorkBook;
      {    - Excel  -   ,  
            }
    if not ExcelOpened then
      if not ReOpenExcel then exit;
    FVer70 := ExcelVersionIs70;
    if FTemplate = '' then FWorkBook := MsExcel.WorkBooks.Add
    else
      if not FileExists(FTemplate) then begin
        ErrorMsg(Format(sohoExlRepTemplateNotFound, [Name, FTemplate]));
        exit;
      end
      else FWorkBook := MsExcel.WorkBooks.Open(FTemplate);

    {     ,      
        -    ,    SaveFile, 
         ,   Save }
    DecodeTime(Time, Hour, Min, Sec, MSec);
    TmpCount := 0; TmpName := IntToStr(Hour) + IntToStr(Min) + IntToStr(Sec);

    {11/10/98 >>}
    TmpPath := GetPathToLocalTemp;
    {11/10/98 <<}
    while FileExists(TmpPath + TmpName + IntToStr(TmpCount) + '.XLS') do inc(TmpCount);
    {09/10/98 >>}
    if FSaveFile <> '' then begin
      FGenSaveFile := FSaveFile;
      if FileExists(FGenSaveFile) then DeleteFile(FGenSaveFile);
      FWorkBook.SaveAs(FSaveFile);
    end
    else begin
      FGenSaveFile := TmpPath + TmpName + IntToStr(TmpCount) + '.XLS';
      FWorkBook.SaveAs(FGenSaveFile);
    end;
    {09/10/98 <<}
    if FVer70 then FSheet := FWorkBook.Sheets(1)
    else FSheet := FWorkBook.Sheets[1];
    FBookClosed := False;
    Result := True;
  except ErrorMsg(Format(sohoExlRepFileOpenError, [FTemplate]));
  end;
end;

function TsohoExcelReporter.PrintDocument(TemplateName: string; SaveFileName: string): Boolean;
begin
  Result := true;
  if Assigned(FBeforePrint) then FBeforePrint(Self, Result);
  if not Result then exit;
  Result := False;
  if TemplateName = '' then TemplateName := FTemplate;
  if SaveFileName = '' then SaveFileName := FSaveFile;
  FTemplate := TemplateName;
  FSaveFile := SaveFileName;

  {25/10/98 >>}
  if FPrintDialog then
    if not GetExcelReportOptions(FPrintAction, FPrintToFile, FCopies) then exit;
  {25/10/98 <<}
  SetCursor(crHourGlass);
  if OpenExcel then
    if PrintTitle then
      if PrintTable then Result := True;
  RestoreCursor;
  if Assigned(FAfterPrint) then FAfterPrint(Self);
end;

function TsohoExcelReporter.SelectTemplate (TemplatesDir: string) : string;
var Templates : TStringList;
    Frm       : TForm;
    Combo     : TComboBox;
begin
  Templates := TStringList.Create;
  TemplatesDir := NormalDir(TemplatesDir);
  {if TemplatesDir[length(TemplatesDir)]<>'\' then
    TemplatesDir := TemplatesDir + '\';}
  FilesToStrings(Templates, TemplatesDir+'*.xls', faArchive);
  if Templates.Count = 0 then begin
    Templates.Free;
    exit;
  end;
  Result := '';
  if Templates.Count = 1 then begin
    Result := TemplatesDir + Templates[0];
    Templates.Free;
    exit;
  end
  else begin
    // o  ?
    try
      Frm := TForm.Create(Application);
      with Frm do begin
        Caption := sohoExlRepTemplateSelecting;
        ClientWidth   := 400;
        ClientHeight  := 82;
        Position := poScreenCenter;
        FormStyle := fsStayOnTop;
        Font.Name := 'Ms Sans Serif';
        Font.Size := 8;
        Font.Style := [fsBold];
        BorderStyle := bsDialog;
        Combo := TComboBox.Create(Frm);
        with Combo do begin
          Parent := Frm;
          Style  := csDropDownList;
          Items.Assign(TStrings(Templates));
          ItemIndex := 0;
        end;
        with TsohoLabel.Create(Frm) do begin
          Parent := Frm;
          Alive := true;
          Left := 4;
          Top  := 4;
          Caption := sohoExlRepSelectTemplate;
          Width  := Frm.ClientWidth - 8;
          Position := wlpTop;
          FocusControl := Combo;
          FontActive.Color := clRed;
        end;
        with TsohoBitBtn.Create(Frm) do begin
          Parent := Frm;
          Width := 75;
          Height := 24;
          Caption := 'OK';
          ModalResult := mrOk;
          Top := Combo.Top+Combo.Height + 2;
          Left := 242;
        end;
        with TsohoBitBtn.Create(Frm) do begin
          Parent := Frm;
          Width := 75;
          Height := 24;
          Caption := sohoExlRepCancelBtnCaption;
          ModalResult := mrCancel;
          Cancel := true;
          Top := Combo.Top+Combo.Height + 2;
          Left := 321;
        end;
      end;
      if Frm.ShowModal = mrOk then
        Result := TemplatesDir+Combo.Text;
    finally
      Frm.Free;
    end;
  end;
  Templates.Free;
end;

function TsohoExcelReporter.PrintDocuments (TemplatesDir: string; SaveFileName: string): Boolean;
var aTemplate : string;
begin
  Result := false;
  if not DirectoryExists(TemplatesDir) then exit;
  aTemplate := SelectTemplate (TemplatesDir);
  if aTemplate <> '' then
    Result := PrintDocument(aTemplate, SaveFileName);
end;

{11/10/98 >>}
procedure TsohoExcelReporter.Loaded;
begin
  inherited Loaded;
  if FTempFree = tfOnCreate then DeleteSavedFiles;
end;

procedure TsohoExcelReporter.DeleteSavedFiles;
var TmpPath : string;
    DeleteFiles : TStringList;
    Index : integer;
begin
  TmpPath := GetPathToLocalTemp;
  DeleteFiles := TStringList.Create;
  FilesToStrings(DeleteFiles, TmpPath+'*.xls', faArchive);
  for Index := 0 to pred(DeleteFiles.Count) do
    DeleteFile(TmpPath+DeleteFiles[Index]);
  DeleteFiles.Free;  
end;
{11/10/98 <<}

constructor TsohoExcelReporter.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FSheet := Unassigned;
  FWorkBook := Unassigned;
  FFolder := nil;
  FAutoClose := True;
  FBookClosed := True;
  FHiddenExcel := True;
  FFields := TList.Create;
  FRecCount := 0;
  FParams := TStringList.Create;
  FValues := TStringList.Create;
  FPrintFields := TStringList.Create;
  fOptions := [erGridFields];
  FBlankRange := 'A1:Z100';
  {11/10/98 >>}
  FQuickPrint := true;
  FTempFree := ftOnDestroy;
  FCopies := 1;
  FPrintAction := paPreview;
  {11/10/98 <<}
  {25/10/98 >>}
  FPrintToFile := false;
  FPrintDialog := false;
  {25/10/98 <<}
end;

procedure TsohoExcelReporter.CloseWorkBook;
begin
  if FBookClosed or (not ExcelOpened) or VarIsEmpty(FWorkBook) then exit;
  FBookClosed := true;
  try
    FWorkBook.Close(saveChanges := False);
  except
  end;  
end;

procedure TsohoExcelReporter.CloseExcel;
begin
  if not Activated then exit;
  CloseWorkBook;
  HideExcel;
  FSheet := Unassigned;
  FWorkBook := Unassigned;
end;

procedure TsohoExcelReporter.FreeFields;
var index: Longint;
begin
  for index := 0 to pred(FFields.Count) do
    Dispose(PsohoExcelField(FFields[index]));
  FFields.Free;
end;

destructor TsohoExcelReporter.Destroy;
begin
  if FAutoClose then CloseExcel;
  FreeFields;
  FParams.Free;
  FValues.Free;
  FPrintFields.Free;
  if FTempFree = ftOnDestroy then DeleteSavedFiles; { 11/10/98 }
  inherited Destroy;
end;

end.

