{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoExRepD;

{$I SOHOLIB.INC}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, SohoBtns, RXSpin, SoExlRep;

type
  TsohoExlRepPrintDialog = class(TForm)
    PrintActionG: TRadioGroup;
    GroupBox1: TGroupBox;
    PrintToFileC: TCheckBox;
    Label1: TLabel;
    CopiesE: TRxSpinEdit;
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    function Execute (var PrintAction : TsohoExcelPrintAction;
       var PrintToFile : boolean; var Copies : integer) : boolean;
  public
    { Public declarations }
  end;

var sohoExlRepPrintDialog: TsohoExlRepPrintDialog;

function GetExcelReportOptions (var PrintAction : TsohoExcelPrintAction;
   var PrintToFile : boolean; var Copies : integer) : boolean;

implementation

{$R *.DFM}

function GetExcelReportOptions (var PrintAction : TsohoExcelPrintAction;
   var PrintToFile : boolean; var Copies : integer) : boolean;
begin
  try
    sohoExlRepPrintDialog := TsohoExlRepPrintDialog.Create(Application);
    Result := sohoExlRepPrintDialog.Execute(PrintAction, PrintToFile, Copies);
  finally
    sohoExlRepPrintDialog.Free;
  end;
end;

procedure TsohoExlRepPrintDialog.FormCreate(Sender: TObject);
begin
  Icon.Handle := LoadIcon(hInstance, 'MAINICON');
end;

function TsohoExlRepPrintDialog.Execute (var PrintAction : TsohoExcelPrintAction;
       var PrintToFile : boolean; var Copies : integer) : boolean;
begin
  if PrintAction = paNone then PrintActionG.ItemIndex := 2
  else PrintActionG.ItemIndex := ord(PrintAction);

  PrintToFileC.Checked := PrintToFile;
  CopiesE.Value := Copies;

  Result := ShowModal = mrOk;
  if not Result then exit;

  PrintAction := TsohoExcelPrintAction(PrintActionG.ItemIndex);

  PrintToFile := PrintToFileC.Checked;
  Copies := trunc(CopiesE.Value);
end;

end.
