{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoDualF;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, StdCtrls, Buttons, SoCtrls, SohoBtns, Placemnt,
     SoTools;

type

  TComponentsDualListForm = class(TForm)
    LeftList: TListBox;
    LeftCaption: TsohoLabel;
    RightCaption: TsohoLabel;
    RightList: TListBox;
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    Ini: TFormStorage;
    procedure LeftListDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure LeftListDragDrop(Sender, Source: TObject; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    FLeftList,FRightList : TList;
    function Execute : boolean;
  end;

implementation

{$R *.DFM}

function TComponentsDualListForm.Execute : boolean;
var Index : integer;
begin
     LeftList.Clear;
     RightList.Clear;
     for Index := 0 to FLeftList.Count-1 do
       LeftList.Items.AddObject(TComponent(FLeftList[Index]).Name, FLeftList[Index]);
     for Index := 0 to FRightList.Count-1 do
       RightList.Items.AddObject(TComponent(FRightList[Index]).Name,FRightList[Index]);
     Result := ShowModal = mrOk;
     FLeftList.Clear;
     FRightList.Clear;
     if not Result then exit;
     for Index := 0 to LeftList.Items.Count-1 do FLeftList.Add(LeftList.Items.Objects[Index]);
     for Index := 0 to RightList.Items.Count-1 do FRightList.Add(RightList.Items.Objects[Index]);
end;


procedure TComponentsDualListForm.LeftListDragOver(Sender, Source: TObject;
  X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
     Accept := (Source is TListBox) and not (Source=Sender);
end;

procedure TComponentsDualListForm.FormCreate(Sender: TObject);
begin
     FLeftList := TList.Create;
     FRightList := TList.Create;
end;

procedure TComponentsDualListForm.LeftListDragDrop(Sender, Source: TObject;
  X, Y: Integer);
var Index : integer;
begin
     for Index := (Source as TListBox).Items.Count-1 downto 0 do
       if (Source as TListBox).Selected[Index] then begin
          (Sender as TListBox).Items.Add((Source as TListBox).Items.Strings[Index]);
          (Sender as TListBox).Items.Objects[(Sender as TListBox).Items.Count-1] :=
             (Source as TListBox).Items.Objects[Index];
          (Source as TListBox).Items.Delete(Index);
       end;
end;

end.
