{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoDBPrp;

{$I SOHOLIB.INC}

interface
uses DsgnIntf, DB, DBTables, DBReg, Classes;

type

  TsohoSubProperty = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
  end;

  TsohoTreeViewEditor = class(TComponentEditor)
    function GetVerbCount: Integer; override;
    function GetVerb(index: Integer): string; override;
    procedure ExecuteVerb(index: Integer); override;
  end;
  
  TsohoFolderEnabledMenusProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

  TsohoSQLFileNameProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

  TsohoDirNameProperty = class(TStringProperty)
  public
    procedure sohoAttr(var Title, MustExistFile: string); virtual;
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

  TTTFDirNameProperty = class(TsohoDirNameProperty)
  public
    procedure sohoAttr(var Title, MustExistFile: string); override;
  end;

  TsohoDBNameProperty = class(TDBStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
  end;

implementation
uses SoTreeF, SoFldMnF, SoSqlFrm, SoSDlgs, Forms, SoUtils, SoTVCont,
  SohoTree;

{ TsohoSubProperty }
function TsohoSubProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paSubProperties];
end;

{ TsohoTreeViewEditor }
function TsohoTreeViewEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TsohoTreeViewEditor.GetVerb(index: Integer): string;
begin
  Result := 'Create tree &Guide';
end;

procedure TsohoTreeViewEditor.ExecuteVerb(index: Integer);
begin
  if not CreateTreeGuide then exit;
  if Component is TsohoTreeView then
    with (Component as TsohoTreeView) do begin
      GroupsTable := aGroupsTableName;
      ItemsTable := aItemsTableName;
    end;
  if Component is TsohoTVContainer then
    with (Component as TsohoTVContainer) do begin
      GroupsTable := aGroupsTableName;
      ItemsTable := aItemsTableName;
    end;
  Designer.Modified;
end;

{ TsohoFolderEnabledMenusProperty }
function TsohoFolderEnabledMenusProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog];
end;

procedure TsohoFolderEnabledMenusProperty.Edit;
var Tmp: string;
begin
  if GetNewEnabledMenus(GetStrValue, Tmp) then SetStrValue(Tmp);
end;

{ TsohoSQLFileNameProperty }
function TsohoSQLFileNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog];
end;

procedure TsohoSQLFileNameProperty.Edit;
var Tmp: string;
begin
  Tmp := GetStrValue;
  if SQLFormExecute(Tmp) then SetStrValue(Tmp);
end;

{ TsohDirName Editor }
procedure TsohoDirNameProperty.sohoAttr;
begin
  MustExistFile := '';
  Title := 'Directory name editor';
end;

function TsohoDirNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog];
end;

procedure TsohoDirNameProperty.Edit;
var Temp: string;
  me, Ttl: string;
begin
  GetDir(0, Temp);
  with TsohoDirectoryDialog.Create(Application) do
    try
      sohoAttr(Ttl, me);
      FileMustExists := me;
      Title := Ttl;
      if Execute then SetStrValue(Directory);
    finally
      Free;
    end;
  ChDir(Temp);
end;

{ TTTFDirName Editor }
procedure TTTFDirNameProperty.sohoAttr;
begin
  MustExistFile := '*.ttf';
  Title := 'SohoLib TTF Directory Property Editor';
end;

{ TsohoDBNameProperty }
procedure TsohoDBNameProperty.GetValueList(List: TStrings);
begin
  Session.GetDatabaseNames(List);
end;

end.

