{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
          ,
      
}
unit SoDate;

{$I SOHOLIB.INC}

interface

{  ,  "" , : '00/00/00' }
function GetNullDateStr: string;
{     mm/dd/yyyy     SQL-.
      ,      
   }
function DateToSQLDate(Date: TDateTime): string;
{    ?      GetNullDateStr, 
     }
function IsNullDate(const Text: string): Boolean;
{    .      exception }
function WStrToDate(const Date: string): TDateTime;
{    .       GetNullDateStr }
function WDateToStr(Date: TDateTime): string;
{    ,       }
function LongDateToStr(Date: TDateTime): string;
{        }
function GetPeriod(var FromDate, ToDate: TDateTime): Boolean;
{       . ,
         - 
       }
function GetMaxDate(var ToDate: TDateTime): Boolean;
{        }
procedure GetDatesOnDay(var FromDate, ToDate: TDateTime);
{         }
procedure GetDatesOnMonth(var FromDate, ToDate: TDateTime);
{         }
procedure GetDatesOnQuarter(var FromDate, ToDate: TDateTime);
{         }
procedure GetDatesOnYear(var FromDate, ToDate: TDateTime);
{         Time }
function TimeToShortTime (Time : TDateTime) : string;

var
  sohoShortDayNames: array[1..7] of string;
  sohoLongDayNames: array[1..7] of string;

implementation

uses SysUtils, SoPrdF, Forms, SoUtils, Classes;

function GetNullDateStr: string;
begin
  Result := '00' + DateSeparator + '00' + DateSeparator + '00';
end;

function DateToSQLDate(Date: TDateTime): string;
var Year, Month, Day: Word;
begin
  if trunc(Date) = 0 then Result := 'null'
  else begin
    DecodeDate(Date, Year, Month, Day);
    Result := '"' + IntToStr(Month) + '/' + IntToStr(Day) + '/' + IntToStr(Year) + '"';
  end;
end;

function IsNullDate(const Text: string): Boolean;
begin
  Result := (GetNoSpacePercent(Text) = 0) or (Text = GetNullDateStr);
end;

function WStrToDate(const Date: string): TDateTime;
begin
  if not IsNullDate(Date) then Result := StrToDate(Date)
  else Result := 0.0;
end;

function WDateToStr(Date: TDateTime): string;
begin
  if trunc(Date) = 0 then Result := GetNullDateStr
  else Result := DateToStr(Date);
end;

function LongDateToStr(Date: TDateTime): string;
begin
  DateTimeToString(Result, LongDateFormat, Date);
end;

var Year, Month, Day: Word;
  
procedure GetDatesOnDay(var FromDate, ToDate: TDateTime);
begin
  FromDate := Date;
  ToDate := Date + 1;
end;

procedure GetDatesOnMonth(var FromDate, ToDate: TDateTime);
begin
  DecodeDate(Date, Year, Month, Day);
  FromDate := EncodeDate(Year, Month, 1);
  if Month = 12 then begin
    inc(Year);
    Month := 0;
  end;
  ToDate := EncodeDate(Year, Month + 1, 1);
end;

procedure GetDatesOnQuarter(var FromDate, ToDate: TDateTime);
begin
  DecodeDate(Date, Year, Month, Day);
  case Month of
    1, 2, 3: begin
      FromDate := EncodeDate(Year, 1, 1);
      ToDate := EncodeDate(Year, 4, 1);
    end;
    4, 5, 6: begin
      FromDate := EncodeDate(Year, 4, 1);
      ToDate := EncodeDate(Year, 7, 1);
    end;
    7, 8, 9: begin
      FromDate := EncodeDate(Year, 7, 1);
      ToDate := EncodeDate(Year, 10, 1);
    end;
    10, 11, 12: begin
      FromDate := EncodeDate(Year, 10, 1);
      ToDate := EncodeDate(Year + 1, 1, 1);
    end;
  end;
end;

procedure GetDatesOnYear(var FromDate, ToDate: TDateTime);
begin
  DecodeDate(Date, Year, Month, Day);
  FromDate := EncodeDate(Year, 1, 1);
  ToDate := EncodeDate(Year + 1, 1, 1);
end;

function GetPeriod;
begin
  try
    Result := False;
    sohoGetPeriodForm := TsohoGetPeriodForm.Create(Application);
    Result := sohoGetPeriodForm.Execute(FromDate, ToDate);
  finally
    sohoGetPeriodForm.Free;
  end;
end;

function GetMaxDate;
begin
  try
    Result := False;
    sohoGetPeriodForm := TsohoGetPeriodForm.Create(Application);
    Result := sohoGetPeriodForm.MaxDate(ToDate);
  finally
    sohoGetPeriodForm.Free;
  end;
end;

function TimeToShortTime (Time : TDateTime) : string;
var Hour, Min, Sec, MSec : word;
    Tmp : string;
begin
  DecodeTime(Time, Hour, Min, Sec, MSec);
  Tmp := IntToStr(Hour);
  Result := AlignStr(Tmp, taRightJustify, '0', 2);
  Tmp := IntToStr(Min);
  Result := Result + ':'+ AlignStr(Tmp, taRightJustify, '0', 2);
end;

var Index : integer;
    ShTmp, LngTmp : string;

initialization
  ShTmp := ShortDayNames[1];
  LngTmp := LongDayNames[1];
  for Index := 7 downto 2 do begin
    sohoShortDayNames[Index-1] := ShortDayNames[Index];
    sohoLongDayNames[Index-1]  := LongDayNames[Index];
  end;
  sohoShortDayNames[7] := ShTmp;
  sohoLongDayNames[7]  := LngTmp;
end.

