{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
         
         
}
unit SoDBRtn;

{$I SOHOLIB.INC}

interface

uses DB, SysUtils, Classes, SoCtmFld, SoTools;


{   ,      FieldName   ID}
function LocaleByID(DataSet: TDataSet; const FieldName: string; ID: Longint): boolean;
{  DataSet.    TTable,  
  TTable.Refresh.      Close/Open }
procedure RefreshDataSet(DataSet: TDataSet);
{  DataSet,   DataSet    Folder}
procedure RefreshFolder(Folder: TsohoCustomFolder);
{   RefreshDataSet.    ,   
        ,   
  ,   KeyField       
    RefreshDataSetWithID.     , 
      }
procedure RefreshDataSetWithID(DataSet: TDataSet; const KeyField: string);
{   RefreshDataSetWithID,   DataSet    Folder }
procedure RefreshFolderWithID(Folder: TsohoCustomFolder; const KeyField: string);
{    }
procedure RefreshDataSetFilter(DataSet: TDataSet);
{         }
function GetFieldSumm(DataSet: TDataSet; const FieldName: string): Double;

{       .    -
     ,      OnProgress }
function CopyDataSetToDataSet(FromD, ToD: TDataSet;
  OnProgress: TsohoProgressEvent): boolean;

{    CopyRecord,     ,
   ,  NewRecord = false,       SummFields
   }
function CopyRecordWithSumm(FromD, ToD: TDataSet; NewRecord: boolean;
  SummFields: TStringList): boolean;
{     DataSet  .  NewRecord = false, 
       }
function CopyRecord(FromD, ToD: TDataSet; NewRecord: boolean): boolean;

{   ReadOnly    }
procedure SetFieldsReadOnly(DataSet: TDataSet; Fields: array of string;
  aReadOnly: boolean);

{      DataSet }
procedure RemoveAllFields(var DataSet: TDataSet);
{   ,   CA.  
   TsohoCustomFolder,    
   }
procedure RemoveAllCAFields(var DataSet: TDataSet);
{       }
function RemoveFieldByIndex(DataSet: TDataSet; index: Longint): Boolean;
{       }
function RemoveFieldByName(DataSet: TDataSet; FieldName: string): Boolean;
{    }
function CreateCalculatedField(DataSet: TDataSet; FieldName: string;
   FieldType: TFieldType; FieldSize: Word): Boolean;
{  true -> 'T', false -> 'F' }
function BoolToIbStr (Value : boolean) : string;

implementation
uses SoUtils, SoCtmRgs
     {$IFDEF Delphi3}
     {$IFDEF RUSSIAN_MESSAGES}
     , DbConsts
     {$ENDIF}
     {$ENDIF}
     ,Graphics, SoDBCns;

function LocaleByID(DataSet: TDataSet; const FieldName: string; ID: Longint): boolean;
begin
  SetCursor(crHourGlass);
  Result := False;
  with DataSet do begin
    First;
    while (not EOF) and (FieldByName(FieldName).AsInteger <> ID) do Next;
    if EOF then exit;
    Result := True;
  end;
  RestoreCursor;
end;

procedure RefreshDataSet(DataSet: TDataSet);
begin
  SetCursor(crHourGlass);
  DataSet.DisableControls;
  DataSet.Close;
  try
    DataSet.Open;
  finally
    DataSet.EnableControls;
    RestoreCursor;
  end;
end;

procedure RefreshFolder(Folder: TsohoCustomFolder);
begin
  Folder.SaveDBGridColumns;
  RefreshDataSet(Folder.Grid.DataSource.DataSet);
  Folder.LoadDBGridColumns;
end;

procedure RefreshDataSetWithID(DataSet: TDataSet; const KeyField: string);
var Tmp: string;
  Field: TField;
begin
  with DataSet do begin
    Field := FindField(KeyField);
    if Field = nil then begin
      ErrorMsg(Format(sohoDBRtnRefreshError, [DataSet.Name, KeyField]));
      exit;
    end;
    Tmp := Field.AsString;
    SetCursor(crHourGlass);
    DisableControls;
    Close;
    try
      Open;
      RestoreCursor;
      SetCursor(crHourGlass);
      First;
      while not EOF do
        if FieldByName(KeyField).AsString <> Tmp then Next
        else Break;
      if EOF then First;
    finally
      DataSet.EnableControls;
      RestoreCursor;
    end;
  end;
end;

procedure RefreshFolderWithID(Folder: TsohoCustomFolder; const KeyField: string);
begin
  Folder.SaveDBGridColumns;
  RefreshDataSetWithID(Folder.Grid.DataSource.DataSet, KeyField);
  Folder.LoadDBGridColumns;
end;

procedure RefreshDataSetFilter(DataSet: TDataSet);
begin
  with DataSet do begin
    DisableControls;
    try
      Filtered := False;
      Filtered := True;
    finally
      EnableControls;
    end;
  end;
end;

function GetFieldSumm(DataSet: TDataSet; const FieldName: string): Double;
var BkMark: TBookMark;
  Field: TField;
begin
  with DataSet do begin
    Field := FindField(FieldName);
    if Field = nil then begin
      ErrorMsg(Format(sohoDBRtnFieldSummFieldNotFound, [DataSet.name, FieldName]));
      exit;
    end;
    if not (Field.DataType in [ftSmallint, ftInteger, ftWord,
      ftFloat, ftCurrency]) then begin
      ErrorMsg(Format(sohoDBRtnFieldSummUnableCalculate, [FieldName, DataSet.name]));
      exit;
    end;
    BkMark := GetBookMark;
    Result := 0;
    DisableControls;
    try
      First;
      while not EOF do begin
        Result := Result + Field.AsFloat;
        Next;
      end;
      GotoBookMark(BkMark);
    finally
      FreeBookMark(BkMark);
      EnableControls;
    end;
  end;
end;

function CopyRecordWithSumm(FromD, ToD: TDataSet; NewRecord: boolean;
    SummFields: TStringList): boolean;
var index: Longint;
  FromField, ToField: TField;
begin
  try
    Result := False;
    if not NewRecord then ToD.Edit
    else ToD.Append;
    for index := 0 to pred(FromD.FieldCount) do begin
      try
        FromField := FromD.Fields[index];
        if ToD.FindField(FromD.Fields[index].FieldName) <> nil then begin
          ToField := ToD.FieldByName(FromD.Fields[index].FieldName);
          case FromField.DataType of
            ftString: ToField.AsString := FromField.AsString;
            ftInteger: begin
              if (not NewRecord) and (SummFields <> nil) and
                (SummFields.IndexOf(AnsiUpperCase(ToField.FieldName)) <> -1) then
                ToField.AsInteger := ToField.AsInteger + FromField.AsInteger
              else ToField.AsInteger := FromField.AsInteger;
            end;
            ftBoolean: ToField.AsBoolean := FromField.AsBoolean;
            ftFloat: begin
              if (not NewRecord) and (SummFields <> nil) and
                (SummFields.IndexOf(AnsiUpperCase(ToField.FieldName)) <> -1) then
                ToField.AsFloat := ToField.AsFloat + FromField.AsFloat
              else ToField.AsFloat := FromField.AsFloat;
            end;
            ftDate,
              ftTime: ToField.AsDateTime := FromField.AsDateTime;
            end;
          end;
        except { nothing to do };
        end;
    end;
    ToD.Post;
    Result := True;
  finally
  end;
end;

function CopyRecord(FromD, ToD: TDataSet; NewRecord: boolean): boolean;
begin
  Result := CopyRecordWithSumm(FromD, ToD, NewRecord, nil);
end;

function CopyDataSetToDataSet(FromD, ToD: TDataSet; OnProgress: TsohoProgressEvent): boolean;
var OnePerc: Double;
  index: Longint;
begin
  Result := False;
  try
    OnePerc := FromD.RecordCount / 100;
    if Assigned(OnProgress) then OnProgress(nil, psStarting, 0, sohoDBRtnCopyDataSetCopying);
    index := 0;
    FromD.DisableControls;
    FromD.First;
    while not FromD.EOF do begin
      if not CopyRecord(FromD, ToD, True) then begin
        ErrorMsg(Format(sohoDBRtnCopyDataSetError, [FromD.name, ToD.name]));
        exit;
      end;
      inc(index);
      if Assigned(OnProgress) then OnProgress(nil, psRunning,
        trunc(index / OnePerc), sohoDBRtnCopyDataSetCopying);
      FromD.Next;
    end;
    if Assigned(OnProgress) then OnProgress(nil, psEnding, 0, '');
    FromD.EnableControls;
    Result := True;
  except
  end;
end;

procedure SetFieldsReadOnly(DataSet: TDataSet; Fields: array of string;
          aReadOnly: boolean);
var index: Integer;
begin
  for index := Low(Fields) to High(Fields) do
    DataSet.FieldByName(Fields[index]).readonly := aReadOnly;
end;

type

   {$HINTS OFF}
   TRemoveField = class(TComponent)
   private
      FDataSet: TDataSet;
   end;

   TRemoveDataSet = class(TComponent)
   private
      FFields: TList;
   end;
   {$HINTS ON}

function RemoveFieldByIndex(DataSet: TDataSet; Index: Longint): Boolean;
begin
  with DataSet do begin
    try
       Fields[Index].Index := FieldCount;
       TRemoveField(Fields[FieldCount - 1]).FDataSet := nil;
       TRemoveDataSet(DataSet).FFields.Remove(Fields[FieldCount - 1]);
       Result := True;
    except
       Result := false;
    end;
  end;
end;

function RemoveFieldByName(DataSet: TDataSet; FieldName: string): Boolean;
var Field: TField;
begin
   Result := False;
   with DataSet do begin
     Field := DataSet.FindField(FieldName);
     if Field <> nil then
        Result := RemoveFieldByIndex(DataSet, Field.Index);
   end;
end;

function CreateCalculatedField(DataSet: TDataSet; FieldName: string;
      FieldType: TFieldType; FieldSize: Word): Boolean;
begin
  Result := False;
  with DataSet do begin
    FieldDefs.Clear;
    try
       FieldDefs.Add(FieldName, FieldType, FieldSize, False);
       FieldDefs.Items[FieldDefs.Count - 1].CreateField(DataSet);
       Fields[FieldCount - 1].Calculated := True;
       Result := True;
    except
    end;
  end;
end;


procedure RemoveAllFields(var DataSet: TDataSet);
var Index: Longint;
begin
   for Index := pred(DataSet.FieldCount) downto 0 do
      RemoveFieldByIndex(DataSet, Index);
end;

procedure RemoveAllCAFields(var DataSet: TDataSet);
var Index: Longint;
begin
   with DataSet do begin
      for index := pred(FieldCount) downto 0 do
        if (Fields[index].Calculated) and
           (Copy(Fields[index].FieldName, 1, 2) = 'CA') then
            RemoveFieldByIndex(DataSet, Index);
   end;
end;

function BoolToIbStr (Value : boolean) : string;
const BoolStrs : array [boolean] of string = ('F', 'T');
begin
  Result := BoolStrs[Value];
end;

end.

