{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoDBReg;

interface

procedure Register;

implementation

uses SysUtils, Classes,  SoDBGrid, SohoTree, SoCtmTre, OutLine,  SoDbPrp,
     DsgnIntf, SohoComb, SohoProt, SoQSrch,  SohoRec,  SoCtmFld, SoFolder,
     SoCtmRgs, SohoRgst, SohoGuid, SoTVCont, SoUnit, SoSpeed, SoSDlgs, SoTools,
     SRep, SoDBOle
     {$IFDEF Win32}
     ,SoExlRep, SoSumRep
     {$ENDIF};

{$IFDEF Win32}
{$R SODBREG.D32}
{$ELSE}
{$R SODBREG.D16}
{$ENDIF}

procedure Register;
begin
  RegisterComponents ('SOHO-Controls', [TsohoDBComboBox, TsohoDBGrid, TsohoTreeView,
                                        {TsohoDocument,} TsohoSpeedBar, TsohoQuickSearch,
                                        TsohoDBOleContainer]);

  RegisterComponents ('SOHO-Tools'   , [TsohoProtect,  TsohoFolder, TsohoRegister,
                                        TsohoSubRegister, TSReport]);
  {$IFDEF Win32}
  RegisterComponents ('SOHO-Tools'   , [TsohoExcelReporter]);
  RegisterComponents ('SOHO-Dialogs' , [TsohoSummReport]);
  RegisterPropertyEditor  (TypeInfo(TsohoExcelReporter), TsohoSummReport, '', TsohoSubProperty);
  {$ENDIF}

  RegisterComponents ('SOHO-Dialogs' , [TsohoRecordForm, TsohoDBGuide,
                                        TsohoTVContainer, TsohoDirectoryDialog]);

  RegisterComponentEditor (TsohoCustomTreeView, TsohoTreeViewEditor);
  RegisterComponentEditor (TsohoTVContainer, TsohoTreeViewEditor);

  RegisterPropertyEditor  (TypeInfo(TsohoDBGrid) , TsohoCustomTreeView,    '', TsohoSubProperty);
  RegisterPropertyEditor  (TypeInfo(TOutLine)    , TsohoCustomTreeView,    '', TsohoSubProperty);

  RegisterPropertyEditor  (TypeInfo(TSQLFileName), TsohoDBComboBox,    'SQLFile', TsohoSQLFileNameProperty);
  RegisterPropertyEditor  (TypeInfo(TSQLFileName), TsohoTVContainer, '', TsohoSQLFileNameProperty);
  RegisterPropertyEditor  (TypeInfo(TSQLFileName), TsohoDBGuide,     'SQLFile', TsohoSQLFileNameProperty);
  // RegisterPropertyEditor  (TypeInfo(TDirName)    , nil, '', TsohoDirNameProperty);

  RegisterPropertyEditor  (TypeInfo(string)      , TsohoCustomFolder,      'EnabledMenus', TsohoFolderEnabledMenusProperty);
  RegisterPropertyEditor  (TypeInfo(string)      , TsohoTVContainer, 'EnabledMenus', TsohoFolderEnabledMenusProperty);
  RegisterPropertyEditor  (TypeInfo(string)      , TsohoDBGuide,     'EnabledMenus', TsohoFolderEnabledMenusProperty);

  RegisterPropertyEditor  (TypeInfo(string)      , TsohoDBComboBox, 'DataBaseName', TsohoDBNameProperty);
  RegisterPropertyEditor  (TypeInfo(string)      , TsohoRecordForm, 'DataBaseName', TsohoDBNameProperty);
  RegisterPropertyEditor  (TypeInfo(string)      , TsohoFolder, 'DataBaseName', TsohoDBNameProperty);
  RegisterPropertyEditor  (TypeInfo(string)      , TsohoDBGuide, 'DataBaseName', TsohoDBNameProperty);
  RegisterPropertyEditor  (TypeInfo(string)      , TsohoTVContainer, 'DataBaseName', TsohoDBNameProperty);
  RegisterPropertyEditor  (TypeInfo(string)      , TsohoSummReport, 'DataBaseName', TsohoDBNameProperty);
end;

end.
