{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
       OLE-
}
unit SoDBOLE;

{$I SOHOLIB.INC}


interface
uses Windows, Classes, Messages, Controls, DB, DBCtrls, OleCtnrs, SysUtils;

type

  {        OLEBLOB-. 
         ,     
    OLE- ( Ms Word, Ms Excel,  Paint  ..).  
     , . TOleContainer
  }
  TsohoDBOLEContainer = class(TOLEContainer)
  private
    FDataLink: TFieldDataLink;
    FAutoDisplay: Boolean;
    FObjectLoaded: Boolean;
    procedure DataChange(Sender: TObject);
    function GetDataField: string;
    function GetDataSource: TDataSource;
    function GetField: TField;
    function GetReadOnly: Boolean;
    procedure SetAutoDisplay(Value: Boolean);
    procedure SetDataField(const Value: string);
    procedure SetDataSource(Value: TDataSource);
    procedure SetReadOnly(Value: Boolean);
    procedure UpdateData(Sender: TObject);
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDblClk); message WM_LBUTTONDBLCLK;
    procedure WMCut(var Message: TMessage); message WM_CUT;
    procedure WMCopy(var Message: TMessage); message WM_COPY;
    procedure WMPaste(var Message: TMessage); message WM_PASTE;
  protected
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
    procedure LoadObject;virtual;
    procedure Changed; override;
    procedure Paint;override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {         }
    procedure Cut;
    {      }
    procedure Assign(Value : TPersistent);override;
    {   ,       }
    property Field: TField read GetField;
  published
    {       }
    property AutoDisplay: Boolean read FAutoDisplay write SetAutoDisplay default True;
    {    ,       }
    property DataField: string read GetDataField write SetDataField;
    {   -  }
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property ParentColor default False;
    {      }
    property ReadOnly: Boolean read GetReadOnly write SetReadOnly default False;
    property TabStop default True;
  end;

implementation
uses SoUtils, ActiveX, OleDlg, Menus, Forms, Graphics, ExtCtrls,
     {$IFDEF RUSSIAN_MESSAGES}
     OleConst,
     {$ENDIF}
     SoDBCns;

type

  {$HINTS OFF}
  THackOleContainer = class(TCustomControl)
  private
    FRefCount: Longint;
    FLockBytes: ILockBytes;
    FStorage: IStorage;
    FOleObject: IOleObject;
    FDrawAspect: Longint;
    FViewSize: TPoint;
    FObjectVerbs: TStringList;
    FDataConnection: Longint;
    FDocForm: IVCLFrameForm;
    FFrameForm: IVCLFrameForm;
    FOleInPlaceObject: IOleInPlaceObject;
    FOleInPlaceActiveObject: IOleInPlaceActiveObject;
    FAccelTable: HAccel;
    FAccelCount: Integer;
    FPopupVerbMenu: TPopupMenu;
    FAllowInPlace: Boolean;
    FAllowActiveDoc: Boolean;
    FAutoActivate: TAutoActivate;
    FAutoVerbMenu: Boolean;
    FBorderStyle: TBorderStyle;
    FCopyOnSave: Boolean;
    FOldStreamFormat: Boolean;
    FSizeMode: TSizeMode;
    FObjectOpen: Boolean;
    FUIActive: Boolean;
    FModified: Boolean;
    FModSinceSave: Boolean;
    FFocused: Boolean;
    FNewInserted: Boolean;
    FOnActivate: TNotifyEvent;
    FOnDeactivate: TNotifyEvent;
    FOnObjectMove: TObjectMoveEvent;
    FOnResize: TNotifyEvent;
    FDocView: IOleDocumentView;
    FDocObj: Boolean;
   end;
   {$HINTS ON}

function IsDocObj(Check : TsohoDBOleContainer) : boolean;
begin
  Result := THackOleContainer(Check).FDocObj;
end;

function GetDrawAspect (Check : TsohoDBOleContainer) : LongInt;
begin
  if Check.Iconic then Result := DVASPECT_ICON
  else Result := DVASPECT_CONTENT;
end;

procedure GetViewSize (Check : TsohoDBOleContainer; var ViewSize : TPoint);
begin
  Check.OleObjectInterface.GetExtent(DVASPECT_CONTENT, ViewSize);
end;

var PixPerInch: TPoint;

{ Convert point from himetric to pixels }
function HimetricToPixels(const P: TPoint): TPoint;
begin
  Result.X := MulDiv(P.X, PixPerInch.X, 2540);
  Result.Y := MulDiv(P.Y, PixPerInch.Y, 2540);
end;

{ TsohoDBOLEContainer }
procedure TsohoDBOLEContainer.Changed;
begin
  inherited Changed;
  if FObjectLoaded then FDataLink.Modified;
  FObjectLoaded := true;
end;

constructor TsohoDBOLEContainer.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FAutoDisplay := True;
  FObjectLoaded := false;
  FDataLink := TFieldDataLink.Create;
  FDataLink.Control := Self;
  FDataLink.OnDataChange := DataChange;
  FDataLink.OnUpdateData := UpdateData;
end;

destructor TsohoDBOLEContainer.Destroy;
begin
  FDataLink.Free;
  FDataLink := nil;
  inherited Destroy;
end;

function TsohoDBOLEContainer.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;

procedure TsohoDBOLEContainer.SetDataSource(Value: TDataSource);
begin
  FDataLink.DataSource := Value;
  if Value <> nil then Value.FreeNotification(Self);
end;

function TsohoDBOLEContainer.GetDataField: string;
begin
  Result := FDataLink.FieldName;
end;

procedure TsohoDBOLEContainer.SetDataField(const Value: string);
begin
  FDataLink.FieldName := Value;
end;

function TsohoDBOLEContainer.GetReadOnly: Boolean;
begin
  Result := FDataLink.ReadOnly;
end;

procedure TsohoDBOLEContainer.SetReadOnly(Value: Boolean);
begin
  FDataLink.ReadOnly := Value;
end;

function TsohoDBOLEContainer.GetField: TField;
begin
  Result := FDataLink.Field;
end;

procedure TsohoDBOLEContainer.SetAutoDisplay(Value: Boolean);
begin
  if FAutoDisplay <> Value then begin
    FAutoDisplay := Value;
    if Value then LoadObject;
  end;
end;

procedure TsohoDBOLEContainer.Assign(Value : TPersistent);
var Tmp : TMemoryStream;
begin
  if (not (Value is TOLEContainer)) or
     (not FDataLink.Edit) then
       raise Exception.Create(sohoDBOLEUnableSendData);
  if (TOLEContainer(Value).State = osEmpty) or (Value = nil) then DestroyObject
  else begin
    Tmp := TMemoryStream.Create;
    TOLEContainer(Value).SaveToStream(Tmp);
    if Tmp.Size > 0 then begin
      Tmp.Position := 0;
      LoadFromStream(Tmp);
    end;
    Tmp.Free;
  end;
end;

procedure TsohoDBOLEContainer.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;
end;

procedure TsohoDBOLEContainer.LoadObject;
var Tmp : TMemoryStream;
begin
  if not FObjectLoaded and FDataLink.Active and
    (not Assigned(FDataLink.Field) or FDataLink.Field.IsBlob) then begin
    Tmp := TMemoryStream.Create;
    TBlobField(FDataLink.Field).SaveToStream(Tmp);
    if Tmp.Size > 0 then begin
      Tmp.Position := 0;
      LoadFromStream(Tmp);
    end
    else DestroyObject;
    Tmp.Free;
  end;
end;

procedure TsohoDBOLEContainer.DataChange(Sender: TObject);
begin
  DestroyObject;
  FObjectLoaded := False;
  if FAutoDisplay then LoadObject;
end;

procedure TsohoDBOLEContainer.UpdateData(Sender: TObject);
var Tmp : TMemoryStream;
begin
  if (State <> osEmpty) and (FDataLink.Field.IsBlob) then begin
    Tmp := TMemoryStream.Create;
    SaveToStream(Tmp);
    Tmp.Position := 0;
    TBlobField(FDataLink.Field).LoadFromStream(Tmp);
    Tmp.Free;
  end
  else FDataLink.Field.Clear;
end;

procedure TsohoDBOLEContainer.Cut;
begin
  if State <> osEmpty then
    if FDataLink.Edit then begin
      Copy;
      DestroyObject;
    end;
end;

procedure TsohoDBOLEContainer.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited KeyDown(Key, Shift);
  case Key of
    VK_INSERT:
      if ssShift in Shift then begin
        if CanPaste and FDataLink.Edit then Paste;
      end
      else begin
        if (ssCtrl in Shift) and (State <> osEmpty) then Copy;
      end;
    VK_DELETE:
      if ssShift in Shift then Cut;
  end;
end;

procedure TsohoDBOLEContainer.KeyPress(var Key: Char);
begin
  inherited KeyPress(Key);
  case Key of
    ^X: Cut;
    ^C: if State <> osEmpty then Copy;
    ^V: if CanPaste and FDataLink.Edit then Paste;
    #13: LoadObject;
    #27: FDataLink.Reset;
  end;
end;

procedure TsohoDBOLEContainer.CMExit(var Message: TCMExit);
begin
  try
    FDataLink.UpdateRecord;
  except
    SetFocus;
    raise;
  end;
  inherited;
end;

procedure TsohoDBOLEContainer.WMLButtonDown(var Message: TWMLButtonDown);
begin
  if TabStop and CanFocus then SetFocus;
  inherited;
end;

procedure TsohoDBOLEContainer.WMLButtonDblClk(var Message: TWMLButtonDblClk);
begin
  LoadObject;
  inherited;
end;

procedure TsohoDBOLEContainer.WMCut(var Message: TMessage);
begin
  Cut;
end;

procedure TsohoDBOLEContainer.WMCopy(var Message: TMessage);
begin
  if State <> osEmpty then Copy;
end;

procedure TsohoDBOLEContainer.WMPaste(var Message: TMessage);
begin
  if CanPaste and FDataLink.Edit then Paste;
end;

procedure TsohoDBOLEContainer.Paint;
var
  W, H: Integer;
  S: TPoint;
  R, CR: TRect;
  X, Y : integer;
  EmptyText : string;
  TopColor, BottomColor : TColor;
  ViewSize : TPoint;
  DrawAspect : LongInt;
begin
  CR := Rect(0,0,Width,Height);

  Canvas.Brush.Style := bsSolid;
  Canvas.Brush.Color := Color;
  Canvas.FillRect(CR);
  AdjustColors(bvLowered, TopColor, BottomColor, clBtnHighlight, clBlack);
  Frame3D(Canvas, CR, TopColor, BottomColor, 1);
  AdjustColors(bvLowered, TopColor, BottomColor, clBtnFace, clBlack);
  Frame3D(Canvas, CR, TopColor, BottomColor, 1);

  if IsDocObj(Self) and (State = osUIActive) then exit;
  if State = osEmpty then begin
    with Canvas do begin
      EmptyText := Caption;
      if EmptyText = '' then EmptyText := sohoDBOLEEmpty;
      x := HorCenter(CR, GetStrWidth(Handle, EmptyText));
      y := VertCenter(CR, GetStrHeight(Handle, EmptyText));
      TextOut(x,y,EmptyText);
    end;
    if Focused then Canvas.DrawFocusRect(CR);
    exit;
  end;
  if OleObjectInterface <> nil then begin
    W := CR.Right - CR.Left;
    H := CR.Bottom - CR.Top;
    GetViewSize(Self, ViewSize);
    DrawAspect := GetDrawAspect(Self);
    S := HimetricToPixels(ViewSize);
    if (DrawAspect = DVASPECT_CONTENT) and (SizeMode = smScale) then
      if W * S.Y > H * S.X then begin
        S.X := S.X * H div S.Y;
        S.Y := H;
      end
      else begin
        S.Y := S.Y * W div S.X;
        S.X := W;
      end;
    if (DrawAspect = DVASPECT_ICON) or (SizeMode = smCenter) or
       (SizeMode = smScale) then begin
      R.Left := (W - S.X) div 2;
      R.Top := (H - S.Y) div 2;
      R.Right := R.Left + S.X;
      R.Bottom := R.Top + S.Y;
    end
    else if SizeMode = smClip then begin
      SetRect(R, CR.Left, CR.Top, S.X, S.Y);
      IntersectClipRect(Canvas.Handle, CR.Left, CR.Top, CR.Right, CR.Bottom);
    end
    else SetRect(R, CR.Left, CR.Top, W, H);
    OleDraw(OleObjectInterface, DrawAspect, Canvas.Handle, R);
  end;
  if Focused then Canvas.DrawFocusRect(CR);
end;

procedure Initialize;
var DC: HDC;
begin
  DC := GetDC(0);
  PixPerInch.X := GetDeviceCaps(DC, LOGPIXELSX);
  PixPerInch.Y := GetDeviceCaps(DC, LOGPIXELSY);
  ReleaseDC(0, DC);
end;

initialization
  Initialize;
end.  

