{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
   ,    
   
}
unit SoCtrls;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, Dialogs, StdCtrls, Menus, ExtCtrls, SoTools;

const

  {  ""  TsohoListBox }
  bId_BlueLamp   = 1;
  {  ""  TsohoListBox }
  bId_RedLamp    = 2;
  {  ""  TsohoListBox }
  bId_YellowLamp = 3;

  {$IFNDEF WIN32}
  {  - - }
  crHandPoint    = -21;
  {$ENDIF}

type

  {      TsohoListBox:  ,    
       }
  TsohoLBAlign = (walCenter, walLeft, walRight);

  {     TsohoListBox }
  TsohoLBText = record
    {     }
    Text: string;
    {   }
    FontName: string;
    {   }
    FontStyle: TFontStyles;
    {   }
    FontSize: Integer;
    {   }
    FontColor: tColor;
    {     }
    FontAlign: TsohoLBAlign;
    {    .     
      'BROWSELIST'+StrToInt(ImageId).    
       }
    ImageID: Integer;
    {     }
    ImageAlign: TsohoLBAlign;
    {        OnKeyStringPressed }
    Key: Boolean;
  end;
  
  {    OnKeyStringPressed. Index -    TsohoListBox,
    sohoLBText -    }
  TsohoLBKeyStringPressed = procedure (Sender: TObject; index: Integer;
    sohoLBText: TsohoLBText) of object;

  { ListBox    ,    .. }
  TsohoListBox = class(TListBox)
  private
    { Private declarations }
    FAlign: Integer;
    FDrawFocus: Boolean;
    Picture: TBitmap;
    FLeftField,
      FRightField: Integer;
    FOnKeyStringPressed: TsohoLBKeyStringPressed;
    FSound: TsohoSound;
    FSoundName: TWaveFileName;
  protected
    { Protected declarations }
    procedure SetDrawFocus(Value: Boolean);
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure CNDrawItem(var message: TWMDrawItem); message CN_DRAWITEM;
    procedure DrawItem(index: Integer; Rect: TRect; State: TOwnerDrawState); override;
    procedure MeasureItem(index: Integer; var Height: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure GetTextParams(var S: string; var FStyle: TFontStyles;
      var FAlign: Integer; var FSize: Integer;
      var FColor: tColor; var FName: string;
      var BID: Integer; var BAlign: Integer);
    procedure SetLeftField(Value: Integer);
    procedure SetRightField(Value: Integer);
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure SetSoundName(Value: TWaveFileName);
    procedure DrawPicture(StringRect: TRect; BAlign: Integer; S: string);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {    ""     }
    function GetCleanString(index: Integer): string;
    {      }
    function TextToString(Value: TsohoLBText): string;
    {      }
    procedure StringToText(S: string; var Value: TsohoLBText);
    {     }
    function GetBottomIndex: Integer;
    {     }
    property Canvas;
  published
    property Align;
    property BorderStyle;
    property Color;
    property Columns;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property ExtendedSelect;
    property Font;
    property IntegralHeight;
    property itemHeight;
    property Items;
    {   .         
         }
    property LeftField: Integer read FLeftField write SetLeftField default 0;
    {   .         
         }
    property RightField: Integer read FRightField write SetRightField default 0;
    {    .    " " TsohoListBox
        ,       ClickSound }
    property Sound: TsohoSound read FSound write FSound;
    {    WAV-   .   , , ,
        "TESTWAVE",     : "#TESTWAVE" }
    property ClickSound: TWaveFileName read FSoundName write SetSoundName;
    {            }
    property DrawItemFocus: Boolean read FDrawFocus write SetDrawFocus default False;
    property MultiSelect;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Sorted;
    property Style;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnDrawItem;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMeasureItem;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    {       " " }
    property OnKeyString: TsohoLBKeyStringPressed read FOnKeyStringPressed write FOnKeyStringPressed;
  end;

  {    OnModify. OldValue -  TsohoEdit.Text  ,
    NewValue -   TsohoEdit.Text }
  TsohoModifyEvent = procedure (Sender: TObject; OldValue, NewValue: string) of object;

  {    TsohoEdit: , , , ,  }
  TValueKind = (vkString, vkInteger, vkFloat, vkDate, vkTime);

  {        ToChars, FromChars }
  TChangeChars = string[255];

  {  edit' -   "" }
  TsohoEditStyle = (weNormal, weFlat);

  {    CanExit.  AllowExit,    
          }
  TsohoCanExit = procedure (Sender: TObject; var AllowExit: Boolean) of object;

  {   TsohoEdit -    Borland,  - Inprise }
  TsohoCustomEdit = class(TCustomEdit)
  private
    { Private declarations }
    FMayBeEmpty: Boolean;
    OBorderStyle: TBorderStyle;
    OParentCtl3D,
      OCtl3D: Boolean;
    OColor: tColor;
    FEditStyle: TsohoEditStyle;
    FCanvas: TCanvas;
    FHighLight,
      FShadow: tColor;
    FFromChars,
      FToChars: TChangeChars;
    FShowMessage: Boolean;
    PString: string;
    FValueKind, PValueKind: TValueKind;
    FOnModify: TsohoModifyEvent;
    FSound: TsohoSound;
    FSoundName: TWaveFileName;
    FCanExit: TsohoCanExit;

    FOnRightClick: TNotifyEvent;
    FRightControl: Boolean;
    FButton: pointer;
    FValueStep: Double;
    FDirectEnter: Boolean;
    FAutoFill: Boolean;

    procedure SetButtonHint(Value: string);
    function GetButtonHint: string;
    procedure SetButtonGlyph(Value: TBitmap);
    function GetButtonGlyph: TBitmap;
    procedure DoRightClick(Sender: TObject);
    procedure SetRightControl(Value: Boolean);
    procedure SetMayBeEmpty(Value: Boolean);
    procedure SetDate(Value: TDateTime);
    procedure SetTime(Value: TDateTime);
    procedure SetString(Value: string);
    procedure SetInteger(Value: Longint);
    procedure SetFloat(Value: Double);
    function GetDate: TDateTime;
    function GetTime: TDateTime;
    function GetString: string;
    function GetInteger: Longint;
    function GetFloat: Double;
    procedure SetEditStyle(Value: TsohoEditStyle);
    procedure SetHighLight(Value: tColor);
    procedure SetShadow(Value: tColor);
    procedure WMPaint(var message: TWMPaint); message WM_PAINT;
    procedure SetValueKind(Value: TValueKind);
    procedure SetSoundName(Value: TWaveFileName);
    procedure SaveAll;
    procedure RestoreAll;
    procedure SetEnabled(Value: Boolean);
    function GetEnabled: Boolean;
  protected
    { Protected declarations }
    procedure SetRightControlPosition; virtual;
    procedure CreateRightControl; virtual;
    procedure DestroyRightControl; virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure ModifyEvent;
    procedure Error(ErrorTextId: Integer);
    procedure CMEnter(var message: TCMEnter); message CM_ENTER;
    procedure CMExit(var message: TCMExit); message CM_EXIT;
    procedure KeyPress(var KEY: Char); override;
    property AutoFill: Boolean read FAutoFill write FAutoFill;
    property Enabled: Boolean read GetEnabled write SetEnabled;
    property EditStyle: TsohoEditStyle read FEditStyle write SetEditStyle;
    property Shadow: tColor read FShadow write SetShadow;
    property HighLight: tColor read FHighLight write SetHighLight;
    property ShowMessage: Boolean read FShowMessage write FShowMessage;
    property FromChars: TChangeChars read FFromChars write FFromChars;
    property ToChars: TChangeChars read FToChars write FToChars;
    property AsDate: TDateTime read GetDate write SetDate;
    property AsTime: TDateTime read GetTime write SetTime;
    property AsString: string read GetString write SetString;
    property AsInteger: Longint read GetInteger write SetInteger;
    property AsFloat: Double read GetFloat write SetFloat;
    property ValueKind: TValueKind read FValueKind write SetValueKind;
    property Sound: TsohoSound read FSound write FSound;
    property ErrorSound: TWaveFileName read FSoundName write SetSoundName;
    property MayBeEmpty: Boolean read FMayBeEmpty write SetMayBeEmpty;
    property CanExit: TsohoCanExit read FCanExit write FCanExit;
    property OnModify: TsohoModifyEvent read FOnModify write FOnModify;
    property Button: pointer read FButton;
    property BtnGlyph: TBitmap read GetButtonGlyph write SetButtonGlyph;
    property BtnHint: string read GetButtonHint write SetButtonHint;
    property DirectEnter: Boolean read FDirectEnter write FDirectEnter default False;
    property ValueStep: Double read FValueStep write FValueStep;
    property RightControl: Boolean read FRightControl write SetRightControl;
    property OnRightClick: TNotifyEvent read FOnRightClick write FOnRightClick;
    procedure Loaded; override;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {     edit'.  ""  
          }
    procedure Cancel;
  end;

  {     TEdit.   
    ,  ,    ValueKind, AsDate,
    AsString, AsTime, AsInteger, AsFloat,     
      .       ValueKind 
             
      .  RightControl = true    
     ,      Date, Time, Integer 
    Float.  ToChars  FromChars      
     .
  }
  TsohoEdit = class(TsohoCustomEdit)
  public
    {   ,    TDateTime }
    property AsDate;
    {   ,    TDateTime }
    property AsTime;
    {     }
    property AsString;
    {   ,    LongInt }
    property AsInteger;
    {   ,    Double }
    property AsFloat;
    {       }
    property Button;
  published
    {         
      ValueKind }
    property AutoFill default False;
    {     }
    property BtnHint;
    {     }
    property BtnGlyph;
    {  DirectEnter = true,      
      .     . 
           -  
       ,      ,
      "  ",     }
    property DirectEnter;
    {   }
    property EditStyle;
    {   wsFlat      }
    property Shadow;
    {   wsFlat      }
    property HighLight;
    {     ( )     }
    property ShowMessage;
    {   ,        ToChars.
        ,    ,   
          ToChars,     .}
    {Exampe:
      FromChars: ABCD
      ToChars  : 1234
       "B"       "2" }
    property FromChars;
    {     }
    property ToChars;
    {   (TsohoValueKind) }
    property ValueKind;
    {     }
    property Sound;
    { ,      ShowMessag = true }
    property ErrorSound;
    {       }
    property MayBeEmpty default True;
    {       }
    property RightControl;
    property ValueStep;
    property Text;
    property BorderStyle;
    property CharCase;
    property Color;
    property Font;
    property HideSelection;
    property OEMConvert;
    property AutoSelect;
    property AutoSize;
    property Visible;
    property Ctl3D default True;
    property DragCursor;
    property DragMode;
    property Enabled;
    property HelpContext;
    property MaxLength;
    property ParentColor;
    property ParentCtl3D default True;
    property ParentFont;
    property ParentShowHint;
    property PasswordChar;
    property ReadOnly;
    property ShowHint;
    property TabOrder;
    property OnChange;
    {      , ..   ,
           }
    property OnModify;
    {        -   spin }
    property OnRightClick;
    {      .   
          }
    property CanExit;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

  {  " ": , , , , -,
    -, -, - }
  TLightPos = (lpLeft, lpRight, lpTop, lpBottom, lpLeftTop, lpLeftBottom,
    lpRightTop, lpRightBottom);

  {  TsohoLabel  FocusControl: , , , ,
      }
  TsohoLabelPosition = (wlpTop, wlpLeft, wlpRight, wlpBottom, wlpUnLinked);

  {  TsohoLabel...   -    }
  TsohoCustomLabel = class(TCustomLabel)
  private
    { Private declarations }
    FAlive: Boolean;
    FFocusOffset: Integer;
    fPos: TsohoLabelPosition;
    FWordWrap: Boolean;
    FLight: TLightPos;
    F3DHeight: Integer;
    FLightColor, FShadowColor: tColor;
    FAlignment: TAlignment;
    FBevelInner, FBevelOuter: TPanelBevel;
    FBevelWidth: Integer;
    FBorderWidth: Integer;
    FBevel: Boolean;
    FActFont: tFont;
    FActColor: tColor;
    FOnMouseEnter: TNotifyEvent;
    FOnMouseLeave: TNotifyEvent;
    procedure SetFocusOffset(Value: Integer);
    procedure SetTrans(Value: Boolean);
    function GetTrans: Boolean;
    procedure SetFControl(Value: TWinControl);
    procedure SetLabelPos(Value: TsohoLabelPosition);
    function GetFControl: TWinControl;
    procedure SetLight(Value: TLightPos);
    procedure Set3DHeight(Value: Integer);
    procedure SetLColor(Value: tColor);
    procedure SetSColor(Value: tColor);
    procedure SetBevel(Value: Boolean);
    procedure SetBevelInner(Value: TPanelBevel);
    procedure SetBevelOuter(Value: TPanelBevel);
    procedure SetBevelWidth(Value: Integer);
    procedure SetBorderWidth(Value: Integer);
    procedure SetAlignment(Value: TAlignment);
    procedure UpdateBounds;
    procedure SetFAutoSize(Value: Boolean);
    function GetFAutoSize: Boolean;
    procedure SetAlive(Value: Boolean);
    procedure SetWrap(Value: Boolean);
    procedure SetFActiveColor(Value: tColor);
    procedure SetFActiveFont(Value: tFont);
    procedure CMParentColorChanged(var message: TMessage); message CM_PARENTCOLORCHANGED;
    procedure CMParentFontChanged(var message: TMessage); message CM_PARENTFONTCHANGED;
    procedure CMMouseEnter(var message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var message: TMessage); message CM_MOUSELEAVE;
    procedure CMTextChanged(var message: TMessage); message CM_TEXTCHANGED;
    procedure CMFontChanged(var message: TMessage); message CM_FONTCHANGED;
    procedure ActFontChanged(Sender: TObject);
  protected
    { Protected declarations }
    MouseOverLabel: Boolean;
    procedure MoveFocusControl(ALeft, ATop, AWidth, AHeight: Integer);
    property Transparent: Boolean read GetTrans write SetTrans;
    property Position: TsohoLabelPosition read fPos write SetLabelPos;
    property FocusControl: TWinControl read GetFControl write SetFControl;
    property AutoSize: Boolean read GetFAutoSize write SetFAutoSize default False;
    property Alive: Boolean read FAlive write SetAlive;
    property Alignment: TAlignment read FAlignment write SetAlignment default taLeftJustify;
    property WordWrap: Boolean read FWordWrap write SetWrap default True;
    property FocusOffset: Integer read FFocusOffset write SetFocusOffset;
    property ColorActive: tColor read FActColor write SetFActiveColor;
    property FontActive: tFont read FActFont write SetFActiveFont;
    property Bevel: Boolean read FBevel write SetBevel;
    property BevelInner: TPanelBevel read FBevelInner write SetBevelInner;
    property BevelOuter: TPanelBevel read FBevelOuter write SetBevelOuter;
    property BorderWidth: Integer read FBorderWidth write SetBorderWidth default 0;
    property BevelWidth: Integer read FBevelWidth write SetBevelWidth default 1;
    property LightColor: tColor read FLightColor write SetLColor default clWhite;
    property ShadowColor: tColor read FShadowColor write SetSColor default clGray;
    property Light: TLightPos read FLight write SetLight default lpTop;
    property Height3D: Integer read F3DHeight write Set3DHeight default 1;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave: TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    procedure Loaded; override;
    procedure Paint; override;
    procedure Click; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  end;
  
  {  ,      FocusControl }
  TsohoLabel = class(TsohoCustomLabel)
  public
    {   }
    property Canvas;
  published
    {  true,      ,  
       ColorActiva, FontActive  Color,Font }
    property Alive;
    {  ,      }
    property ColorActive;
    {  ,      }
    property FontActive;
    {    FocusControl }
    property FocusOffset;
    { ,      FocusControl }
    property Position;
    {     , FocusControl    }
    property FocusControl;
    property AutoSize;
    property Alignment;
    property WordWrap;
    {     }
    property Bevel;
    property BevelInner;
    property BevelOuter;
    property BorderWidth;
    property BevelWidth;
    {  "" }
    property LightColor;
    {   }
    property ShadowColor;
    {  ""  }
    property Light;
    {   }
    property Height3D;
    property Align;
    property Caption;
    property Color;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Transparent;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    {     ,      }
    property OnMouseEnter;
    {     ,     }
    property OnMouseLeave;
  end;

  {    .    
     ,     BackImage  nil, .. 
     ,      ,   
      }
  TsohoPanel = class(TCustomPanel)
  private
    { Private declarations }
    FBackImage: TBitmap;
  protected
    { Protected declarations }
    procedure SetBackImage(Value: TBitmap);
    procedure Paint; override;
    function GetPalette: HPALETTE; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {    }
    property Canvas;
  published
    { ,    .   ,  
         ,     }
    property BackImage: TBitmap read FBackImage write SetBackImage;
    property Align;
    property Alignment;
    property BevelInner;
    property BevelOuter;
    property BevelWidth;
    property BorderWidth;
    property BorderStyle;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Caption;
    property Color;
    property Ctl3D;
    property Font;
    property Locked;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
  end;

{  ""    .    TsohoLabel }
procedure Draw3DText(Text: string; var Rect: TRect; Canvas: TCanvas; LightPos: TLightPos;
  Color, LightColor, ShadowColor: tColor; Height3D: Integer;
  Alignment: TAlignment; WordWrap, PreffixOff, Calc: Boolean);

implementation
uses SoUtils, PickDate, DateUtil, SoTimeF, SoDate, SohoBtns, RxCalc;

{$IFDEF Win32}
{$R SoCtrls.R32}
{$ELSE}
{$R SoCtrls.R16}
{$ENDIF}

{-------------------------------------------------------------}
const

  {TsohoEdit errors constants}
  se_ErrorMustBeInteger    = 12300; {" .   !"}
  se_ErrorMustBeFloat      = 12301; {" .   !"}
  se_ErrorMustBeDate       = 12302; {" .  !"}
  se_ErrorMustBeTime       = 12303; {" .  !"}
  se_ErrorCannotLetString  = 12304; {"  !   !"}
  se_ErrorCannotLetInteger = 12305; {"    .   !"}
  se_ErrorCannotLetFloat   = 12306; {"    .   !"}
  se_ErrorCannotLetDate    = 12307; {"  .   !"}
  se_ErrorCannotLetTime    = 12308; {"  \377.   ."}
  se_ErrorNotInteger       = 12309; {"   !"}
  se_ErrorNotFloat         = 12310; {"   !"}
  se_ErrorNotDate          = 12311; {"  !"}
  se_ErrorNotTime          = 12312; {"  \377"}
  se_ErrorStringEmpty      = 12313; {"    !"}

  {TsohoListBox errors}
  solb_NotSetFontStyle     = 12400; {    }
  solb_NotSetTextAlign     = 12401; {     }
  solb_WrongTextAlign      = 12402; {   }
  solb_NotSetFontSize      = 12403; {     }
  solb_WrongFontSize       = 12404; {   }
  solb_NotSetFontColor     = 12405; {     }
  solb_WrongFontColor      = 12406; {   }
  solb_NotSetFont          = 12407; {     }
  solb_WrongFont           = 12408; {  \377 }
  solb_NotSetBitmapID      = 12409; {     }
  solb_WrongBitmapID       = 12410; {   }
  solb_NotSetBitmapAlign   = 12411; {     }
  solb_WrongBitmapAlign    = 12412; {  \377 }
  solb_NoTextParams        = 12413; {   \377}

procedure Draw3DText;
const Aligns: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
var Flags: Word;
  PText          : array[0..256] of Char;
  Leng           : Integer;
  LightR, ShadowR: TRect;
begin
  InflateRect(Rect, - Height3D, - Height3D);
  LightR := Rect;
  ShadowR := Rect;
  Flags := Aligns[Alignment] or DT_EXPANDTABS;
  if WordWrap then Flags := Flags or DT_WORDBREAK;
  if PreffixOff then Flags := Flags or DT_NOPREFIX;
  if Calc then Flags := Flags or DT_CALCRECT;
  StrPCopy(PText, Text);
  Leng := Length(Text);
  with Canvas do begin
    case LightPos of
      lpLeft: begin
        OffsetRect(LightR, - Height3D, 0);
        OffsetRect(ShadowR, Height3D, 0);
      end;
      lpRight: begin
        OffsetRect(ShadowR, - Height3D, 0);
        OffsetRect(LightR, Height3D, 0);
      end;
      lpTop: begin
        OffsetRect(LightR, 0, - Height3D);
        OffsetRect(ShadowR, 0, Height3D);
      end;
      lpBottom: begin
        OffsetRect(ShadowR, 0, - Height3D);
        OffsetRect(LightR, 0, Height3D);
      end;
      lpLeftTop: begin
        OffsetRect(LightR, - Height3D, - Height3D);
        OffsetRect(ShadowR, Height3D, Height3D);
      end;
      lpRightBottom: begin
        OffsetRect(ShadowR, - Height3D, - Height3D);
        OffsetRect(LightR, Height3D, Height3D);
      end;
      lpLeftBottom: begin
        OffsetRect(ShadowR, Height3D, - Height3D);
        OffsetRect(LightR, - Height3D, Height3D);
      end;
      lpRightTop: begin
        OffsetRect(LightR, Height3D, - Height3D);
        OffsetRect(ShadowR, - Height3D, Height3D);
      end;
    end;
    SetTextColor(Handle, ColorToRGB(LightColor));
    DrawText(Handle, PText, Leng, LightR, Flags);
    SetTextColor(Handle, ColorToRGB(ShadowColor));
    DrawText(Handle, PText, Leng, ShadowR, Flags);
    SetTextColor(Handle, ColorToRGB(Color));
    DrawText(Handle, PText, Leng, Rect, Flags);
  end;
end;

{ TsohoListBox }
function TsohoListBox.GetBottomIndex: Integer;
var CurHeight, HeightCount: Integer;
begin
  Result := TopIndex; if Result = -1 then exit;
  HeightCount := 0;
  repeat
    MeasureItem(Result, CurHeight);
    HeightCount := HeightCount + CurHeight;
    inc(Result);
  until (HeightCount >= Height) or (Result > pred(Items.Count));
  dec(Result);
end;

procedure TsohoListBox.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (AComponent = FSound) and (Operation = opRemove) then FSound := nil;
  inherited Notification(AComponent, Operation);
end;

procedure TsohoListBox.SetSoundName;
begin
  FSoundName := Value;
end;

procedure TsohoListBox.SetDrawFocus(Value: Boolean);
begin
  if FDrawFocus = Value then exit;
  FDrawFocus := Value;
  Repaint;
end;

procedure TsohoListBox.CNDrawItem(var message: TWMDrawItem);
var
  State: TOwnerDrawState;
begin
  with message.DrawItemStruct^ do begin
    {$IFDEF WIN32}
    State := TOwnerDrawState(WordRec(LongRec(itemState).Lo).Lo);
    {$ELSE}
    State := TOwnerDrawState(WordRec(itemState).Lo);
    {$ENDIF}
    Canvas.Handle := HDC;
    Canvas.Font := Font;
    Canvas.BRUSH := BRUSH;
    if (Integer(itemID) >= 0) and (odSelected in State) then begin
      Canvas.BRUSH.Color := clHighlight;
      Canvas.Font.Color := clHighlightText
    end;
    
    if Integer(itemID) >= 0 then
      DrawItem(itemID, rcItem, State) else
      Canvas.FillRect(rcItem);
    if FDrawFocus and (odFocused in State) then Canvas.DrawFocusRect(rcItem);
    Canvas.Handle := 0;
  end;
end;

procedure TsohoListBox.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var V: TsohoLBText;
begin
  if Button = mbLeft then begin
    try
      StringToText(Items.Strings[ItemIndex], V);
    except on EStringListError do exit;
  end;
  if V.KEY then begin
    if FSound <> nil then begin
      if FSoundName[1] = '#' then
        FSound.PlayResourceWave(Copy(FSoundName, 2, Length(FSoundName)))
      else FSound.PlayWave(FSoundName);
    end;
    if Assigned(FOnKeyStringPressed) then begin
      inherited MouseDown(Button, Shift, X, Y);
      FOnKeyStringPressed(self, ItemIndex, V);
      exit;
    end;
  end;
end;
inherited MouseDown(Button, Shift, X, Y);
end;

procedure TsohoListBox.SetLeftField(Value: Integer);
begin
  if (Value < 0) or (FLeftField = Value) then exit;
  FLeftField := Value;
  Repaint;
end;

procedure TsohoListBox.SetRightField(Value: Integer);
begin
  if (Value < 0) or (FRightField = Value) then exit;
  FRightField := Value;
  Repaint;
end;

constructor TsohoListBox.Create;
begin
  inherited Create(AOwner);
  Style := lbOwnerDrawVariable;
  Picture := TBitmap.Create;
  FLeftField := 0;
  FRightField := 0;
  if Owner <> nil then FSound := FindSound(GetOwnerForm(self));
  FSoundName := '';
  FDrawFocus := False;
end;

destructor TsohoListBox.Destroy;
begin
  Picture.Free;
  inherited Destroy;
end;

function TsohoListBox.GetCleanString(index: Integer): string;
begin
  Result := Items.Strings[index];
  if (Result[1] = '>') or (Result[1] = '#') then
    Result := Copy(Result, Pos(')', Result) + 1, Length(Result));
end;

procedure TsohoListBox.GetTextParams(var S: string; var FStyle: TFontStyles; var FAlign: Integer;
    var FSize: Integer; var FColor: tColor; var FName: string;
    var BID: Integer; var BAlign: Integer);
{  :-( }
label 1;
var S1, CurWord: string;
  K      : Integer;
  ErrorId: Word;   
begin
  S1 := S;
  if (S[1] <> '#') and (S[1] <> '>') then exit;
  ErrorId := 0;
  S := Copy(S, 3, Pos(')', S) - 3);
  {    !}
  if S = '' then ErrorId := solb_NoTextParams;
  if ErrorId <> 0 then goto 1;
  
  {  }
  CurWord := ''; K := 1;
  while (K <= Length(S)) and (S[K] <> ',') do begin CurWord := CurWord + S[K]; inc(K); end;
  {  -     }
  if K > Length(S) then ErrorId := solb_NotSetFontStyle;
  if ErrorId <> 0 then goto 1;
  
  FStyle := []; inc(K);
  if Pos('B', CurWord) <> 0 then FStyle := [fsBold];
  if Pos('I', CurWord) <> 0 then FStyle := FStyle + [fsItalic];
  if Pos('U', CurWord) <> 0 then FStyle := FStyle + [fsUnderline];
  if Pos('S', CurWord) <> 0 then FStyle := FStyle + [fsStrikeOut];
  if Pos('N', CurWord) <> 0 then FStyle := [];
  if S1[1] = '>' then FStyle := FStyle + [fsUnderline];

  {  }
  CurWord := '';
  while (K <= Length(S)) and (S[K] <> ',') do begin CurWord := CurWord + S[K]; inc(K); end;
  {  -    }
  if K > Length(S) then ErrorId := solb_NotSetTextAlign;
  if ErrorId <> 0 then goto 1;
  try
    FAlign := StrToInt(CurWord);
    inc(K);
  except ErrorId := solb_WrongTextAlign;
  end;
  if ErrorId <> 0 then goto 1;
  
  {  }
  CurWord := '';
  while (K <= Length(S)) and (S[K] <> ',') do begin CurWord := CurWord + S[K]; inc(K); end;
  {  -     }
  if K > Length(S) then ErrorId := solb_NotSetFontSize;
  if ErrorId <> 0 then goto 1;

  try
    FSize := StrToInt(CurWord);
    inc(K);
  except ErrorId := solb_WrongFontSize;
  end;
  if ErrorId <> 0 then goto 1;
  
  {  }
  CurWord := '';
  while (K <= Length(S)) and (S[K] <> ',') do begin CurWord := CurWord + S[K]; inc(K); end;
  {  -     }
  if K > Length(S) then ErrorId := solb_NotSetFontColor;
  if ErrorId <> 0 then goto 1;
  
  try
    FColor := StrToInt(CurWord);
    inc(K);
  except ErrorId := solb_WrongFontColor;
  end;
  if ErrorId <> 0 then goto 1;
  
  {  }
  CurWord := '';
  while (K <= Length(S)) and (S[K] <> ',') do begin CurWord := CurWord + S[K]; inc(K); end;
  {  -     }
  if K > Length(S) then ErrorId := solb_NotSetFont;
  if ErrorId <> 0 then goto 1;
  if CurWord = '""' then CurWord := 'Ms Sans Serif'
  else CurWord := Copy(CurWord, 2, Length(CurWord) - 2);
  FName := CurWord; inc(K);
  
  {  }
  CurWord := '';
  while (K <= Length(S)) and (S[K] <> ',') do begin CurWord := CurWord + S[K]; inc(K); end;
  {  -     }
  if K > Length(S) then ErrorId := solb_NotSetBitmapID;
  if ErrorId <> 0 then goto 1;
  try
    BID := StrToInt(CurWord);
    inc(K);
  except ErrorId := solb_WrongBitmapID;
  end;
  if ErrorId <> 0 then goto 1;

  {  }
  CurWord := Copy(S, K, Length(S));
  if CurWord = '' then ErrorId := solb_NotSetBitmapAlign;
  if ErrorId <> 0 then goto 1;
  try
    BAlign := StrToInt(CurWord);
    {inc(K);}
  except ErrorId := solb_WrongBitmapAlign;
  end;
  if ErrorId <> 0 then goto 1;
  
  S := Copy(S1, Pos(')', S1) + 1, Length(S1));
  exit;
  { ,      :-( }
  1: S := ResString(ErrorId);
  FStyle := [fsBold];
  FAlign := 1;
  FSize := 12;
  FColor := clRed;
  FName := 'Ms Sans Serif';
  BID := bId_RedLamp;
  BAlign := 2;
end;

function TsohoListBox.TextToString(Value: TsohoLBText): string;
var Res: string;
begin
  with Value do begin
    if KEY then Res := '>(' else Res := '#(';
    {Set font style}
    if fsBold in FontStyle then Res := Res + 'B';
    if fsItalic in FontStyle then Res := Res + 'I';
    if fsUnderline in FontStyle then Res := Res + 'U';
    if fsStrikeOut in FontStyle then Res := Res + 'S';
    if FontStyle = [] then Res := Res + 'N';
    {Set font align}
    case FontAlign of
      walCenter: Res := Res + ',1';
      walLeft: Res := Res + ',2';
      walRight: Res := Res + ',3';
    else Res := Res + ',1';
    end;
    {Set font size}
    Res := Res + ',' + IntToStr(FontSize);
    {Set font color}
    Res := Res + ',' + IntToStr(FontColor);
    {Set font name}
    Res := Res + ',"' + FontName + '"';
    {Set image ID}
    Res := Res + ',' + IntToStr(ImageID);
    {Set image align}
    case ImageAlign of
      walCenter: Res := Res + ',1';
      walLeft: Res := Res + ',2';
      walRight: Res := Res + ',3';
    else Res := Res + ',1';
    end;
    {Set text}
    Res := Res + ')' + Text;
    TextToString := Res;
  end;
end;

procedure TsohoListBox.StringToText;
var tAlign, BAlign: Integer;
begin
  with Value do begin
    Text := S;
    KEY := Text[1] = '>';
    GetTextParams(Text, FontStyle, tAlign, FontSize, FontColor, FontName,
      ImageID, BAlign);
    if KEY then FontStyle := FontStyle - [fsUnderline];
    case tAlign of
      1: FontAlign := walCenter;
      2: FontAlign := walLeft;
      3: FontAlign := walRight;
    end;
    case BAlign of
      1: ImageAlign := walCenter;
      2: ImageAlign := walLeft;
      3: ImageAlign := walRight;
    end;
  end;
end;

procedure TsohoListBox.DrawPicture(StringRect: TRect; BAlign: Integer; S: string);
begin
  with Canvas do begin
    case BAlign of
      1: BrushCopy(Bounds(HorCenter(StringRect, Picture.Width),
        StringRect.Top, Picture.Width, Picture.Height), Picture,
          Bounds(0, 0, Picture.Width, Picture.Height),
          Picture.Canvas.Pixels[0, Picture.Height - 1]);
      2: BrushCopy(Bounds(StringRect.Left, VertCenter(StringRect, Picture.Height),
        Picture.Width, Picture.Height), Picture,
          Bounds(0, 0, Picture.Width, Picture.Height),
          Picture.Canvas.Pixels[0, Picture.Height - 1]);
      3: BrushCopy(Bounds(StringRect.Right - Picture.Width,
        VertCenter(StringRect, Picture.Height),
          Picture.Width, Picture.Height), Picture,
          Bounds(0, 0, Picture.Width, Picture.Height),
          Picture.Canvas.Pixels[0, Picture.Height - 1]);
    end;
    case BAlign of
      1: if Picture.Width <> StringRect.Right - StringRect.Left then
        TextOut(StringRect.Left, StringRect.Top + Picture.Height, S)
      else TextOut(HorCenter(StringRect, TextWidth(S)), StringRect.Top + Picture.Height, S);
      2: TextOut(StringRect.Left + Picture.Width, VertCenter(StringRect, TextHeight('W')), S);
      3: TextOut(StringRect.Right - TextWidth(S) - Picture.Width,
        VertCenter(StringRect, TextHeight('W')), S);
    end;
  end;
end;

procedure TsohoListBox.DrawItem(index: Integer; Rect: TRect;
    State: TOwnerDrawState);
var FName, S: string;
  FStyle             : TFontStyles;
  FSize              : Integer;    
  FColor             : tColor;     
  BID, BAlign        : Integer;    
  Bitmap             : HBITMAP;    
  StringRect         : TRect;      
  AllWidth, AllHeight: Integer;    
begin
  S := Items.Strings[index];
  with Canvas do begin
    BRUSH.Color := self.Color;
    FillRect(Rect);
    BID := 0; BAlign := 0;
    GetTextParams(S, FStyle, FAlign, FSize, FColor, FName, BID, BAlign);
    Font.name := FName;
    Font.Style := FStyle;
    Font.Size := FSize;
    Font.Color := FColor;
    if BID > 0 then begin
      Bitmap := ResBitmap('BROWSELIST' + IntToStr(BID));
      if Bitmap = 0 then Bitmap := ResBitmap('BROWSEERROR');
      if Bitmap <> 0 then begin
        if Picture.Handle <> 0 then DeleteObject(Picture.Handle);
        Picture.Handle := Bitmap;
        if BAlign = 1 then begin
          AllWidth := GetMax(TextWidth(S), Picture.Width);
          AllHeight := Picture.Height + TextHeight('A');
        end
        else begin
          AllWidth := TextWidth(S) + Picture.Width;
          AllHeight := GetMax(TextHeight('A'), Picture.Height);
        end;
        with StringRect do begin
          case FAlign of
            1: begin
              Left := (Rect.Right - Rect.Left - AllWidth) div 2;
              Right := Left + AllWidth;
              Top := VertCenter(Rect, AllHeight);
              Bottom := Top + AllHeight;
            end;
            2: begin
              Left := Rect.Left + FLeftField;
              Right := Left + AllWidth;
              Top := VertCenter(Rect, AllHeight);
              Bottom := Top + AllHeight;
            end;
            3: begin
              Left := (Rect.Right - FRightField - AllWidth);
              Right := Left + AllWidth;
              Top := VertCenter(Rect, AllHeight);
              Bottom := Top + AllHeight;
            end;
          end;
        end;
        DrawPicture(StringRect, BAlign, S);
      end;
    end
    else
      case FAlign of
        1: TextOut(HorCenter(Rect, TextWidth(S)), VertCenter(Rect, TextHeight('W')), S);
        2: TextOut(Rect.Left + FLeftField, VertCenter(Rect, TextHeight('W')), S);
        3: TextOut(Rect.Right - TextWidth(S) - FRightField, VertCenter(Rect, TextHeight('W')), S);
      end;
  end;
end;

procedure TsohoListBox.MeasureItem(index: Integer; var Height: Integer);
var FName, S: string;
  FStyle     : TFontStyles;
  FSize      : Integer;    
  FColor     : tColor;     
  BID, BAlign: Integer;    
  Bitmap     : HBITMAP;    
begin
  S := Items.Strings[index];
  with Canvas do begin
    BID := 0;
    if (S[1] = '#') or (S[1] = '>') then begin
      GetTextParams(S, FStyle, FAlign, FSize, FColor, FName, BID, BAlign);
      Font.name := FName;
      Font.Style := FStyle;
      Font.Size := FSize;
    end;
    if BID > 0 then begin
      Bitmap := ResBitmap('BROWSELIST' + IntToStr(BID));
      if Bitmap = 0 then Bitmap := ResBitmap('BROWSEERROR');
      if Bitmap <> 0 then begin
        if Picture.Handle <> 0 then DeleteObject(Picture.Handle);
        Picture.Handle := Bitmap;
        if BAlign = 1 then Height := TextHeight('A') + Picture.Height
        else Height := GetMax(TextHeight('A'), Picture.Height);
      end;
    end
    else Height := TextHeight('W');
  end;
end;

procedure TsohoListBox.MouseMove(Shift: TShiftState; X, Y: Integer);
var Point: TPoint;
  index: Integer;
  S    : string;
begin
  Point.X := X; Point.Y := Y;
  index := ItemAtPos(Point, True);
  if index = -1 then exit;
  S := Items.Strings[index];
  if S[1] = '>' then Cursor := crHandPoint else Cursor := crDefault;
end;

{ TsohoCustomEdit }
procedure TsohoCustomEdit.Loaded;
begin
  inherited Loaded;
  if FAutoFill then
    case ValueKind of
      vkDate: AsDate := Date;
      vkTime: AsTime := Time;
    end;
  SetBounds(Left, Top, Width, Height);
end;

procedure TsohoCustomEdit.SetEnabled(Value: Boolean);
begin
  inherited Enabled := Value;
  if FButton <> nil then TsohoBitBtn(FButton).Enabled := Value;
end;

function TsohoCustomEdit.GetEnabled: Boolean;
begin
  Result := inherited Enabled;
end;

procedure TsohoCustomEdit.SetButtonGlyph(Value: TBitmap);
begin
  if FButton = nil then exit;
  TsohoBitBtn(FButton).Glyph := Value;
end;

function TsohoCustomEdit.GetButtonGlyph: TBitmap;
begin
  Result := nil;
  if FButton = nil then exit;
  Result := TsohoBitBtn(FButton).Glyph;
end;

procedure TsohoCustomEdit.SetButtonHint(Value: string);
begin
  if FButton <> nil then TsohoBitBtn(FButton).Hint := Value;
end;

function TsohoCustomEdit.GetButtonHint: string;
begin
  Result := '';
  if FButton <> nil then Result := TsohoBitBtn(FButton).Hint;
end;

procedure TsohoCustomEdit.SetMayBeEmpty;
var Can: Boolean;
begin
  FMayBeEmpty := Value;
  Can := Value or (not Value and (Text <> ''));
  if Assigned(FCanExit) then FCanExit(self, Can);
  if not (csDesigning in ComponentState) and not (csLoading in ComponentState)
    and (not Can) then
    if Parent <> nil then begin
      Error(se_ErrorStringEmpty);
      SetFocus;
    end;
end;

procedure TsohoCustomEdit.WMPaint(var message: TWMPaint);
var Rect: TRect;
begin
  inherited;
  if FEditStyle = weFlat then begin
    Rect := ClientRect;
    Rect.Top := Rect.Bottom - 2;
    FCanvas.Handle := message.DC;
    Frame3D(FCanvas, Rect, FHighLight, FShadow, 1);
    FCanvas.Handle := 0;
  end;
end;

procedure TsohoCustomEdit.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (AComponent = FSound) and (Operation = opRemove) then FSound := nil;
  inherited Notification(AComponent, Operation);
end;

procedure TsohoCustomEdit.SetSoundName;
begin
  FSoundName := Value;
end;

procedure TsohoCustomEdit.KeyPress(var KEY: Char);
var index: Integer;
begin
  if FDirectEnter then begin
    KEY := #0;
    exit;
  end;
  if KEY = #27 then CANCEL;
  for index := 1 to Length(FFromChars) do
    if (FFromChars[index] = KEY) and (index <= Length(FToChars)) then begin
      KEY := FToChars[index];
      Break;
    end;
  inherited KeyPress(KEY);
end;

procedure TsohoCustomEdit.Error(ErrorTextId: Integer);
begin
  if not FShowMessage then exit;
  if FSound <> nil then begin
    if FSoundName[1] = '#' then
      FSound.PlayResourceWave(Copy(FSoundName, 2, Length(FSoundName)))
    else FSound.PlayWave(FSoundName);
  end;
  ErrorRes(ErrorTextId);
end;

procedure TsohoCustomEdit.ModifyEvent;
begin
  if Assigned(FOnModify) then FOnModify(self, PString, Text);
end;

procedure TsohoCustomEdit.SaveAll;
begin
  PString := Text;
  PValueKind := FValueKind;
end;

procedure TsohoCustomEdit.RestoreAll;
begin
  FValueKind := PValueKind;
  Text := PString;
end;

function TsohoCustomEdit.GetDate: TDateTime;
begin
  Result := 0;
  try
    Result := WStrToDate(Text);
  except on EConvertError do Error(se_ErrorNotDate);
end;
end;

function TsohoCustomEdit.GetTime: TDateTime;
begin
  Result := 0;
  try
    Result := StrToTime(Text);
  except on EConvertError do Error(se_ErrorNotTime);
end;
end;

function TsohoCustomEdit.GetString: string;
begin
  Result := Text;
end;

function TsohoCustomEdit.GetInteger: Longint;
var WasError: Boolean;
begin
  Result := WStrToInt(Text, WasError);
  if WasError then Error(se_ErrorNotInteger);
end;

function TsohoCustomEdit.GetFloat: Double;
var WasError: Boolean;
begin
  Result := WStrToFloat(Text, WasError);
  if WasError then Error(se_ErrorNotFloat);
end;

procedure TsohoCustomEdit.SetDate(Value: TDateTime);
begin
  if FValueKind <> vkDate then begin
    Error(se_ErrorCannotLetDate); exit;
  end;
  SaveAll;
  Text := WDateToStr(Value);
end;

procedure TsohoCustomEdit.SetTime(Value: TDateTime);
begin
  if FValueKind <> vkTime then begin
    Error(se_ErrorCannotLetTime); exit;
  end;
  SaveAll;
  Text := TimeToStr(Value);
end;

procedure TsohoCustomEdit.SetString(Value: string);
begin
  if FValueKind <> vkString then begin
    Error(se_ErrorCannotLetString); exit;
  end;
  SaveAll;
  Text := Value;
end;

procedure TsohoCustomEdit.SetInteger(Value: Longint);
begin
  if FValueKind <> vkInteger then begin
    Error(se_ErrorCannotLetInteger); exit;
  end;
  SaveAll;
  Text := IntToStr(Value);
end;

procedure TsohoCustomEdit.SetFloat(Value: Double);
begin
  if FValueKind <> vkFloat then begin
    Error(se_ErrorCannotLetFloat); exit;
  end;
  SaveAll;
  Text := FloatToStr(Value);
end;

procedure TsohoCustomEdit.SetValueKind(Value: TValueKind);
var IntTmp: Longint;
  WasError: Boolean;
  FlTmp   : Double;
begin
  IntTmp := 0;
  FlTmp := 0;
  if Value = FValueKind then exit;
  SaveAll;
  FValueKind := Value;
  case Value of
    vkInteger: begin if csLoading in ComponentState then Text := '0'
                     else IntTmp := WStrToInt(Text, WasError);
                Text := IntToStr(IntTmp);
    end;
    vkFloat: begin if csLoading in ComponentState then Text := '0'
                   else FlTmp := WStrToFloat(Text, WasError);
                Text := FloatToStr(FlTmp);
    end;
    vkDate: if FAutoFill then Text := WDateToStr(Date);
    vkTime: if FAutoFill then Text := TimeToStr(Time);
  end;
  DestroyRightControl;
  CreateRightControl;
end;

procedure TsohoCustomEdit.CMExit;
var WasError, Can: Boolean;
  index : Integer;
  StrTmp: string;
begin
  if (not FMayBeEmpty) or (Text <> '') then
    case FValueKind of
      vkInteger: begin WStrToInt(self.Text, WasError);
        if WasError then begin
          RestoreAll;
          Error(se_ErrorMustBeInteger);
          SetFocus;
          exit;
        end;
      end;
      vkFloat: begin WStrToFloat(self.Text, WasError);
        if WasError then begin
          RestoreAll;
          Error(se_ErrorMustBeFloat);
          SetFocus;
          exit;
        end;
      end;
      vkDate: begin
        try
          if not IsNullDate(Text) then StrToDate(Text);
        except on EConvertError do begin
           RestoreAll;
           Error(se_ErrorMustBeDate);
           SetFocus;
           exit;
          end;
        end;
      end;
      vkTime: begin
        try
          StrToTime(Text);
        except on EConvertError do begin
            RestoreAll;
            Error(se_ErrorMustBeTime);
            SetFocus;
            exit;
          end;
        end;
     end;
    end;
    StrTmp := Text;
    for index := 1 to Length(FFromChars) do
      if index <= Length(FToChars) then
        StrTmp := ChangeChars(StrTmp, FFromChars[index], FToChars[index]);
    Text := StrTmp;
    Can := FMayBeEmpty or (not (FMayBeEmpty) and (Text <> ''));
    if Assigned(FCanExit) then FCanExit(self, Can);
    if (not Can) and not (csDesigning in ComponentState) then begin
      Error(se_ErrorStringEmpty);
      SetFocus;
      exit;
    end;
    inherited;
    if PString <> Text then ModifyEvent;
end;

procedure TsohoCustomEdit.CMEnter;
begin
  SaveAll;
  SelectAll;
  inherited;
end;

procedure TsohoCustomEdit.SetHighLight(Value: tColor);
begin
  FHighLight := Value;
  Invalidate;
end;

procedure TsohoCustomEdit.SetShadow(Value: tColor);
begin
  FShadow := Value;
  Invalidate;
end;

destructor TsohoCustomEdit.Destroy;
begin
  if FRightControl then
    if FButton<>nil then TsohoBitBtn(FButton).OnClick := nil;
  FCanvas.Free;
  inherited Destroy;
end;

procedure TsohoCustomEdit.SetEditStyle;
begin
  FEditStyle := Value;
  if Value = weFlat then begin
    OColor := Color;
    OBorderStyle := BorderStyle;
    if Parent <> nil then begin
      OParentCtl3D := ParentCtl3D;
      OCtl3D := Ctl3D;
      ParentCtl3D := False;
      Ctl3D := False;
    end;
    Color := GetParentColor(self);
    BorderStyle := bsNone;
  end
  else begin
    Color := OColor;
    BorderStyle := OBorderStyle;
    ParentCtl3D := OParentCtl3D;
    Ctl3D := OCtl3D;
  end;
  Invalidate;
end;

procedure TsohoCustomEdit.DoRightClick(Sender: TObject);
var NewDate: TDateTime;
    NewTime: string;
begin
  case ValueKind of
    vkDate: begin NewDate := AsDate;
      if SelectDate(NewDate, ' ', Mon,[Sun], clRed, nil) then
        AsDate := NewDate;
    end;
    vkTime: begin NewTime := Text;
      if GetTimeDialogStr(NewTime, ' ') then
        Text := NewTime;
    end;
    vkInteger, vkFloat:
     { -    -    Design-time }
     if not (csDesigning in ComponentState) then
      with TRxCalculator.Create(self) do begin
        Title := '';
        if ValueKind = vkInteger then Value := AsInteger
        else Value := AsFloat;
        if Execute then begin
          if ValueKind = vkInteger then AsInteger := SoUtils.Round(Value)
          else AsFloat := Value;
        end;
        Free;
      end;
  end;
  if Assigned(FOnRightClick) then FOnRightClick(self);
end;

procedure TsohoCustomEdit.DestroyRightControl;
begin
  if FButton<>nil then TsohoBitBtn(FButton).Visible := false;
end;

procedure TsohoCustomEdit.SetRightControlPosition;
begin
  with TsohoBitBtn(FButton) do begin
    Left := self.Left + self.Width + 2;
    Top := self.Top;
    Height := self.Height;
    Width := Height;
  end;
end;

procedure TsohoCustomEdit.SetBounds(ALeft, ATop, AWidth, AHeight: Integer);
begin
  inherited SetBounds(ALeft, ATop, AWidth, AHeight);
  if not FRightControl then exit;
  SetRightControlPosition;
end;

procedure TsohoCustomEdit.SetRightControl(Value: Boolean);
begin
  if FRightControl = Value then exit;
  FRightControl := Value;
  if FRightControl then CreateRightControl
  else DestroyRightControl;
end;

procedure TsohoCustomEdit.CreateRightControl;
var GlyphName: string;
begin
  if not FRightControl then exit;
  TsohoBitBtn(FButton).Parent := Parent;
  SetRightControlPosition;
  with TsohoBitBtn(FButton) do begin
    case ValueKind of
      vkString: GlyphName := '';
      vkDate: GlyphName := 'SOHODATEEDIT';
      vkTime: GlyphName := 'SOHOTIMEEDIT';
      vkInteger,
      vkFloat: GlyphName := 'SOHOCALCEDIT';
    end;
    if GlyphName <> '' then Glyph.Handle := ResBitmap(GlyphName);
    Visible := True;
  end;
end;

constructor TsohoCustomEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FShowMessage := True;
  FValueKind := vkString;
  PString := Text;
  if Owner <> nil then FSound := FindSound(GetOwnerForm(self));
  FSoundName := 'SystemAsterisk';
  FHighLight := clBtnShadow;
  FShadow := clBtnHighlight;
  OBorderStyle := BorderStyle;
  OParentCtl3D := True;
  OCtl3D := True;
  OColor := Color;
  FEditStyle := weNormal;
  FCanvas := TControlCanvas.Create;
  TControlCanvas(FCanvas).CONTROL := self;
  FMayBeEmpty := True;
  FButton := nil;
  FValueStep := 1;
  FButton := TsohoBitBtn.Create(self);
  with TsohoBitBtn(FButton) do begin
    SetBounds(0, 0, Height, Height);
    ParentColor := true;
    NumGlyphs := 2;
    Visible := True;
    OnClick := DoRightClick;
    SetComponentState(FButton,[]);
    TabStop := false;
  end;
  SetComponentState(TsohoBitBtn(FButton),[]);
  FAutoFill := False;
end;

procedure TsohoCustomEdit.Cancel;
begin
  RestoreAll;
  Invalidate;
  SelStart := Length(Text);
  SelLength := 0;
end;

{ TsohoLabel }
procedure TsohoCustomLabel.Loaded;
begin
  inherited Loaded;
  MoveFocusControl(Left, Top, Width, Height)
end;

procedure TsohoCustomLabel.Click;
begin
  if not ClickAssigned(self) and (FocusControl <> nil) and
    Alive and (FocusControl.Enabled) and (FocusControl.Visible) then FocusControl.SetFocus
  else inherited Click;
end;

procedure TsohoCustomLabel.UpdateBounds;
var Rect: TRect;
  DC: HDC;
begin
  if AutoSize then begin
    Rect := ClientRect;
    DC := GetDC(0);
    Canvas.Handle := DC;
    Canvas.Font := Font;
    Draw3DText(Caption, Rect, Canvas, Light, Color, LightColor, ShadowColor, Height3D,
      Alignment, WordWrap, False, True);
    Canvas.Handle := 0;
    ReleaseDC(0, DC);
    if Bevel then begin
      if BevelOuter <> bvNone then begin
        Rect.Right := Rect.Right + 2 * BevelWidth;
        Rect.Bottom := Rect.Bottom + 2 * BevelWidth;
      end;
      Rect.Right := Rect.Right + 2 * BorderWidth;
      Rect.Bottom := Rect.Bottom + 2 * BorderWidth;
      if BevelInner <> bvNone then begin
        Rect.Right := Rect.Right + 2 * BevelWidth;
        Rect.Bottom := Rect.Bottom + 2 * BevelWidth;
      end;
    end;
    Height := Rect.Bottom;
    Width := Rect.Right;
  end;
end;

procedure TsohoCustomLabel.SetTrans(Value: Boolean);
begin
  inherited Transparent := Value;
end;

function TsohoCustomLabel.GetTrans: Boolean;
begin
  Result := inherited Transparent;
end;

function TsohoCustomLabel.GetFAutoSize: Boolean;
begin
  Result := inherited AutoSize;
end;

procedure TsohoCustomLabel.SetFAutoSize(Value: Boolean);
begin
  inherited AutoSize := Value;
  UpdateBounds;
  Repaint;
end;

procedure TsohoCustomLabel.SetWrap;
begin
  FWordWrap := Value;
  UpdateBounds;
  Repaint;
end;

procedure TsohoCustomLabel.SetFActiveColor(Value: tColor);
begin
  FActColor := Value;
  if not (csLoading in ComponentState) then ParentColor := False;
end;

procedure TsohoCustomLabel.SetFActiveFont(Value: tFont);
begin
  FActFont.Assign(Value);
  if not (csLoading in ComponentState) then ParentFont := False;
end;

procedure TsohoCustomLabel.CMParentColorChanged(var message: TMessage);
begin
  inherited;
  if ParentColor then FActColor := Color;
end;

procedure TsohoCustomLabel.CMParentFontChanged(var message: TMessage);
begin
  inherited;
  if ParentFont then FActFont.Assign(Font);
end;

procedure TsohoCustomLabel.CMMouseEnter(var message: TMessage);
begin
  MouseOverLabel := True;
  if Assigned(FOnMouseEnter) then FOnMouseEnter(self);
  if FAlive then Invalidate;
end;

procedure TsohoCustomLabel.CMMouseLeave(var message: TMessage);
begin
  MouseOverLabel := False;
  if Assigned(FOnMouseLeave) then FOnMouseLeave(self);
  if FAlive then Invalidate;
end;

destructor TsohoCustomLabel.Destroy;
begin
  FActFont.Free;
  inherited Destroy;
end;

procedure TsohoCustomLabel.SetAlive;
begin
  FAlive := Value;
  Invalidate;
end;

constructor TsohoCustomLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FAlive := False;
  inherited AutoSize := False;
  FAlignment := taLeftJustify;
  Height := 21;
  FLight := lpLeftTop;
  F3DHeight := 1;
  FLightColor := clWhite;
  FShadowColor := clGray;
  FBevel := True;
  FBevelInner := bvRaised;
  FBevelOuter := bvLowered;
  FBevelWidth := 1;
  FBorderWidth := 0;
  Transparent := True;
  FWordWrap := True;
  fPos := wlpLeft;
  FFocusOffset := 2;
  MouseOverLabel := False;
  FActFont := tFont.Create;
  FActFont.OnChange := ActFontChanged;
  FActColor := Color;
end;

procedure TsohoCustomLabel.ActFontChanged(Sender: TObject);
begin
  Invalidate;
end;

procedure TsohoCustomLabel.SetFocusOffset;
begin
  FFocusOffset := Value;
  MoveFocusControl(Left, Top, Width, Height)
end;

procedure TsohoCustomLabel.SetBounds;
var DoMove: Boolean;
begin
  DoMove := (Top <> ATop) or (Left <> ALeft) or (Height <> AHeight) or (Width <> AWidth);
  inherited SetBounds(ALeft, ATop, AWidth, AHeight);
  if DoMove then MoveFocusControl(ALeft, ATop, AWidth, AHeight);
end;

procedure TsohoCustomLabel.SetBevel(Value: Boolean);
begin
  FBevel := Value;
  UpdateBounds;
  Repaint;
end;

procedure TsohoCustomLabel.SetBevelInner(Value: TPanelBevel);
begin
  FBevelInner := Value;
  UpdateBounds;
  Repaint;
end;

procedure TsohoCustomLabel.SetBevelOuter(Value: TPanelBevel);
begin
  FBevelOuter := Value;
  UpdateBounds;
  Repaint;
end;

procedure TsohoCustomLabel.SetBevelWidth(Value: Integer);
begin
  FBevelWidth := Value;
  UpdateBounds;
  Repaint;
end;

procedure TsohoCustomLabel.SetBorderWidth(Value: Integer);
begin
  FBorderWidth := Value;
  UpdateBounds;
  Repaint;
end;

procedure TsohoCustomLabel.SetAlignment(Value: TAlignment);
begin
  FAlignment := Value;
  UpdateBounds;
  Repaint;
end;

procedure TsohoCustomLabel.SetLColor(Value: tColor);
begin
  FLightColor := Value; Repaint;
end;

procedure TsohoCustomLabel.SetFControl(Value: TWinControl);
begin
  inherited FocusControl := Value;
  MoveFocusControl(Left, Top, Width, Height);
end;

procedure TsohoCustomLabel.SetLabelPos(Value: TsohoLabelPosition);
begin
  fPos := Value;
  MoveFocusControl(Left, Top, Width, Height);
end;

procedure TsohoCustomLabel.MoveFocusControl(ALeft, ATop, AWidth, AHeight: Integer);
begin
  if (FocusControl <> nil) and (fPos <> wlpUnLinked) and
    (FocusControl.Parent = Parent) then
    with FocusControl do begin
      case fPos of
        wlpTop: begin
          Top := ATop + AHeight + FFocusOffset;
          Left := ALeft;
          Width := AWidth;
        end;
        wlpLeft: begin
          Top := ATop;
          Left := ALeft + AWidth + FFocusOffset;
          Height := AHeight;
        end;
        wlpRight: begin
          Top := ATop;
          Left := ALeft - Width - FFocusOffset;
          Height := AHeight;
        end;
        wlpBottom: begin
          Top := ATop - Height - FFocusOffset;
          Left := ALeft;
          Width := AWidth;
        end;
      end;
    end;
end;

function TsohoCustomLabel.GetFControl: TWinControl;
begin
  Result := inherited FocusControl;
end;

procedure TsohoCustomLabel.SetSColor(Value: tColor);
begin
  FShadowColor := Value;
  Invalidate;
end;

procedure TsohoCustomLabel.CMTextChanged(var message: TMessage);
begin
  Invalidate;
  UpdateBounds;
end;

procedure TsohoCustomLabel.CMFontChanged(var message: TMessage);
begin
  UpdateBounds;
  Invalidate;
end;

procedure TsohoCustomLabel.SetLight(Value: TLightPos);
begin
  FLight := Value;
  Invalidate;
end;

procedure TsohoCustomLabel.Set3DHeight(Value: Integer);
begin
  if Value < 0 then exit;
  F3DHeight := Value;
  UpdateBounds;
  Repaint;
end;

procedure TsohoCustomLabel.Paint;
var TopColor,
  BottomColor: tColor;
  Rect       : TRect; 
begin
  with Canvas do begin
    Rect := GetClientRect;
    if FBevel then begin
      if BevelOuter <> bvNone then begin
        AdjustColors(BevelOuter, TopColor, BottomColor, clBtnHighlight, clBtnShadow);
        Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
      end;
      Frame3D(Canvas, Rect, Color, Color, BorderWidth);
      if BevelInner <> bvNone then begin
        AdjustColors(BevelInner, TopColor, BottomColor, clBtnHighlight, clBtnShadow);
        Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
      end;
    end;
    if not Transparent then begin
      BRUSH.Style := bsSolid;
      if MouseOverLabel then BRUSH.Color := FActColor
      else BRUSH.Color := self.Color;
      FillRect(Rect);
    end;
    BRUSH.Style := bsClear;
    if MouseOverLabel then Font.Assign(FActFont)
    else Font.Assign(self.Font);
    Draw3DText(Caption, Rect, Canvas, FLight, Font.Color, FLightColor, FShadowColor,
      F3DHeight, Alignment, FWordWrap, False, False);
  end;
end;

{ TsohoPanel }
constructor TsohoPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FBackImage := TBitmap.Create;
  FBackImage.Handle := ResBitmap('DEFAULTPANEL');
end;

function TsohoPanel.GetPalette: HPALETTE;
begin
  Result := FBackImage.Palette;
end;

destructor TsohoPanel.Destroy;
begin
  FBackImage.Free;
  inherited Destroy;
end;

procedure TsohoPanel.SetBackImage(Value: TBitmap);
begin
  FBackImage.Assign(Value);
  if Value = nil then FBackImage.Handle := ResBitmap('DEFAULTPANEL');
  Invalidate;
end;

procedure TsohoPanel.Paint;
var Rect, Image: TRect;
  TopColor, BottomColor: tColor;
  Text                 : array[0..255] of Char;
  TmpW, FontHeight     : Integer;
  K, k1                : Integer;
  MemBmp               : TBitmap;

const Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
begin
  Rect := GetClientRect;
  try
    MemBmp := TBitmap.Create;
    MemBmp.Width := Width;
    MemBmp.Height := Height;
    MemBmp.Palette := FBackImage.Palette;
    with MemBmp do begin
      if BevelOuter <> bvNone then begin
        AdjustColors(BevelOuter, TopColor, BottomColor, clBtnHighlight, clBtnShadow);
        Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
      end;
      // Frame3D(Canvas, Rect, Color, Color, BorderWidth);
      TmpW := BorderWidth;
      Dec(Rect.Bottom); Dec(Rect.Right);
      while TmpW > 0 do begin
        Dec(TmpW);
        InflateRect(Rect, -1, -1);
      end;
      Inc(Rect.Bottom); Inc(Rect.Right);
      if BevelInner <> bvNone then begin
        AdjustColors(BevelInner, TopColor, BottomColor, clBtnHighlight, clBtnShadow);
        Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
      end;
      with MemBmp.Canvas do begin
        if FBackImage <> nil then begin
          for K := 0 to Round((Rect.Right - Rect.Left) / FBackImage.Width) do
            for k1 := 0 to Round((Rect.Bottom - Rect.Top) / FBackImage.Height) do
              with IMAGE do begin
                Left := Rect.Left + K * FBackImage.Width;
                Top := Rect.Top + k1 * FBackImage.Height;
                Right := Left + FBackImage.Width;
                if Right > Rect.Right then Right := Rect.Right;
                Bottom := Top + FBackImage.Height;
                if Bottom > Rect.Bottom then Bottom := Rect.Bottom;
                CopyRect(IMAGE, FBackImage.Canvas, Bounds(0, 0, IMAGE.Right - IMAGE.Left,
                  IMAGE.Bottom - IMAGE.Top));
              end;
        end
        else begin
          BRUSH.Color := Color;
          BRUSH.Style := bsSolid;
          FillRect(Rect);
        end;
        BRUSH.Style := bsClear;
        Font := self.Font;
        FontHeight := TextHeight('W');
        with Rect do begin
          Top := ((Bottom + Top) - FontHeight) shr 1;
          Bottom := Top + FontHeight;
        end;
        StrPCopy(Text, Caption);
        DrawText(Handle, Text, StrLen(Text), Rect, (DT_EXPANDTABS or
          DT_VCENTER) or Alignments[Alignment]);
      end;
    end;
    BitBlt(Canvas.Handle, 0, 0, Width, Height, MemBmp.Canvas.Handle, 0, 0, SRCCOPY);
  finally
    MemBmp.Free;
  end;
end;

begin
  Screen.Cursors[crHandPoint] := ResCursor('POINTCURSOR');
end.

