{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoTreeView -    
 SohoLib        
}
unit SoCtmTre;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, DB, ExtCtrls, Outline, SoSplit, Menus, Grids,
     StdCtrls, SoCtrls, SoTools, SoCtmFld, SoDBGrid, DBGrids, RxCtrls,
     RXDBCtrl, Dialogs;

type
  
  {    . GroupName -  , GroupId - 
     .   }
  TsohoTreeNode = record
    GroupName: string;
    GroupId: Longint;
  end;

  {   TsohoCustomTreeView:
    trDeleteGroup -  ,
    trAddGroup    -  ,
    trEditGroup   -   ,
    trDeleteItem  -   ,
    trAddItem     -   ,
    trEditItem    -   ,
    trRefresh     -  ,
    trReNumber    -  ,
    trMoveItem    -   ,
    trMoveGroup   -   
  }
  TsohoTreeOption = (trDeleteGroup, trAddGroup, trEditGroup, trDeleteItem,
    trAddItem, trEditItem, trRefresh, trReNumber,
    trMoveItem, trMoveGroup);

  {     TsohoCustomTreeView }
  TsohoTreeOptions = set of TsohoTreeOption;

  { trSaveOutLine   -   OutLine,
    trSaveSplitter  -     OutLine  DBGrid,
    trSaveViewChild -   CheckBox' }
  TsohoTreeSaveOption = (trSaveOutLine, trSaveSplitter, trSaveViewChild);

  {     TreeView }
  TsohoTreeSaveOptions = set of TsohoTreeSaveOption;

  {    OnFilter. DataSet -   
     .  Visible     }
  TsohoTreeOnFilter = procedure (Sender: TObject; DataSet: TDataSet;
    var Visible: boolean) of object;

  {    OnItemDelete.    ItemId,
     "" . Allow   ,  
     }
  TsohoTreeOnDeleteItem = procedure (Sender: TObject; ItemID: Longint;
    var DeleteMany: boolean; var Allow: boolean) of object;
  {    OnGrpDelete.    GrpId.
    Allow   ,    }
  TsohoTreeOnDeleteGroup = procedure (Sender: TObject; GrpId: Longint;
    var Allow: boolean) of object;
  {    OnGrpDelete.    GrpId.
    Allow   ,    }
  TsohoTreeOnNewItem = procedure (Sender: TObject; GroupId: Longint;
    var ItemID, ItemHash: Longint; var Allow: boolean) of object;
  {    OnNewGrp.    NewGroup.
    Allow   ,    }
  TsohoTreeOnNewGroup = procedure (Sender: TObject; NewGroup: TsohoTreeNode;
    var Allow: boolean) of object;
  {    OnItemEdit.    GroupId 
      itemId. Allow   ,    }
  TsohoTreeOnEditItem = procedure (Sender: TObject; GroupId, ItemID: Longint;
    var Allow: boolean) of object;
  {    OnGrpEdit.    Group.
    Allow   ,    }
  TsohoTreeOnEditGroup = procedure (Sender: TObject; Group: TsohoTreeNode;
    var Allow: boolean) of object;
  {     OnCustomEditGrp  OnCustomNewGrp.   
   GroupId,   GroupHash,    ParentId 
     GroupName. Allow       }
  TsohoTreeCustomGroup = procedure (Sender: TObject; GroupId, GroupHash, ParentId: Longint;
    var GroupName: string; var Allow: boolean) of object;
  {     OnItemMove.   ,  
     OldGroupId,  ,     NewGroupId,
     ItemId,      NewItemHash. Allow
         }
  TsohoTreeOnMoveItem = procedure (Sender: TObject; OldGroupId, NewGroupId: Longint;
    ItemID, NewItemHash: Longint; var Allow: boolean) of object;

  TsohoTreeOnPopupCreate = procedure (Sender: TObject; PopupMenu: TPopupMenu) of object;

  {    OutLine. ItemId -  , ItemsHash -  
     , ParentId -    }
  PTreeLeaf = ^TTreeLeaf;
  TTreeLeaf = record
    ItemID: Longint;
    ItemHash: Longint;
    ParentId: Longint;
  end;

  {     }
  TsohoMoveItem = record
    ID: Longint;
    OldGrpId, NewGrpId: Longint;
    NewHash: Longint;
    { Fields for drag&drop }
    ItemDragBegin: boolean;
    DragOverId: Longint;
    GridDrag: boolean;
    GridRow: Longint;
  end;

  {     }
  TsohoMoveGroup = record
    GrpDragSourceRow: Longint;
  end;

  TsohoCustomTreeView = class(TCustomControl)
  private
    { Private declarations }
    FFolder: TsohoCustomFolder;
    FFixedGrpName: string;
    FFixedGrpId: Longint;
    FRootName: string;
    FActive: boolean;
    FCloseGroups: boolean;
    FEditOnDblClick: boolean;

    FGroupsDS,
      FItemsDS: TDataSet;

    FIdGrpField: string;
    FParentIdField: string;
    FHashField: string;
    FOrderField: string;
    FKeyField: string;

    FItemsName: string;
    FGroupsName: string;

    FGroupPreffix,
      FItemsPreffix: string;
    FBottomIndex: Longint;
    FSaveFile: TIniFileName;
    fOptions: TsohoTreeOptions;
    FSaveOptions: TsohoTreeSaveOptions;

    { Events }
    FOnActivate: TNotifyEvent;
    FOnFilter: TsohoTreeOnFilter;
    FOnItemDelete: TsohoTreeOnDeleteItem;
    FOnGrpDelete: TsohoTreeOnDeleteGroup;
    FOnNewItem: TsohoTreeOnNewItem;
    FOnMoveItem: TsohoTreeOnMoveItem;
    FOnNewGrp: TsohoTreeOnNewGroup;
    FOnItemEdit: TsohoTreeOnEditItem;
    FOnGrpEdit: TsohoTreeOnEditGroup;

    FOnCustomEditGrp: TsohoTreeCustomGroup;
    FOnCustomNewGrp: TsohoTreeCustomGroup;

    FOnGetCellsProps: TGetCellPropsEvent;
    FOnDrawCells: TDrawDataCellEvent;
    FOnSaveFolder: TsohoOnSaveEvent;
    FOnLoadFolder: TsohoOnLoadEvent;
    FOnPopup: TNotifyEvent;
    FAfterGrpDelete: TNotifyEvent;
    FOnChange: TNotifyEvent;
    FOnGroupSelect: TNotifyEvent;
    FOnPopupMenuCreate: TsohoTreeOnPopupCreate;

    FOnGridDblClick: TNotifyEvent;
    FOnGridKeyDown: TKeyEvent;
    FOnGroupsKeyDown: TKeyEvent;
    FOnGroupsMouseDown: TMouseEvent;
    FOnGroupsMouseMove: TMouseMoveEvent;
    FOnGroupsDragOver: TDragOverEvent;
    FOnGroupsDragDrop: TDragDropEvent;
    FOnGridDragDrop: TDragDropEvent;
    FOnGridMouseMove: TMouseMoveEvent;
    FOnGridDragOver: TDragOverEvent;
    FOnGridMouseDown: TMouseEvent;

    { Visible controls }
    FBtnsPanel,
      FComPanel,
      FOutLinePanel,
      FGridPanel: TPanel;
    FGroups: TOutLine;
    FGrid: TsohoDBGrid;
    FSplitter: TsohoSplitter;
    FViewChild: TCheckBox;
    FReport: TLabel;
    FMenuBtn: TRxSpeedButton;
    FBtnMenu: TPopupMenu;

    { Data Access }
    FSource: TDataSource;
    FOldGrp,
      FOldItm: boolean;
    FOnDSFilter: TFilterRecordEvent;
    FGroupsTable: TFileName;
    FItemsTable: TFileName;

    FPopMenu: TPopupMenu;
    FGroupMenu: TPopupMenu;
    FGrpSelItem,
      FGrpDeselItem: TMenuItem;
    FEnabledItem,
      FDisabledItem: TMenuItem;
    FParSet: boolean;
    // OperationQuery: TQuery;

    procedure GroupsKeyDown(Sender: TObject; var KEY: Word; Shift: TShiftState);
    procedure GroupsMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure GroupsMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure GroupsDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: boolean);
    procedure GroupsDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ItemsGridDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ItemsGridMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure ItemsGridDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: boolean);
    procedure ItemsGridMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

    { Design and Run-Time routines }
    procedure WriteGrid(Stream: TStream);
    procedure WriteOutLine(Stream: TStream);
    procedure ReadGrid(Stream: TStream);
    procedure ReadOutLine(Stream: TStream);
    procedure DefineProperties(Filer: TFiler); override;
    function GetGroupsVisible: boolean;
    function GetItemsVisible: boolean;
    procedure SetGroupsVisible(Show: boolean);
    procedure SetItemsVisible(Show: boolean);
    procedure SetIncludeSubTree(Value: boolean);
    function GetIncludeSubTree: boolean;
    procedure SetGroupsTable(Value: TFileName);
    function FindMaxID(index: Longint): Longint;
    procedure ButtonMenuClick(Sender: TObject);
    procedure CheckFilter(DataSet: TDataSet; var Accept: boolean);
    procedure GroupSelected(Sender: TObject);
    procedure SetItemsName(Value: string);
    procedure SetGroupsName(Value: string);
    procedure UpdateBtnMenus;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure SetGroupsDataSet(Value: TDataSet);
    procedure SetItemsDataSet(Value: TDataSet);
    procedure SetNameGrID(Value: string);
    procedure SetOrderField(Value: string);
    procedure SetNameParentID(Value: string);
    procedure SetHashField(Value: string);
    procedure SetOptions(Value: TsohoTreeOptions);
    function GetItemId: Longint;
    procedure SetItemId(Value: Longint);
    procedure SetActive(Value: boolean);
    procedure SetRootName(Value: string);
    function GetResults: TsohoDBGridResults;
    procedure SetKeyField (Value : string);

    { Events handlers }
    procedure GridDblClick(Sender: TObject);

    procedure GridGetCellProps (Sender: TObject; Field: TField;
              AFont: TFont; var Background: TColor);

    procedure GridDataCell(Sender: TObject; const Rect: TRect; Field: TField;
      State: TGridDrawState);

    procedure GridKeyDown(Sender: TObject; var KEY: Word; Shift: TShiftState);
    procedure FolderSave(Sender: TObject; DataSet: TDataSet);
    procedure FolderLoad(Sender: TObject; DataSet: TDataSet);

    procedure MenuItemClick(Sender: TObject);
    procedure OnMenuPopup(Sender: TObject);

    procedure OnBtnMenuPopup (Sender : TObject);
    procedure ViewChildClick(Sender: TObject);
    procedure SetSaveFile(Value: TIniFileName);
    function InGroup(FilterGroup: Longint): boolean;
    procedure SetFolder(Value: TsohoCustomFolder);
    procedure CreateBtnMenus;
  protected
    { Protected declarations }

    { For drag and drop }
    FMoveItem: TsohoMoveItem;
    FMoveGroup: TsohoMoveGroup;
    LeftHash, RightHash: Longint;

    function CreateGroupsTree: boolean;virtual;
    function AddTreeItem(ItemID, ParentId, ItemHash, index: Longint;
      ItemName: string): boolean;
    procedure Loaded; override;
    procedure Changed; virtual;
    procedure Paint; override;
    function  RenumberRecords: boolean;virtual; abstract;
    function  DeleteOneRecord(var ManyDelete: boolean; ItemID: Longint): boolean;virtual; abstract;
    procedure MoveGroup (NewParentId, NewHash, Id : LongInt);virtual; abstract;
    function  TreeViewGetGroupsIds(const aFixedGrpName, aGroupTable: string;
              var Ids: TsohoDBGridResults): boolean;virtual; abstract;
  public
    {     }
    function GetSelectedGroupId : LongInt;
    {     }
    function GetSelectedGroupName : string;

    {          }
    function QuietAddGroup(var NewName: string): boolean; virtual; abstract;
    {   }
    function AddGroup: boolean; virtual;
    {          }
    function QuietEditGroup(var NewName: string): boolean; virtual; abstract;
    {    }
    function EditGroup: boolean; virtual;
    {   }
    function DeleteGroup: boolean; virtual; abstract;
    {   }
    function AddItem: boolean; virtual;
    {   }
    function EditItem: boolean; virtual;
    {   }
    function MoveItem: boolean; virtual; abstract;
    {   }
    function DeleteItem: boolean; virtual; abstract;
    {      GroupsDataSet  , 
          GroupOutLine.     CloseGroups = false }
    function LocateOnGroup: boolean;
    {  ,       TreeView, 
      -  -      
      GetNewId    SoUnit }
    function GetNewGroupIdPreffix: string;
    {  ,       TreeView, 
      -  -      
      GetNewId    SoUnit }
    function GetNewItemIdPreffix: string;
    {  TreeView }
    procedure ReDrawTreeView;
    {   GroupOutLine }
    procedure SetOutLineWidth(Value: Integer);
    {  true,     ChildItemIndex  
          ParentItemIndex }
    function ItemIsChild(ParentItemIndex, ChildItemIndex: Longint): boolean;
    {       }
    function GetIndexByName(name: string): Longint;
    {     Hash    }
    function GetNewItemHash(GrpId: Longint; AIdGroupField: string): Longint;virtual; abstract;
    {    Hash       }
    function GetHash(Left, Right: Longint): Longint;
    {      }
    function GetLeafRecord(index: Longint): TTreeLeaf;
    {      }
    function GetIndexByID(ItemID: Longint): Longint;
    {    -   TsohoCustomTreeView.    
        actDelGroup   }
    procedure TreeViewButtonsClick(ButtonIndex: Longint); virtual;
    {     }
    procedure RefreshGroup;
    {   }
    procedure RefreshItems;
    {    }
    procedure RefreshTreeView; virtual;
    {   ini-  TreeView }
    procedure LoadTreeViewState; virtual;
    {   ini-  TreeView }
    procedure SaveTreeViewState; virtual;
    {     .   
      Id, IdGrp, Hash }
    function AddNewItem(GrpId, ItemID, ItemHash: Longint): boolean;virtual; abstract;

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {    TreeView }
    property Active: boolean read FActive write SetActive;
    {      TsohoDBGrid }
    property Results: TsohoDBGridResults read GetResults;
    {    }
    property ItemID: Longint read GetItemId write SetItemId default - 1;
    {    .  ,   TreeView   
       }
    property FixedGrpName: string read FFixedGrpName write FFixedGrpName;
    {    .  ,   TreeView   
       }
    property FixedGrpId: Longint read FFixedGrpId write FFixedGrpId;
    {       CheckBox'  TreeView }
    property BtnsPanel: TPanel read FBtnsPanel;
    {   IncludeSubTree CheckBox' }
    property ChildCheckBox: TCheckBox read FViewChild;
  published
    property Align;
    property Font;
    property Color;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property DragCursor;
    property DragMode;
    property Ctl3D;
    property ParentCtl3D;
    {  true,     DBGrid    }
    property EditOnDblClick: boolean read FEditOnDblClick write FEditOnDblClick default True;
    {      .    
       GetNewId }
    property GroupPreffix: string read FGroupPreffix write FGroupPreffix;
    {      .    
       GetNewId }
    property ItemsPreffix: string read FItemsPreffix write FItemsPreffix;
    {   TsohoFolder  DBGrid.   Auto  Folder 
        false }
    property Folder: TsohoCustomFolder read FFolder write SetFolder;
    {               }
    property IncludeSubTree: boolean read GetIncludeSubTree write SetIncludeSubTree;
    {     OutLine }
    property RootName: string read FRootName write SetRootName;
    { DataSet   }
    property GroupsDataSet: TDataSet read FGroupsDS write SetGroupsDataSet;
    {      }
    property GroupsTable: TFileName read FGroupsTable write SetGroupsTable;
    {      }
    property ItemsTable: TFileName read FItemsTable write FItemsTable;
    { DataSet   }
    property ItemsDataSet: TDataSet read FItemsDS write SetItemsDataSet;
    {  ,   ItemsDataSet      .
         - 'IdGrp'}
    property NameGroupID: string read FIdGrpField write SetNameGrID;
    {  ,   GroupsDataSet     
         - 'IdParent'}
    property NameParentID: string read FParentIdField write SetNameParentID;
    property KeyField: string read FKeyField write SetKeyField;
    {  ,          
       }
    property OrderField: string read FOrderField write SetOrderField;
    {  ,      
       .    - "Hash" }
    property HashField: string read FHashField write SetHashField;
    {    : , ,     }
    property Options: TsohoTreeOptions read fOptions write SetOptions;
    {    TreeView    }
    property SaveOptions: TsohoTreeSaveOptions read FSaveOptions write FSaveOptions default[trSaveSplitter];
    {    -   .     
      :  ,    .      ,
          ,     }
    property ItemsName: string read FItemsName write SetItemsName;
    {    -   .     
      :  ,    .      ,
          ,     }
    property GroupsName: string read FGroupsName write SetGroupsName;
    {     ,       ?
            -   ,  
        ,  CloseGroups    false,  
               GroupsDataSet }
    property CloseGroups: boolean read FCloseGroups write FCloseGroups default True;
    {   }
    property DBGrid: TsohoDBGrid read FGrid;
    {   }
    property GroupOutLine: TOutLine read FGroups;
    {     }
    property GroupsVisible: boolean read GetGroupsVisible write SetGroupsVisible;
    {      }
    property ItemsVisible: boolean read GetItemsVisible write SetItemsVisible;
    {  ini-    TreeView.    Folder,
           -folder }
    property SaveFile: TIniFileName read FSaveFile write SetSaveFile;

    {      }
    property OnFilter: TsohoTreeOnFilter read FOnFilter write FOnFilter;
    {      }
    property OnItemDelete: TsohoTreeOnDeleteItem read FOnItemDelete write FOnItemDelete;
    {      }
    property OnGrpDelete: TsohoTreeOnDeleteGroup read FOnGrpDelete write FOnGrpDelete;
    {      }
    property OnNewItem: TsohoTreeOnNewItem read FOnNewItem write FOnNewItem;
    {      }
    property OnNewGrp: TsohoTreeOnNewGroup read FOnNewGrp write FOnNewGrp;
    {      }
    property OnItemEdit: TsohoTreeOnEditItem read FOnItemEdit write FOnItemEdit;
    {      }
    property OnItemMove: TsohoTreeOnMoveItem read FOnMoveItem write FOnMoveItem;
    {      }
    property OnGrpEdit: TsohoTreeOnEditGroup read FOnGrpEdit write FOnGrpEdit;
    {      ""  ,   ,
           ,     .
         ,  OnGrpEdit   -  
              OnCustomEditGrp }
    property OnCustomEditGrp: TsohoTreeCustomGroup read FOnCustomEditGrp write FOnCustomEditGrp;
    {      ""  ,   ,
           ,     .
         ,  OnNewGrp   -  
              OnCustomEditGrp }
    property OnCustomNewGrp: TsohoTreeCustomGroup read FOnCustomNewGrp write FOnCustomNewGrp;
    {      }
    property AfterGrpDelete: TNotifyEvent read FAfterGrpDelete write FAfterGrpDelete;
    property OnGridDblClick: TNotifyEvent read FOnGridDblClick write FOnGridDblClick;
    property OnGridKeyDown: TKeyEvent read FOnGridKeyDown write FOnGridKeyDown;
    property OnGridDragDrop: TDragDropEvent read FOnGridDragDrop write FOnGridDragDrop;
    property OnGridMouseMove: TMouseMoveEvent read FOnGridMouseMove write FOnGridMouseMove;
    property OnGridMouseDown: TMouseEvent read FOnGridMouseDown write FOnGridMouseDown;
    property OnGridDragOver: TDragOverEvent read FOnGridDragOver write FOnGridDragOver;
    property OnOutLineKeyDown: TKeyEvent read FOnGroupsKeyDown write FOnGroupsKeyDown;
    property OnOutLineMouseDown: TMouseEvent read FOnGroupsMouseDown write FOnGroupsMouseDown;
    property OnOutLineMouseMove: TMouseMoveEvent read FOnGroupsMouseMove write FOnGroupsMouseMove;
    property OnOutLineDragOver: TDragOverEvent read FOnGroupsDragOver write FOnGroupsDragOver;
    property OnOutLineDragDrop: TDragDropEvent read FOnGroupsDragDrop write FOnGroupsDragDrop;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    {       }
    property OnGroupSelect: TNotifyEvent read FOnGroupSelect write FOnGroupSelect;

    {     sohoTreeView Grid }
    property OnGetCellProps: TGetCellPropsEvent read FOnGetCellsProps write FOnGetCellsProps;
    {     sohoTreeView Grid }
    property OnDrawDataCell: TDrawDataCellEvent read FOnDrawCells write FOnDrawCells;

    { -         }
    property OnPopupMenuCreate: TsohoTreeOnPopupCreate read FOnPopupMenuCreate write FOnPopupMenuCreate;
    {      }
    property OnActivate : TNotifyEvent read FOnActivate write FOnActivate;
  end;

{    }
function SohoTreeNode(GroupName: string; GroupId: Longint): TsohoTreeNode;

const
  {   }
  actDelGroup       = 0;
  {   }
  actNewGroup       = 1;
  {   }
  actEditGroup      = 2; 
  {   }
  actDelItem        = 3;
  {   }
  actNewItem        = 4;
  {   }
  actEditItem       = 5;
  {   }
  actRefresh        = 6;
  {   }
  actReNumber       = 7;

  {       }
  ButtonsPanelWidth = 60;

implementation
uses IniFiles, SoDBRtn, SoUnit, SoUtils, SohoWrds, SoCtmRgs, SoDBCns;

{$IFNDEF WIN32}
{$R SOHOTREE.R16}
{$ELSE}
{$R SOHOTREE.R32}
{$ENDIF}

{const

  rs_sohoTreeDelete   = 12650;
  rs_sohoTreeCreate   = 12651;
  rs_sohoTreeEdit     = 12652;
  rs_sohoTreeRefresh  = 12653;
  rs_sohoTreeReNumber = 12654;}
  
const sohoTreeViewBtnsCaptions: array[actDelGroup..actReNumber] of TCaption = (
    sohoTreeBtnDeleteGroup, sohoTreeBtnCreateGroup, sohoTreeBtnEditGroup,
    sohoTreeBtnDeleteItem, sohoTreeBtnCreateItem, sohoTreeBtnEditItem,
    sohoTreeBtnRefresh, sohoTreeBtnRenumber);

function SohoTreeNode(GroupName: string; GroupId: Longint): TsohoTreeNode;
begin
  Result.GroupName := GroupName;
  Result.GroupId := GroupId;
end;


{ TsohoCustomTreeView }
procedure TsohoCustomTreeView.SetKeyField (Value : string);
begin
  if FKeyField = Value then exit;
  FKeyField := Value;
  FGrid.KeyField := Value;
  FGrid.Update;  
end;

function TsohoCustomTreeView.LocateOnGroup: boolean;
begin
  Result := False;
  if not FGroupsDS.Active then exit;
  Result := LocaleById(FGroupsDS, FKeyField, GetLeafRecord(FGroups.SelectedItem).ItemID);
end;

function TsohoCustomTreeView.GetResults: TsohoDBGridResults;
begin
  if FGrid = nil then Result := nil
  else Result := FGrid.Results;
end;

procedure TsohoCustomTreeView.RefreshItems;
begin
  if FFolder <> nil then RefreshFolderWithId(FFolder, FKeyField)
  else RefreshDataSet(FItemsDS)
end;

procedure TsohoCustomTreeView.Changed;
begin
  if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TsohoCustomTreeView.WriteGrid(Stream: TStream);
begin
  Stream.WriteComponent(FGrid);
end;

procedure TsohoCustomTreeView.WriteOutLine;
begin
  Stream.WriteComponent(FGroups);
end;

procedure TsohoCustomTreeView.ReadGrid(Stream: TStream);
begin
  Stream.ReadComponent(FGrid);
end;

procedure TsohoCustomTreeView.ReadOutLine(Stream: TStream);
begin
  FGroups.Parent := FOutLinePanel;
  FParSet := True;
  Stream.ReadComponent(FGroups);
end;

procedure TsohoCustomTreeView.SetSaveFile;
begin
  if FSaveFile = Value then exit;
  FSaveFile := Value;
end;

procedure TsohoCustomTreeView.RefreshTreeView;
begin
  TreeViewButtonsClick(actRefresh);
end;

procedure TsohoCustomTreeView.Loaded;
var index: Longint;
  MnuItem: TMenuItem;
begin
  inherited Loaded;
  if not (csDesigning in ComponentState) then begin
    if PopupMenu <> nil then begin
      if Assigned(FOnPopupMenuCreate) then FOnPopupMenuCreate(Self, FPopMenu);
      FPopMenu.Items.Add(NewItem('-', 0, False, True, nil, 0, ''));
      for index := 0 to pred(PopupMenu.Items.Count) do begin
        MnuItem := PopupMenu.Items[0];
        PopupMenu.Items.Delete(0);
        FPopMenu.Items.Add(MnuItem);
      end;
      FOnPopup := PopupMenu.OnPopup;
    end;
  end;
  if (FFolder <> nil) and not (csDesigning in ComponentState) then begin
    FOnSaveFolder := FFolder.OnSaveDataSet;
    FOnLoadFolder := FFolder.OnLoadDataSet;
    FFolder.OnSaveDataSet := FolderSave;
    FFolder.OnLoadDataSet := FolderLoad;
  end;
end;

procedure TsohoCustomTreeView.FolderSave(Sender: TObject; DataSet: TDataSet);
begin
  SaveTreeViewState;
  if Assigned(FOnSaveFolder) then FOnSaveFolder(FFolder, FItemsDS);
end;

procedure TsohoCustomTreeView.FolderLoad(Sender: TObject; DataSet: TDataSet);
begin
  LoadTreeViewState;
  if Assigned(FOnLoadFolder) then FOnLoadFolder(FFolder, FItemsDS);
end;

procedure TsohoCustomTreeView.SetFolder(Value: TsohoCustomFolder);
begin
  if FFolder = Value then exit;
  {    , ,     }
  if (FFolder <> nil) and not (csDesigning in ComponentState) then begin
    FFolder.OnSaveDataSet := FOnSaveFolder;
    FFolder.OnLoadDataSet := FOnLoadFolder;
  end;
  FFolder := Value;
end;

procedure TsohoCustomTreeView.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
  Filer.DefineBinaryProperty('FGrid', ReadGrid, WriteGrid, FGrid <> nil);
  Filer.DefineBinaryProperty('FGroups', ReadOutLine, WriteOutLine, FGroups <> nil);
end;

procedure TsohoCustomTreeView.SetGroupsVisible(Show: boolean);
begin
  FOutLinePanel.Visible := Show;
  if not Show then
    fOptions := fOptions - [trEditItem, trAddItem, trDeleteItem];
  UpdateBtnMenus;
end;

procedure TsohoCustomTreeView.SetItemsVisible(Show: boolean);
begin
  FGridPanel.Visible := Show;
  if not Show then
    fOptions := fOptions - [trEditGroup, trAddGroup, trDeleteGroup];
  UpdateBtnMenus;
end;

function TsohoCustomTreeView.GetGroupsVisible;
begin
  Result := FOutLinePanel.Visible;
end;

function TsohoCustomTreeView.GetItemsVisible;
begin
  Result := FGridPanel.Visible;
end;

function TsohoCustomTreeView.GetIncludeSubTree: boolean;
begin
  Result := FViewChild.Checked;
end;

procedure TsohoCustomTreeView.SetIncludeSubTree(Value: boolean);
begin
  if FViewChild.Checked = Value then exit;
  FViewChild.Checked := Value;
end;

function TsohoCustomTreeView.GetIndexByName(name: string): Longint;
var index: Longint;
begin
  Result := -1;
  for index := 1 to FGroups.ItemCount do
    if name = FGroups.Items[index].Text then begin
      Result := index;
      exit;
    end;
end;

function TsohoCustomTreeView.GetHash(Left, Right: Longint): Longint;
begin
  Result := Left div 2 + Right div 2;
end;

function TsohoCustomTreeView.GetLeafRecord(index: Longint): TTreeLeaf;
begin
  if (index < 1) or (index > FGroups.ItemCount) then exit;
  Result := PTreeLeaf(FGroups.Items[index].Data)^;
end;

function TsohoCustomTreeView.GetIndexByID(ItemID: Longint): Longint;
var index: Longint;
begin
  Result := -1;
  for index := 1 to FGroups.ItemCount do
    if ItemID = PTreeLeaf(FGroups.Items[index].Data)^.ItemID then begin
      Result := index;
      exit;
    end;
end;

function TsohoCustomTreeView.FindMaxID(index: Longint): Longint;
begin
  Result := index;
  index := FGroups.Items[index].GetLastChild;
  if index <> -1 then Result := FindMaxID(index);
end;

function TsohoCustomTreeView.AddTreeItem(ItemID, ParentId, ItemHash, index: Longint;
    ItemName: string): boolean;
var NewLeaf: PTreeLeaf;
begin
  Result := False;
  try
    New(NewLeaf);
  except exit;
  end;
  NewLeaf^.ItemID := ItemID;
  NewLeaf^.ParentId := ParentId;
  NewLeaf^.ItemHash := ItemHash;
  try
    FGroups.AddChildObject(index, ItemName, NewLeaf);
  except ErrorMsg(Format(sohoTreeNotMemory, [Name]));
    exit;
  end;
  Result := True;
end;


function TsohoCustomTreeView.AddGroup: boolean;
var NewName: string;
  F1, F2, F3, NewC: string;
begin
  {         }
  Result := False;
  if not (trAddGroup in fOptions) then exit;
  NewName := '';
  {   ,  -      ,
            }
  if not Assigned(FOnCustomNewGrp) then begin
    WordToWordForm(FGroupsName, F1, F2, F3);
    if WordGender(F1) = gnFemale then NewC := sohoTreeNewFeMaleGroup
    else NewC := sohoTreeNewMaleGroup;
    repeat
      if not InputQuery(NewC + F1, sohoTreeGroupName + F3, NewName) then exit;
      if NewName = '' then exit;
      NewName := ChangeChars(NewName, '"', '''');
    until GetIndexByName(NewName) = -1;
    {         }
  end;
  Result := QuietAddGroup(NewName);
end;

function TsohoCustomTreeView.EditGroup: boolean;
var NewName: string;
  F1, F2, F3        : string;
  CurIndex, NowIndex: Longint;
begin
  {   }
  Result := False;
  if not (trEditGroup in fOptions) then exit;
  with FGroups do begin
    CurIndex := SelectedItem;
    NewName := Items[CurIndex].Text;
  end;
  if CurIndex = 1 then exit;
  if not Assigned(FOnCustomEditGrp) then begin
    WordToWordForm(FGroupsName, F1, F2, F3);
    repeat
      if not InputQuery(sohoTreeGroupNameChange + F2, sohoTreeGroupName + F2, NewName) then exit;
      if NewName = '' then exit;
      NewName := ChangeChars(NewName, '"', '''');
      NowIndex := GetIndexByName(NewName);
      if CurIndex = NowIndex then exit;
    until (NowIndex = -1);
  end;
  Result := QuietEditGroup(NewName);
end;


function TsohoCustomTreeView.GetNewGroupIdPreffix: string;
begin
  if FGroupPreffix <> '' then Result := FGroupPreffix
  else Result := Owner.name + '.' + name + '.Group';
end;

function TsohoCustomTreeView.GetNewItemIdPreffix: string;
begin
  if FItemsPreffix <> '' then Result := FItemsPreffix
  else Result := Owner.name + '.' + name + '.Items';
end;

function TsohoCustomTreeView.AddItem: boolean;
var NewId, GrpId: Longint;
  NewHash: Longint;
begin
  Result := False;
  if not (trAddItem in fOptions) then exit;
  {         }
  NewId := SoUnit.GetNewId(GetNewItemIdPreffix);
  GrpId := GetLeafRecord(FGroups.SelectedItem).ItemID;
  {    }
  NewHash := GetNewItemHash(GrpId, FIdGrpField);
  if Assigned(FOnNewItem) then FOnNewItem(Self, GrpId, NewId, NewHash, Result);
  {      AddNewItem(IDGrp,IDItem, ItemHash) }
  if Result then begin
    RefreshItems;
    Changed;
  end;
end;

function TsohoCustomTreeView.EditItem: boolean;
begin
  Result := False;
  if not (trEditItem in fOptions) then exit;
  if FItemsDS.FieldByName(FKeyField).IsNull then Result := AddItem
  else
    if Assigned(FOnItemEdit) then FOnItemEdit(Self, GetLeafRecord(FGroups.SelectedItem).ItemID,
      FItemsDS.FieldByName(FKeyField).AsInteger, Result);
  if Result then begin
    RefreshItems;
    Changed;
  end;
end;

function TsohoCustomTreeView.CreateGroupsTree: boolean;

  function GetParentIndex(ParentId: Longint): Integer;
  var index: Integer;
  begin
    Result := -1;
    for index := 1 to FGroups.ItemCount do
      with FGroups.Items[index] do begin
        if PTreeLeaf(Data)^.ItemID = ParentId then begin
          Result := index;
          exit;
        end;
      end;
  end;

var LastParentId, LastIndex, index: Longint;
  ItemID, ParentId, ItemHash  : Longint;
  ItemName                    : string;
  DoAddItem                   : boolean;
  Ids                         : TsohoDBGridResults;

begin
  Result := False;
  if FGroups = nil then begin
    ErrorMsg(Format(sohoTreeGetNilInsteadOutLine, [name]));
    exit;
  end;
  for index := 1 to FGroups.ItemCount do
    Dispose(PTreeLeaf(FGroups.Items[Index].Data));

  FGroups.Clear;
  with FGroupsDS do begin
    if not Active then
      try
        Open;
      except ErrorMsg(Format(sohoTreeCantOpenGroupsTable,[Name]));
        exit;
      end;
    {  }
    LastParentId := 0;
    LastIndex    := 1;
    if not AddTreeItem(0, 0, 0, 0, FRootName) then exit;
    {      }
    Ids := TsohoDBGridResults.Create;

    if FFixedGrpName <> '' then
      TreeViewGetGroupsIds(FFixedGrpName, FGroupsTable, Ids);

    First;
    while not EOF do begin
      ItemID    := FieldByName(FKeyField).AsInteger;
      ParentId  := FieldByName(FParentIdField).AsInteger;
      ItemHash  := FieldByName(FHashField).AsInteger;
      ItemName  := FieldByName('Name').AsString;
      DoAddItem := (ItemID <> 0) and
                   ((ItemID = FFixedGrpId) or (FFixedGrpId = -1)) and
                   ((Ids.IndexOf(ItemID) <> -1) or (FFixedGrpName = ''));

      if DoAddItem then
        AddTreeItem(ItemID, ParentId, ItemHash, 0, ItemName);
      Next;
    end;
    Ids.Free;
    if FCloseGroups then Close;
  end;
  index := 1;
  while index < FGroups.ItemCount do begin
    Inc(index);
    if FGroups.Items[index].Level = 1 then
      FGroups.Items[index].MOVETO(
      GetParentIndex(GetLeafRecord(index).ParentId), oaAddChild);
    while (FGroups.Items[index].Level = 1) and (index > 1) do dec(index);
  end;
  FGroups.FullExpand;
  FGroups.SelectedItem := 1;
  Result := True;
end;


procedure TsohoCustomTreeView.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (AComponent = FGroupsDS) and (Operation = opRemove) then begin
    Active := False;
    FGroupsDS := nil;
  end;
  if (AComponent = FItemsDS) and (Operation = opRemove) then begin
    Active := False;
    FItemsDS := nil;
  end;
  if (AComponent = FFolder) and (Operation = opRemove) then
    FFolder := nil;
end;

procedure TsohoCustomTreeView.SetGroupsTable;
begin
  FGroupsTable := Value;
end;

procedure TsohoCustomTreeView.SetOutLineWidth(Value: Integer);
begin
  FOutLinePanel.Width := Value;
end;

procedure TsohoCustomTreeView.LoadTreeViewState;
var FIniFile: TFileName;
begin
  if csDesigning in ComponentState then exit;
  FIniFile := FSaveFile;
  if (FIniFile = '') and (FFolder <> nil) then FIniFile := FFolder.FullFolderName;
  if FIniFile = '' then exit;
  with TIniFile.Create(FIniFile) do begin
    if trSaveSplitter in FSaveOptions then
      FOutLinePanel.Width := ReadInteger(Owner.ClassName + name + 'Splitter',
      'Width', FOutLinePanel.Width);
    if trSaveViewChild in FSaveOptions then
      FViewChild.Checked := ReadBool(Owner.ClassName + name + 'ViewChild',
      'View', False);
    Free;
  end;
  try
    if trSaveOutLine in FSaveOptions then ApplyOutLineDescription(FGroups, FIniFile);
  except {     }
  end;
end;

procedure TsohoCustomTreeView.SaveTreeViewState;
var FIniFile: TFileName;
begin
  if csDesigning in ComponentState then exit;
  FIniFile := FSaveFile;
  if (FIniFile = '') and (FFolder <> nil) then FIniFile := FFolder.FullFolderName;
  if FIniFile = '' then exit;
  with TIniFile.Create(FIniFile) do begin
    if trSaveSplitter in FSaveOptions then
      WriteInteger(Owner.ClassName + name + 'Splitter', 'Width', FOutLinePanel.Width);
    if trSaveViewChild in FSaveOptions then
      WriteBool(Owner.ClassName + name + 'ViewChild', 'View', FViewChild.Checked);
    Free;
    if trSaveOutLine in FSaveOptions then SaveOutLineDescription(FGroups, FIniFile);
  end;
end;

procedure TsohoCustomTreeView.SetActive(Value: boolean);

  procedure RestoreDataSets;
  begin
    if FOldGrp then FGroupsDS.Open
    else FGroupsDS.Close;
    if FOldItm then FItemsDS.Open
    else FItemsDS.Close;
  end;

begin
  if (FActive = Value) then exit;
  if (FGroupsDS = nil) or (FItemsDS = nil) or
    (FIdGrpField = '') or (FGroupsTable = '') then begin
    ErrorMsg(Format(sohoTreeCantActivateTreeView, [name]));
    exit;
  end;
  if not Value then begin
    if FFolder <> nil then begin
      FFolder.SaveDataSet;
      FFolder.SaveDBGridColumns;
      FFolder.Deactivate;
      FFolder.RestoreEvents;
      FFolder.Grid := nil;
    end;
    {      Popup}
    FGrid.PopupMenu.OnPopup := OnMenuPopup;
    RestoreDataSets;
    FActive := Value;
    if FGroups <> nil then FGroups.Clear;
    FItemsDS.OnFilterRecord := FOnDSFilter;
    exit;
  end;
  try
    SetCursor(crHourGlass);
    FOldGrp := FGroupsDS.Active;
    FOldItm := FItemsDS.Active;
    if not FGroupsDS.Active then FGroupsDS.Open;
    Screen.Cursor := crHourGlass;
    if not FItemsDS.Active then FItemsDS.Open;
    Screen.Cursor := crHourGlass;
    {Check fields}
    with FGroupsDS do
      if (FindField(FKeyField) = nil) or
        (FindField(FParentIdField) = nil) or
        (FindField('Name') = nil) or
        (FindField(FHashField) = nil)
        then begin
        ErrorMsg(Format(sohoTreeMustExistGrpFields, [Name, KeyField, FParentIdField, FHashField]));
        RestoreDataSets;
        exit;
      end;

    with FItemsDS do begin
      if (FindField(FKeyField) = nil) or
        (FindField(FIdGrpField) = nil) or
        (FindField(FHashField) = nil) then begin
        ErrorMsg(Format(sohoTreeMustExistItmFields, [Name, KeyField, FIdGrpField, FHashField]));
        RestoreDataSets;
        exit;
      end;
    end;

    with FGroups do begin
      Parent := FOutLinePanel;
      Align := alClient;
      PopupMenu := FGroupMenu;
      OnClick := GroupSelected;
    end;

    with FGrid do Parent := FGridPanel;


    CreateGroupsTree;

    FOnDSFilter := FItemsDS.OnFilterRecord;
    FItemsDS.OnFilterRecord := CheckFilter;

    FGrid.DataSource := FSource;
    FSource.DataSet := FItemsDS;
    FActive := Value;
    if FFolder <> nil then begin
      FFolder.KeyField := FKeyField;
      FFolder.Grid := FGrid;
      FFolder.Activate;
      FFolder.LoadDBGridColumns;
    end;
    FGrid.PopupMenu := FPopMenu;
    if Assigned(FOnActivate) then FOnActivate(Self);
    RestoreCursor;
  except ErrorMsg(Format(sohoTreeDataSetsActivateError, [name]));
  end;
end;

procedure TsohoCustomTreeView.SetGroupsDataSet(Value: TDataSet);
begin
  if FGroupsDS = Value then exit;
  Active := False;
  FGroupsDS := Value;
end;

procedure TsohoCustomTreeView.SetItemsDataSet(Value: TDataSet);
begin
  if FItemsDS = Value then exit;
  Active := False;
  FItemsDS := Value;
end;

procedure TsohoCustomTreeView.SetOrderField(Value: string);
begin
  if FOrderField = Value then exit;
  Active := False;
  FOrderField := Value;
end;

procedure TsohoCustomTreeView.SetHashField(Value: string);
begin
  if FHashField = Value then exit;
  Active := False;
  FHashField := Value;
end;

procedure TsohoCustomTreeView.SetNameGrID(Value: string);
begin
  if FIdGrpField = Value then exit;
  Active := False;
  FIdGrpField := Value;
end;

procedure TsohoCustomTreeView.SetNameParentID(Value: string);
begin
  if FParentIdField = Value then exit;
  Active := False;
  FParentIdField := Value;
end;

procedure TsohoCustomTreeView.SetOptions(Value: TsohoTreeOptions);
begin
  if fOptions = Value then exit;
  fOptions := Value;
  UpdateBtnMenus;
end;

procedure TsohoCustomTreeView.SetGroupsName(Value: string);
begin
  if FGroupsName = Value then exit;
  FGroupsName := Value;
  UpdateBtnMenus;
end;

procedure TsohoCustomTreeView.SetItemsName(Value: string);
begin
  if FItemsName = Value then exit;
  FItemsName := Value;
  UpdateBtnMenus;
end;

procedure TsohoCustomTreeView.UpdateBtnMenus;
var index: Integer;
    F1, F2, F3: string;
    GroupsActive, ItemsActive : boolean;
begin
  if csDestroying in ComponentState then exit;
  GroupsActive := FGroups.ItemCount > 0;
  ItemsActive := (FItemsDS<>nil) and (FItemsDS.Active);
  for Index := actDelGroup to actReNumber do
    with FBtnMenu.Items[index] do begin
      Caption := sohoTreeViewBtnsCaptions[index];
      if (Index < 3) then WordToWordForm(FGroupsName, F1, F2, F3)
      else WordToWordForm(FItemsName, F1, F2, F3);
      if Index <= actEditItem then Caption := Caption + ' ' + F2;
      if Index <= actReNumber then Enabled := TsohoTreeOption(index) in fOptions;
      if Index < 3 then Enabled := Enabled and GroupsActive
      else
        if Index < actReNumber then Enabled := Enabled and ItemsActive;
    end;
  //     ""
  FBtnMenu.Items[actReNumber].Enabled := FBtnMenu.Items[actReNumber].Enabled
    and ItemsActive and (FOrderField<>'')
    and (FItemsDS.FindField(FOrderField) <> nil);
end;

function TsohoCustomTreeView.GetItemId: Longint;
begin
  Result := -1;
  if (FItemsDS = nil) or (not FItemsDS.Active) then exit;
  Result := FItemsDS.FieldByName(FKeyField).AsInteger;
end;

procedure TsohoCustomTreeView.SetItemId(Value: Longint);
var CurGrp, CurItem: Longint;
  ID, index: Longint;
begin
  if (FItemsDS = nil) or (not FItemsDS.Active) then begin
    ErrorMsg(Format(sohoTreeCantSetItemId, [name]));
    exit;
  end;
  if Value < 0 then exit;
  {     ! }
  CurGrp := FGroups.SelectedItem;
  with FItemsDS do begin
    CurItem := FieldByName(FKeyField).AsInteger;
    DisableControls;
    SetCursor(crHourGlass);
    for index := 1 to FGroups.ItemCount do begin
      FGroups.SelectedItem := index;
      First;
      ID := -1;
      while not EOF do begin
        ID := FieldByName(FKeyField).AsInteger;
        if ID = Value then begin
          FGroups.SelectedItem := GetIndexByID(FieldByName(FIdGrpField).AsInteger);
          EnableControls;
          RestoreCursor;
          exit;
        end;
        Next;
      end;
    end;
    {ErrorMsg('   !');}
    FGroups.SelectedItem := CurGrp;
    First;
    while not EOF and not (CurItem = FieldByName(FKeyField).AsInteger) do Next;
    EnableControls;
    RestoreCursor;
  end;
end;

procedure TsohoCustomTreeView.Paint;
begin
  inherited Paint;
  if not FParSet then begin
    FGroups.Parent := FOutLinePanel;
    FGrid.Parent := FGridPanel;
    FParSet := True;
  end;
  FOutLinePanel.Update;
  FGridPanel.Update;
end;

procedure TsohoCustomTreeView.ViewChildClick(Sender: TObject);
begin
  if FActive then GroupSelected(Sender);
end;

procedure TsohoCustomTreeView.CreateBtnMenus;
var index: Longint;
  Item: TMenuItem;
begin
  for index := actDelGroup to actReNumber do begin
    Item := NewItem(sohoTreeViewBtnsCaptions[index], 0, False, True, ButtonMenuClick, 0, '');
    Item.Tag := index;
    FBtnMenu.Items.Add(Item);
  end;
end;

constructor TsohoCustomTreeView.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ShowHint := true;
  fOptions := [trDeleteGroup, trAddGroup, trEditGroup, trDeleteItem,
    trAddItem, trEditItem, trRefresh, trReNumber,
    trMoveItem, trMoveGroup];
  FSaveOptions := [trSaveSplitter];
  FEditOnDblClick := True;
  FGroupsDS := nil;
  FItemsDS := nil;
  FFolder := nil;
  FActive := False;
  FIdGrpField := 'IDGrp';
  FOrderField := 'NumOrder';
  FHashField := 'Hash';
  FParentIdField := 'IdParent';
  FKeyField := 'Id';
  FItemsName := sohoTreeDefItemName;
  FGroupsName := sohoTreeDefGroupName;
  Font.name := 'Ms Sans Serif';
  Font.Size := 8;
  FFixedGrpId := -1;
  FFixedGrpName := '';
  FItemsPreffix := '';
  FGroupPreffix := '';
  FCloseGroups := True;

  { Create visible controls }
  Width := 400;
  Height := 200;

  FBtnsPanel := TPanel.Create(Self);
  with FBtnsPanel do begin
    Parent := Self;
    Width := ButtonsPanelWidth;
    Align := alLeft;
    BevelOuter := bvNone;
    BevelInner := bvNone;
    ParentColor := True;
    ParentFont := True;
  end;

  FComPanel := TPanel.Create(Self);
  with FComPanel do begin
    Parent := Self;
    Align := alClient;
    BevelOuter := bvNone;
    BevelInner := bvNone;
    ParentColor := True;
    ParentFont := True;
    ParentShowHint := true;
  end;

  FOutLinePanel := TPanel.Create(Self);
  with FOutLinePanel do begin
    Parent := FComPanel;
    Width := 100;
    Align := alLeft;
    BevelOuter := bvNone;
    BevelInner := bvNone;
    ParentColor := True;
    ParentFont := True;
    ParentShowHint := true;
  end;

  FSplitter := TsohoSplitter.Create(Self);
  with FSplitter do begin
    Parent := FComPanel;
    Left := FOutLinePanel.Left + FOutLinePanel.Width + 2;
    Align := alLeft;
  end;

  FGridPanel := TPanel.Create(Self);
  with FGridPanel do begin
    Parent := FComPanel;
    Align := alClient;
    BevelOuter := bvNone;
    BevelInner := bvNone;
    Caption := sohoTreeNoRecords;
    ParentColor := True;
    ParentFont := True;
    ParentShowHint := true;
  end;

  FGrid := TsohoDBGrid.Create(Self);
  with FGrid do begin
    Align := alClient;
    Options := [dgTitles, dgIndicator, dgColumnResize, dgColLines,
      dgRowLines, dgTabs, dgAlwaysShowSelection, dgCancelOnExit];
    ReadOnly := true;
    SmashColumn := true;
    OnGetCellProps := GridGetCellProps;
    OnDrawDataCell := GridDataCell;
    OnDblClick := GridDblClick;
    OnKeyDown := GridKeyDown;
    OnDragDrop := ItemsGridDragDrop;
    OnMouseMove := ItemsGridMouseMove;
    OnMouseDown := ItemsGridMouseDown;
    OnDragOver := ItemsGridDragOver;
    ParentFont := True;
    ParentShowHint := true;
  end;

  FBtnMenu := TPopupMenu.Create(Self);
  FBtnMenu.OnPopup := OnBtnMenuPopup;
  CreateBtnMenus;

  FMenuBtn := TRxSpeedButton.Create(Self);
  with FMenuBtn do begin
    Parent := FBtnsPanel;
    Transparent := True;
    DropDownMenu := FBtnMenu;
    Width := ButtonsPanelWidth - 4;
    Left := 2;
    Top := 2;
    Hint := sohoTreeItemsOperations;
    Glyph.Handle := ResBitmap('SOHOTVMENUBTN');
    Cursor := crHandPoint;
  end;

  FViewChild := TCheckBox.Create(Self);
  with FViewChild do begin
    Parent := FBtnsPanel;
    Hint := sohoTreeShowChilds;
    Checked := False;
    OnClick := ViewChildClick;
    Top := FMenuBtn.Top + FMenuBtn.Height + 4;
    Left := 2;
    Caption := sohoTreeChildsCaption;
    Cursor := crHandPoint;
  end;

  FEnabledItem := NewItem(sohoTreeSelectItem, 0, False, True, MenuItemClick, 0, '');
  FEnabledItem.Tag := -1;
  FDisabledItem := NewItem(sohoTreeUnselectItem, 0, False, True, MenuItemClick, 0, '');
  FDisabledItem.Tag := -1;
  FPopMenu := NewPopupMenu(Self, '', paLeft, True,[FEnabledItem, FDisabledItem]);
  FPopMenu.OnPopup := OnMenuPopup;

  FGrpSelItem := NewItem(sohoTreeSelectItem, 0, False, True, MenuItemClick, 0, '');
  FGrpDeselItem := NewItem(sohoTreeUnselectItem, 0, False, True, MenuItemClick, 0, '');
  FGroupMenu := NewPopupMenu(Self, '', paLeft, True,[FGrpSelItem, FGrpDeselItem]);
  FGroupMenu.OnPopup := OnMenuPopup;

  FGroups := TOutLine.Create(Self);
  with FGroups do begin
    name := Self.name + 'OutLine';
    Align := alClient;
    PopupMenu := FGroupMenu;
    Style := otOwnerDraw;
    ItemHeight := 19;
    PictureClosed.Handle := ResBitmap('TVCLOSEBAG');
    PictureOpen.Handle   := ResBitmap('TVOPENBAG');
    PictureLeaf.Handle   := ResBitmap('TVLEAF');
    Canvas.Pen.Style := psDot;
    Canvas.Pen.Mode := pmNotXor;
    OnKeyDown := GroupsKeyDown;
    OnMouseDown := GroupsMouseDown;
    OnMouseMove := GroupsMouseMove;
    OnDragOver := GroupsDragOver;
    OnDragDrop := GroupsDragDrop;
    ParentShowHint := true;
  end;

  FParSet := False;
  
  FGrid.PopupMenu := FPopMenu;
  
  FSource := TDataSource.Create(Self);
  FRootName := '';
  FGrid.DataSource := FSource;

  // OperationQuery := TQuery.Create(Self);

  with FMoveItem do begin
    ID := -1;
    OldGrpId := -1;
    NewGrpId := -1;
    NewHash := -1;
    {Fields for drag&drop}
    ItemDragBegin := False;
    DragOverId := -1;
    GridDrag := False;
    GridRow := -1;
  end;
  with FMoveGroup do begin
    GrpDragSourceRow := -1;
  end;

end;

procedure TsohoCustomTreeView.SetRootName;
begin
  FRootName := Value;
  if csLoading in ComponentState then exit;
  if FGroups.ItemCount <> 0 then FGroups.Items[1].Text := Value
  else AddTreeItem(0, 0, 0, 0, Value);
end;


procedure TsohoCustomTreeView.TreeViewButtonsClick(ButtonIndex: Longint);
var Res: boolean;
  FIniFile: TFileName;
begin
  Res := False;
  case ButtonIndex of
    actDelGroup: Res := DeleteGroup; { }
    actNewGroup: Res := AddGroup; { }
    actEditGroup: EditGroup; { }
    actDelItem: Res := DeleteItem; { item}
    actNewItem: Res := AddItem; { item}
    actEditItem: Res := EditItem; { item}
    actRefresh: begin Res := True; {}
      if trSaveOutLine in FSaveOptions then begin
        FIniFile := FSaveFile;
        if (FIniFile = '') and (FFolder <> nil) then
          FIniFile := FFolder.FullFolderName;
        SaveOutLineDescription(FGroups, FIniFile);
      end;
      Active := False;
      Active := True;
      try
        if trSaveOutLine in FSaveOptions then
          ApplyOutLineDescription(FGroups, FIniFile);
      except
      end;
    end;
    actReNumber: Res := RenumberRecords; {}
  end;
  if Res then GroupSelected(FGroups);
end;

procedure TsohoCustomTreeView.ButtonMenuClick(Sender: TObject);
var index: Integer;
begin
  index := (Sender as TMenuItem).Tag;
  if (index >= actDelGroup) and (index <= actReNumber) then TreeViewButtonsClick(index);
end;

function TsohoCustomTreeView.InGroup(FilterGroup: Longint): boolean;
var index: Integer;
  Ftmp: TTreeLeaf;
begin
  Result := False;
  with FGroups do begin
    if SelectedItem = ItemCount then exit; {  }
    if Items[SelectedItem].GetLastChild = -1 then exit;
    Result := True;
    for index := SelectedItem + 1 to FBottomIndex do begin
      Ftmp := GetLeafRecord(index);
      if Ftmp.ItemID = FilterGroup then exit;
    end;
    Result := False;
  end;
end;

function TsohoCustomTreeView.GetSelectedGroupId : LongInt;
begin
  if Active and (FGroups<>nil) and (FGroups.SelectedItem<>-1) then
   Result := GetLeafRecord(FGroups.SelectedItem).ItemID
  else Result := -1;
end;

function TsohoCustomTreeView.GetSelectedGroupName : string;
begin
  if GetSelectedGroupId <> -1 then
    Result := FGroups.Items[FGroups.SelectedItem].Text
  else Result := '';  
end;

procedure TsohoCustomTreeView.CheckFilter(DataSet: TDataSet; var Accept: boolean);
var GrpId, CurId: Longint;
  Allow: boolean;
begin
  if (csDestroying in ComponentState) then exit;
  GrpId := GetLeafRecord(FGroups.SelectedItem).ItemID;
  CurId := FItemsDS.FieldByName(FIdGrpField).AsInteger;
  if not FViewChild.Checked then Allow := CurId = GrpId
  else Allow := (GrpId = 0) or (CurId = GrpId) or InGroup(CurId);
  if Assigned(FOnFilter) then FOnFilter(Self, FItemsDS, Allow);
  Accept := Allow;
  if Assigned(FOnDSFilter) then FOnDSFilter(DataSet, Accept);
end;

procedure TsohoCustomTreeView.RefreshGroup;
begin
  GroupSelected(FGroups);
end;

procedure TsohoCustomTreeView.GroupSelected(Sender: TObject);
begin
  {      }
  with FGroups do begin
    FBottomIndex := SelectedItem;
    while Items[FBottomIndex].GetLastChild <> -1 do
      FBottomIndex := Items[FBottomIndex].GetLastChild;
  end;
  { Update filter texts }
  RefreshDataSetFilter(FItemsDS);
  FGrid.Visible := FItemsDS.RecordCount > 0;
  if Assigned(FOnGroupSelect) then FOnGroupSelect(Self);
end;

procedure TsohoCustomTreeView.GridDblClick(Sender: TObject);
begin
  if FEditOnDblClick then EditItem;
  if Assigned(FOnGridDblClick) then FOnGridDblClick(Sender);
end;

procedure TsohoCustomTreeView.GridDataCell(Sender: TObject; const Rect: TRect; Field: TField;
    State: TGridDrawState);
begin
  if Assigned(FOnDrawCells) then FOnDrawCells(Sender, Rect, Field, State);
end;

procedure TsohoCustomTreeView.GridGetCellProps(Sender : TObject; Field: TField; AFont: TFont;
              var Background: TColor);
begin
  if Assigned(FOnGetCellsProps) then FOnGetCellsProps(Sender, Field, aFont,
     Background);
end;

procedure TsohoCustomTreeView.GridKeyDown(Sender: TObject; var KEY: Word; Shift: TShiftState);
begin
  if Assigned(FOnGridKeyDown) then FOnGridKeyDown(Sender, KEY, Shift);
  case KEY of
    VK_INSERT: begin
      if Shift = [] then begin
        TreeViewButtonsClick(actNewItem);
        KEY := 0;
      end;
      if (Shift = [ssCtrl]) and (not FMoveItem.ItemDragBegin) then begin
        KEY := 0;
        if not (trMoveItem in fOptions) then exit;
        FMoveItem.ItemDragBegin := True;
        FMoveItem.ID := FItemsDS.FieldByName(FKeyField).AsInteger;
        SetCaptureControl(FGrid);
        SetCursor(crCross);
      end;
      if (Shift = [ssShift]) and FMoveItem.ItemDragBegin then begin
        KEY := 0;
        SetCaptureControl(nil);
        if not (trMoveItem in fOptions) then exit;
        FMoveItem.ItemDragBegin := False;
        with FItemsDS do begin
          FMoveItem.DragOverId := FieldByName(FKeyField).AsInteger;
          FMoveItem.NewGrpId := FieldByName(FIdGrpField).AsInteger;
          RightHash := FieldByName(FHashField).AsInteger;
          Prior;
          if FieldByName(FKeyField).AsInteger = FMoveItem.DragOverId then
            LeftHash := - MaxLongint
          else LeftHash := FieldByName(FHashField).AsInteger;
          FMoveItem.NewHash := GetHash(LeftHash, RightHash);
        end;
        {       Hash,    ID }
        MoveItem;
        {  Resfresh   }
        RefreshItems;
        RestoreCursor;
      end;
    end;
    VK_ESCAPE: if FMoveItem.ItemDragBegin then begin
      SetCaptureControl(nil);
      FMoveItem.ItemDragBegin := False;
      RestoreCursor;
      KEY := $00;
    end;
    VK_RETURN: if Shift = [ssAlt] then TreeViewButtonsClick(actEditItem);
    VK_DELETE: DeleteItem;
  end;
end;

procedure TsohoCustomTreeView.OnBtnMenuPopup (Sender : TObject);
begin
  UpdateBtnMenus;
end;

procedure TsohoCustomTreeView.OnMenuPopup(Sender: TObject);
var index: Longint;

begin
  if (Sender = FEnabledItem) or (Sender = FDisabledItem) then begin
    index := Results.IndexOf(FItemsDS.FieldByName(FKeyField).AsInteger);
    with FPopMenu do begin
      FEnabledItem.Enabled := index = -1;
      FDisabledItem.Enabled := index <> -1;
    end;
  end;
  if (Sender <> FGroupMenu) and Assigned(FOnPopup) then FOnPopup(Sender);
end;

procedure TsohoCustomTreeView.MenuItemClick(Sender: TObject);
  
  procedure SelectGroup(DoSelect: boolean);
  var OldCheck: boolean;
  begin
    OldCheck := FViewChild.Checked;
    try
      with FItemsDS do begin
        DisableControls;
        FViewChild.Checked := True;
        First;
        while not EOF do begin
          if DoSelect then Results.Add(FItemsDS.FieldByName(FKeyField).AsInteger)
          else Results.Remove(FItemsDS.FieldByName(FKeyField).AsInteger);
          Next;
        end;
      end;
    finally
      FViewChild.Checked := OldCheck;
      FItemsDS.EnableControls;
    end;
  end;
   begin
  with Sender as TMenuItem do begin
    if (Sender = FEnabledItem) or (Sender = FDisabledItem) then begin
      if Sender = FEnabledItem then Results.Add(FItemsDS.FieldByName(FKeyField).AsInteger)
      else Results.Remove(FItemsDS.FieldByName(FKeyField).AsInteger);
    end
    else begin
      if (Sender = FGrpSelItem) then { } SelectGroup(True)
      else {   } SelectGroup(False);
    end;
  end;
end;

destructor TsohoCustomTreeView.Destroy;
var Index : integer;
begin
  {     }
  FBtnMenu.Free;
  FMenuBtn.Free;
  FViewChild.Free;
  FBtnsPanel.Free;
  for Index := 1 to FGroups.ItemCount do
    Dispose(PTreeLeaf(FGroups.Items[Index].Data));
  FGroups.Free;
  FOutLinePanel.Free;
  FGrid.Free;
  FGridPanel.Free;
  FSplitter.Free;
  FComPanel.Free;
  FPopMenu.Free;
  FGroupMenu.Free;
  FSource.Free;
  // OperationQuery.Free;
  inherited Destroy;
end;

procedure TsohoCustomTreeView.GroupsKeyDown(Sender: TObject; var KEY: Word; Shift: TShiftState);
begin
  case KEY of
    VK_INSERT: begin TreeViewButtonsClick(actNewGroup);
      KEY := $00;
    end;
    VK_RETURN: begin
      if Shift = [ssAlt] then begin {Edit Group name}
        TreeViewButtonsClick(actEditGroup);
        KEY := $00;
      end;
      if Shift = [] then begin {Get goods list}
        KEY := $00;
        RefreshDataSetFilter(FItemsDS);
      end;
    end;
  end;
  if Assigned(FOnGroupsKeyDown) then FOnGroupsKeyDown(Sender, KEY, Shift);
end;

procedure TsohoCustomTreeView.GroupsMouseDown(Sender: TObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer);
begin
  if (Shift = [ssRight]) then begin
    FGroups.SelectedItem := FGroups.GetItem(X, Y);
    RefreshDataSetFilter(FItemsDS);
  end;
  if Assigned(FOnGroupsMouseDown) then FOnGroupsMouseDown(Sender, Button, Shift, X, Y);
end;

procedure TsohoCustomTreeView.GroupsMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var NowItem: Longint;
begin
  NowItem := FGroups.GetItem(X, Y);
  { Drag&Drop   Ctrl }
  if (Shift = [ssLeft, ssCtrl]) and (FGroups.Dragging = False) then begin
    FGroups.BeginDrag(True);
    FMoveGroup.GrpDragSourceRow := NowItem;
  end;
  if Assigned(FOnGroupsMouseMove) then FOnGroupsMouseMove(Sender, Shift, X, Y);
end;

function TsohoCustomTreeView.ItemIsChild(ParentItemIndex, ChildItemIndex: Longint): boolean;
var Tmp: TOutLineNode;
begin
  Result := True;
  if (ParentItemIndex = ChildItemIndex) or (ParentItemIndex = -1) then exit;
  with FGroups do begin
    Tmp := Items[ChildItemIndex];
    while (Tmp.index <> 1) or (Tmp.index <> ParentItemIndex) do Tmp := Tmp.Parent;
    Result := Tmp.index = ParentItemIndex;
  end;
end;

procedure TsohoCustomTreeView.GroupsDragOver(Sender, Source: TObject; X,
    Y: Integer; State: TDragState; var Accept: boolean);
var NowItem: Longint;
begin
  NowItem := FGroups.GetItem(X, Y);
  Accept := ((FMoveGroup.GrpDragSourceRow <> 1) and
    (FMoveGroup.GrpDragSourceRow <> NowItem))
    or FMoveItem.GridDrag;
  FGroups.SelectedItem := NowItem;
  if Assigned(FOnGroupsDragOver) then FOnGroupsDragOver(Sender, Source, X, Y, State, Accept);
end;

procedure TsohoCustomTreeView.GroupsDragDrop(Sender, Source: TObject; X, Y: Integer);
var SelectItm: Longint;
  GroupName                          : string;
  Buttons                            : TMsgDlgButtons;
  ParentIndex, NewHash, RLeft, RRight: Longint;
  BeforeChild, AfterChild, LastChild : Longint;
  ParentId, CurrentId                : Longint;
  Res                                : TModalResult;
begin
  SelectItm := FGroups.SelectedItem;
  if Source is TsohoDBGrid then begin
    FMoveItem.GridDrag := False;
    {     items.db}
    if FItemsTable = '' then begin
      ErrorMsg(Format(sohoTreeCantMoveItem, [Name]));
      exit;
    end;
    {ParentIndex := GetLeafRecord(SelectItm).ItemId;}
    RightHash := MaxLongint;
    with FMoveItem do begin
      NewHash := GetNewItemHash(ParentIndex, FIdGrpField);
      NewGrpId := GetLeafRecord(SelectItm).ItemID;
    end;
    MoveItem;
    exit;
  end;
  GroupName := FGroups.Items[FMoveGroup.GrpDragSourceRow].Text;
  if SelectItm = 1 then Buttons := [mbYes, mbCancel]
  else Buttons := [mbYes, mbNo, mbCancel];
  Res := YesNoCancel(Format(sohoTreeIncludeGroupInto, [GroupName, FGroups.Items[FGroups.SelectedItem].Text]));
  {Res := MessageDlg(, mtConfirmation, Buttons, 0);}
  case Res of
    mrCancel: exit; {  }
    mrYes: begin {  }
      ParentIndex := SelectItm;
      BeforeChild := -1;
      AfterChild := FGroups.Items[ParentIndex].GetLastChild;
    end;
    mrNo: begin { }
      ParentIndex := FGroups.Items[SelectItm].Parent.index;
      BeforeChild := SelectItm;
      AfterChild := FGroups.Items[ParentIndex].GetPrevChild(BeforeChild);
    end;
  end;

  with FGroups do begin
   ParentId := GetLeafRecord(ParentIndex).ItemID;

   if AfterChild = -1 then RLeft := - MaxLongint
   else RLeft := GetLeafRecord(AfterChild).ItemHash;

   if BeforeChild = -1 then RRight := MaxLongint
   else RRight := GetLeafRecord(BeforeChild).ItemHash;
   NewHash := GetHash(RLeft, RRight);

   CurrentId := PTreeLeaf(Items[FMoveGroup.GrpDragSourceRow].Data)^.ItemID;
   if (AfterChild = BeforeChild) or (BeforeChild = -1) then
     Items[FMoveGroup.GrpDragSourceRow].MOVETO(ParentIndex, oaAddChild)
   else
    Items[FMoveGroup.GrpDragSourceRow].MOVETO(BeforeChild, oaInsert);

   Update;
   FullExpand;
   ParentIndex := GetIndexByID(ParentId);
   {      }
   LastChild := GetIndexByID(CurrentId);
   if LastChild < 1 then exit;
   PTreeLeaf(Items[LastChild].Data)^.ItemHash := NewHash;
   PTreeLeaf(Items[LastChild].Data)^.ParentId := ParentId;
  end;
  MoveGroup(ParentId, NewHash, GetLeafRecord(LastChild).ItemID);
  if Assigned(FOnGroupsDragDrop) then FOnGroupsDragDrop(Sender, Source, X, Y);
end;


procedure TsohoCustomTreeView.ItemsGridDragDrop(Sender, Source: TObject; X, Y: Integer);
var Coord: TGridCoord;
  Insert: Word;
begin
  Coord := (Sender as TsohoDBGrid).MouseCoord(X, Y);
  Insert := VK_INSERT;
  GridKeyDown(Sender, Insert,[ssCtrl]);
  FItemsDS.MoveBy(Coord.Y - FMoveItem.GridRow);
  Insert := VK_INSERT;
  GridKeyDown(Sender, Insert,[ssShift]);
  if Assigned(FOnGridDragDrop) then FOnGridDragDrop(Sender, Source, X, Y);
end;

procedure TsohoCustomTreeView.ItemsGridMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  if Shift = [ssLeft, ssCtrl] then begin
    FGrid.BeginDrag(False);
    if not FMoveItem.GridDrag then begin
      FMoveItem.GridDrag := True;
      FMoveItem.GridRow := 1 + (Sender as TsohoDBGrid).GetActiveRow;
      FMoveItem.ID := FItemsDS.FieldByName(FKeyField).AsInteger;
      FReport.Caption := IntToStr(FMoveItem.ID);
    end;
  end;
  if Assigned(FOnGridMouseMove) then FOnGridMouseMove(Sender, Shift, X, Y);
end;

procedure TsohoCustomTreeView.ItemsGridDragOver(Sender, Source: TObject; X, Y: Integer;
    State: TDragState; var Accept: boolean);
var Coord: TGridCoord;
begin
  Coord := (Sender as TsohoDBGrid).MouseCoord(X, Y);
  Accept := (Source is TsohoDBGrid) and (FMoveItem.GridRow <> Coord.Y);
  if Assigned(FOnGridDragOver) then
    FOnGridDragOver(Sender, Source, X, Y, State, Accept);
end;

procedure TsohoCustomTreeView.ItemsGridMouseDown(Sender: TObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(FOnGridMouseDown) then
    FOnGridMouseDown(Sender, Button, Shift, X, Y);
end;

procedure TsohoCustomTreeView.ReDrawTreeView;
begin
  FGroups.Height := Height;
  FGroups.Width := FOutLinePanel.Width;
end;

end.

