{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{              Written by Allex, VSM                    }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
     TsohoCustomRegister  TsohoSubRegister
}
unit SoCtmRgs;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     ExtCtrls, Menus, IniFiles, SoUnit, StdCtrls, SohoProt, Forms;

type

  {    OnNewUserBox. BoxName -      }
  TsohoNewUserBoxCreated = procedure (Sender: TObject; BoxName: string) of object;

  {   TsohoCustomRegister:        
     }
  TsohoRegisterActivate = (raFormShow, raFormCreate);

  TsohoCustomRegister = class(TComponent)
  private
    { Private declarations }
    FPanel: TPanel;
    FTrial: Longint;
    FPassword: boolean;
    FOnFormShow: TNotifyEvent; { .   
                                     }
    FProtectLevel: Longint; {   }
    FProtectInterval: Longint; {,     .
                                      ,     }

    FSohoProt1: TSohoProtect; {     }
    FOnActivate: TNotifyEvent;
    FOnNewUserBox: TsohoNewUserBoxCreated;
    FWindowHandle: HWND;
    Timer: TTimer;
    Cancelled: boolean;
    SavedWindowHandle: Longint;
    FActivateOn: TsohoRegisterActivate;
    {        
            }
    function GetActionRightsAsString: string;
    function GetDataReadRightsAsString: string;
    function GetDataWriteRightsAsString: string;
    procedure SetActionRightsAsString(aValue: string);
    procedure SetDataReadRightsAsString(aValue: string);
    procedure SetDataWriteRightsAsString(aValue: string);

    {       }
    procedure SetProtectLevel(aValue: Longint);
    procedure SetProtectInterval(aValue: Longint);
    procedure SetPasswordRequired(aValue: boolean);

    { -   }
    procedure FormShow(Sender: TObject);
    procedure Loaded; override;
    procedure WNDPROC(var message: TMessage);
  protected

    {   }
    procedure DefineProgramPath;
    procedure DefineDataPath;virtual;
    procedure DefineTempPath;
    procedure DefineHomePath;
    procedure DefineSQLPath;
    procedure DefineReportsPath;
    procedure DefineImagesPath;
    procedure DefineScriptsPath;

    function MonitorExists: boolean;
    procedure DoRegisterTimer(Sender: TObject);
    procedure SMAnswer(var message: TMessage); virtual;
    procedure SMKill(var message: TMessage); virtual;

    procedure DoActivate; virtual;
    procedure DoNewUserBox; virtual;
    {     }
    procedure ShowUserList; virtual; abstract;
    {         }
    function ShowPasswordDialog: boolean;virtual; abstract;
    {    }
    procedure ChangePassword;virtual; abstract;

    {    ,   TsohoCustomRegister    }
    property WindowHandle: HWND read FWindowHandle;

  public
    {  ? }
    Answer: boolean;
    {  ,       }
    MonitorFileName: string;
    {       -     }
    PathToData: string;
    {     .    }
    DataName: string;
    { ,     }
    PathToProgram: string;
    {     .    - 
           -    
          }
    ProgramName: string;
    {      }
    PathToTemp: string;
    {   -    -    
       .  TsohoFolder }
    PathToHome: string;
    {      }
    PathToSQL: string;
    {     .     XLS. * Delphi 3* }
    PathToReports: string;
    {          .. }
    PathToImages: string;
    {     }
    PathToScripts: string;
    {   .    , 
       PathToUsers = PathToHome.       
        }
    PathToUsers: string;

    {   -  }
    IniFileName: string;
    {   }
    UserName: string;
    {    }
    ShortName: string;
    {   -   TsohoFolder    }
    UserID: Longint;
    {       }
    DataLevel: Longint;
    {    -  ,   TAG    }
    ActionRights: SetOfByte;
    {    .  TAG    TDataSet }
    DataReadRights: SetOfByte;
    {   (.. ) .  TAG    TDataSet
           TsohoFolder,  
         TsohoCustomRegister.     
         " "       
        .    ,     }
    DataWriteRights: SetOfByte;

    {     ,  SohoMon }
    function ReadString(const Section, Ident, Value: string): string;
    {     ,  SohoMon }
    function WriteString(const Section, Ident, Value: string): boolean;

    { Testing process }
    function GetMonitorWindow: Longint;

    {  TsohoCustomRegister -  ,     }
    procedure Activate;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    {       }
    property UserActionRights: string read GetActionRightsAsString write SetActionRightsAsString;
    {         }
    property UserDataReadRights: string read GetDataReadRightsAsString write SetDataReadRightsAsString;
    {         }
    property UserDataWriteRights: string read GetDataWriteRightsAsString write SetDataWriteRightsAsString;
    {     SohoMon }
    property DesignedProgramName: string read ProgramName write ProgramName;
    {         ? }
    property PasswordRequired: boolean read FPassword write SetPasswordRequired default False;
    {    .  TsohoProtect }
    property ProtectionInterval: Longint read FProtectInterval write SetProtectInterval default 0;
    {   .  TsohoProtect }
    property ProtectionLevel: Longint read FProtectLevel write SetProtectLevel default 0;
    {   .  TsohoProtect }
    property Trial: Longint read FTrial write FTrial;
    property Panel: TPanel read FPanel write FPanel;
    {  :   ,     }
    property ActivateOn: TsohoRegisterActivate read FActivateOn write FActivateOn default raFormShow;
    {     TsohoCustomRegister }
    property OnActivate: TNotifyEvent read FOnActivate write FOnActivate;
    {         }
    property OnNewUserBox: TsohoNewUserBoxCreated read FOnNewUserBox write FOnNewUserBox;
  end;

  { -      
    TsohoCustomRegister }
  TsohoSubRegister = class(TComponent)
  private
    FActivateOn: TsohoRegisterActivate;
    FOnActivate: TNotifyEvent;
    FOnFormShow: TNotifyEvent;
  protected
    procedure FormShow(Sender: TObject);
    procedure Loaded; override;
  public
    {   }
    procedure Activate; virtual;
    constructor Create(AOwner: TComponent); override;
    {  TsohoCustomRegister }
    function PathToData: string;
    {  TsohoCustomRegister }
    function DataName: string;
    {  TsohoCustomRegister }
    function PathToProgram: string;
    {  TsohoCustomRegister }
    function ProgramName: string;
    {  TsohoCustomRegister }
    function PathToTemp: string;
    {  TsohoCustomRegister }
    function PathToHome: string;
    {  TsohoCustomRegister }
    function PathToSQL: string;
    {  TsohoCustomRegister }
    function PathToReports: string;
    {  TsohoCustomRegister }
    function PathToImages: string;
    {  TsohoCustomRegister }
    function PathToUsers: string;
    {  TsohoCustomRegister }
    function IniFileName: string;
    {  TsohoCustomRegister }
    function UserName: string;
    {  TsohoCustomRegister }
    function ShortName: string;
    {  TsohoCustomRegister }
    function UserID: Longint;
    {  TsohoCustomRegister }
    function DataLevel: Longint;
    {  TsohoCustomRegister }
    function ActionRights: SetOfByte;
    {  TsohoCustomRegister }
    function DataReadRights: SetOfByte;
    {  TsohoCustomRegister }
    function DataWriteRights: SetOfByte;
  published
    {  TsohoCustomRegister }
    property ActivateOn: TsohoRegisterActivate read FActivateOn write FActivateOn default raFormShow;
    {  TsohoCustomRegister }
    property OnActivate: TNotifyEvent read FOnActivate write FOnActivate;
  end;

{      TsohoCustomRegister }
function FindSohoRegister: TsohoCustomRegister;

var
   {     TsohoCustomRegister   }
   SingleRegister: TsohoCustomRegister;

implementation
uses SoUtils, FileCtrl, SoDBCns;

procedure TsohoCustomRegister.DoActivate;
begin
  if Assigned(FOnActivate) then FOnActivate(Self);
end;

procedure TsohoCustomRegister.DoNewUserBox;
begin
 if Assigned(FOnNewUserBox) then FOnNewUserBox(Self, PathToHome + '\');
end;

function TsohoCustomRegister.ReadString(const Section, Ident, Value: string): string;
var Ini: TIniFile;
begin
  try
    Ini := TIniFile.Create(MonitorFileName);
    Result := Ini.ReadString(Section, Ident, Value);
    Ini.Free;
  except
    Result := Value;
  end;
end;

function TsohoCustomRegister.WriteString(const Section, Ident, Value: string): boolean;
var Ini: TIniFile;
begin
  try
    Ini := TIniFile.Create(MonitorFileName);
    Ini.WriteString(Section, Ident, Value);
    Ini.Free;
    Result := True;
  except
    Result := False;
  end;
end;

function FindSohoRegister: TsohoCustomRegister;
begin
  Result := SingleRegister;
end;

const Debug = False;
  
procedure TsohoCustomRegister.SetProtectLevel(aValue: Longint);
begin
  if aValue < 0 then aValue := 0;
  if aValue > 6 then aValue := 6; {   }
  FProtectLevel := aValue;
end;

procedure TsohoCustomRegister.SetPasswordRequired(aValue: boolean);
begin
  FPassword := aValue;
end;

procedure TsohoCustomRegister.SetProtectInterval(aValue: Longint);
begin
  if aValue > 3600 then aValue := 3600; {60  -   }
  FProtectInterval := aValue;
end;

procedure TsohoCustomRegister.Loaded;
var Form: TForm;
begin
  inherited Loaded;
  if not (csDesigning in ComponentState) then begin
    Form := GetOwnerForm(Self);
    if Form <> nil then begin
      if FActivateOn = raFormShow then begin
        FOnFormShow := Form.OnShow;
        Form.OnShow := FormShow;
      end
      else begin
        FOnFormShow := Form.OnCreate;
        Form.OnCreate := FormShow;
      end;
    end;
  end;
end;

constructor TsohoCustomRegister.Create;
begin
  if SingleRegister <> nil then raise
    Exception.Create(sohoRegisterOnlySingleRegister);
  inherited Create(AOwner);
  FTrial := 0;
  FPassword := False;
  FProtectLevel := 0;
  FProtectInterval := 0;
  FSohoProt1 := nil;
  FActivateOn := raFormShow;
  {        ! }
  SingleRegister := Self;
  ActionRights := [0..255];
  DataReadRights := [0..255];
  DataWriteRights := [0..255];
  
  if not (csDesigning in ComponentState) then begin
    FWindowHandle := AllocateHWnd(WNDPROC);
    DefineProgramPath; {,   }
    DefineDataPath; {,   }
    DefineTempPath; {  }
    DefineSQLPath; {     }
    DefineReportsPath;
    DefineImagesPath;
    DefineScriptsPath;
  end;
end;

procedure TsohoCustomRegister.WNDPROC(var message: TMessage);
begin
  with message do
    case Msg of
      SM_ANSWER: SMAnswer(message);
      SM_KILL: SMKill(message);
    else Result := DefWindowProc(FWindowHandle, Msg, WPARAM, LPARAM);
    end;
end;

destructor TsohoCustomRegister.Destroy;
begin
  if not (csDesigning in ComponentState) then DeallocateHWnd(FWindowHandle);
  SendMessage(GetMonitorWindow, SM_Unregister, SavedWindowHandle, 0);
  { ,    ...}
  if FSohoProt1 <> nil then FSohoProt1.Free;
  SingleRegister := nil;
  inherited Destroy;
end;

{Monitor section start}
function TsohoCustomRegister.GetMonitorWindow: Longint;
var Ini: TIniFile;
begin
  {      -   }
  Ini := TIniFile.Create('Win.ini');
  Result := Ini.ReadInteger('SOHO', 'MonitorWindow', HWND_BROADCAST);
  Ini.Free;
end;

procedure TsohoCustomRegister.SMKill(var message: TMessage);
var Form: TForm; I {,j}: Longint;
begin
  if (message.LPARAM = 99) or (message.LPARAM = 666) then begin
    Application.Terminate;
    Application.ProcessMessages;
  end else begin
    Form := Application.MainForm;
    ApplyActionRights(Form, ActionRights);
    with Application.MainForm do for I := 0 to ComponentCount - 1 do
        if Components[I] is TForm then begin
          Form := TForm(Components[I]);
          ApplyActionRights(Form, ActionRights);
          Form.Refresh;
        end;
    {       
               TSohoFolder
      SohoFolder     }
  end;
end;

procedure TsohoCustomRegister.SMAnswer(var message: TMessage); {- -  }
var
  Category, Number: byte;  
  Data            : Word;  
  ws              : string;
begin
  DecodeData(message.LPARAM, Data, Category, Number);
  case Category of
    ccUserID: {     }
      case Number of
        0: if Data = 65535 then Self.UserID := 0;
        1: Self.UserID := Self.UserID + Data;
        2: Self.UserID := Self.UserID + Longint(Data) shl 16;
      end;
    ccUserName: { }
      if (Number = 0) and (Data = 65535) then Self.UserName := '' else begin
        ws := Self.UserName;
        AppendCharToString(Chr(Data), Number, ws);
        Self.UserName := ws;
      end;
    ccUserShortName: {  }
      if (Number = 0) and (Data = 65535) then Self.ShortName := '' else begin
        ws := Self.ShortName;
        AppendCharToString(Chr(Data), Number, ws);
        Self.ShortName := ws;
      end;
    ccDataLevel: {   ( )}
      if (Number = 0) and (Data = 65535)
        then Self.DataLevel := 0
      else Self.DataLevel := Data;
    ccUserAction: {  }
      if (Number = 0) and (Data = 65535)
        then Self.ActionRights := [0]
      else Self.ActionRights := Self.ActionRights + [Data];
    ccUserRead: {   }
      if (Number = 0) and (Data = 65535)
        then Self.DataReadRights := [0]
      else Self.DataReadRights := Self.DataReadRights + [Data];
    ccUserWrite: {   }
      if (Number = 0) and (Data = 65535)
        then Self.DataWriteRights := [0]
      else Self.DataWriteRights := Self.DataWriteRights + [Data];
    ccManagerFileName:
      if (Number = 0) and (Data = 65535)
        then Self.MonitorFileName := 'soho.ini'  // 9.01.99 #&Allex
      else begin
        ws := Self.MonitorFileName;
        AppendCharToString(Chr(Data), Number, ws);
        Self.MonitorFileName := ws;
      end;
      
    ccManagerReady: begin
      {Manager:=Message.wParam;}
      {  if Timer<>nil then Timer.Free;Timer:=nil; -  MonitorExists}
      Cancelled := True; { }
      Answer := True; {    }
      if Self.DesignedProgramName = '' then Self.DesignedProgramName := 'UNKNOWN';
      for Number := 1 to Length(Self.DesignedProgramName) do
        SendMessage(message.WPARAM, SM_REQUEST, WindowHandle,
        EncodeData(Ord(Self.DesignedProgramName[Number]), ccApplicationName, Number));
      SendMessage(message.WPARAM, SM_REQUEST, WindowHandle, EncodeData(0, ccReadyForReceive, 0));
    end;
  end;
end;

procedure TsohoCustomRegister.DoRegisterTimer(Sender: TObject);
begin
  Timer.Enabled := False; {Lock timer ticks}
  Cancelled := True; {Cancel "Waiting for ..." }
end;

function TsohoCustomRegister.MonitorExists: boolean;
begin
  {   SOHOMonitor,      
     ,  -  }
  {    500 }
  Timer := TTimer.Create(Self);
  with Timer do begin
    OnTimer := DoRegisterTimer;
    Interval := 500;
    Enabled := True;
  end;
  Cancelled := False;
  Answer := False;
  SavedWindowHandle := WindowHandle; {   DESTROY}
  Self.UserID := 0;
  SendMessage(GetMonitorWindow, SM_AREYOUHERE, WindowHandle, 0); { SOHO Monitor}
  while not Cancelled do Application.ProcessMessages;
  Timer.Free; {,     -    }
  Result := Answer;
end;

procedure TsohoCustomRegister.Activate; {  ,    }
var MainMenu: TMainMenu;
  Form  : TForm;  
  index : Longint;
  TmpDir: string; 
  Valid : boolean;
begin
  {   }
  FSohoProt1 := TSohoProtect.Create(Self);
  FSohoProt1.Trial := FTrial; { }
  with FSohoProt1 do begin
    CheckInterval := FProtectInterval;
    ValidLevel := FProtectLevel;
    Enabled := True;
  end;
  
  Valid := True;
  if PasswordRequired then
    {  .  ,  
            ,  - 
       ,      }
    if not MonitorExists then begin
      {-      ,  "" }
      GetDir(0, TmpDir);
      Valid := ShowPasswordDialog;
      ChDir(TmpDir);
    end; {Password required}
  if Valid then begin
    DefineHomePath; {  }

    Form := GetOwnerForm(Self);
    if Form <> nil then
      with Form do begin
        {         }
        MainMenu := nil;
        for index := 0 to pred(ComponentCount) do
          if Components[index] is TMainMenu then MainMenu := TMainMenu(Components[index]);
        if Assigned(MainMenu) then AppendMenu(MainMenu, PathToProgram + IniFileName);
        ApplyActionRights(Form, ActionRights);
      end;
    DoActivate;
  end
  else Application.Terminate;
end;

procedure TsohoCustomRegister.DefineScriptsPath;
begin
  PathToScripts := PathToProgram + 'Scripts\' + DefaultName+'\';
  // PathToScripts := Copy(PathToScripts, 1, Length(PathToScripts) - 1) + '\';
end;

procedure TsohoCustomRegister.DefineImagesPath;
begin
  PathToImages := PathToProgram + 'Images\' + DefaultName+'\';
  // PathToImages := Copy(PathToImages, 1, Length(PathToImages) - 1) + '\';
end;

procedure TsohoCustomRegister.DefineReportsPath;
begin
  PathToReports := PathToProgram + 'Reports\' + DefaultName+'\';
  // PathToReports := Copy(PathToReports, 1, Length(PathToReports) - 1) + '\';
end;

procedure TsohoCustomRegister.DefineSQLPath;
begin
  PathToSQL := PathToProgram + 'SQL\' + DefaultName+'\';
  // PathToSQL := Copy(PathToSQL, 1, Length(PathToSQL) - 1) + '\';
end;

procedure TsohoCustomRegister.DefineDataPath;
var S: string;
begin
  { Paramstr(1)     }
  if ParamStr(1) <> '' then begin
    S := ParamStr(1); {ExtractFile ...}
    if not DirectoryExists(S) then ErrorMsg(Format(sohoRegisterPathDontExists, [S]));
    PathToData := S;
  end
  else begin
    PathToData := PathToProgram;
    DataName := DefaultName;
  end;
  { -      '\',     }
  PathToData := NormalDir(PathToData);
  // if PathToData[Length(PathToData)] <> '\' then PathToData := PathToData + '\';
end;


procedure TsohoCustomRegister.DefineProgramPath;
begin
  PathToProgram := ParamStr(0);
  PathToProgram := ExtractFilePath(PathToProgram);
  IniFileName := DefaultName + '.ini';
end;

procedure TsohoCustomRegister.DefineTempPath;
begin
  PathToTemp := GetEnvVar('temp');
  PathToTemp := NormalDir(PathToTemp);
  //if PathToTemp[Length(PathToTemp)] <> '\' then PathToTemp := PathToTemp + '\';
  PathToTemp := ExtractFilePath(PathToTemp); { -   }
end;

procedure TsohoCustomRegister.DefineHomePath;
var FindFile: TSearchRec;
begin
  GetDir(0, PathToHome);
  PathToHome := NormalDir(PathToHome);
  PathToUsers := PathToHome;
  // if PathToUsers[Length(PathToUsers)] <> '\' then PathToUsers := PathToUsers + '\';
  if ShortName <> '' then PathToHome := PathToHome + ShortName;
  {      HomePath    }
  // if PathToHome[Length(PathToHome)] <> '\' then PathToHome := PathToHome + '\';
  PathToHome := PathToHome + '\'+DefaultName;
  // PathToHome := Copy(PathToHome, 1, Length(PathToHome) - 1);
  {      .    ... }
  if FindFirst(PathToHome, faDirectory, FindFile) <> 0 then begin
    MakeDirectory(PathToHome); { Allex }
    DoNewUserBox;
  end;
  // PathToHome := PathToHome + '\';
end;

{$i-}

function TsohoCustomRegister.GetActionRightsAsString: string;
begin
  Result := SetToStr(ActionRights);
end;

procedure TsohoCustomRegister.SetActionRightsAsString(aValue: string);
begin
  ActionRights := StrToSet(aValue);
end;

function TsohoCustomRegister.GetDataReadRightsAsString: string;
begin
  Result := SetToStr(DataReadRights);
end;

procedure TsohoCustomRegister.SetDataReadRightsAsString(aValue: string);
begin
  DataReadRights := StrToSet(aValue);
end;

function TsohoCustomRegister.GetDataWriteRightsAsString: string;
begin
  Result := SetToStr(DataWriteRights);
end;

procedure TsohoCustomRegister.SetDataWriteRightsAsString(aValue: string);
begin
  DataWriteRights := StrToSet(aValue);
end;

procedure TsohoCustomRegister.FormShow(Sender: TObject);
var Form: TForm;
begin
  Activate;
  if (csDesigning in ComponentState) then exit;
  Form := GetOwnerForm(Self);
  {       ,  
         }
  if Form <> nil then begin
    if FActivateOn = raFormShow then Form.OnShow := FOnFormShow
    else Form.OnCreate := FOnFormShow;
    if Assigned(FOnFormShow) then FOnFormShow(Sender);
  end;
end;

{ TsohoSubRegister }
procedure TsohoSubRegister.FormShow(Sender: TObject);
var Form: TForm;
begin
  if SingleRegister = nil then exit;
  Activate;
  Form := GetOwnerForm(Self);
  {       ,  
         }
  if Form <> nil then begin
    if FActivateOn = raFormShow then Form.OnShow := FOnFormShow
    else Form.OnCreate := FOnFormShow;
    if Assigned(FOnFormShow) then FOnFormShow(Sender);
  end;
end;

procedure TsohoSubRegister.Activate;
var Form: TForm;
begin
  Form := GetOwnerForm(Self);
  if Form <> nil then ApplyActionRights(Form, ActionRights);
  if Assigned(FOnActivate) then FOnActivate(Self);
end;

procedure TsohoSubRegister.Loaded;
var Form: TForm;
begin
  inherited Loaded;
  if not (csDesigning in ComponentState) then begin
    Form := GetOwnerForm(Self);
    if Form <> nil then begin
      if FActivateOn = raFormShow then begin
        FOnFormShow := Form.OnShow;
        Form.OnShow := FormShow;
      end
      else begin
        FOnFormShow := Form.OnCreate;
        Form.OnCreate := FormShow;
      end;
    end;
  end;
end;

constructor TsohoSubRegister.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FActivateOn := raFormShow;
end;

function TsohoSubRegister.PathToData: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.PathToData;
end;

function TsohoSubRegister.DataName: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.DataName;
end;

function TsohoSubRegister.PathToProgram: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.PathToProgram;
end;

function TsohoSubRegister.ProgramName: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.ProgramName;
end;

function TsohoSubRegister.PathToTemp: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.PathToTemp;
end;

function TsohoSubRegister.PathToHome: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.PathToHome;
end;

function TsohoSubRegister.IniFileName: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.IniFileName;
end;

function TsohoSubRegister.UserName: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.UserName;
end;

function TsohoSubRegister.ShortName: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.ShortName;
end;

function TsohoSubRegister.UserID: Longint;
begin
  Result := -1;
  if SingleRegister = nil then exit;
  Result := SingleRegister.UserID;
end;

function TsohoSubRegister.DataLevel: Longint;
begin
  Result := -1;
  if SingleRegister = nil then exit;
  Result := SingleRegister.DataLevel;
end;


function TsohoSubRegister.ActionRights: SetOfByte;
begin
  Result := [0..255];
  if SingleRegister = nil then exit;
  Result := SingleRegister.ActionRights;
end;

function TsohoSubRegister.DataReadRights: SetOfByte;
begin
  Result := [0..255];
  if SingleRegister = nil then exit;
  Result := SingleRegister.DataReadRights;
end;

function TsohoSubRegister.DataWriteRights: SetOfByte;
begin
  Result := [0..255];
  if SingleRegister = nil then exit;
  Result := SingleRegister.DataWriteRights;
end;

function TsohoSubRegister.PathToSQL: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.PathToSQL;
end;

function TsohoSubRegister.PathToReports: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.PathToReports;
end;

function TsohoSubRegister.PathToImages: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.PathToImages;
end;

function TsohoSubRegister.PathToUsers: string;
begin
  Result := '';
  if SingleRegister = nil then exit;
  Result := SingleRegister.PathToUsers;
end;
 begin
  SingleRegister := nil;
end.

