{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoCtmRec;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Controls,
     Forms, DB, SoNwRcF, ExtCtrls, SoCtmFld, Graphics;

type

  {    BeforeSQL, AfterSQL.    ,
        -      }
  TsohoOnSQLGenerate = procedure (Sender: TObject; SQL: TStringList) of object;

  {    OnAddField. FieldName -  , FieldLabel - 
        ,     DisplayLabel, Complex - ,
      - ,     - LongInt,    
      . ,     ,
           -    
      .    -  
     OnGetTextForField. Allow -       ? }
  TsohoOnAddField = procedure (Sender: TObject; FieldName: string;
    var FieldLabel: string; var Complex, Allow: Boolean) of object;
  
  {    OnAddFieldToSQL. Allow -      ? }
  TsohoOnAddFieldToSQL = procedure (Sender: TObject; FieldName: string;
    var Allow: Boolean) of object;

  {    OnGetValue.     SQL      Value }
  TsohoOnGetValue = procedure (Sender: TObject; FieldName: string; var Value: string) of object;

  {    OnGetComplexValue.      ""  
    -    , ,    }
  TsohoOnGetComplexValue = procedure (Sender: TObject; FieldName: string; var Value: Longint) of object;

  {    OnGetTextForField.    (FieldText) 
    "" ,     (FieldValue) }
  TsohoOnGetTextForField = procedure (Sender: TObject; const FieldName: string;
    var FieldText: string; FieldValue: Longint) of object;

  {  :  ,   ,  
     }
  TsohoRecordMode = (rmNone, rmInsert, rmEdit);

  EsohoRecordError = class(Exception);

  TsohoCustomRecordForm = class(TComponent)
  private
    FFolder: TsohoCustomFolder;
    FTableName: TFileName;
    FDialog: TsohoNewRecordForm;

    FHideFields: TStringList;
    FComplexFields: TStringList;
    FComplexLabels: TStringList;
    FSQLHideFields: TStringList;

    FBeforeSQLGen,
      FAfterSQLGen: TsohoOnSQLGenerate;
    FOnAddField: TsohoOnAddField;
    FOnAddFieldToSQL: TsohoOnAddFieldToSQL;
    FOnGetValue: TsohoOnGetValue;
    FOnGetTextForField: TsohoOnGetTextForField;
    FOnGetComplexValue: TsohoOnGetComplexValue;
    FOnCardCreate,
      FOnCardDestroy,
      FOnCardSave,
      FOnCardLoad: TNotifyEvent;

    FCaption: TCaption;
    FMode: TsohoRecordMode;
    FKeyField: string;
    FAfterExec: TNotifyEvent;
    FPanel: TPanel;

    FFocusField: string;
    FNewId: Longint;

    procedure SetFolder(Value: TsohoCustomFolder);
    procedure DoComplexClick(Sender: TObject);
    procedure SetHideFields(Value: TStringList);
    procedure SetSQLHideFields(Value: TStringList);
    procedure SetComplexFields(Value: TStringList);
    procedure SetComplexLabels(Value: TStringList);
  protected
    procedure GetTextForField(const FieldName: string; var FieldText: string; FieldValue: Longint);
    function GetStringByIndex(index: Integer): string;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    function GenerateInsertSQL: Boolean; virtual;
    function GenerateUpdateSQL: Boolean; virtual;
    procedure PrepareCard; virtual;
    procedure SaveToFolder; virtual;
    procedure LoadFromFolder; virtual;
    procedure LoadFieldsListFromFolder; virtual;
    function  RunUpdateSQL (SQLText : TStringList) : boolean;virtual; abstract;
    function  RunInsertSQL (SQLText : TStringList) : boolean;virtual; abstract;
    procedure DoAfterSQLExecute;
    {  ,     ,    ModalResult?!}
    property Panel: TPanel read FPanel write FPanel;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {       }
    function Insert: Boolean;
    {       }
    function Edit: Boolean;
    {   -      
      Insert, Edit }
    procedure Close;
    {        }
    function ValueByName(FieldName: string): string;
    {           SQL.
      Index -      DataSet.  
         }
    function GetSQLValue(Value: string; index: Integer): string;
    {         }
    property Values[index: Integer]: string read GetStringByIndex;
    {     }
    property DialogForm: TsohoNewRecordForm read FDialog;
    {    -   Close,    rmNone }
    property Mode: TsohoRecordMode read FMode;
    {      KeyField     }
    property NewId: Longint read FNewId;
  published
    {         }
    property FocusField: string read FFocusField write FFocusField;

    {   DataSet   TosohoFolder }
    property Folder: TsohoCustomFolder read FFolder write SetFolder;
    {   .    Insert  Update  }
    property TableName: TFileName read FTableName write FTableName;
    {   }
    property Caption: TCaption read FCaption write FCaption;
    { ,     -  'Id' }
    property KeyField: string read FKeyField write FKeyField;

    {  ,      .  
        -  OnAddField }
    property HideFields: TStringList read FHideFields write SetHideFields;
    {  ,      SQL-.  
        -  OnAddField }
    property SQLHideFields: TStringList read FSQLHideFields write SetSQLHideFields;
    {  "" .      -  OnAddField }
    property ComplexFields: TStringList read FComplexFields write SetComplexFields;
    {  ,      " ".
             -  OnAddField }
    property ComplexLabels: TStringList read FComplexLabels write SetComplexLabels;

    {  ,       
      "" .     - 
       ,     }
    property OnGetTextForField: TsohoOnGetTextForField read FOnGetTextForField write FOnGetTextForField;
    {  ,       "" .
            , , 
          }
    property OnGetComplexValue: TsohoOnGetComplexValue read FOnGetComplexValue write FOnGetComplexValue;
    {     SQL.   , 
          - ,   
         }
    property BeforeSQL: TsohoOnSQLGenerate read FBeforeSQLGen write FBeforeSQLGen;
    {     SQL.       SQL-? }
    property AfterSQL: TsohoOnSQLGenerate read FAfterSQLGen write FAfterSQLGen;
    {     .     
         ,      
       .       OnGetValue,
           ""  }
    property OnAddField: TsohoOnAddField read FOnAddField write FOnAddField;
    {       SQL-.     
      DataSet   ,      }
    property OnAddFieldToSQL: TsohoOnAddFieldToSQL read FOnAddFieldToSQL write FOnAddFieldToSQL;
    {     SQL.     
         }
    property OnGetValue: TsohoOnGetValue read FOnGetValue write FOnGetValue;
    {          }
    property AfterSQLExecute: TNotifyEvent read FAfterExec write FAfterExec;
    
    {         }
    property OnCardCreate: TNotifyEvent read FOnCardCreate write FOnCardCreate;
    {     }
    property OnCardDestroy: TNotifyEvent read FOnCardDestroy write FOnCardDestroy;
    {       ini- }
    property OnCardSave: TNotifyEvent read FOnCardSave write FOnCardSave;
    {       ini- }
    property OnCardLoad: TNotifyEvent read FOnCardLoad write FOnCardLoad;
  end;

implementation
uses SoUnit, SoUtils, ToolEdit, SoCtrls, StdCtrls, SoDate, SohoBtns;

const
  CorrectFieldsType : set of TFieldType = [
    ftString, ftSmallint, ftInteger, ftWord, ftFloat, ftCurrency, ftBoolean,
    ftDate, ftTime, ftDateTime
  ];

procedure TsohoCustomRecordForm.DoAfterSQLExecute;
begin
 if Assigned(FAfterExec) then FAfterExec(Self);
end;

procedure TsohoCustomRecordForm.SetSQLHideFields(Value: TStringList);
begin
  FSQLHideFields.Assign(Value);
end;

procedure TsohoCustomRecordForm.SetHideFields(Value: TStringList);
begin
  FHideFields.Assign(Value);
end;

procedure TsohoCustomRecordForm.SetComplexFields(Value: TStringList);
begin
  FComplexFields.Assign(Value);
end;

procedure TsohoCustomRecordForm.SetComplexLabels(Value: TStringList);
begin
  FComplexLabels.Assign(Value);
end;

procedure TsohoCustomRecordForm.SetFolder(Value: TsohoCustomFolder);
begin
  if FFolder = Value then exit;
  FFolder := Value;
end;

procedure TsohoCustomRecordForm.LoadFieldsListFromFolder;
var OneField, FolderFields : string;
    Index : LongInt;
begin
  if FFolder = nil then exit;
  SetDivisers([',']);
  with FFolder.Ini do begin
    FolderFields := ReadString('CardFields','HideFields','');
    if FolderFields <> '' then begin
      for Index := 1 to WordsInString(FolderFields) do begin
        OneField := AnsiUpperCase(GetSomeWords(FolderFields, Index,Index));
        if FHideFields.IndexOf(OneField)=-1 then FHideFields.Add(OneField)
      end;
    end;
    FolderFields := ReadString('CardFields','SQLHideFields','');
    if FolderFields <> '' then begin
      for Index := 1 to WordsInString(FolderFields) do begin
        OneField := AnsiUpperCase(GetSomeWords(FolderFields, Index,Index));
        if FSQLHideFields.IndexOf(OneField)=-1 then FSQLHideFields.Add(OneField)
      end;
    end;
  end;
end;

procedure TsohoCustomRecordForm.DoComplexClick(Sender: TObject);
var index: Longint;
  Value               : Longint;    
  CNTRL               : TWinControl;
  FieldName, FieldText: string;     
begin
  with FDialog do begin
    for index := 0 to pred(Fields.Strings.Count) do begin
      CNTRL := GetControlByIndex(index);
      if CNTRL = Sender then begin
        if Assigned(FOnGetComplexValue) then begin
          Value := TsohoEdit(CNTRL).Tag;
          FieldName := StrUpper(FFolder.DataSet.Fields[index].FieldName);
          FOnGetComplexValue(Self, FieldName, Value);
          {       
                     }
          if Value <> TsohoEdit(CNTRL).Tag then begin
            GetTextForField(FieldName, FieldText, Value);
            with TsohoEdit(CNTRL) do begin
              Tag := Value;
              Text := FieldText;
            end;
          end;
        end;
        exit;
      end;
    end;
  end;
end;

function TsohoCustomRecordForm.GetSQLValue(Value: string; index: Integer): string;
var DblTmp: Double;
  DateTmp: TDateTime;
  Error  : Boolean;  
begin
  if FFolder.DataSet = nil then begin
    ErrorMsg(FFolder.name + ':   Grid.DataSource.DataSet!');
    exit;
  end;
  if (FDialog = nil) or not (FFolder.DataSet.Active) then exit;
  case FFolder.DataSet.Fields[index].DataType of
    ftString: Result := '"' + Value + '"';
      ftSmallint,
        ftInteger,
        ftWord: begin
          Result := Value;
          if Result = '' then Result := '0';
        end;
      ftFloat,
        ftCurrency: begin
          DblTmp := WStrToFloat(Value, Error);
          Result := SoUtils.FloatToSQLFloat(DblTmp);
        end;
    ftBoolean: Result := '"' + Value + '"';
    ftDate, ftDateTime: begin
      DateTmp := WStrToDate(Value);
      Result := SoDate.DateToSQLDate(DateTmp);
    end;
    ftTime: Result := '"' + Value + '"';
  end;
end;

function TsohoCustomRecordForm.ValueByName(FieldName: string): string;
var Field: TField;
begin
  Result := '';
  if FFolder.DataSet = nil then begin
    ErrorMsg(FFolder.name + ':   Grid.DataSource.DataSet!');
    exit;
  end;
  if (FDialog = nil) or not (FFolder.DataSet.Active) then exit;
  Field := FFolder.DataSet.FindField(FieldName);
  if Field = nil then exit;
  Result := FDialog.GetStrValueByIndex(Field.index);
end;

function TsohoCustomRecordForm.GetStringByIndex(index: Integer): string;
begin
  Result := '';
  if FFolder.DataSet = nil then begin
    ErrorMsg(FFolder.name + ':   Grid.DataSource.DataSet!');
    exit;
  end;
  if (FDialog = nil) or not (FFolder.DataSet.Active) then exit;
  Result := FDialog.GetStrValueByIndex(index);
end;

procedure TsohoCustomRecordForm.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (AComponent = FFolder) and (Operation = opRemove) then begin
    if FDialog <> nil then FDialog.Free;
    FFolder := nil;
  end;
  inherited Notification(AComponent, Operation);
end;

function TsohoCustomRecordForm.GenerateUpdateSQL: Boolean;
var SQL : TStringList;
  index           : Integer;
  FieldName, Value: string;
  SQLValue        : string;
  Field           : TField;

  procedure InsertField(index: Integer);
  var Allow: Boolean;
    FieldControl: TWinControl;
  begin
    Allow := True;
    if (FSQLHideFields.IndexOf(FieldName) <> -1) or
       not (FFolder.DataSet.Fields[index].DataType in CorrectFieldsType)  then exit
    else if Assigned(FOnAddFieldToSQL) then FOnAddFieldToSQL(Self, FieldName, Allow);
    if Allow then begin
      {        Text,
               Tag,   "" }
      FieldControl := FDialog.GetControlByIndex(index);
      Value := '';
      if FieldControl <> nil then begin
        if (FieldControl is TsohoEdit) and
          (TsohoEdit(FieldControl).DirectEnter) then
          Value := IntToStr(TsohoEdit(FieldControl).Tag)
        else Value := FDialog.GetStrValueByIndex(index);
      end;
      {      ,  Id }
      {      ,     DataSet }
      if Assigned(FOnGetValue) then FOnGetValue(Self, FieldName, Value);

      {     ,     ,
               -   }
      if Value = '' then Value := FFolder.DataSet.FieldByName(FieldName).AsString;
      SQLValue := ' ' + FieldName + '=' + GetSQLValue(Value, index);
      if index <> pred(FFolder.DataSet.FieldCount) then SQL.Add(SQLValue + ',')
      else SQL.Add(SQLValue);
    end;
  end;
begin
  Result := False;
  if FFolder.DataSet = nil then begin
    ErrorMsg(FFolder.name + ':   Grid.DataSource.DataSet!');
    exit;
  end;
  if FKeyField = '' then begin
    ErrorMsg(name + ':      -   !');
    exit;
  end;
  try
    SQL := TStringList.Create;
    SQL.Clear;
    {    SQL  -  ! }
    if Assigned(FBeforeSQLGen) then FBeforeSQLGen(Self, SQL)
    else begin
      if ExtractFileExt(FTableName) <> '' then
        SQL.Add('update "' + FTableName + '" ')
      else
        SQL.Add('update ' + FTableName);
      SQL.Add('set ');
      for index := 0 to pred(FFolder.DataSet.FieldCount) do begin
        FieldName := StrUpper(FFolder.DataSet.Fields[index].FieldName);
        if FieldName <> StrUpper(FKeyField) then InsertField(index);
      end;
      { ,      ! }
      Value := SQL[SQL.Count - 1];
      if Value[Length(Value)] = ',' then begin
        Value[Length(Value)] := ' ';
        SQL[SQL.Count - 1] := Value;
      end;
      Field := FFolder.DataSet.FindField(FKeyField);
      if Field = nil then begin
        ErrorMsg(name + ':    !');
        exit;
      end;
      SQL.Add('where ' + FKeyField + '=' + GetSQLValue(Field.AsString, Field.index));
      if Assigned(FAfterSQLGen) then FAfterSQLGen(Self, SQL);
    end;
    Result := RunUpdateSQL(SQL);
  finally
    SQL.Free;
    RestoreCursor;
  end;
end;

function TsohoCustomRecordForm.GenerateInsertSQL: Boolean;
var SQL : TStringList;
  index           : Integer;
  Allow           : Boolean;
  FieldName, Value: string;
  SQLValue        : string;
  FieldControl    : TWinControl;

  procedure InsertField(index: Integer);
  begin
    Allow := True;
    if (FSQLHideFields.IndexOf(FieldName) <> -1) or
       not (FFolder.DataSet.Fields[index].DataType in CorrectFieldsType)  then exit
    else if Assigned(FOnAddFieldToSQL) then FOnAddFieldToSQL(Self, FieldName, Allow);
    if not Allow then exit;
    Value := '';
    {        Text,
            Tag,   "" }
    FieldControl := FDialog.GetControlByIndex(index);
    if (FieldControl is TsohoEdit) and
      (TsohoEdit(FieldControl).DirectEnter) then
      Value := IntToStr(TsohoEdit(FieldControl).Tag)
    else Value := FDialog.GetStrValueByIndex(index);
    {     ,  Id}
    if Assigned(FOnGetValue) then FOnGetValue(Self, FieldName, Value);

    SQLValue := GetSQLValue(Value, index);
    try
      if AnsiUpperCase(FieldName) = AnsiUpperCase(KeyField) then FNewId := StrToInt(Value);
    except
      on E:Exception do ErrorMsg('     ! '+
        E.Message);
    end;
    if index <> pred(FFolder.DataSet.FieldCount) then SQL.Add(SQLValue + ',')
    else SQL.Add(SQLValue + ')');
  end;
begin
  Result := False;
  if FFolder.DataSet = nil then begin
    ErrorMsg(FFolder.name + ':   Grid.DataSource.DataSet!');
    exit;
  end;
  try
    SQL := TStringList.Create;
    SQL.Clear;
    {    SQL  -  ! }
    if Assigned(FBeforeSQLGen) then FBeforeSQLGen(Self, SQL)
    else begin
      if ExtractFileExt(FTableName) <> '' then
        SQL.Add('insert into "' + FTableName + '" (')
      else
        SQL.Add('insert into ' + FTableName + ' (');
      for index := 0 to pred(FFolder.DataSet.FieldCount) do begin
        FieldName := StrUpper(FFolder.DataSet.Fields[index].FieldName);
        Allow := (FSQLHideFields.IndexOf(FieldName) = -1) and
                 (FFolder.DataSet.Fields[index].DataType in CorrectFieldsType);
        if Assigned(FOnAddFieldToSQL) then FOnAddFieldToSQL(Self, FieldName, Allow);
        if Allow then
          if index <> pred(FFolder.DataSet.FieldCount) then SQL.Add(FieldName + ',')
          else SQL.Add(FieldName + ')');
      end;
      { ,        ! }
      Value := SQL[SQL.Count - 1];
      if Value[Length(Value)] = ',' then begin
        Value[Length(Value)] := ')';
        SQL[SQL.Count - 1] := Value;
      end;
      SQL.Add('values (');
      for index := 0 to pred(FFolder.DataSet.FieldCount) do begin
        FieldName := StrUpper(FFolder.DataSet.Fields[index].FieldName);
        InsertField(index);
      end;
      { ,        ! }
      Value := SQL[SQL.Count - 1];
      if Value[Length(Value)] = ',' then begin
        Value[Length(Value)] := ')';
        SQL[SQL.Count - 1] := Value;
      end;
      if Assigned(FAfterSQLGen) then FAfterSQLGen(Self, SQL);
    end;
    Result := RunInsertSQL(SQL);
  finally
    SQL.Free;
    RestoreCursor;
  end;
end;

constructor TsohoCustomRecordForm.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FFolder := nil;
  FTableName := '';
  FDialog := nil;
  FCaption := '';
  FKeyField := 'Id';
  FPanel := nil;
  FHideFields := TStringList.Create;
  FSQLHideFields := TStringList.Create;
  FComplexFields := TStringList.Create;
  FComplexLabels := TStringList.Create;
end;

destructor TsohoCustomRecordForm.Destroy;
begin
  Close;
  FHideFields.Free;
  FSQLHideFields.Free;
  FComplexFields.Free;
  FComplexLabels.Free;
  inherited Destroy;
end;

procedure TsohoCustomRecordForm.GetTextForField(const FieldName: string;
    var FieldText: string; FieldValue: Longint);
begin
  FieldText := '';
  if Assigned(FOnGetTextForField) then FOnGetTextForField(Self, FieldName, FieldText,
    FieldValue);
end;

procedure TsohoCustomRecordForm.PrepareCard;
const LabelWidth = 180;
  EditWidth        = 250;
  ButtonPanelWidth = 83;

var index: Integer;
  Allow     : Boolean;
  Complex   : Boolean;
  FieldName : string;
  FieldText : string;
  FieldLabel: string;
  RealIndex : Integer;

  NewLabel  : TsohoLabel;
  NewControl: TWinControl;
  NewParent : TWinControl;

  function CreateLabel(AParent: TWinControl): TsohoLabel;
  begin
    Result := TsohoLabel.Create(FDialog);
    with Result do begin
      Parent := AParent;
      Left := 8;
      Width := LabelWidth;
      Alive := True;
      FontActive.Color := clRed;
      Height := 22;
      Top := RealIndex * 24 + 8;
      if Top + Height > FDialog.ClientHeight then
        FDialog.ClientHeight := Top + Height + 8;
    end;
  end;

  function CreateEdit(AParent: TWinControl; aValueKind: TValueKind): TsohoEdit;
  begin
    Result := TsohoEdit.Create(FDialog);
    with Result do begin
      Parent := AParent;
      case aValueKind of
        vkDate: Text := WDateToStr(Date);
        vkTime: Text := TimeToStr(Time);
      else Text := '';
      end;
      ValueKind := aValueKind;
      Font.Style := [];
      CanExit := FDialog.EditExit;
      MayBeEmpty := True;
      FromChars := '"';
      ToChars := '''';
      if ValueKind <> vkString then RightControl := True;
      if ValueKind = vkString then begin
        MaxLength := FFolder.DataSet.Fields[index].Size;
        Width := GetStrWidth(GetDC(Handle), Chars('W', MaxLength)) + 10;
        if Width > EditWidth then Width := EditWidth;
      end
      else Width := 150;
      if Left + Width + 15 + LabelWidth + Height > AParent.Width then
        FDialog.ClientWidth := Left + Width + 15 + LabelWidth + ButtonPanelWidth + Height;
    end;
  end;

  function CreateCheck(AParent: TWinControl): TCheckBox;
  begin
    Result := TCheckBox.Create(FDialog);
    with Result do begin
      Parent := AParent;
      Caption := '';
      Width := 15;
    end;
  end;
  
  procedure PrepareField(index: Integer);
  begin
    with FFolder.DataSet do begin
      if Complex and (Fields[index] is TIntegerField) then begin
        NewControl := CreateEdit(NewParent, vkString);
        with TsohoEdit(NewControl) do begin
          DirectEnter := True;
          RightControl := True;
          TsohoBitBtn(Button).Caption := '<<';
          OnRightClick := DoComplexClick;
          if Mode = rmEdit then begin
            Tag := TIntegerField(Fields[index]).AsInteger;
            GetTextForField(FieldName, FieldText, Tag);
            Text := FieldText;
          end;
        end;
      end
      else
        case Fields[index].DataType of
          ftString: begin
            NewControl := CreateEdit(NewParent, vkString);
            if Mode = rmEdit then
              TsohoEdit(NewControl).Text := Fields[index].AsString;
          end;
          ftSmallint,
            ftInteger,
            ftWord: begin
              NewControl := CreateEdit(NewParent, vkInteger);
              if Mode = rmEdit then
                TsohoEdit(NewControl).Text := Fields[index].AsString;
            end;
          ftFloat,
            ftCurrency: begin
              NewControl := CreateEdit(NewParent, vkFloat);
              if Mode = rmEdit then
                TsohoEdit(NewControl).Text := Fields[index].AsString;
            end;
          ftBoolean: begin
            NewControl := CreateCheck(NewParent);
            if Mode = rmEdit then TCheckBox(NewControl).checked :=
              TBooleanField(Fields[index]).AsBoolean;
          end;
          ftDate, ftDateTime: begin
            NewControl := CreateEdit(NewParent, vkDate);
            if Mode = rmEdit then
              TsohoEdit(NewControl).Text := Fields[index].AsString;
          end;
          ftTime: begin
            NewControl := CreateEdit(NewParent, vkTime);
            if Mode = rmEdit then
              TsohoEdit(NewControl).Text := Fields[index].AsString;
          end;
        end;
      NewLabel := CreateLabel(NewParent);
      NewLabel.Caption := ChangeChars(FieldLabel, '~', ' ');
      { RealIndex -       }
      inc(RealIndex);
    end;
  end;
begin
  FNewId := -1;
  if FFolder.DataSet = nil then
    raise EsohoRecordError.Create(FFolder.name + ':   Grid.DataSource.DataSet!');
  if FPanel <> nil then NewParent := FPanel
  else begin
    FDialog := TsohoNewRecordForm.Create(Self);
    FDialog.Fields.Clear;
    NewParent := FDialog;
  end;

  LoadFieldsListFromFolder; {      Folder' }
  with FFolder.DataSet do begin
    RealIndex := 0;
    for index := 0 to pred(FieldCount) do begin
      Allow := True; Complex := False;
      FieldName := StrUpper(Fields[index].FieldName);
      FieldLabel := Fields[index].DisplayLabel;

      NewControl := nil;
      NewLabel := nil;
      {     ? }
      Allow := (FHideFields.IndexOf(FieldName) = -1) and
               (FFolder.DataSet.Fields[index].DataType in CorrectFieldsType);
      {   ? }
      Complex := FComplexFields.IndexOf(FieldName) <> -1;
      FieldLabel := FFolder.DataSet.Fields[index].DisplayLabel;
      {   ,  -    DisplayLabel ! }
      if Complex and
        (FComplexLabels.Count >= FComplexFields.IndexOf(FieldName) + 1) then
        FieldLabel := FFolder.DataSet.FieldByName(FComplexLabels[
        FComplexFields.IndexOf(FieldName)]).DisplayLabel;
      {   ,      
                  ? }
      if Allow and Assigned(FOnAddField) then FOnAddField(Self, FieldName, FieldLabel,
        Complex, Allow);
      if Allow then PrepareField(index);
      FDialog.AddField(FieldName, NewLabel, NewControl);
    end;
  end;
  {   " " }
  with FDialog do begin
    Caption := FCaption;
    OkB.Top := 8;
    OkB.Left := ClientWidth - OkB.Width - 6;
    CancelB.Top := OkB.Top + OkB.Height + 5;
    CancelB.Left := ClientWidth - CancelB.Width - 6;
  end;
  {      ,     Grid' ,
            -     }
  FieldName := FFolder.Grid.SelectedField.FieldName;
  FieldLabel := FFolder.Grid.SelectedField.DisplayLabel;
  if FHideFields.IndexOf(FieldName) = -1 then begin
    if Assigned(FOnAddField) then FOnAddField(Self, FieldName,
      FieldLabel, Complex, Allow)
    else FDialog.aFocusField := FFocusField;
  end
  else FDialog.aFocusField := FFocusField;
  if Assigned(FOnCardCreate) then FOnCardCreate(Self);
  LoadFromFolder;
end;

procedure TsohoCustomRecordForm.SaveToFolder;
var index: Longint;
  FldLabel: TsohoLabel; 
  FldEdit : TWinControl;
begin
  if FFolder.DataSet = nil then exit; {then
       raise EsohoRecordError.Create(FFolder.Name+':   Grid.DataSource.DataSet!');}
  if (FDialog = nil) or not (FFolder.DataSet.Active) then exit;
  with FFolder.Ini do begin
    WriteInteger('EditCard', 'Width', FDialog.Width);
    WriteInteger('EditCard', 'Height', FDialog.Height);
    WriteInteger('EditCard', 'OkWidth', FDialog.OkB.Width);
    WriteInteger('EditCard', 'OkHeight', FDialog.OkB.Height);
    WriteInteger('EditCard', 'OkTop', FDialog.OkB.Top);
    WriteInteger('EditCard', 'OkLeft', FDialog.OkB.Left);
    WriteInteger('EditCard', 'CancelWidth', FDialog.CancelB.Width);
    WriteInteger('EditCard', 'CancelHeight', FDialog.CancelB.Height);
    WriteInteger('EditCard', 'CancelTop', FDialog.CancelB.Top);
    WriteInteger('EditCard', 'CancelLeft', FDialog.CancelB.Left);
  end;
  for index := 0 to pred(FFolder.DataSet.FieldCount) do begin
    FldLabel := FDialog.GetLabelByIndex(index);
    if FldLabel <> nil then begin
      FldEdit := FldLabel.FocusControl;
      {        }
      with FFolder.Ini, FFolder.DataSet.Fields[index] do begin
        WriteInteger(FieldName, 'LabelTop', FldLabel.Top);
        WriteInteger(FieldName, 'LabelLeft', FldLabel.Left);
        WriteInteger(FieldName, 'LabelWidth', FldLabel.Width);
        WriteInteger(FieldName, 'LabelHeight', FldLabel.Height);
        WriteInteger(FieldName, 'FieldEditWidth', FldEdit.Width);
      end;
    end;
  end;
  if Assigned(FOnCardSave) then FOnCardSave(Self);
end;

procedure TsohoCustomRecordForm.LoadFromFolder;
var index: Longint;
  FldLabel: TsohoLabel; 
  FldEdit : TWinControl;
begin
  if FFolder.DataSet = nil then
    raise EsohoRecordError.Create(FFolder.name + ':   Grid.DataSource.DataSet!');
  if (FDialog = nil) or not (FFolder.DataSet.Active) then exit;
  with FFolder.Ini do begin
    FDialog.Ini.Active := False;
    FDialog.Width := ReadInteger('EditCard', 'Width', FDialog.Width);
    FDialog.Height := ReadInteger('EditCard', 'Height', FDialog.Height);
    FDialog.OkB.Width := ReadInteger('EditCard', 'OkWidth', FDialog.OkB.Width);
    FDialog.OkB.Height := ReadInteger('EditCard', 'OkHeight', FDialog.OkB.Height);
    FDialog.OkB.Top := ReadInteger('EditCard', 'OkTop', FDialog.OkB.Top);
    FDialog.OkB.Left := ReadInteger('EditCard', 'OkLeft', FDialog.OkB.Left);
    FDialog.CancelB.Width := ReadInteger('EditCard', 'CancelWidth', FDialog.CancelB.Width);
    FDialog.CancelB.Height := ReadInteger('EditCard', 'CancelHeight', FDialog.CancelB.Height);
    FDialog.CancelB.Top := ReadInteger('EditCard', 'CancelTop', FDialog.CancelB.Top);
    FDialog.CancelB.Left := ReadInteger('EditCard', 'CancelLeft', FDialog.CancelB.Left);
    with FDialog.Ini, MinMaxInfo do begin
      IniFilename := FFolder.FullFolderName;
      IniSection := 'EditCard';
      MaxSizeHeight := FDialog.Height;
      MaxSizeWidth := FDialog.Width;
      MaxTrackHeight := FDialog.Height;
      MaxTrackWidth := FDialog.Width;
      MinTrackHeight := FDialog.Height;
      MinTrackWidth := FDialog.Width;
    end;
  end;
  for index := 0 to pred(FFolder.DataSet.FieldCount) do begin
    FldLabel := FDialog.GetLabelByIndex(index);
    if FldLabel <> nil then begin
      FldEdit := FldLabel.FocusControl;
      {        }
      with FFolder.Ini, FFolder.DataSet.Fields[index] do begin
        FldLabel.Top := ReadInteger(FieldName, 'LabelTop', FldLabel.Top);
        FldLabel.Left := ReadInteger(FieldName, 'LabelLeft', FldLabel.Left);
        FldLabel.Width := ReadInteger(FieldName, 'LabelWidth', FldLabel.Width);
        FldLabel.Height := ReadInteger(FieldName, 'LabelHeight', FldLabel.Height);
        FldEdit.Width := ReadInteger(FieldName, 'FieldEditWidth', FldEdit.Width);
      end;
    end;
  end;
  if Assigned(FOnCardLoad) then FOnCardLoad(Self);
end;

function TsohoCustomRecordForm.Insert: Boolean;
begin
  Result := False;
  if FFolder.DataSet = nil then
    raise EsohoRecordError.Create(FFolder.name + ':   Grid.DataSource.DataSet!');
  if (FDialog <> nil) or not (FFolder.DataSet.Active) then exit;
  try
    FMode := rmInsert;
    PrepareCard;
    if FDialog.ShowModal = mrOk then Result := GenerateInsertSQL;
    SaveToFolder;
  except FDialog.Free;
    FDialog := nil;
  end;
end;

function TsohoCustomRecordForm.Edit: Boolean;
begin
  Result := False;
  if FFolder.DataSet = nil then
    raise EsohoRecordError.Create(FFolder.name + ':   Grid.DataSource.DataSet!');
  if (FDialog <> nil) or not (FFolder.DataSet.Active) then exit;
  try
    FMode := rmEdit;
    PrepareCard;
    if FDialog.ShowModal = mrOk then Result := GenerateUpdateSQL;
    SaveToFolder;
  except FDialog.Free;
    FDialog := nil;
  end;
end;

procedure TsohoCustomRecordForm.Close;
begin
  if FDialog <> nil then begin
    SaveToFolder;
    if Assigned(FOnCardDestroy) then FOnCardDestroy(Self);
    FDialog.Free;
    FDialog := nil;
    FMode := rmNone;
  end;
end;

end.

