{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{            Written by VSM, Allex, MVL                 }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
     TsohoCustomFolder
}
unit SoCtmFld;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Menus, SoTools, SoDBGrid, DB, IniFiles, SoIntrpr, SoUnit, Grids,
  DbGrids;

type


  EFolderError = class(Exception);

  { ,      -, 
       TsohoCustomFolder.   }
  TsohoCustomFolderCalc = class(TCalcObj)
    DataSet: TDataSet;
    function IsName(S: string): Boolean; override;
    function ValueOfName(S: string): Pointer; override;
  end;

  PCalcList = ^TCalcList;
  {    TsohoCustomFolder -   ,  
          111 }
  TCalcList = array[0..110] of TsohoCustomFolderCalc;
  
  {    TsohoOnLoadEvent  TsohoCustomFolder. DataSet - 
      }
  TsohoOnLoadEvent = procedure (Sender: TObject; DataSet: TDataSet) of object;
  {    TsohoOnSaveEvent  TsohoCustomFolder. DataSet - 
      }
  TsohoOnSaveEvent = procedure (Sender: TObject; DataSet: TDataSet) of object;

  TsohoCustomFolder = class(TComponent)
  private
    { Private declarations }
    Compiled: Boolean;
    FMenuAppend: Boolean;
    FSubMenu: Boolean;
    FActivated: Boolean;
    FEventsOur: Boolean;
    FAuto: Boolean;
    FMenu: TPopupMenu;
    FHiddenFields: TMenuItem;
    FItem: TMenuItem;
    FFolderDir: TDirName;
    FFolderName: TFileName;
    FGrid: TsohoDBGrid;
    FDataSet: TDataSet;
    FBeforeOpen: TDataSetNotifyEvent;
    FAfterOpen: TDataSetNotifyEvent;
    FBeforeClose: TDataSetNotifyEvent;
    FBeforePost: TDataSetNotifyEvent; {Allex}
    FOnFilter: TFilterRecordEvent; {Wizard}
    FOnFormActive: TNotifyEvent;
    FCalcFields: TDataSetNotifyEvent;
    FOldPopup: TNotifyEvent;
    FOldBeforeColMoved : TNotifyEvent;
    FOldAfterColMoved  : TMovedEvent;
    FEnabledMenus: SetOfByte;
    FOnColResize: TNotifyEvent;
    FOnLoad: TsohoOnLoadEvent;
    FOnSave: TsohoOnSaveEvent;
    FTablePath: TFileName;
    FCanResize: Boolean;
    FOnChange: TNotifyEvent;
    FProtectView : boolean;
    FKeyField : string;	
    { For setting properties and events }
    procedure DoBeforeColMoved(Sender: TObject);
    procedure DoAfterColMoved(Sender: TObject; FromIndex, ToIndex: Longint);
    procedure DoColResize(Sender: TObject);
    procedure SetGrid(Value: TsohoDBGrid);
    procedure SetFolderName(Value: TFileName);
    procedure SetFolderDir(Value: TDirName);
    procedure SetActivated(Value: Boolean);
    procedure SetEnabledMenus(Value: string);
    function GetEnabledMenus: string;
    procedure SetProtect (Value : boolean);
    procedure SetDataSet;
    { Methods are running on popup-menu click }
    procedure SetDisplayLabel;
    procedure SetDisplayWidth;
    procedure SetDisplayFormat;
    procedure SetFieldAlign;
    procedure SetTitleLines;
    procedure SetTitleAlign;
    procedure CreateField;
    procedure DeleteField;
    procedure ChangeField;
    procedure CreateMenu;
    procedure HideField(index: Longint);
    procedure AddLink;
    procedure DeleteLink;
  protected
    Formulas: TStringList;
    Calculators: PCalcList;
    FIni: TIniFile;
    procedure CreateRealField; virtual; abstract;
    procedure DeleteRealField; virtual; abstract;
    procedure ChangeVisible; virtual; abstract;

    function MenuCount: Integer; virtual;
    procedure SetMenuItem(index: Integer; Item: TMenuItem); virtual;
    procedure DoCalcFields(DataSet: TDataSet);
    {    ini- }
    procedure DoBeforeClose(DataSet: TDataSet); virtual;
    {    ini- }
    procedure DoAfterOpen(DataSet: TDataSet); virtual;
    {      -   }
    procedure DoBeforePost(DataSet: TDataSet); {Allex, all procedure}
    {      ,    
          }
    procedure DoFormActivate(Sender: TObject); virtual;
    {      ,  ,
        calculated-  ini- }
    procedure DoBeforeOpen(DataSet: TDataSet); virtual;
    {   }
    procedure DoOnFilter(DataSet: TDataSet; var Accept: Boolean); { Wizard }
    procedure MenuClick(Sender: TObject); virtual;
    procedure Notification(AComponent: TComponent; aOperation: TOperation); override;
    procedure BeforeMenuPopup(Sender: TObject); virtual;
    procedure GetRights;
    procedure Compile;
    function GetDisplayLabel(FieldName: string): string;
    procedure DefineFormula(DataSet: TDataSet; FieldName: string);
    procedure SaveColumn(index: Longint);
    procedure LoadColumn(index: Longint);
    procedure Changed; virtual;

    procedure Loaded; override;
    {      DataSet',  
      Grid  DataSource }
    property Auto: Boolean read FAuto write FAuto;
    {   - }
    property FolderName: TFileName read FFolderName write SetFolderName;
    { ,      }
    property FolderDir: TDirName read FFolderDir write SetFolderDir;
    {    .   ,    
          }
    property TableName: TFileName read FTablePath write FTablePath;
    {     }
    property EnabledMenus: string read GetEnabledMenus write SetEnabledMenus;
  public
    {    ,   .. . TsohoRegister}
    ActionRights    : SetOfByte;
    {       . . TsohoRegister }
    DataReadRights  : SetOfByte;
    {       . . TsohoRegister }
    DataWriteRights : SetOfByte;
    {  . . TsohoRegister }
    UserId          : Longint;
    { . TsohoRegister }
    DataLevel: Longint;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    {     }
    procedure ApplyDataSetDescription;
    {     }
    procedure SaveDataSetDescription;
    {    /   .   
       TsohoRegister }
    procedure ApplyDataRights(DataRead, DataWrite: SetOfByte);
    {    }
    procedure SaveDBGridColumns; virtual;
    {    }
    procedure LoadDBGridColumns; virtual;
    {  DataSet,   Grid }
    procedure ReOpen;
    {   ,     - }
    procedure ReActivate;
    {        DataSet,
       Grid }
    procedure SetEvents;virtual;
    {        DataSet,
        Grid }
    procedure RestoreEvents;virtual;
    {   }
    procedure SaveDataSet; virtual;
    {   }
    procedure LoadDataSet; virtual;
    {  :  ,   }
    function Activate: Boolean;
    {     }
    function Deactivate: Boolean;
    {    -: FolderDir+FolderName }
    function FullFolderName: TFileName;
    {    }
    property Activated: Boolean read FActivated write SetActivated;
    {   ""   DataSet.   true
      TsohoFolder      
              "Protect".
        ,     false  
        }
    property ProtectView : boolean read FProtectView write SetProtect;
    property KeyField : string read FKeyField write FKeyField;
    {   ini-,      }
    property Ini: TIniFile read FIni;
    {   DataSet }
    property DataSet: TDataSet read FDataSet;
    {   ,      }
    property Grid: TsohoDBGrid read FGrid write SetGrid;
    {      DataSet }
    property OnSaveDataSet: TsohoOnSaveEvent read FOnSave write FOnSave;
    {      DataSet }
    property OnLoadDataSet: TsohoOnLoadEvent read FOnLoad write FOnLoad;
    {       Grid }
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
  end;

const

  {      }
  mDisplaylabel    = 0;
  mDisplayWidth    = 1;
  mDisplayFormat   = 2;
  mFieldAlign      = 3;
  mHideField       = 4;
  mCreateField     = 5;
  mDeleteField     = 6;
  mChangeField     = 7;
  mChangeVisible   = 8;
  mSeparator1      = 9;
  mSaveFolder      = 10;
  mLoadFolder      = 11;
  mSeparator2      = 12;
  mTitleLines      = 13;
  mTitleAlign      = 14;
  mSeparator3      = 15;
  mCreateRField    = 16;
  mDeleteRField    = 17;
  mSeparator4      = 18;
  mAddLink         = 19;
  mDeleteLink      = 20;

  {     }
  MenuOptionsCount = mDeleteLink + 1;

  {        }
function GetMenuCaption(MenuIndex: Integer): string;

implementation
uses SoUtils, Dialogs, SohoCalc, SoCtmRgs, SoCrFldF, SoFldFrm, SoRghtsF,
     SoDBRtn, SoDBCns;

type

  EsohoFolderException = class(Exception);

var CurrentSoFolder: TsohoCustomFolder;

function GetMenuCaption(MenuIndex: Integer): string;
begin
  case MenuIndex of
    mDisplaylabel  : Result := sohoFoldermDisplaylabel;
    mDisplayWidth  : Result := sohoFoldermDisplayWidth;
    mDisplayFormat : Result := sohoFoldermDisplayFormat;
    mFieldAlign    : Result := sohoFoldermFieldAlign;
    mHideField     : Result := sohoFoldermHideField;
    mCreateField   : Result := sohoFoldermCreateField;
    mChangeVisible : Result := sohoFoldermChangeVisible;
    mDeleteField   : Result := sohoFoldermDeleteField;
    mChangeField   : Result := sohoFoldermChangeField;
    mSaveFolder    : Result := sohoFoldermSaveFolder;
    mLoadFolder    : Result := sohoFoldermLoadFolder;
    mSeparator1,
    mSeparator2,
    mSeparator3,
    mSeparator4    : Result := '-';
    mTitleLines    : Result := sohoFoldermTitleLines;
    mTitleAlign    : Result := sohoFoldermTitleAlign;
    mCreateRField  : Result := sohoFoldermCreateRField;
    mDeleteRField  : Result := sohoFoldermDeleteRField;
    mAddLink       : Result := sohoFoldermAddLink;
    mDeleteLink    : Result := sohoFoldermDeleteLink;
 end;
end;

function FieldByLabel(aLabel: string): TField;
var index: Longint;
begin
  Result := nil;
  with CurrentSoFolder do
    for index := 0 to pred(FDataSet.FieldCount) do
      if AnsiUpperCase(GetDisplayLabel(FDataSet.Fields[index].FieldName)) = aLabel then begin
        Result := FDataSet.Fields[index];
        exit;
      end;
end;

function TsohoCustomFolderCalc.IsName;
begin
  Result := FieldByLabel(S) <> nil;
end;

function TsohoCustomFolderCalc.ValueOfName;
begin
  Result := NewStr(DataSet.FieldByName(S).AsString);
end;


{ TsohoCustomFolder }
procedure TsohoCustomFolder.SetProtect (Value : boolean);
begin
  if FProtectView = Value then exit;
  FProtectView := Value;
end;

procedure TsohoCustomFolder.ApplyDataRights;
var Index: Longint;
  I: Longint; { Added by Allex.  ? }
  { Added by Wizard.  ...   ... ,
                            :) }
begin
  {     .
         }
  if not Assigned(FDataSet) then exit; {    - }
  { C    "" ALLEX, april 1998 }
  with FDataSet do begin
    for Index := 0 to pred(FieldCount) do { ,    }
      if not (LOWORD(Fields[Index].Tag) in DataRead) then
        for I := 0 to pred(FGrid.FieldCount) do
          if FGrid.Fields[I].FieldName = FDataSet.Fields[index].FieldName then begin
            FGrid.ColWidths[I] := 5;
            Break; {  }
          end;
    for Index := 0 to pred(FieldCount) do
      Fields[index].Readonly := not (LOWORD(Fields[index].Tag) in DataWrite)
      or Fields[index].Readonly;
  end;
end;

procedure TsohoCustomFolder.ApplyDataSetDescription;
var FieldList: TStringList;
  I           : Longint;
  CurrentField: TField; 
begin
  FieldList := TStringList.Create;
  if not FDataSet.Active then exit; { Can't apply to closed dataset }
  FIni.ReadSection('Fields', FieldList);
  with FIni, FDataSet, FieldList do begin
    for I := 0 to pred(Count) do begin
      CurrentField := FindField(Strings[I]);
      if CurrentField = nil then Continue;
      with CurrentField do begin
        DisplayLabel := ReadString(Strings[I], 'DisplayLabel', DisplayLabel);
        index := ReadInteger(Strings[I], 'Index', index);
        Visible := ReadBool(Strings[I], 'Visible', Visible);
        Tag := ReadInteger(Strings[I], 'Tag', Tag);
        Alignment := TAlignment(ReadInteger(Strings[I], 'Alignment', Integer(Alignment)));
        if DataType in [ftSmallint, ftInteger, ftWord, ftFloat, ftCurrency,
          ftDate, ftDateTime, ftBCD] then
          if IsProperty(CurrentField, 'DisplayFormat') then
            SetStringProperty(CurrentField, 'DisplayFormat', ReadString(Strings[I], 'DisplayFormat', ''));
        if DataType in [ftBoolean] then
          if IsProperty(CurrentField, 'DisplayValues') then
            SetStringProperty(CurrentField, 'DisplayValues', ReadString(Strings[I], 'DisplayValues', ''));
      end;
    end;
  end;
  FieldList.Free;
end;

procedure TsohoCustomFolder.SaveDataSetDescription;
var I: Longint;
begin
  if not FDataSet.Active then exit; {Can't save status of closed dataset}
  with FIni, FDataSet do begin
    EraseSection('Fields');
    for I := 0 to pred(FieldCount) do
      with Fields[I] do begin
        if Fields[I].Calculated then WriteString('Fields', FieldName, 'Calculated')
        else WriteString('Fields', FieldName, 'Stored');
        WriteString(FieldName, 'DisplayLabel', DisplayLabel);
        WriteInteger(FieldName, 'DisplayWidth', DisplayWidth);
        WriteInteger(FieldName, 'Index', index);
        WriteInteger(FieldName, 'Tag', Tag);
        WriteBool(FieldName, 'Visible', Visible);
        WriteInteger(FieldName, 'Alignment', Integer(Alignment));
        if DataType in [ftSmallint, ftInteger, ftWord, ftFloat, ftCurrency,
          ftDate, ftDateTime, ftBCD] then
          if IsProperty(Fields[I], 'DisplayFormat') then
            WriteString(FieldName, 'DisplayFormat', GetStringProperty(Fields[I], 'DisplayFormat'));
        if DataType in [ftBoolean] then
          if IsProperty(Fields[I], 'DisplayValues') then
            WriteString(FieldName, 'DisplayValues', GetStringProperty(Fields[I], 'DisplayValues'));
      end;
  end;
end;


ResourceString
  sohoFolderDataSetOpenError = '%s.ReOpen:   !  DataSet-  !';

procedure TsohoCustomFolder.ReOpen;
begin
  with FDataSet do begin
    DisableControls;
    CLOSE;
    try
      try
        {    ,   
                }
        RemoveAllFields(FDataSet);
        Open;
      except {   !  DataSet-  ! }
        ErrorMsg(Format(sohoFolderDataSetOpenError, [Self.name]));
      end;
    finally
      EnableControls;
    end;
  end;
end;

procedure TsohoCustomFolder.DoFormActivate(Sender: TObject);
begin
  LoadDBGridColumns;
  if Assigned(FOnFormActive) then FOnFormActive(Self);
end;

procedure TsohoCustomFolder.Changed;
begin
  if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TsohoCustomFolder.DefineFormula(DataSet: TDataSet; FieldName: string);
var index: Longint;
begin
  try
    CalculatorF := TCalculatorF.Create(Owner); {  }
    CalculatorF.FormulaE.Text := FIni.ReadString(FieldName, 'Formula', 'ERROR');
    CalculatorF.ListBox1.Clear;
    CalculatorF.FieldsBox.Clear;
    
    for index := 0 to pred(TDataSet(DataSet).FieldCount) do
      if DataSet.Fields[index].FieldName <> FieldName then begin
        CalculatorF.ListBox1.Items.Add(
          GetDisplayLabel(DataSet.Fields[index].FieldName));
        CalculatorF.FieldsBox.Items.Add(DataSet.Fields[index].FieldName);
      end;
    { Run and Get new formula }
    if CalculatorF.ShowModal = mrOk then begin
      FIni.WriteString(FieldName, 'Formula', CalculatorF.FormulaE.Text);
      {         
         }
      ReOpen;
      FGrid.Refresh;
    end
    else {    ! };
    { Free }
  finally
    CalculatorF.Free;
  end;
end;

procedure TsohoCustomFolder.DoBeforeColMoved(Sender: TObject);
begin
  SaveDBGridColumns;
  if Assigned(FOldBeforeColMoved) then FOldBeforeColMoved(Self);
end;

procedure TsohoCustomFolder.DoAfterColMoved(Sender: TObject; FromIndex, ToIndex: Longint);
begin
  LoadDBGridColumns;
  if Assigned(FOldAfterColMoved) then FOldAfterColMoved(Self, FromIndex, ToIndex);
end;

procedure TsohoCustomFolder.Compile;
var index, Index1: Longint;
  {$IfNDef Win32}
var MemoryCheck: Longint;
  {$EndIf}
begin
  {   }
  { Second phase - Create Calculator objects and compile formulas.}
  {$IFNDEF Win32}
  {$i+}
  MemoryCheck := MemAvail;
  if MemoryCheck < 10000 then begin
    ErrorMsg(sohoFolderNoMemory);
    Application.Terminate;
    exit;
  end;
  {$ENDIF}

  if Calculators = nil then
    GetMem(Calculators, Sizeof(TsohoCustomFolderCalc) * Formulas.Count);
  {$i-}
  {   }
  CurrentSoFolder := Self; {       }
  for index := 0 to pred(Formulas.Count) do begin
    Calculators^[index] := TsohoCustomFolderCalc.Create(C0);
    Calculators^[index].DataSet := FDataSet;
    {        ,   
             20  }
    Calculators^[index].Compile(Formulas[index]);
  end;
  { Third Phase - Replace DisplayLabels to FieldNames }
  for index := 0 to pred(Formulas.Count) do
    with Calculators^[index] do begin
      for Index1 := 1 to CompiledPData do
        if FieldByLabel(CompiledDataNameStack[Index1]) <> nil then
          CompiledDataNameStack[Index1] :=
          FieldByLabel(CompiledDataNameStack[Index1]).FieldName;
    end;
  { Forth phase - sort compiled formulas }

  {   }
  Compiled := True;
end;

procedure TsohoCustomFolder.SetEvents;
var FActive: Boolean;
  Form: TForm;
begin
  if csDesigning in ComponentState then exit;
  if FDataSet = nil then raise
    EsohoFolderException.Create(Format(sohoFolderDataSetNotDefined, [name]));
  Form := GetOwnerForm(Self);
  if Form <> nil then begin
    FOnFormActive := Form.OnActivate;
    Form.OnActivate := DoFormActivate;
  end;
  FActive := FDataSet.Active;
  FDataSet.Close;
  with FDataSet do begin
    FAfterOpen := AfterOpen;
    FBeforeClose := BeforeClose;
    FBeforeOpen := BeforeOpen;
    AfterOpen := DoAfterOpen;
    BeforeClose := DoBeforeClose;
    BeforeOpen := DoBeforeOpen;
    FCalcFields := OnCalcFields;
    OnCalcFields := DoCalcFields;
    FBeforePost := BeforePost; {Allex}
    BeforePost := DoBeforePost; {Allex ...}

    FOnFilter := FDataSet.OnFilterRecord;
    if FProtectView then FDataSet.OnFilterRecord := DoOnFilter;
    {... Wizard}
  end;
  if Assigned(FGrid) then begin
    FOnColResize := FGrid.OnColResize;
    FOldBeforeColMoved := FGrid.OnBeforeColumnMoved;
    FOldAfterColMoved := FGrid.OnColumnMoved;
    FGrid.OnColResize := DoColResize;
    FGrid.OnColumnMoved := DoAfterColMoved;
    FGrid.OnBeforeColumnMoved := DoBeforeColMoved;
  end;

  if FActive then FDataSet.Open;
  FEventsOur := True;
end;

procedure TsohoCustomFolder.RestoreEvents;
var FActive: Boolean;
  Form: TForm;
begin
  if csDesigning in ComponentState then exit;
  if FDataSet = nil then raise
    EsohoFolderException.Create(Format(sohoFolderDataSetNotDefined, [name]));
  Form := GetOwnerForm(Self);
  if Form <> nil then Form.OnActivate := FOnFormActive;
  FActive := FDataSet.Active;
  if not (csDestroying in ComponentState) then FDataSet.Close;
  with FDataSet do begin
    AfterOpen := FAfterOpen;
    BeforeClose := FBeforeClose;
    BeforeOpen := FBeforeOpen;
    OnCalcFields := FCalcFields;
  end;
  {  -   }
  if not (csDestroying in ComponentState) and Assigned(FGrid) then begin
    FGrid.OnColResize := FOnColResize;
    FGrid.OnColumnMoved := FOldAfterColMoved;
    FGrid.OnBeforeColumnMoved := FOldBeforeColMoved;
  end;
  if not (csDestroying in ComponentState) then begin
    if FActive then FDataSet.Open
    else FDataSet.Close;
  end;
  FEventsOur := False;
end;

procedure TsohoCustomFolder.SetEnabledMenus(Value: string);
begin
  FEnabledMenus := StrToSet(Value);
end;

function TsohoCustomFolder.GetEnabledMenus: string;
begin
  Result := SetToStr(FEnabledMenus);
end;

function TsohoCustomFolder.GetDisplayLabel(FieldName: string): string;
begin
  {    }
  if FIni = nil then FIni := TIniFile.Create(FullFolderName);
  Result := FIni.ReadString(FieldName, 'DisplayLabel', FieldName);
end;

procedure TsohoCustomFolder.HideField(index: Longint);
begin
  SaveDBGridColumns;
  FGrid.Fields[index].Visible := False;
  LoadDBGridColumns;
end;

procedure TsohoCustomFolder.DoColResize;
var index: Longint;
  OldOnResize: TNotifyEvent;
begin
  if (not FCanResize) or (csDestroying in ComponentState) then exit;
  if mHideField in FEnabledMenus then
    with FGrid do begin
      OldOnResize := OnColResize;
      OnColResize := nil;
      for index := 0 to pred(FieldCount) do
        if ColWidths[index + 1] <= 8 then begin
          ColWidths[index + 1] := 100;
          HideField(index);
        end;
      OnColResize := OldOnResize;
    end;
  if Assigned(FOnColResize) then FOnColResize(FGrid);
end;

procedure TsohoCustomFolder.GetRights;
var Reg: TsohoCustomRegister;
begin
  {       TsohoRegister     DataReadRights
      DataRightRights.     }
  ActionRights := [0..255];
  DataReadRights := [0..255];
  DataWriteRights := [0..255];
  UserId := 666;
  DataLevel := 0;
  Reg := FindSohoRegister;
  if Reg <> nil then begin
    ActionRights := Reg.ActionRights;
    DataReadRights := Reg.DataReadRights;
    DataWriteRights := Reg.DataWriteRights;
    UserId := Reg.UserId;
    DataLevel := Reg.DataLevel;
    if FolderDir = '' then FolderDir := Reg.PathToHome;
  end;
end;

procedure TsohoCustomFolder.SetActivated(Value: Boolean);
begin
  if csDesigning in ComponentState then exit;
  if FActivated = Value then exit;
  if not Value then begin
    SaveDataSet;
    if FSubMenu then begin
      {    }
      FGrid.PopupMenu.OnPopup := FOldPopup;
      FItem.Parent.Remove(FItem);
      FItem.Free;
      FItem := nil;
    end
    else begin
      if not (csDestroying in FMenu.ComponentState) then FMenu.Free;
      FMenu := nil;
    end;
  end;
  if Value then begin
    SetDataSet;
    if not FEventsOur then SetEvents;
    LoadDataSet;
    CreateMenu;
  end;
  FActivated := Value;
end;

procedure TsohoCustomFolder.SetDataSet;
begin
  if (FGrid <> nil) and (FGrid.DataSource <> nil) then
    FDataSet := FGrid.DataSource.DataSet;
end;

procedure TsohoCustomFolder.SetGrid(Value: TsohoDBGrid);
begin
  if (FGrid <> nil) and (FAuto) then Activated := False;
  FGrid := Value;
  SetDataSet;
end;

function TsohoCustomFolder.FullFolderName: TFileName;
begin
  Result := FFolderDir + FFolderName;
end;

procedure TsohoCustomFolder.SetFolderName;
var FPath: string;
begin
  if (FIni <> nil) and not (csDesigning in ComponentState) then begin
    FIni.Free;
    FIni := nil;
  end;
  if FFolderDir + FFolderName = Value then exit;
  FPath := ExtractFilePath(Value);
  FFolderName := ExtractFileName(Value);
  if FPath <> '' then FolderDir := FPath;
  if not (csDesigning in ComponentState) and (FIni = nil) then
    FIni := TIniFile.Create(FullFolderName);
end;

procedure TsohoCustomFolder.SetFolderDir;
begin
  if (FIni <> nil) and not (csDesigning in ComponentState) then begin
    FIni.Free;
    FIni := nil;
  end;
  if FFolderDir = Value then exit;
  FFolderDir := Value;
  if FFolderDir <> '' then {Added by ALLEX}
    FFolderDir := NormalDir(FFolderDir);
    // if FFolderDir[Length(FFolderDir)] <> '\' then FFolderDir := FFolderDir + '\';
  if not (csDesigning in ComponentState) and (FIni = nil) then
    FIni := TIniFile.Create(FullFolderName);
end;


procedure TsohoCustomFolder.CreateMenu;
var MenuItem: TMenuItem;
  index: Integer;
  
  procedure AddMenuItem(CAPTION: string; OnClick: TNotifyEvent);
  begin
    MenuItem := NewItem(CAPTION, 0, False, True, OnClick, 0, '');
    if not FSubMenu then FMenu.Items.Add(MenuItem)
    else FItem.Add(MenuItem);
    SetMenuItem(index, MenuItem);
  end;
begin
  FSubMenu := False;
  FHiddenFields := NewItem(sohoFolderShowColumn, 0, False, True, nil, 0, '');
  if FGrid.PopupMenu <> nil then begin
    FItem := NewItem(sohoFolderService, 0, False, True, nil, 0, '');
    FGrid.PopupMenu.Items.Insert(0, FItem);
    FSubMenu := True;
    FOldPopup := FGrid.PopupMenu.OnPopup;
  end
  else begin
    FMenu := TPopupMenu.Create(Owner);
    FGrid.PopupMenu := FMenu;
  end;
  FGrid.PopupMenu.OnPopup := BeforeMenuPopup;
  for index := 0 to MenuCount do AddMenuItem('', MenuClick);
  MenuItem.Caption := '-';
  if not FSubMenu then FMenu.Items.Add(FHiddenFields)
  else FItem.Add(FHiddenFields);
end;

procedure TsohoCustomFolder.BeforeMenuPopup;
var index: Integer;
  Field      : TField;
  TmpMenuItem: TMenuItem;
begin
  {   ,      ,
           }
  for index := mDisplaylabel to MenuOptionsCount - 1 do
    if FSubMenu then FItem.Items[index].Visible := True
    else FMenu.Items[index].Visible := True;

  for index := mDisplaylabel to pred(MenuOptionsCount) do
    if not (index in [mSeparator1, mSeparator2, mSeparator3, mSeparator4]) then
      if FSubMenu then begin
        if not ((index + 1 in FEnabledMenus) and (index + 1 in ActionRights)) then FItem.Items[index].Visible := False;
      end
      else if not ((index + 1 in FEnabledMenus) and (index + 1 in ActionRights)) then FMenu.Items[index].Visible := False;

  Field := FGrid.SelectedField;
  if FSubMenu then begin
    FItem.Items[mDisplayFormat].Visible := FItem.Items[mDisplayFormat].Visible and
                                           IsProperty(Field,'DisplayFormat');
    FItem.Items[mDeleteField].Visible := FItem.Items[mDeleteField].Visible and
                     Field.Calculated and (Copy(Field.FieldName, 1, 2) = 'CA');
    FItem.Items[mChangeField].Visible := FItem.Items[mChangeField].Visible and
                     Field.Calculated and (Copy(Field.FieldName, 1, 2) = 'CA');

    FItem.Items[mDeleteRField].Visible := FItem.Items[mDeleteRField].Visible and
     (not (Field.Calculated and (Copy(Field.FieldName, 1, 2) = 'CA')) and
          (FTablePath <> ''));
    FItem.Items[mCreateRField].Visible := FItem.Items[mCreateRField].Visible and
                                          (FTablePath <> '');

    FItem.Items[mAddLink].Visible := FItem.Items[mAddLink].Visible and
          (Copy(Field.FieldName, 1, 2) = 'ID') and (Field.FieldName <> FKeyField);
    FItem.Items[mDeleteLink].Visible := FItem.Items[mDeleteLink].Visible and
          (FIni.ReadString(FGrid.SelectedField.FieldName, 'LinkedTo', '') <> '');
    FItem.Items[mDeleteLink].CAPTION := sohoFolderFreeLink +
      ExtractFileName(FIni.ReadString(FGrid.SelectedField.FieldName, 'LinkedTo', '')) + ')';
    FItem.Items[mChangeVisible].CAPTION := sohoFolderVisibility;

    { Allex }
    FItem.Items[mSeparator1].Visible := FItem.Items[mSaveFolder].Visible or FItem.Items[mLoadFolder].Visible;
    FItem.Items[mSeparator2].Visible := FItem.Items[mTitleLines].Visible or FItem.Items[mTitleAlign].Visible;
    FItem.Items[mSeparator3].Visible := FItem.Items[mCreateRField].Visible or FItem.Items[mDeleteRField].Visible;
    FItem.Items[mSeparator4].Visible := FItem.Items[mAddLink].Visible or FItem.Items[mDeleteLink].Visible;
  end
  else begin
    FMenu.Items[mDisplayFormat].Visible := FMenu.Items[mDisplayFormat].Visible and
       IsProperty(Field, 'DisplayFormat');
    FMenu.Items[mDeleteField].Visible := FMenu.Items[mDeleteField].Visible and
      Field.Calculated and (Copy(Field.FieldName, 1, 2) = 'CA');
    FMenu.Items[mChangeField].Visible := FMenu.Items[mChangeField].Visible and
       Field.Calculated and (Copy(Field.FieldName, 1, 2) = 'CA');

    FMenu.Items[mDeleteRField].Visible := FMenu.Items[mDeleteRField].Visible and
      not (Field.Calculated and (Copy(Field.FieldName, 1, 2) = 'CA')) and
      (FTablePath <> '');
    FMenu.Items[mCreateRField].Visible := FMenu.Items[mCreateRField].Visible and
      (FTablePath <> '');

    FMenu.Items[mAddLink].Visible := (Copy(Field.FieldName, 1, 2) = 'ID') and (Field.FieldName <> FKeyField);
    FMenu.Items[mDeleteLink].Visible := FIni.ReadString(FGrid.SelectedField.FieldName, 'LinkedTo', '') <> '';;
    FMenu.Items[mDeleteLink].Caption := sohoFolderFreeLink +
      ExtractFileName(FIni.ReadString(FGrid.SelectedField.FieldName, 'LinkedTo', '')) + ')';

    FMenu.Items[mSeparator1].Visible := FMenu.Items[mSaveFolder].Visible or FMenu.Items[mLoadFolder].Visible;
    FMenu.Items[mSeparator2].Visible := FMenu.Items[mTitleLines].Visible or FMenu.Items[mTitleAlign].Visible;
    FMenu.Items[mSeparator3].Visible := FMenu.Items[mCreateRField].Visible or FMenu.Items[mDeleteRField].Visible;
    FMenu.Items[mSeparator4].Visible := FMenu.Items[mAddLink].Visible or FMenu.Items[mDeleteLink].Visible;
  end;

  for index := pred(FHiddenFields.Count) downto 0 do
    FHiddenFields.Delete(index);
  for index := 0 to pred(FDataSet.FieldCount) do
    if (not FDataSet.Fields[index].Visible)
      then begin
      TmpMenuItem := NewItem(FDataSet.Fields[index].{FieldName} DisplayLabel, 0,
        False, True, MenuClick, 0, '');

      TmpMenuItem.ENABLED := ((255 in ActionRights) or not SohoNames(FDataSet.Fields[index].FieldName))
        {  -   -        
          "    ,  " }
        and (LOWORD(FDataSet.Fields[index].Tag) in DataReadRights);

      {  20-    }
      if (FHiddenFields.Count mod 20 = 0) and
        (FHiddenFields.Count <> 0) then TmpMenuItem.Break :=
        mbBarBreak;
      FHiddenFields.Add(TmpMenuItem);
    end;
  FHiddenFields.Visible := FHiddenFields.Count > 0;
  if Assigned(FOldPopup) then FOldPopup(Sender);
end;

procedure TsohoCustomFolder.ReActivate;
begin
  Activated := False;
  Activated := True;
end;

procedure TsohoCustomFolder.AddLink;
var Dialog: TOpenDialog;
begin
  Dialog := TOpenDialog.Create(nil);
  with Dialog do begin
    Filename := '*.ini;*.fld';
    Filter := sohoFolderDescriptionFiles;
    FilterIndex := 1;
    Options := [ofHideReadOnly, ofPathMustExist, ofFileMustExist];
    Title := sohoFolderDescDialogTitle;
    if not Execute then exit;
  end;
  FIni.WriteString(FGrid.SelectedField.FieldName, 'LinkedTo', Dialog.Filename);
  Dialog.Free;
end;

procedure TsohoCustomFolder.DeleteLink;
begin
  FIni.WriteString(FGrid.SelectedField.FieldName, 'LinkedTo', '');
end;


procedure TsohoCustomFolder.CreateField;
var FieldId: Longint;
  FieldName: string;
begin
  FDataSet.DisableControls;
  FDataSet.CLOSE;
  FieldId := GetNewID('CA'); {  }
  FieldName := 'CA' + IntToStr(FieldId);
  with FIni do begin
    WriteString('Fields', FieldName, 'Temp');
    WriteString(FieldName, 'Formula', C0 + '0' + C0);
    WriteInteger(FieldName, 'DisplayWidth', 60);
    WriteString(FieldName, 'DisplayLabel', sohoFolderFormuleDefName);
  end;
  FDataSet.OPEN;
  DefineFormula(FDataSet, FieldName);
  FDataSet.EnableControls;
  FGrid.SelectedIndex := FGrid.FieldCount - 1;
  Changed;
end;

procedure TsohoCustomFolder.DeleteField;
var FieldList: TStringList;
  index          : Longint;
  DeleteFieldName: string;
begin
  if FGrid.SelectedField.Calculated then begin
    FDataSet.DisableControls;
    FDataSet.CLOSE;
    DeleteFieldName := FGrid.SelectedField.FieldName;
    FieldList := TStringList.Create;
    FIni.ReadSection('Fields', FieldList);
    FIni.EraseSection('Fields');
    with FieldList do
      for index := 0 to pred(Count) do
        if Strings[index] <> DeleteFieldName then
          FIni.WriteString('Fields', Strings[index], 'not Deleted');
    FIni.EraseSection(DeleteFieldName);
    FieldList.Free;
    RemoveFieldByName(FDataSet, DeleteFieldName);
    FDataSet.OPEN;
    FDataSet.EnableControls;
    Changed;
  end
  else InfoMsg(sohoFolderColumnIsNotCalc);
end;

procedure TsohoCustomFolder.ChangeField;
begin
  if FGrid.SelectedField.Calculated then begin
    DefineFormula(FDataSet, FGrid.SelectedField.FieldName);
    Changed;
  end
  else ErrorMsg(sohoFolderColumnIsNotCalc);
end;

procedure TsohoCustomFolder.SetFieldAlign;
begin
  if SetField(FGrid.SelectedField, FEnabledMenus, FGrid, 0, mFieldAlign) then Changed;
end;

procedure TsohoCustomFolder.SetDisplayLabel;
begin
  {   }
  if SetField(FGrid.SelectedField, FEnabledMenus, FGrid, 0, mDisplaylabel) then Changed;
end;

procedure TsohoCustomFolder.SetDisplayWidth;
begin
  FCanResize := False;
  if SetField(FGrid.SelectedField, FEnabledMenus, FGrid, 0, mDisplayWidth) then begin
    SaveDBGridColumns;
    Changed;
  end;
  FCanResize := True;
end;

procedure TsohoCustomFolder.SetDisplayFormat;
begin
  if SetField(FGrid.SelectedField, FEnabledMenus, FGrid, 0, mDisplayFormat) then Changed;
end;

procedure TsohoCustomFolder.SetTitleLines;
begin
  if SetField(FGrid.SelectedField, FEnabledMenus, FGrid, 1, mTitleLines) then Changed;
end;

procedure TsohoCustomFolder.SetTitleAlign;
begin
  if SetField(FGrid.SelectedField, FEnabledMenus, FGrid, 1, mTitleAlign) then Changed;
end;

function TsohoCustomFolder.MenuCount: Integer;
begin
  Result := MenuOptionsCount;
end;

procedure TsohoCustomFolder.SetMenuItem(index: Integer; Item: TMenuItem);
begin
  if index <= MenuCount then Item.CAPTION := GetMenuCaption(index);
end;

procedure TsohoCustomFolder.DoCalcFields(DataSet: TDataSet);
var index: Longint;
  wFormula  : PString;
  TmpFormula: string;
begin
  if not Compiled then exit;
  for index := 0 to pred(Formulas.Count) do begin
    try
      wFormula := Calculators^[index].Calculate;
      TmpFormula := wFormula^;
      DisposeStr(wFormula);
      DataSet.FieldByName(Calculators^[index].ResultName).AsString :=
        TmpFormula;
    except
      if Calculators = nil then ErrorMsg(sohoFolderCalculatorsNill)
      else ErrorMsg(Format(sohoFolderCantCalculate, [Name, Calculators^[index].ResultName]));
    end;
  end;
  if Assigned(FCalcFields) then FCalcFields(DataSet);
end;

procedure TsohoCustomFolder.DoBeforeClose(DataSet: TDataSet);
var index: Longint;
begin
  {    }
  SaveDataSet;
  {      }
  for index := 0 to pred(Formulas.Count) do
    Calculators^[index].Free;
  if Calculators <> nil then
    FreeMem(Calculators, Sizeof(TsohoCustomFolderCalc) * Formulas.Count);
  Calculators := nil;
  Formulas.Free;
  Formulas := nil;
  if Assigned(FBeforeClose) then FBeforeClose(DataSet);
  FActivated := False;
end;

procedure TsohoCustomFolder.DoOnFilter;
var CheckField: TField;
begin
  if FDataSet = nil then exit;
  if FDataSet.State = dsInactive then exit;
  if Assigned(FOnFilter) then FOnFilter(FDataSet, Accept);
  CheckField := FDataSet.FindField('PROTECT');
  if CheckField <> nil then
    Accept := Accept and (CheckField.AsInteger in DataReadRights);
end;

{ Allex, all procedure }
procedure TsohoCustomFolder.DoBeforePost(DataSet: TDataSet);
var Field: TField;
begin
  Field := DataSet.FindField('MdfDate');
  if Assigned(Field) then Field.AsDateTime := Date;
  Field := DataSet.FindField('MdfTime');
  if Assigned(Field) then Field.AsDateTime := Time;
  Field := DataSet.FindField('IDMdfAuth');
  if Assigned(Field) then Field.AsInteger := UserId;
  Field := DataSet.FindField('PROTECT');
  if Assigned(Field) then Field.AsInteger := DataLevel;
end;


{      ,  ,
    calculated-  ini- }
procedure TsohoCustomFolder.DoBeforeOpen(DataSet: TDataSet);
var index: Longint;
  IniFieldsList: TStringList;
  FStatus      : string;
begin
  GetRights;
  Compiled := False;
  if Formulas = nil then Formulas := TStringList.Create;
  {Clear Formulas}
  Formulas.Clear;
  if FIni = nil then FIni := TIniFile.Create(FullFolderName);
  {    }
  with DataSet, FieldDefs do begin
    {     DataSet}
    Update;
    {  ,    , 
              TFields}
    for index := 0 to Count - 1 do begin
      if FindField(Items[index].name) = nil then
        Items[index].CreateField(DataSet);
    end;
    IniFieldsList := TStringList.Create;
    FIni.ReadSection('Fields', IniFieldsList);
    for index := 0 to pred(IniFieldsList.Count) do begin
      if (Copy(IniFieldsList[index], 1, 2) = 'CA') then begin
        if (FindField(IniFieldsList[index]) = nil) then
          CreateCalculatedField(DataSet, IniFieldsList[index],
          ftString, 80);
        FStatus := FIni.ReadString(IniFieldsList.Strings[index],
          'Formula', '');
        {    }
        Formulas.Add(IniFieldsList.Strings[index] + ':=' + FStatus);
      end;
    end;
    IniFieldsList.Free;
  end;
  if Assigned(FBeforeOpen) then FBeforeOpen(DataSet);
end;

procedure TsohoCustomFolder.DoAfterOpen(DataSet: TDataSet);
begin
  LoadDataSet;
  if Assigned(FAfterOpen) then FAfterOpen(DataSet);
  Changed;
  Compile;
  FActivated := True;
end;

procedure TsohoCustomFolder.MenuClick(Sender: TObject);
var index: Integer;
  Field: TField;
  
  function FindHiddenField(index: Longint): TField;
  var HdIndex: Longint;
    HdCount: Longint;
  begin
    HdIndex := 0;
    HdCount := 0;
    Result := nil;
    while (HdIndex <= pred(FDataSet.FieldCount)) and (HdCount <= index) do begin
      if not FDataSet.Fields[HdIndex].Visible then inc(HdCount);
      if HdCount > index then Break;
      inc(HdIndex);
    end;
    if HdIndex <= pred(FDataSet.FieldCount) then Result := FDataSet.Fields[HdIndex];
  end;
   begin
  if FSubMenu then index := FItem.IndexOf(TMenuItem(Sender))
  else index := FMenu.Items.IndexOf(TMenuItem(Sender));
  {      , ,   ,
         }
  if index = -1 then begin
    SaveDBGridColumns;
    index := FHiddenFields.IndexOf(TMenuItem(Sender));
    Field := FindHiddenField(index);
    if Field <> nil then Field.Visible := True;
    LoadDBGridColumns;
  end
  else begin
    if index = mLoadFolder then begin
      LoadDataSet;
      exit;
    end;
    SaveDBGridColumns;
    case index of
      mDisplaylabel: SetDisplayLabel;
      mDisplayWidth: SetDisplayWidth;
      mDisplayFormat: SetDisplayFormat;
      mFieldAlign: SetFieldAlign;
      mHideField: begin
        HideField(FGrid.SelectedIndex);
        exit;
      end;
      mCreateField: CreateField;
      mChangeVisible: ChangeVisible;
      mDeleteField: DeleteField;
      mChangeField: ChangeField;
      mSaveFolder: SaveDataSet;
      mTitleLines: SetTitleLines;
      mTitleAlign: SetTitleAlign;
      mCreateRField: CreateRealField;
      mDeleteRField: DeleteRealField;
      mAddLink: AddLink;
      mDeleteLink: DeleteLink;
    end;
    LoadDBGridColumns;
  end;
end;

procedure TsohoCustomFolder.SaveColumn(index: Longint);
var Field: TField;
  Offset: Integer;
begin
  try
    Field := FGrid.Fields[index];
  except exit;
  end;
  if (dgIndicator in FGrid.Options) then Offset := 1
  else Offset := 0;
  if (Field.Visible) and (index + Offset < FGrid.ColCount) then
    FIni.WriteInteger(Field.FieldName, 'GridWidth', FGrid.ColWidths[index + Offset]);
end;

procedure TsohoCustomFolder.LoadColumn(index: Longint);
var Field: TField;
  Offset: Integer;
begin
  try
    Field := FGrid.Fields[index];
  except exit;
  end;
  if (dgIndicator in FGrid.Options) then Offset := 1
  else Offset := 0;
  if Field <> nil then
    if Field.Visible and (index + Offset < FGrid.ColCount) then
      FGrid.ColWidths[index + Offset] := FIni.ReadInteger(Field.FieldName,
      'GridWidth', FGrid.ColWidths[index + Offset]);
end;

procedure TsohoCustomFolder.SaveDBGridColumns;
var index: Longint;
begin
  FCanResize := False;
  for index := 0 to pred(FGrid.FieldCount) do SaveColumn(index);
  FCanResize := True;
end;

procedure TsohoCustomFolder.LoadDBGridColumns;
var index: Longint;
begin
  FCanResize := False;
  for index := 0 to pred(FGrid.FieldCount) do
    try
      LoadColumn(index);
    except
    end;
  FCanResize := True;
end;

procedure TsohoCustomFolder.SaveDataSet;
begin
  if (FGrid = nil) or (csDestroying in FGrid.ComponentState) then exit;
  if FDataSet = nil then SetDataSet;
  if FDataSet = nil then
    raise EsohoFolderException.Create(Format(sohoFolderDataSetUndefined,
      [name]));
  if FullFolderName = '' then
    raise EsohoFolderException.Create(Format(sohoFolderNameUndefined, [name]));
  if not FDataSet.Active then exit;
  SaveDataSetDescription;
  SaveDBGridColumns;
  with FIni do begin
    WriteInteger('Main', 'TitleLines', FGrid.TitleLines);
    WriteInteger('Main', 'TitleAlign', Integer(FGrid.TitleAlignment));
  end;
  if Assigned(FOnSave) then FOnSave(Self, FDataSet);
end;

procedure TsohoCustomFolder.LoadDataSet;
begin
  if FGrid = nil then
    raise EsohoFolderException.Create(Format(sohoFolderLoadDataSetError, [name]));
  if FDataSet = nil then SetDataSet;
  if FDataSet = nil then
    raise EsohoFolderException.Create(Format(sohoFolderDataSetUndefined, [Name]));
  if FullFolderName = '' then
    raise EsohoFolderException.Create(Format(sohoFolderNameUndefined, [Name]));
  if FDataSet.Active then begin
    ApplyDataSetDescription;
    with FIni do begin
      FGrid.TitleLines := ReadInteger('Main', 'TitleLines', FGrid.TitleLines);
      FGrid.TitleAlignment := TAlignment(ReadInteger('Main', 'TitleAlign', Integer(FGrid.TitleAlignment)));
    end;
    LoadDBGridColumns;
    ApplyDataRights(DataReadRights, DataWriteRights);
  end;
  if Assigned(FOnLoad) then FOnLoad(Self, FDataSet);
end;

procedure TsohoCustomFolder.Notification(AComponent: TComponent; aOperation: TOperation);
begin
  if (AComponent = FGrid) and (aOperation = opRemove) then begin
    Activated := False;
    FGrid := nil;
    FDataSet := nil;
  end;
  if (AComponent = FDataSet) and (aOperation = opRemove) then begin
    Activated := False;
    FDataSet := nil;
  end;
  inherited Notification(AComponent, aOperation);
end;

function TsohoCustomFolder.Activate: Boolean;
begin
  Result := False;
  Activated := not Result;
  Result := Activated;
end;

function TsohoCustomFolder.Deactivate: Boolean;
begin
  Result := True;
  Activated := not Result;
  Result := not Activated;
end;

procedure TsohoCustomFolder.Loaded;
begin
  inherited Loaded;
  if FAuto and not (csDesigning in ComponentState) then begin
    SetDataSet;
    SetEvents;
    CreateMenu;
    FActivated := True;
  end;
end;

constructor TsohoCustomFolder.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEventsOur := False;
  FMenuAppend := False;
  FActivated := False;
  FSubMenu := False;
  FAuto := True;
  FFolderDir := '';
  FFolderName := '';
  FMenu := nil;
  FItem := nil;
  FIni := nil;
  Compiled := False;
  Formulas := nil;
  FCanResize := False;
  FEnabledMenus := StrToSet('0-9,11-12,14-15,17-18,20-22');
  FProtectView := true;
  FKeyField := 'Id';
end;

destructor TsohoCustomFolder.Destroy;
begin
  if FAuto then Deactivate;
  if (FEventsOur) and (FDataSet <> nil) then RestoreEvents;
  if FIni <> nil then FIni.Free;
  if Formulas <> nil then Formulas.Free;
  inherited Destroy;
end;

end.

