{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoCtmCmb;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, StdCtrls, Menus, SoUnit, SoTools, DB;

type

  {         .  
      (SQLFile),  ,   
         (TextField),     
     (KeyField),         IdItems.
        DataBaseName  TableName -    
        SQLFile   .   
         ItemId
  }
  TsohoCustomDBComboBox = class(TCustomComboBox)
  private
    { Private declarations }
    FTextField: string;
    FKeyField: string;
    FAutoInsert: Boolean;
    FAutoSelect: Boolean;
    FSQLFile: TSQLFileName;
    FTableName: TFileName;
    FPrepared: Boolean;
    FBeforeOpen: TDataSetNotifyEvent;
    FItemsPreffix : string;

    procedure SetAutoInsert(Value: Boolean);
    procedure SetIdItem(index: Integer; Value: Longint);
    function GetIdItem(index: Integer): Longint;
    procedure SetItemId(Value: Longint);
    function GetItemId: Longint;
    procedure SetAutoSelect(Value: Boolean);
    procedure SetPrepared(Value: Boolean);
    procedure SetSQLFile(Value: TSQLFileName);
  protected
    { Protected declarations }
    function  ActivateSelection (SQLText : TStringList) : TDataSet;virtual; abstract;
    procedure DoInsertSQL (SQLText : TStringList);virtual; abstract;
    procedure PrepareList; virtual;
    function  IndexOfId(Value: Longint): Integer;
    procedure KeyDown (var Key: Word; Shift: TShiftState);override;
    procedure DoExit;override;
    procedure InsertNewItem;virtual;
    procedure DoBeforeOpen (DataSet : TDataSet);virtual;
  public
    constructor Create(AOwner: TComponent); override;
    {   }
    procedure DropDown; override;
    {    }
    procedure Activate;
    {    }
    procedure Deactivate;
    {    .      }
    procedure AddItem(aItemId: Longint; const aItemText: string);
    {       }
    property IdItems[index: Integer]: Longint read GetIdItem write SetIdItem;
    {    }
    property itemID: Longint read GetItemId write SetItemId;
    {   }
    property Active: Boolean read FPrepared write SetPrepared;
    {    TCustomComboBox,    
      published,      ,
       Style    csDropDown }
    property Style;
  published
    {     . . GetNewId }
    property ItemsPreffix : string read FItemsPreffix write FItemsPreffix;
    {  ,        }
    property TextField: string read FTextField write FTextField;
    {  ,          }
    property KeyField: string read FKeyField write FKeyField;
    {  true,           }
    property AutoSelect: Boolean read FAutoSelect write SetAutoSelect default true;
    {       }
    property AutoInsert: Boolean read FAutoInsert write SetAutoInsert default false;
    {    SQL-,     }
    property SQLFile: TSQLFileName read FSQLFile write SetSQLFile;
    {  ,        }
    property TableName: TFileName read FTableName write FTableName;
    property Color;
    property Ctl3D;
    property DragMode;
    property DragCursor;
    property DropDownCount;
    property Enabled;
    property Font;
    property ItemHeight;
    property MaxLength;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Sorted;
    property TabOrder;
    property TabStop;
    property Text;
    property Visible;
    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnDrawItem;
    property OnDropDown;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMeasureItem;
    {      }
    property OnBeforeOpen: TDataSetNotifyEvent read FBeforeOpen write FBeforeOpen;
  end;

implementation
uses SoUtils, SoCtmRgs;

procedure TsohoCustomDBComboBox.DoBeforeOpen (DataSet : TDataSet);
begin
 if Assigned(FBeforeOpen) then FBeforeOpen(DataSet);
end;

procedure TsohoCustomDBComboBox.SetPrepared(Value: Boolean);
begin
  if FPrepared = Value then exit;
  if Value then PrepareList
  else begin
    Items.Clear;
    FPrepared := False;
  end;
end;

procedure TsohoCustomDBComboBox.Activate;
begin
  Active := True;
end;

procedure TsohoCustomDBComboBox.Deactivate;
begin
  Active := False;
end;

procedure TsohoCustomDBComboBox.SetSQLFile(Value: TSQLFileName);
begin
  if FSQLFile = Value then exit;
  Active := False;
  FSQLFile := Value;
end;

procedure TsohoCustomDBComboBox.InsertNewItem;
var Query : TStringList;
    NewId : LongInt;
begin
  if (FTableName = '') or
     (Items.IndexOf(Text)<>-1) or
     (Text = '') then exit;
  Query := TStringList.Create;
  with Query do begin
    try
      if ExtractFileExt(FTableName)<>'' then
        Add('insert into "'+FTableName+'" ('+KeyField+', '+TextField+')')
      else
        Add('insert into '+FTableName+' ('+KeyField+', '+TextField+')');
      repeat
        NewId := GetNewId(FItemsPreffix);
      until IndexOfId(NewId)=-1;
      Add('values ('+IntToStr(NewId)+', "'+Self.Text+'")');
      SetCursor(crHourGlass);
      DoInsertSQL(Query);
      AddItem(NewId, Self.Text);
      ItemId := NewId;
    finally
      RestoreCursor;
      Free;
    end;
  end;
end;

procedure TsohoCustomDBComboBox.DoExit;
begin
  inherited DoExit;
  if FAutoInsert then InsertNewItem;
end;

procedure TsohoCustomDBComboBox.KeyDown (var Key: Word; Shift: TShiftState);
begin
  inherited KeyDown(Key, Shift);
  if (Key = VK_INSERT) and FAutoInsert then InsertNewItem;
end;

procedure TsohoCustomDBComboBox.SetAutoInsert(Value: Boolean);
begin
  // if FAutoInsert = Value then exit;
  FAutoInsert := Value;
  if FAutoInsert then Style := csDropDown
  else Style := csDropDownList;
end;

function TsohoCustomDBComboBox.IndexOfId(Value: Longint): Integer;
begin
  Result := Items.IndexOfObject(TObject(Value));
end;

procedure TsohoCustomDBComboBox.SetIdItem(index: Integer; Value: Longint);
begin
  Items.Objects[index] := TObject(Value);
end;

function TsohoCustomDBComboBox.GetIdItem(index: Integer): Longint;
begin
  Result := Longint(Items.Objects[index]);
end;

procedure TsohoCustomDBComboBox.SetItemId(Value: Longint);
var index: Integer;
begin
  index := IndexOfId(Value);
  if index = -1 then exit;
  ItemIndex := index;
  if Style = csDropDown then Text := Items[index];
end;

function TsohoCustomDBComboBox.GetItemId: Longint;
begin
  Result := -1;
  if ItemIndex = -1 then exit;
  Result := IdItems[ItemIndex];
end;

procedure TsohoCustomDBComboBox.SetAutoSelect(Value: Boolean);
begin
  // if FAutoSelect = Value then exit;
  FAutoSelect := Value;
  {      ,    
          ! }
  if (Items.Count > 0) and (ItemIndex = -1) then ItemID := IdItems[0];
end;

procedure TsohoCustomDBComboBox.AddItem(aItemId: Longint; const aItemText: string);
begin
  Items.AddObject(aItemText, TObject(aItemId));
end;

procedure TsohoCustomDBComboBox.PrepareList;
var Query: TStringList;
    DataSet : TDataSet;
    Reg  : TsohoCustomRegister;
    CanAdd : boolean;
begin
  try
    DataSet := nil;
    Query := TStringList.Create;
    Reg := nil;
    try
      Clear;
      with Query do begin
        Clear;
        if not FileExists(FSQLFile) then
          if SingleRegister<>nil then FSQLFile := SingleRegister.PathToSQL + FSQLFile;
        if FSQLFile <> '' then LoadFromFile(FSQLFile)
        else begin
          if FTableName = '' then begin
            ErrorMsg(name + ':      ,    !');
            Query.Free;
            exit;
          end;
          if ExtractFileExt(FTableName)<>'' then
            Add('select ' + FKeyField + ', ' + FTextField + ' from "' + FTableName + '"')
          else
            Add('select ' + FKeyField + ', ' + FTextField + ' from ' + FTableName);
        end;
        DataSet := ActivateSelection(Query);
        if DataSet = nil then begin
          Query.Free;
          exit;
        end;
        if DataSet.FindField('PROTECT')<>nil then Reg := SingleRegister;
        CanAdd := true;
        while not DataSet.EOF do begin
          {     }
          if Reg<>nil then
            CanAdd := (DataSet.FieldByName('PROTECT').AsInteger in Reg.DataReadRights);
          if CanAdd then AddItem(DataSet.FieldByName(FKeyField).AsInteger,
                                 DataSet.FieldByName(FTextField).AsString);
          DataSet.Next;
        end;
        DataSet.Close;
      end;
      FPrepared := True;
      if FAutoSelect then
        if (Items.Count > 0) and (ItemIndex = -1) then ItemID := IdItems[0];
    except
    end;
  finally
    Query.Free;
    if DataSet <> nil then DataSet.Free;
  end;
end;

constructor TsohoCustomDBComboBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FTextField := 'Name';
  FKeyField := 'Id';
  FAutoInsert := false;
  FAutoSelect := true;
  FSQLFile := '';
  FTableName := '';
  FPrepared := False;
  Style := csDropDownList;
end;

procedure TsohoCustomDBComboBox.DropDown;
begin
  inherited DropDown;
end;

end.

