{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoCtlPrp;

{$I SOHOLIB.INC}

interface
uses DsgnIntf;

type

  TsohoListBoxItems = class (TClassProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TsohoStringGridEditor = class (TComponentEditor)
    function  GetVerbCount : integer; override;
    function  GetVerb (Index : integer) : string; override;
    procedure ExecuteVerb (Index : integer);override;
  end;

implementation
uses SysUtils, Controls, Forms, SoBrEd, Classes, SoGrdEd,
     Grids, SoGrids, SoUtils, SoCtrls;

{ TsohoListBoxItems }
procedure TsohoListBoxItems.Edit;
var WizLBEditorForm : TWizLBEditorForm;
begin
     WizLBEditorForm := TWizLBEditorForm.Create(Application);
     try
        with (GetComponent(0) as TsohoListBox) do begin
           WizLBEditorForm.wPreview.Items.Assign(TStrings(GetOrdValue));
           WizLBEditorForm.wPreview.Color := Color;
           WizLBEditorForm.wPreview.LeftField  := LeftField;
           WizLBEditorForm.wPreview.RightField := RightField;
        end;
        if WizLBEditorForm.ShowModal=mrOk then begin
          SetOrdValue(Longint(WizLBEditorForm.wPreview.Items));
        end;
     finally
        WizLBEditorForm.Free;
     end;
end;

function TsohoListBoxItems.GetAttributes: TPropertyAttributes;
begin
     Result := [paDialog];
end;

{ TsohoStringGridEditor }
function TsohoStringGridEditor.GetVerbCount : integer;
begin
     Result := 1;
end;

function TsohoStringGridEditor.GetVerb (Index : integer) : string;
begin
     case Index of
       0 : Result := '&Edit the grid';
     end;
end;

procedure TsohoStringGridEditor.ExecuteVerb (Index : integer);
var GridEditorForm: TGridEditorForm;
begin
     try
        GridEditorForm := TGridEditorForm.Create(Application);
        GridEditorForm.Prepare(TsohoStringGrid(Component).ColCount,
                               TsohoStringGrid(Component).RowCount);
        GridEditorForm.CopyFrom(TsohoStringGrid(Component));
        if Component is TsohoStringGrid then GridEditorForm.vGrid.PopupMenu :=
             GridEditorForm.AlignMenu
        else GridEditorForm.vGrid.PopupMenu := nil;
        if GridEditorForm.ShowModal = mrOk then begin
           GridEditorForm.CopyTo(TsohoStringGrid(Component));
           Designer.Modified;
        end;
     finally
        GridEditorForm.Free;
     end;
end;

end.
