{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoCrFldF;

{$I SOHOLIB.INC}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, RXSpin, StdCtrls, SoCtrls, SoTools, SohoBtns, StrHlder;

type

  TCreateFieldForm = class(TForm)
    sohoLabel1: TsohoLabel;
    sohoLabel2: TsohoLabel;
    sohoLabel3: TsohoLabel;
    sohoLabel4: TsohoLabel;
    NameE: TsohoEdit;
    TypeC: TComboBox;
    LengthE: TRxSpinEdit;
    SQLE: TsohoEdit;
    sohoBitBtn1: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    sohoEnterTab1: TsohoEnterTab;
    RealTypes: TStrHolder;
    procedure NameEChange(Sender: TObject);
    procedure NameECanExit(Sender: TObject; var AllowExit: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var CreateFieldForm: TCreateFieldForm;

function CreateNewField (var SQLCommand : string) : boolean;

implementation

{$R *.DFM}

function CreateNewField (var SQLCommand : string) : boolean;
begin
     try
        CreateFieldForm := TCreateFieldForm.Create(Application);
        CreateFieldForm.TypeC.ItemIndex := 0;
        Result := CreateFieldForm.ShowModal=mrOk;
        if Result then SQLCommand := CreateFieldForm.SQLE.AsString;
     finally
        CreateFieldForm.Free;
     end;
end;

procedure TCreateFieldForm.NameEChange(Sender: TObject);
begin
     LengthE.Enabled := TypeC.Text = '';
     SQLE.AsString := NameE.AsString+' '+RealTypes.Strings[TypeC.ItemIndex];
     if LengthE.Enabled then SQLE.AsString := SQLE.AsString+' ('+LengthE.Text+')';
end;

procedure TCreateFieldForm.NameECanExit(Sender: TObject;  var AllowExit: Boolean);
begin
     AllowExit := (NameE.AsString<>'') or (ActiveControl = CancelB);
end;

end.
