{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoBrEd;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, Dialogs, StdCtrls, SoCtrls, ExtCtrls, Buttons, SoBrLn,
     SohoBtns, Placemnt, SoTools, DsgnIntf;

type

  TWizLBEditor = class (TComponentEditor)
    function GetVerbCount : integer; override;
    function GetVerb (Index : integer) : string; override;
    procedure ExecuteVerb (Index : integer);override;
  end;

  TWizLBEditorForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    wPreview: TsohoListBox;
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    AddB: TsohoBitBtn;
    InsertB: TsohoBitBtn;
    DeleteB: TsohoBitBtn;
    EditB: TsohoBitBtn;
    Ini: TFormStorage;
    procedure InsertBClick(Sender: TObject);
    procedure DeleteBClick(Sender: TObject);
    procedure EditBClick(Sender: TObject);
    procedure wPreviewKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{======================Editor registration======================}
function TWizLBEditor.GetVerbCount : integer;
begin
     Result:=1;
end;

function TWizLBEditor.GetVerb (Index : integer) : string;
begin
     Result:='External editor';
end;

procedure TWizLBEditor.ExecuteVerb (Index : integer);
var WizLBEditorForm : TWizLBEditorForm;
    procedure CopyListBox (Dest, Source : TsohoListBox);
    begin
         Dest.Color      := Source.Color;
         Dest.LeftField  := Source.LeftField;
         Dest.RightField := Source.RightField;
         Dest.Items.Assign(Source.Items);
    end;
begin
     WizLBEditorForm := TWizLBEditorForm.Create(Application);
     try
        CopyListBox(WizLBEditorForm.wPreview,Component as TsohoListBox);
        WizLBEditorForm.Caption:=Component.Owner.Name+'.'+
         Component.Name+' - Component Editor';
        if WizLBEditorForm.ShowModal=mrOk then begin
            CopyListBox(Component as TsohoListBox, WizLBEditorForm.wPreview);
            Designer.Modified;
        end;
     finally
        WizLBEditorForm.Free;
     end;
end;

{$R *.DFM}

procedure TWizLBEditorForm.InsertBClick(Sender: TObject);
var V : TsohoLBText;
    tmp : string;
    StringEditForm: TStringEditForm;
begin
     StringEditForm := TStringEditForm.Create(self);
     with StringEditForm do begin
        TextE.Text:='';
        TextAlignG.ItemIndex:=0;
        ImageAlignG.ItemIndex:=0;
        ImageG.ItemIndex:=0;
        IDSpin.Value:=1;
        IDSpin.Enabled:=false;
        KeyB.Checked:=false;
        if ShowModal=mrOk then begin
            V.Text       := TextE.Text;
            V.FontName   := FontDialog.Font.Name;
            V.FontStyle  := FontDialog.Font.Style;
            V.FontSize   := FontDialog.Font.Size;
            V.FontColor  := FontDialog.Font.Color;
            case TextAlignG.ItemIndex of
                 0 : V.FontAlign  := walCenter;
                 1 : V.FontAlign  := walLeft;
                 2 : V.FontAlign  := walRight;
            end;
            case ImageG.ItemIndex of
                 0 : V.ImageID    := 0;
                 1 : V.ImageID    := IDSpin.Value;
            end;
            case ImageAlignG.ItemIndex of
                 0 : V.ImageAlign  := walCenter;
                 1 : V.ImageAlign  := walLeft;
                 2 : V.ImageAlign  := walRight;
            end;
            V.Key        := KeyB.Checked;
            tmp := wPreview.TextToString(V);
            if wPreview.ItemIndex=-1 then wPreview.ItemIndex:=0;
            if (Sender as TsohoBitBtn).Tag=1 then wPreview.Items.Add(tmp)
            else wPreview.Items.Insert(wPreview.ItemIndex,tmp);
        end;
     end;
    StringEditForm.Free;
end;

procedure TWizLBEditorForm.DeleteBClick(Sender: TObject);
begin
     if wPreview.ItemIndex=-1 then exit;
     if MessageDlg('Are you sure?',mtConfirmation,[mbYes,mbNo],0)=mrYes then
       wPreview.Items.Delete(wPreview.ItemIndex);
end;

procedure TWizLBEditorForm.EditBClick(Sender: TObject);
var V   : TsohoLBText;
    tmp : string;
    StringEditForm: TStringEditForm;
    Ind : integer;
begin
     if wPreview.ItemIndex=-1 then exit;
     tmp:=wPreview.Items.Strings[wPreview.ItemIndex];
     wPreview.StringToText(tmp,V);
     StringEditForm := TStringEditForm.Create(self);
     with StringEditForm do begin
        TextE.Text:=V.Text;
        FontDialog.Font.Name  := V.FontName;
        FontDialog.Font.Style := V.FontStyle;
        FontDialog.Font.Size  := V.FontSize;
        FontDialog.Font.Color := V.FontColor;
        case V.FontAlign of
             walCenter : TextAlignG.ItemIndex := 0;
             walLeft   : TextAlignG.ItemIndex := 1;
             walRight  : TextAlignG.ItemIndex := 2;
        end;
        case V.ImageAlign of
             walCenter : ImageAlignG.ItemIndex := 0;
             walLeft   : ImageAlignG.ItemIndex := 1;
             walRight  : ImageAlignG.ItemIndex := 2;
        end;
        IDSpin.Value  :=1;
        IDSpin.Enabled:=false;
        case V.ImageID of
             0 : ImageG.ItemIndex:=0;
             else begin
                 ImageG.ItemIndex :=1;
                 IDSpin.Value     :=V.ImageID;
                 IDSpin.Enabled   :=true;
             end;
        end;
        KeyB.Checked:=V.Key;
        if ShowModal=mrOk then begin
           V.Text       := TextE.Text;
           V.FontName   := FontDialog.Font.Name;
           V.FontStyle  := FontDialog.Font.Style;
           V.FontSize   := FontDialog.Font.Size;
           V.FontColor  := FontDialog.Font.Color;
           case TextAlignG.ItemIndex of
                0 : V.FontAlign  := walCenter;
                1 : V.FontAlign  := walLeft;
                2 : V.FontAlign  := walRight;
           end;
           case ImageG.ItemIndex of
                0 : V.ImageID    := 0;
                1 : V.ImageID    := IDSpin.Value;
           end;
           case ImageAlignG.ItemIndex of
                0 : V.ImageAlign  := walCenter;
                1 : V.ImageAlign  := walLeft;
                2 : V.ImageAlign  := walRight;
           end;
           V.Key        := KeyB.Checked;
           tmp := wPreview.TextToString(V);
           ind := wPreview.ItemIndex;
           wPreview.Items.Insert(Ind,tmp);
           wPreview.Items.Delete(Ind+1);
        end;
     end;
     StringEditForm.Free;
end;

procedure TWizLBEditorForm.wPreviewKeyDown(Sender: TObject; var Key: Word;
          Shift: TShiftState);
begin
     case Key of
          vk_Insert : InsertBClick(InsertB);
          vk_Return : EditBClick(EditB);
          vk_Delete : DeleteBClick(DeleteB);
     end;
     if Key in [vk_Insert,vk_Return,vk_Delete] then Key := $00;
end;

begin
     {,       IDE Delphi?}
     Application.HintColor := clAqua;
end.
