{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoBackground,   ""
     
}
unit SoBckgrd;

{$I SOHOLIB.INC}

interface
uses WinTypes, WinProcs, Forms, Classes, Graphics, Controls, SysUtils,
     Messages, SoTools;

type

  ENonFormOwner = class(Exception);

  {  :
    fmTiles   -  (    )
    fmCenter  -     
    fmStretch -       
  }
  TBitmapFillMode = (fmTiles, fmCenter, fmStretch);

  {    OnPaint  TsohoBackground. 
    Canvas          }
  TsohoOnPaint = procedure (Sender : TObject; Canvas : TCanvas) of object;

  {        
    .     :   Bitmap,
          ( FileName).  
    ,      run-time.  
       ,    , FormStyle   fsMDIForm }
  TsohoBackground = class(TComponent)
  private
    { Private declarations }
    OwnerWndProc: TFarProc;
    MyWndProc: TFarProc;
    FGrabbed: boolean;
    FBitmap: TBitmap;
    FFileName: TFileName;
    FMode: TBitmapFillMode;
    FHookedHandle: THandle;
    FSet: boolean;
    FOnPaint : TsohoOnPaint;
    FDraw : boolean;
    procedure SetFileName   (Value : TFileName);
    procedure SetBitmap     (Value : TBitmap);
    procedure BitmapChanged (Sender : TObject);
    procedure SetDraw (Value : boolean);
  protected
    { Protected declarations }
    procedure DoPaint (Canvas : TCanvas);virtual;
    procedure CreateTiledBitmap   (Dest : TBitmap);virtual;
    procedure CreateCenterBitmap  (Dest : TBitmap);virtual;
    procedure CreateStretchBitmap (Dest : TBitmap);virtual;
    procedure FreeHandlerHook; virtual;
    procedure WNDPROC(var Msg: TMessage); virtual;
    procedure DefaultHandler(var Msg); override;
    procedure WMDestroy(var Msg: TWMDestroy); message WM_DESTROY;
    procedure WMSize(var Msg: TWMSize); message WM_Size;
    procedure WMEraseBkgnd(var message: TWMEraseBkgnd); message WM_ERASEBKGND;
    procedure WMPaint (var message: TMessage); message WM_Paint;
    procedure Loaded; override;
  public
    {      }
    procedure HookPaint;virtual;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {      }
    property  Draw : boolean read FDraw write SetDraw;
  published
    {     }
    property FillMode : TBitmapFillMode read FMode write FMode default fmCenter;
    { ,        }
    property Bitmap   : TBitmap read FBitmap write SetBitmap;
    {  ,      }
    property FileName : TFileName read FFileName write SetFileName;
    {        .  
         -    }
    property OnPaint  : TsohoOnPaint read FOnPaint write FOnPaint;
  end;

var
  {    ,     .
       ImagesDir   FileName  TsohoBackground 
       ,    }
  ImagesDir : TDirName;

implementation
uses SoUtils, IniFiles, AppUtils, Jpeg, RxGif, SoCmnCns;

procedure TsohoBackground.SetDraw (Value : boolean);
begin
  if FDraw = Value then exit;
  FDraw := Value;
  InvalidateRect(FHookedHandle, nil, True);
end;

procedure TsohoBackground.WMPaint (var message: TMessage);
begin
  if FGrabbed and
     ((Owner as TForm).FormStyle = fsMDIForm) then InvalidateRect(FHookedHandle, nil, True);
  inherited;
end;

procedure TsohoBackground.WMSize(var Msg: TWMSize);
begin
  inherited;
  if FGrabbed then InvalidateRect(FHookedHandle, nil, True);
end;

procedure TsohoBackground.BitmapChanged (Sender : TObject);
begin
  if csLoading in ComponentState then exit;
  if FGrabbed then InvalidateRect(FHookedHandle, nil, True);
end;

procedure TsohoBackground.SetFileName (Value : TFileName);
var Ext : string;
    JpgImage : TJpegImage;
    GifImage : TGifImage;
begin
  if FFileName = Value then exit;
  Ext := StrUpper(ExtractFileExt(Value));
  FFileName := Value;
  if ImagesDir<>'' then FFileName := ImagesDir + FFileName;
  if (FSet and (csLoading in ComponentState)) or
     (csDesigning in ComponentState) then exit;
  if not FileExists(FFileName) then begin
    FBitmap.Assign(nil);
    exit;
  end;
  // Bmp?
  if Ext = '.BMP' then FBitmap.LoadFromFile(FFileName);
  // Jpeg?
  if (Ext = '.JPG') or (Ext = '.JPEG') then begin
    JpgImage := TJpegImage.Create;
    JpgImage.LoadFromFile(FFileName);
    FBitmap.Assign(JpgImage);
    JpgImage.Free;
  end;
  // Gif?
  if Ext = '.GIF' then begin
    GifImage := TGifImage.Create;
    GifImage.LoadFromFile(FFileName);
    FBitmap.Assign(GifImage);
    GifImage.Free;
  end;
end;

procedure TsohoBackground.SetBitmap (Value : TBitmap);
begin
  FBitmap.Assign(Value);
  if Value<>nil then FSet := true;
end;

constructor TsohoBackground.Create(AOwner: TComponent);
begin
  if not (AOwner is TForm) then
    raise ENonFormOwner.Create(sohoOwnerMustBeWindow);
  inherited Create(AOwner);
  FGrabbed := False;
  FSet := false;
  FFileName := '';
  FMode := fmCenter;
  FBitmap := TBitmap.Create;
  FBitmap.OnChange := BitmapChanged;
  FDraw := true;
end;

procedure TsohoBackground.HookPaint;
begin
  if FGrabbed then exit;
  with (Owner as TForm) do begin
    if FormStyle = fsMDIForm then FHookedHandle := ClientHandle
    else FHookedHandle := Handle;
  end;
  OwnerWndProc := TFarProc(GetWindowLong(FHookedHandle, GWL_WNDPROC));
  MyWndProc := MakeObjectInstance(WNDPROC);
  SetWindowLong(FHookedHandle, GWL_WNDPROC, Longint(MyWndProc));
  FGrabbed := True;
end;

procedure TsohoBackground.Loaded;
begin
  inherited Loaded;
  if (csDesigning in ComponentState) then exit;
  with TIniFile.Create(GetDefaultIniName) do begin
    FDraw := ReadBool(GetOwnerForm(Self).ClassName, 'DrawBackground', true);
    Free;
  end;
  HookPaint;
end;

procedure TsohoBackground.FreeHandlerHook;
begin
  SetWindowLong(FHookedHandle, GWL_WNDPROC, Longint(OwnerWndProc));
  FGrabbed := False;
end;

destructor TsohoBackground.Destroy;
begin
  if FGrabbed then FreeHandlerHook;
  FreeObjectInstance(MyWndProc);
  FBitmap.Free;
  inherited Destroy;
end;

procedure TsohoBackground.WMDestroy(var Msg: TWMDestroy);
begin
  if FGrabbed then FreeHandlerHook;
  inherited;
end;

procedure TsohoBackground.WNDPROC(var Msg: TMessage);
begin
  if Msg.Result = 0 then Dispatch(Msg);
end;

procedure TsohoBackground.DefaultHandler(var Msg);
begin
  with TMessage(Msg) do
    Result := CallWindowProc(OwnerWndProc, (Owner as TWinControl).Handle,
    Msg, WPARAM, LPARAM);
end;

procedure TsohoBackground.CreateTiledBitmap (Dest : TBitmap);
var I, J: Integer;
    CopyRect : TRect;
begin
  if (FBitmap.Width=0) or (FBitmap.Height=0) then exit;
  for I := 0 to Round(Dest.Width / FBitmap.Width) do
    for J := 0 to Round(Dest.Height / FBitmap.Height) do begin
      with CopyRect do begin
        Left := I * FBitmap.Width;
        Top := J * FBitmap.Height;
        Right := Left + FBitmap.Width;
        if Right > Dest.Width then Right := Dest.Width;
        Bottom := Top + FBitmap.Height;
        if Bottom > Dest.Height then Bottom := Dest.Height;
      end;
      //Dest.Canvas.CopyMode := cmSrcCopy;
      Dest.Canvas.CopyRect(CopyRect, FBitmap.Canvas,
        Bounds(0, 0, CopyRect.Right - CopyRect.Left,
        CopyRect.Bottom - CopyRect.Top));
    end;
end;

procedure TsohoBackground.CreateCenterBitmap (Dest : TBitmap);
var X, Y : integer;
    CopyRect : TRect;
begin
  CopyRect := (Owner as TForm).ClientRect;
  Dest.Canvas.Brush.Color := (Owner as TForm).Color;
  Dest.Canvas.FillRect(CopyRect);
  X:= (Dest.Width - FBitmap.Width) div 2;
  Y:= (Dest.Height - FBitmap.Height) div 2;
  Dest.Canvas.Draw(X, Y, FBitmap);
end;

procedure TsohoBackground.CreateStretchBitmap (Dest : TBitmap);
var CopyRect : TRect;
begin
  if (FBitmap.Width=0) or (FBitmap.Height=0) then exit;
  Dest.Canvas.CopyMode := cmSrcCopy;
  CopyRect := (Owner as TForm).ClientRect;
  Dest.Canvas.StretchDraw(CopyRect, FBitmap);
end;

procedure TsohoBackground.DoPaint (Canvas : TCanvas);
begin
  if Assigned(FOnPaint) then FOnPaint(Self, Canvas);
end;

procedure TsohoBackground.WMEraseBkgnd(var message: TWMEraseBkgnd);
var DestRect: TRect;
    MemBmp  : TBitmap;
    TmpCanvas : TCanvas;
begin
  try
    MemBmp := TBitmap.Create;
    if ((FBitMap.Width = 0) or (FBitMap.Height = 0)) or (not FDraw) then begin
       inherited;
       TmpCanvas := TCanvas.Create;
       TmpCanvas.Handle := Message.DC;
       DoPaint(TmpCanvas);
       TmpCanvas.Free;
    end
    else begin
      if (Owner as TForm).FormStyle<>fsMDIForm then
        with DestRect do begin
          Left   := 0;
          Top    := 0;
          Right  := (Owner as TForm).ClientWidth;
          Bottom := (Owner as TForm).ClientHeight;
        end
      else GetClipBox(Message.DC, DestRect);
      MemBmp.Width := (DestRect.Right - DestRect.Left);
      MemBmp.Height := (DestRect.Bottom - DestRect.Top);
      case FMode of
        fmTiles   : CreateTiledBitmap(MemBmp);
        fmCenter  : CreateCenterBitmap(MemBmp);
        fmStretch : CreateStretchBitmap(MemBmp);
      end;
      DoPaint(MemBmp.Canvas);
      BitBlt(Message.DC, DestRect.Left, DestRect.Top,
          (DestRect.Right - DestRect.Left), (DestRect.Bottom - DestRect.Top),
          MemBmp.Canvas.Handle, DestRect.Left, DestRect.Top, SRCCOPY);
      Message.Result := 1;
    end;
  finally
    MemBmp.Free;
  end;
end;

end.

