{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{              Written by Allex, VSM                    }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoBDERtn;

{$I SOHOLIB.INC}

interface
uses Classes, DB, DBTables, SoTools, SysUtils;

type

  {    SQL  : ,  
     }
  TsohoSQLQueryMode = (qmNull, qmLocal, qmServer);
  {   : -,   }
  TsohoOpenMode = (omReadWrite, omReadOnly);
  TsohoPassThroughMode = (tmSharedAutocommit, tmSharedNoAutoCommit, tmNotShared);

  {    }
  TsohoAliasInfo = record
    ServerName: string;
    DefaultDriver: string;
    Path: string;
    DefaultUserName: string;
    OpenMode: TsohoOpenMode;
    SchemaCacheSize: 0..32;
    LanguageDriver: string;
    SQLQueryMode: TsohoSQLQueryMode;
    SQLPassThroughMode: TsohoPassThroughMode;
    SchemaCacheTime: Longint;
    MaxRows: Longint;
    BatchCount: Longint;
    EnableSchemaCache: boolean;
    SchemaCacheDir: string;
    EnableBCD: boolean;
    BlobsToCache: 64..65536;
    BlobSize: 32..1000;
  end;

{     }
function GetAliasInfo(AliasName: string): TsohoAliasInfo;
{      . SQLFile -    
  SQL-, aDataBaseName -    , SQLParams -  
  ,      .    
    @1,@2   .   ,   
  RoutinesQuiet = true,   -  . 
     ,       .
  ,     , , ,    
   : "@1"}
function GetSQLResult(const SQLfile: TFileName; const aDataBaseName: string;
  SQLParams: array of string): string;
{       TQuery. SQLFile -    
  SQL-, aDataBaseName -    , SQLParams -  
  ,      .    
    @1,@2   .   ,   
  RoutinesQuiet = true,   -  . 
     ,       .
  ,     , , ,    
   : "@1"}
function GetQuery(const SQLfile: TFileName; const aDataBaseName: string;
  SQLParams: array of string): TQuery;
{   GetSQLResult,   ,     }
function GetCheckSQLResult(const SQLfile: TFileName; const aDataBaseName: string;
  SQLParams: array of string; var Null: boolean): string;
{     .      
  GetSQLResult }
function ExecuteSQL(const SQLfile: TFileName; const aDataBaseName: string;
  SQLParams: array of string): boolean;
{  ExecuteSQL,   ,        }
function ExecuteSQLText(const SQLText: string; const aDataBaseName: string;
  SQLParams: array of string): boolean;
{   ExecuteSQL.    , ExecuteSQL  
    Insert, Update  Delete,     
      Select }
function OpenQueryWithParams (Query : TQuery; const SQLFile : string;
  SQLParams: array of string) : boolean;

{ ,  aa    }
function PutParameteres(SQL: TStringList; Params: array of string): boolean;
{       SQL- }
function GetFieldSQLSumm(const TableName, FieldName: string): Double;

{  ,   DataSet }
function CreateTableByDataSet(DataSet: TDataSet; const NewTableName: string): boolean;
{  SQL,   ,   DataSet.
        ResultSQLFile.  ,
   Create = true,       }
function CreateTableByDataSetWithSave(DataSet: TDataSet; const NewTableName,
  ResultSQLFile: string; Create: boolean): boolean;

{   aFieldName  aFieldType   aTableName }
function AddFieldToTable(const aDataBaseName, aTableName, aFieldName: string;
  aFieldType: TFieldType; aFieldLen: Longint): boolean;

{   ,  CopyDataSetToDataSet.  . 
   ,       ,  , 
          .   ,  
        }
function JoinTables(FromD, ToD: TDataSet; const ToDataBaseName, ToTableName,
  KeyField: string): boolean;

const
  {      ,   
       SQL-,   
     .         
     }
  NillParams: array[0..0] of string = ('NILLPARAMS');

var
  {    true     , 
             }
  RoutinesQuiet       : boolean;

  {  true,          }
  ShowSQLBeforeExecute: boolean;


implementation
uses SoDBRtn, SoDate, SoCtmRgs, Windows, SoDBCns, SoUtils;

function PutParameteres(SQL: TStringList; Params: array of string): boolean;
var index: Longint;
  CurInd: Longint;
  CurPos: Longint;
  Tmp   : string;

  function FindParams(var IndexOfString, ParamPos: Longint): boolean;
  var StrIndex: Integer;
  begin
    Result := True;
    for StrIndex := 0 to pred(SQL.Count) do begin
      IndexOfString := StrIndex;
      ParamPos := Pos('@' + IntToStr(index + 1), SQL[StrIndex]);
      if ParamPos <> 0 then exit;
    end;
    Result := False;
  end;
  
  procedure SetSpecialParams;
  const
    SpecParams: array[1..4] of string = (
      'MDFDATE', 'MDFTIME', 'IDMDFAUTH', 'PROTECT'
      );
  var ParamPos,
    SpecIndex: Integer;
    StrIndex : Integer;
    Value    : string; 
  begin
    for StrIndex := 0 to pred(SQL.Count) do
      for SpecIndex := 1 to 4 do begin
        Tmp := StrUpper(SQL[StrIndex]);
        ParamPos := Pos('@' + SpecParams[SpecIndex], Tmp);
        if ParamPos <> 0 then begin
          Tmp := SQL[StrIndex];
          case SpecIndex of
            1: Value := DateToSQLDate(Date);
            2: Value := '"' + TimeToStr(SysUtils.Time) + '"';
            3: if SingleRegister <> nil then
              Value := IntToStr(SingleRegister.UserId)
            else Value := '0';
            4: if SingleRegister <> nil then
              Value := IntToStr(SingleRegister.DataLevel)
            else Value := '0';
          end;
          Tmp := Copy(Tmp, 1, ParamPos - 1) + Value + Copy(Tmp, ParamPos +
            Length('@' + SpecParams[SpecIndex]), Length(Tmp));
          SQL[StrIndex] := Tmp;
        end;
      end;
  end;
begin
  Result := False;
  if Params[Low(Params)] = NillParams[0] then begin
    Result := True;
    exit;
  end;
  for index := Low(Params) to High(Params) do
    if not FindParams(CurInd, CurPos) then exit
    else begin
      Tmp := SQL[CurInd];
      Tmp := Copy(Tmp, 1, CurPos - 1) + Params[index] + Copy(Tmp, CurPos +
        Length('@' + IntToStr(index + 1)), Length(Tmp));
      SQL[CurInd] := Tmp;
    end;
  SetSpecialParams; {16/10/98}
  if ShowSQLBeforeExecute then begin
    SQL.SaveToFile(GetPathToTemp + 'CURSQL.SQL');
    WinExec('notepad.exe CURSQL.SQL', SW_SHOWNORMAL);
  end;
  Result := True;
end;

function GetCheckSQLResult(const SQLfile: TFileName; const aDataBaseName: string;
    SQLParams: array of string; var Null: boolean): string;
var TmpQ: TQuery;
begin
  Result := '';
  try
    TmpQ := TQuery.Create(nil);
    with TmpQ, SQL do begin
      DataBaseName := aDataBaseName;
      LoadFromFile(SQLfile);
      if (not PutParameteres(TStringList(SQL), SQLParams)) and
        (not RoutinesQuiet) then begin
        ErrorMsg(Format(sohoBDERtnTooManyParams,[SQLfile]));
      end
      else
        try
          SetCursor(crHourGlass);
          Open;
          Null := Fields[0].IsNull;
          Result := Fields[0].AsString;
        except
          on E: Exception do begin
              TStringList(SQL).SaveToFile(GetPathToLocalTemp+'error.sql');
              ErrorMsg(Format(sohoBDERtnOpenError, [SQLfile, E.message]));
          end;
        end;
    end;
  finally
    TmpQ.Free;
    RestoreCursor;
  end;
end;

function GetSQLResult;
var Null: boolean;
begin
  Result := GetCheckSQLResult(SQLfile, aDataBaseName, SQLParams, Null);
end;

function GetQuery;
begin
  Result := TQuery.Create(nil);
  with Result, SQL do begin
    DataBaseName := aDataBaseName;
    LoadFromFile(SQLfile);
    if (not PutParameteres(TStringList(SQL), SQLParams)) and
      (not RoutinesQuiet) then begin
      ErrorMsg(Format(sohoBDERtnTooManyParams,[SQLfile]));
    end
    else
      try
        SetCursor(crHourGlass);
        Open;
      except
        on E: Exception do begin
            TStringList(SQL).SaveToFile(GetPathToLocalTemp+'error.sql');
            RestoreCursor;
            ErrorMsg(Format(sohoBDERtnOpenError, [SQLfile, E.message]));
            Result.Free;
            Result := nil;
          end
      end;
  end;
  RestoreCursor;
end;

function OpenQueryWithParams (Query : TQuery; const SQLFile : string;
  SQLParams: array of string) : boolean;
begin
  with Query, SQL do begin
    Close;
    LoadFromFile(SQLfile);
    if (not PutParameteres(TStringList(SQL), SQLParams)) and
      (not RoutinesQuiet) then begin
      ErrorMsg(Format(sohoBDERtnTooManyParams,[SQLfile]));
    end
    else
      try
        SetCursor(crHourGlass);
        Open;
      except
        on E: Exception do begin
            TStringList(SQL).SaveToFile(GetPathToLocalTemp+'error.sql');
            RestoreCursor;
            ErrorMsg(Format(sohoBDERtnOpenError, [SQLfile, E.message]));
          end
      end;
  end;
  RestoreCursor;
end;

function ExecuteSQL;
var TmpQ: TQuery;
begin
  Result := False;
  try
    TmpQ := TQuery.Create(nil);
    with TmpQ, SQL do begin
      DataBaseName := aDataBaseName;
      LoadFromFile(SQLfile);
      if (not PutParameteres(TStringList(SQL), SQLParams)) and
        (not RoutinesQuiet) then begin
        ErrorMsg(Format(sohoBDERtnTooManyParams,[SQLfile]));
      end
      else
        try
          SetCursor(crHourGlass);
          ExecSQL;
          Result := True;
        except
          on E: Exception do begin
              TStringList(SQL).SaveToFile(GetPathToLocalTemp+'error.sql');
              if not RoutinesQuiet then
                ErrorMsg(Format(sohoBDERtnOpenError, [SQLfile, E.message]));
             raise;
          end;
        end;
    end;
  finally
    TmpQ.Free;
    RestoreCursor;
  end;
end;

function ExecuteSQLText(const SQLText: string; const aDataBaseName: string;
  SQLParams: array of string): boolean;
var TmpQ: TQuery;
begin
  Result := False;
  try
    TmpQ := TQuery.Create(nil);
    with TmpQ, SQL do begin
      DataBaseName := aDataBaseName;
      SQL.Text := SQLText;
      if (not PutParameteres(TStringList(SQL), SQLParams)) and
        (not RoutinesQuiet) then begin
        ErrorMsg(Format(sohoBDERtnTooManyParams,[SQLText]));
      end
      else
        try
          SetCursor(crHourGlass);
          ExecSQL;
          Result := True;
        except
          on E: Exception do begin
              TStringList(SQL).SaveToFile(GetPathToLocalTemp+'error.sql');
              if not RoutinesQuiet then
                ErrorMsg(Format(sohoBDERtnOpenError, [SQLText, E.message]));
             raise;
          end;
        end;
    end;
  finally
    TmpQ.Free;
    RestoreCursor;
  end;
end;

function GetFieldSQLSumm(const TableName, FieldName: string): Double;
var Query: TQuery;
  Tmp  : string;
  Error: boolean;
begin
  Result := 0;
  try
    Query := TQuery.Create(nil);
    with Query, SQL do begin
      DataBaseName := ExtractFilePath(TableName);
      Add('select SUM(' + FieldName + ') from "' + ExtractFileName(TableName) + '"');
      try
        SetCursor(crHourGlass);
        ExecSQL;
        Tmp := Fields[0].AsString;
        if Tmp <> '' then Result := WStrToFloat(Tmp, Error);
      except
        on E: Exception do
            ErrorMsg(Format(sohoBDERtnSummError, [FieldName, TableName, E.message]));
      end;
    end;
  finally
    Query.Free;
    RestoreCursor;
  end;
end;

function JoinTables(FromD, ToD: TDataSet; const ToDataBaseName, ToTableName,
    KeyField: string): boolean;
var CheckQ: TQuery;
  DoAppend: boolean;
begin
  Result := False;
  try
    CheckQ := TQuery.Create(nil);
    with CheckQ, SQL do begin
      DataBaseName := ToDataBaseName;
      Add('select '+KeyField+' from "' + ToTableName + '" where '+KeyField+'=:Id');
    end;
    while not FromD.EOF do begin
      DoAppend := KeyField = '';
      if not DoAppend then begin
        CheckQ.Params[0].AsInteger := FromD.FieldByName(KeyField).AsInteger;
        try
          CheckQ.Open;
          {     -   ! }
          DoAppend := CheckQ.Fields[0].IsNull;
          CheckQ.Close;
        except
          on E: Exception do begin
              ErrorMsg(Format(sohoBDERtnRowSearchError, [ToTableName, KeyField,
                FromD.FieldByName(KeyField).AsString, E.message]));
              CheckQ.Free;
              exit;
            end;
        end;
      end;
      if not DoAppend then LocaleByID(ToD, KeyField, FromD.FieldByName(KeyField).AsInteger);
      if not CopyRecord(FromD, ToD, DoAppend) then begin
        ErrorMsg(Format(sohoBDERtnCopyError, [FromD.name, ToD.name]));
        exit;
      end;
      FromD.Next;
    end;
    Result := True;
  finally
    CheckQ.Free;
  end;
end;

function FieldTypeToSQLFieldType(DataType: TFieldType): string;
begin
  case DataType of
    ftString: Result := ' Char ';
    ftSmallint: Result := ' Smallint ';
    ftInteger,
    ftWord: Result := ' Integer ';
    ftBytes: Result := ' Bytes ';
    ftBoolean: Result := ' Boolean ';
    ftFloat,
    ftCurrency: Result := ' Numeric ';
    ftDate: Result := ' Date ';
    ftTime: Result := ' Time ';
    ftMemo: Result := ' BLOB (0, 1) ';
    ftBlob: Result := ' BLOB (0, 2) ';
    ftGraphic: Result := ' BLOB (0, 5) ';
  end;
end;

function CountIndexFields(DataSet: TDataSet): Integer;
var index: Longint;
begin
  Result := 0;
  for index := 0 to pred(DataSet.FieldCount) do
    if DataSet.Fields[index].IsIndexField then inc(Result);
end;

function CreateTableByDataSetWithSave(DataSet: TDataSet; const NewTableName,
       ResultSQLFile: string; Create: boolean): boolean;
var index: Integer;
    CreateQuery: TQuery;
    NewFieldName: string;
    NewFieldType: string;
    IndexFieldName: string;
    TmpCount: Integer;
begin
  Result := False;
  if not DataSet.Active then exit;
  CreateQuery := TQuery.Create(nil);
  if ExtractFileExt(NewTableName)<>'' then
    CreateQuery.SQL.Add('CREATE TABLE "' + NewTableName + '" (')
  else
    CreateQuery.SQL.Add('CREATE TABLE ' + NewTableName + ' (');
  with DataSet do begin
    for index := 0 to pred(FieldCount) do begin
      NewFieldName := Fields[index].FieldName;
      NewFieldType := FieldTypeToSQLFieldType(Fields[index].DataType);
      if Fields[index].DataType = ftString then NewFieldType := NewFieldType +
        '(' + IntToStr((Fields[index].DataSize - 1)) + ')';
      if index < pred(FieldCount) then NewFieldType := NewFieldType + ',';
      CreateQuery.SQL.Add(NewFieldName + NewFieldType);
    end;
    if CountIndexFields(DataSet) <> 0 then begin
      CreateQuery.SQL.Add(', Primary Key (');
      TmpCount := 0;
      for index := 0 to pred(FieldCount) do
        if Fields[index].IsIndexField then begin
          IndexFieldName := Fields[index].FieldName;
          inc(TmpCount);
          if index < pred(TmpCount) then IndexFieldName := IndexFieldName + ',';
          CreateQuery.SQL.Add(IndexFieldName);
        end;
      CreateQuery.SQL.Add(')');
    end;
    CreateQuery.SQL.Add(')');
  end;
  try
    try
      SetCursor(crHourGlass);
      if ResultSQLFile <> '' then CreateQuery.SQL.SaveToFile(ResultSQLFile);
      if Create then CreateQuery.ExecSQL;
      Result := True;
    except
      on E: Exception do
          ErrorMsg(Format(sohoBDERtnCreateTableError, [NewTableName, E.message]));
    end;
  finally
    RestoreCursor;
    CreateQuery.Free;
  end;
end;

function CreateTableByDataSet(DataSet: TDataSet; const NewTableName: string): boolean;
begin
  Result := CreateTableByDataSetWithSave(DataSet, NewTableName, '', True);
end;

function AddFieldToTable(const aDataBaseName, aTableName, aFieldName: string;
         aFieldType: TFieldType; aFieldLen: Longint): boolean;
var TmpQuery: TQuery;
    SQLCommand: string;
begin
  try
    TmpQuery := TQuery.Create(nil);
    case aFieldType of
      ftString: SQLCommand := ' char (' + IntToStr(aFieldLen) + ') ';
      ftInteger: SQLCommand := ' Integer ';
      ftBoolean: SQLCommand := ' Boolean ';
        ftFloat,
          ftCurrency: SQLCommand := ' Numeric ';
          ftDate: SQLCommand := ' Date ';
          ftTime: SQLCommand := ' Time ';
          else begin
            InfoMsg(sohoBDERtnUnknownField);
            SQLCommand := 'char (10)';
          end;
    end;
    SQLCommand := aFieldName + SQLCommand;
    with TmpQuery, SQL do begin
      DataBaseName := aDataBaseName;
      Add('ALTER TABLE "' + aTableName + '" ADD ' + SQLCommand);
      try
        SetCursor(crHourGlass);
        ExecSQL;
      except
        on E: Exception do
            ErrorMsg(Format(sohoBDERtnAddFieldError, [E.message]));
      end;
    end;
  finally
    TmpQuery.Free;
    RestoreCursor;
  end;
end;

function GetAliasInfo(AliasName: string): TsohoAliasInfo;
var Params: TStringList;
    Tmp: string;
    Error: boolean;
begin
  try
    Params := TStringList.Create;
    try
      Session.Open;
      Session.GetAliasParams(AliasName, TStrings(Params));
    except
     on E: Exception do ErrorMsg(Format(sohoBDERtnAliasError, [AliasName, E.Message]));
    end;
    with Result do begin
      Path := Params.Values['PATH'];
      DefaultDriver := Params.Values['DEFAULT DRIVER'];

      ServerName := Params.Values['SERVER NAME'];
      if (ServerName <> '') and (Path = '') then Path := ServerName;

      DefaultUserName := Params.Values['USER NAME'];

      Tmp := Params.Values['OPEN MODE'];
      if Tmp = 'READ/WRITE' then OpenMode := omReadWrite
      else OpenMode := omReadOnly;

      SchemaCacheSize := WStrToInt(Params.Values['SCHEMA CACHE SIZE'], Error);
      LanguageDriver := Params.Values['LANGDRIVER'];

      Tmp := Params.Values['SQLQRYMODE'];
      if Tmp = 'LOCAL' then SQLQueryMode := qmLocal;
      if Tmp = 'SERVER' then SQLQueryMode := qmServer;
      if Tmp = '' then SQLQueryMode := qmNull;

      Tmp := Params.Values['SQLPASSTHRU MODE'];
      if Tmp = 'SHARED AUTOCOMMIT' then SQLPassThroughMode := tmSharedAutocommit;
      if Tmp = 'SHARED NOAUTOCOMMIT' then SQLPassThroughMode := tmSharedNoAutoCommit;
      if Tmp = 'NOT SHARED' then SQLPassThroughMode := tmNotShared;

      SchemaCacheTime := WStrToInt(Params.Values['SCHEMA CACHE TIME'], Error);
      MaxRows := WStrToInt(Params.Values['MAX ROWS'], Error);
      BatchCount := WStrToInt(Params.Values['BATCH COUNT'], Error);
      EnableSchemaCache := StrToBool(Params.Values['ENABLE SCHEMA CACHE']);
      SchemaCacheDir := Params.Values['SCHEMA CACHE DIR'];
      EnableBCD := StrToBool(Params.Values['ENABLE BCD']);
      BlobsToCache := WStrToInt(Params.Values['BLOBS TO CACHE'], Error);
      BlobSize := WStrToInt(Params.Values['BLOB SIZE'], Error);
    end;
  finally
    Params.Free;
  end;
end;

initialization
  RoutinesQuiet := False;
  ShowSQLBeforeExecute := False;
end.
