{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoAboutBox -   
 " ..."
}
unit SoAbout;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, SoCtrls, SohoBtns, SoTools, SoBckgrd, StdCtrls, ExtCtrls;

type
  
  TAboutBoxForm = class(TForm)
    back: TsohoBackground;
    ProgNameL: TsohoLabel;
    OperationSystemL: TsohoLabel;
    CopyrightL: TsohoLabel;
    WizLabel1: TsohoLabel;
    OwnerNameL: TsohoLabel;
    OwnerCompanyL: TsohoLabel;
    WizLabel2: TsohoLabel;
    WizLabel3: TsohoLabel;
    FreeMemoryL: TsohoLabel;
    sohoBitBtn1: TsohoBitBtn;
    AboutImage: TImage;
    sohoLabel1: TsohoLabel;
    FileVersionL: TsohoLabel;
  private
    { Private declarations }
    procedure SetLabels(aLight: TLightPos; aHeight3D: Integer;
      aLightColor, aShadowColor: TColor;
      aLabelsFont: tFont;
      aFillBack: boolean);
    procedure Execute;
  end;
  
    {     " ...".  
       : ""    ,
       ..}
  TsohoAboutBox = class(TComponent)
  private
    { Private declarations }
    FShowAbout: boolean;
    FTitle: string;
    FCopyRight: string;
    FOwnerName: string;
    FOwnerCompany: string;
    FProductName: string;
    FGlyph: TBitmap;
    FLight: TLightPos;
    FLColor,
      FSColor: TColor;
    FHeight3D: Integer;
    FsohoardPanel: boolean;
    FBackGround: TBitmap;
    FOwnerFromIni: boolean;
    FIniFileName: TIniFileName;
    FFont: tFont;
  protected
    { Protected declarations }
    procedure SetFont(Value: tFont);
    procedure SetShowAbout(Value: boolean);
    procedure SetGlyph(Value: TBitmap);
    procedure SetBackGround(Value: TBitmap);
    procedure SetHeight3D(Value: Integer);
    procedure SetOwnerFromIni(Value: boolean);
    procedure SetIniFile(Value: TIniFileName);
    procedure GetFieldsFromIni;
    procedure Loaded; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {   }
    procedure Execute;
  published
    {   ini-     (  )  }
    property IniFileName: TIniFileName read FIniFileName write SetIniFile;
    {       ini- }
    property OwnerFromIni: boolean read FOwnerFromIni write SetOwnerFromIni default False;
    {      design-time }
    property ShowAboutBox: boolean read FShowAbout write SetShowAbout default False;
    {   }
    property Title: string read FTitle write FTitle;
    {     }
    property CopyRight: string read FCopyRight write FCopyRight;
    {    }
    property OwnerName: string read FOwnerName write FOwnerName;
    {    }
    property OwnerCompany: string read FOwnerCompany write FOwnerCompany;
    {     }
    property ProductName: string read FProductName write FProductName;
    {     .   ,    
       }
    property Glyph: TBitmap read FGlyph write SetGlyph;
    { . TsohoLabel }
    property Light: TLightPos read FLight write FLight;
    { . TsohoLabel }
    property Height3D: Integer read FHeight3D write SetHeight3D;
    { . TsohoLabel }
    property LightColor: TColor read FLColor write FLColor;
    { . TsohoLabel }
    property ShadowColor: TColor read FSColor write FSColor;
    {      }
    property LabelsFont: tFont read FFont write SetFont;
    {     ? }
    property FillBitmap: boolean read FsohoardPanel write FsohoardPanel;
    {     }
    property BackGround: TBitmap read FBackGround write SetBackGround;
  end;

implementation
uses SoUtils, IniFiles, SoVrsInf;

{$R *.DFM}

var AboutBoxForm: TAboutBoxForm;
  
procedure TAboutBoxForm.SetLabels;
var K: Integer;
begin
  for K := 0 to pred(ComponentCount) do
    if Components[K] is TsohoLabel then
      with Components[K] as TsohoLabel do begin
        Light := aLight;
        LightColor := aLightColor;
        ShadowColor := aShadowColor;
        Height3D := aHeight3D;
        Font := aLabelsFont;
      end;
  if aFillBack then begin
    if back.Bitmap.Handle = 0 then
      back.Bitmap.Handle := ResBitmap('DEFAULTPANEL');
  end
  else back.Bitmap := nil;
end;

procedure TAboutBoxForm.Execute;
  {$IFDEF WIN32}
var MemStat: TMemoryStatus;
  {$ENDIF}
begin
  {$IFNDEF WIN32}
  FreeMemoryL.Caption := IntToStr(GetFreeSpace(0) div 1024) + ' Kb ';
  {$ELSE}
  MemStat.dwLength := SizeOf(TMemoryStatus);
  GlobalMemoryStatus(MemStat);
  FreeMemoryL.Caption := IntToStr(trunc(MemStat.dwTotalPhys / 1024)) + ' Kb ';
  FileVersionL.Caption := GetFileVersion+' ';
  {$ENDIF}
  OperationSystemL.Caption := ' ' + WindowsVerStr;
  if AboutImage.Picture.Bitmap.Handle = 0 then
     AboutImage.Picture.Icon.Handle := LoadIcon(hInstance, 'MAINICON');
  ShowModal;
end;

{ TsohoAboutBox }
procedure TsohoAboutBox.SetFont(Value: tFont);
begin
  FFont.Assign(Value);
end;

constructor TsohoAboutBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FGlyph := TBitmap.Create;
  FBackGround := TBitmap.Create;
  FShowAbout := False;
  FLight := lpRightBottom;
  FHeight3D := 1;
  FLColor := clWhite;
  FSColor := clGray;
  FsohoardPanel := True;
  FOwnerFromIni := False;
  FIniFileName := '';
  FOwnerName := '';
  FOwnerCompany := '';
  FFont := tFont.Create;
  with FFont do begin
    name := 'Ms Sans Serif';
    Size := 8;
    Style := [fsBold];
  end;
end;

destructor TsohoAboutBox.Destroy;
begin
  FFont.Free;
  FBackGround.Free;
  FGlyph.Free;
  inherited Destroy;
end;

procedure TsohoAboutBox.SetIniFile;
begin
  if (UpperCase(ExtractFileExt(Value)) <> 'INI') and (Value <> '') then
    Value := ChangeFileExt(Value, '.INI');
  if FIniFileName = Value then exit;
  FIniFileName := Value;
end;

procedure TsohoAboutBox.Loaded;
begin
  inherited Loaded;
  {  run-time    ini-,    }
  if not (csDesigning in ComponentState) and (FIniFileName = '') then
    IniFileName := DefaultName + '.ini';
  if (FIniFileName <> '') and (OwnerFromIni) then GetFieldsFromIni;
end;

procedure TsohoAboutBox.GetFieldsFromIni;
var Ini: TIniFile;
begin
  try
    Ini := TIniFile.Create(IniFileName);
    OwnerName := Ini.ReadString('Main', 'OwnerName', '');
    OwnerCompany := Ini.ReadString('Main', 'OwnerCompany', '');
  finally
    Ini.Free;
  end;
end;

procedure TsohoAboutBox.SetOwnerFromIni(Value: boolean);
begin
  if FOwnerFromIni = Value then exit;
  FOwnerFromIni := Value;
  if FOwnerFromIni and (FIniFileName <> '') then GetFieldsFromIni;
end;

procedure TsohoAboutBox.SetHeight3D(Value: Integer);
begin
  if Value < 0 then exit;
  FHeight3D := Value;
end;

procedure TsohoAboutBox.SetShowAbout(Value: boolean);
begin
  FShowAbout := Value;
  if not FShowAbout then exit;
  try
    AboutBoxForm := TAboutBoxForm.Create(Application);
    with AboutBoxForm do begin
      Caption := FTitle;
      ProgNameL.Caption := ' ' + FProductName;
      CopyrightL.Caption := ' Copyright (c) ' + FCopyRight;
      OwnerNameL.Caption := ' ' + FOwnerName;
      OwnerCompanyL.Caption := ' ' + FOwnerCompany;
      if Glyph.Handle <> 0 then AboutImage.Picture.Bitmap.Assign(FGlyph);
      if BackGround.Handle <> 0 then
        Back.Bitmap.Assign(BackGround);
    end;
    AboutBoxForm.SetLabels(Light, Height3D, LightColor, ShadowColor, FFont,
      FillBitmap);
    AboutBoxForm.Execute;
  finally
    AboutBoxForm.Free;
  end;
  FShowAbout := False;
end;

procedure TsohoAboutBox.Execute;
begin
  ShowAboutBox := True;
end;

procedure TsohoAboutBox.SetGlyph(Value: TBitmap);
begin
  FGlyph.Assign(Value);
end;

procedure TsohoAboutBox.SetBackGround(Value: TBitmap);
begin
  FBackGround.Assign(Value);
end;

end.

