unit tabsizer;

interface

Uses Sizer, Classes, ComCtrls, Controls, Messages;

Type
  TTabSizerHelper=Class(TSizerHelper)
  private
    FTab:TCustomTabControl;
    FTabWidth :Integer;
    FTabHeight:Integer;
  protected
    Procedure SizerResized(AFractionX,AFractionY:Real; Options:TSizerOptions); Override;
    Procedure SetTab(ATab:TCustomTabControl);
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  published
    Property  Tab:TCustomTabControl read FTab write SetTab;
  End;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('ATSystems', [TTabSizerHelper]);
end;

{******************* Tab Sizer *********************}

Type
  TExposeTab=Class(TCustomTabControl)
    property TabHeight;
    property TabWidth;
  End;

Procedure TTabSizerHelper.SetTab(ATab:TCustomTabControl);
Begin
  If FTab<>ATab Then Begin
    FTab:=ATab;
    If ATab<>Nil Then Begin
      FTabHeight:=TExposeTab(FTab).TabHeight;
      FTabWidth :=TExposeTab(FTab).TabWidth;
    End;
  End;
End;

Procedure TTabSizerHelper.SizerResized(AFractionX,AFractionY:Real; Options:TSizerOptions);
Var Loop:Integer;
Begin
  If (FTab<>Nil) And (Options.Size) Then Begin
    TExposeTab(FTab).TabHeight:=Round(FTabHeight*AFractionY);
    TExposeTab(FTab).TabWidth :=Round(FTabWidth*AFractionX);
  End;
End;

procedure TTabSizerHelper.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = FTab) then FTab := nil;
end;

end.
