unit SizerSpecial;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, Sizer;

type
  TSizerSpecialForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    DrawGrid1: TDrawGrid;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure DrawGrid1DrawCell(Sender: TObject; Col, Row: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure DrawGrid1DblClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
    Sizer   :TSizer;
  public
    { Public declarations }
    Procedure SetSizer(ASizer:TSizer);
  end;

implementation

{$R *.DFM}
Uses ChooseControl;

Const Headings:Array[0..3] of String=('Control Name','Position','Size','Font size');

Type TExposeSizer=Class(TSizer);

procedure TSizerSpecialForm.SetSizer(ASizer:TSizer);
Begin
  Sizer:=ASizer;
  If TExposeSizer(Sizer).FSpecial.Count=0 Then DrawGrid1.RowCount:=2
  Else DrawGrid1.RowCount:=Succ(TExposeSizer(Sizer).FSpecial.Count);
End;

procedure TSizerSpecialForm.FormCreate(Sender: TObject);
begin
  DrawGrid1.ColWidths[0]:=163;
  DrawGrid1.ColWidths[1]:=60;
  DrawGrid1.ColWidths[2]:=60;
  DrawGrid1.ColWidths[3]:=60;
end;

procedure TSizerSpecialForm.DrawGrid1DrawCell(Sender: TObject; Col, Row: Integer;
  Rect: TRect; State: TGridDrawState);
Var
  Txt,OneItem:String;
  Flags:Set Of TSpecialFlags;
  PositX,PositY:Integer;
  SpecialList  :TStrings;
begin
  If (Row=0) Then Txt:=Headings[Col]
  Else Begin
    SpecialList:=TExposeSizer(Sizer).FSpecial;
    If SpecialList.Count=0 Then Txt:=''
    Else Begin
      OneItem:=SpecialList[Pred(Row)];
      If Col=0 Then Txt:=Copy(OneItem,4,Length(OneItem)-3)
      Else Begin
        If OneItem[Col]='X' Then Begin
          DrawGrid1.Canvas.Font.Color:=clRed;
          Txt:='X';
        End
        Else Txt:='';
        DrawGrid1.Canvas.Font.Size:=12;
      End
    End;
  End;
  If (Col=0) And (Row<>0) Then PositX:=Rect.Left+10
  Else PositX:=(Rect.Right-Rect.Left) Div 2-DrawGrid1.Canvas.TextWidth(Txt) Div 2+Rect.Left;
  PositY:=(Rect.Bottom-Rect.Top) Div 2-DrawGrid1.Canvas.TextHeight(Txt) Div 2+Rect.Top;
  DrawGrid1.Canvas.TextOut(PositX,PositY,Txt);
end;

procedure TSizerSpecialForm.DrawGrid1DblClick(Sender: TObject);
Var
  Row,Col:Integer;
  OneItem:String;
begin
  If (DrawGrid1.Selection.Top=DrawGrid1.Selection.Bottom) And
     (DrawGrid1.Selection.Left=DrawGrid1.Selection.Right) Then Begin
    Row:=DrawGrid1.Selection.Top;
    Col:=DrawGrid1.Selection.Left;
    If (Row>0) And (Row<=TExposeSizer(Sizer).FSpecial.Count) And (Col<>0) Then Begin
      OneItem:=TExposeSizer(Sizer).FSpecial[Pred(Row)];
      If OneItem[Col]='X' Then OneItem[Col]:=' '
      Else OneItem[Col]:='X';
      TExposeSizer(Sizer).FSpecial[Pred(Row)]:=OneItem;
      DrawGrid1.Refresh;
    End;
  End;
end;

procedure TSizerSpecialForm.Button1Click(Sender: TObject);
Var
  ChooseControlForm:TChooseControlForm;
begin
  ChooseControlForm:=TChooseControlForm.Create(Nil);
  ChooseControlForm.SetSizer(Sizer);
  If ChooseControlForm.ShowModal=mrOK Then Begin
    TExposeSizer(Sizer).FSpecial.Add('XXX'+ChooseControlForm.Edit1.Text);
    DrawGrid1.RowCount:=TExposeSizer(Sizer).FSpecial.Count+1;
    DrawGrid1.Refresh;
  End;
  ChooseControlForm.Release;
end;

procedure TSizerSpecialForm.Button2Click(Sender: TObject);
begin
  If (DrawGrid1.Col>0) And (DrawGrid1.Row>=1) And
     (DrawGrid1.Row<=TExposeSizer(Sizer).FSpecial.Count) Then Begin
    If MessageDlg('Remove currently selected ?',mtConfirmation, [mbYes, mbNo], 0) = mrYes Then Begin
      TExposeSizer(Sizer).FSpecial.Delete(Pred(DrawGrid1.Row));
      If DrawGrid1.RowCount<>2 Then DrawGrid1.RowCount:=DrawGrid1.RowCount-1;
      DrawGrid1.Refresh;
    End
  End
  Else ShowMessage('Nothing selected to remove!');
end;

end.
