unit Sizer;

//*****************************************************************************
//*                               FORM SIZER v1.0                             *
//*---------------------------------------------------------------------------*
//*        THIS COMPONENT IS FREEWARE - PLEASE DON'T REMOVE THIS TEXT         *
//*---------------------------------------------------------------------------*
//* Written By P.Demoore, phill@fdesign.demon.co.uk 7/6/1998                  *
//* Please email me with any usefull alterations, so that i can continue to   *
//* supply improved versions of this component                                *
//*****************************************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, dsgnintf;

type
  TResizeEvent = procedure (Sender:TObject; FractionX,FractionY:Real) of Object;

  TCustomSizer=Class;

  TSpecialFlags=(sfFontSize,sfSize,sfPosition);

  TSizerOptions=Class(TPersistent)
  private
    FFont    :Boolean;
    FPosition:Boolean;
    FSize    :Boolean;
  protected
    FSizer   :TCustomSizer;
    procedure SetPosition(Value: Boolean);
    procedure SetSize(Value: Boolean);
    procedure SetFont(Value: Boolean);
  public
    Constructor Create(AOwner:TCustomSizer);
  published
    property Font:Boolean read FFont write SetFont default TRUE;
    property Position:Boolean read FPosition write SetPosition default TRUE;
    property Size:Boolean read FSize write SetSize default TRUE;
  End;

  TControlInfo=Class
    ControlRef:TControl;
    FontSize  :Word;
    Left  :SmallInt;
    Top   :SmallInt;
    Width :SmallInt;
    Height:SmallInt;
  End;

  TSizerHelper=Class;

  TCustomSizer = class(TComponent)
  private
    { Private declarations }
    FActive    :Boolean;
    FFormFont  :SmallInt;
    FFormHeight:SmallInt;
    FFormWidth :SmallInt;
    FLoaded    :Boolean;
    FOldWindowProc:TWndMethod;
    FOnResize  :TResizeEvent;
    FOptions   :TSizerOptions;
    procedure AddNewControls;
    function  FindControl(AControl:TControl; SearchIn:TControl):Boolean;
    procedure NewFormWindowProc(var Message: TMessage);
 protected
    { Protected declarations }
    FControlList:TList;   {All controls on the form handled by the resizer}
    function  ControlExists(AControl:TControl):Boolean;
    procedure Loaded; Override;
    procedure Resize(Sender: TObject);
    procedure ResizeIterator(Use:TControlInfo; FractionX,FractionY:Real); Virtual;
    Procedure SetActive(Value:Boolean);
    { Declarations }
    property Active : Boolean read FActive write SetActive default TRUE;
    property Options : TSizerOptions read FOptions write FOptions;
    { Events}
    property OnResize: TResizeEvent read FOnResize write FOnResize;
  public
    { Public declarations }
    Constructor Create(AOwner:TComponent); Override;
    Destructor  Destroy; Override;
    Procedure   ExcludeControl(ControlName:String);
    Procedure   IncludeControl(AControl:TControl);
  End;


  TSizer = class(TCustomSizer)
  private
    { Private declarations }
  protected
    { Protected declarations }
    FSpecial:TStringList;
    procedure ResizeIterator(Use:TControlInfo; FractionX,FractionY:Real); Override;
    procedure SetSpecial(Value:TStringList);
  public
    { Public declarations }
    Constructor Create(AOwner:TComponent); Override;
    Destructor  Destroy; Override;
  published
    { Published declarations }
    property Active;
    property Options;
    property Special:TStringList read FSpecial write SetSpecial stored TRUE;
    { Published events}
    property OnResize;
  end;

  TSizerHelper=Class(TComponent)
  protected
    Procedure SizerResized(FractionX,FractionY:Real; Options:TSizerOptions); Virtual; Abstract;
  End;

  TSpecialProperty=Class(TPropertyEditor)
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  End;

  TRect2=Record
    Left,Top,Width,Height:Integer;
  End;

procedure Register;

implementation

Uses SizerSpecial;

procedure Register;
begin
  RegisterComponents('ATSystems', [TSizer]);
  RegisterPropertyEditor(TypeInfo(TStringList), TSizer, 'Special',TSpecialProperty);
end;

function Rect2(X,Y,W,H:Integer):TRect2;
Begin
  Result.Left  :=X;
  Result.Top   :=Y;
  Result.Width :=W;
  Result.Height:=H;
End;
{********** TSIZER - OPTIONS **********}

Constructor TSizerOptions.Create(AOwner:TCustomSizer);
Begin
  inherited Create;
  FSizer  :=AOwner;
  Position:=True;
  Size    :=True;
  Font    :=True;
End;

procedure TSizerOptions.SetPosition(Value: Boolean);
Begin
  FPosition:=Value;
  If FSizer<>Nil Then FSizer.Resize(Nil);
End;

procedure TSizerOptions.SetSize(Value: Boolean);
Begin
  FSize:=Value;
  If FSizer<>Nil Then FSizer.Resize(Nil);
End;

procedure TSizerOptions.SetFont(Value: Boolean);
Begin
  FFont:=Value;
  If FSizer<>Nil Then FSizer.Resize(Nil);
End;

{*************************** TCustomSizer ***********************************}
Constructor TCustomSizer.Create(AOwner:TComponent);
Begin
  Inherited Create(AOwner);
  FControlList:=TList.Create; {COMPONENTS - Stored info on controls e.g. original sizes}
  FOptions:=TSizerOptions.Create(Self);
  FOldWindowProc:=TForm(AOwner).WindowProc;
  TForm(AOwner).WindowProc:=NewFormWindowProc;
  Active :=True;
End;

Destructor TCustomSizer.Destroy;
Begin
  If Assigned(Owner) Then TForm(Owner).WindowProc:=FOldWindowProc;
  FOptions.Free;
  While FControlList.Count<>0 Do Begin
    TObject(FControlList[0]).Free;
    FControlList.Delete(0);
  End;
  Inherited Destroy;
End;

Procedure TCustomSizer.Loaded;
Begin
  FFormWidth :=TForm(Owner).ClientWidth;
  FFormHeight:=TForm(Owner).ClientHeight;
  FFormFont  :=TForm(Owner).Font.Size;
  FLoaded:=True;
End;

procedure TCustomSizer.NewFormWindowProc(var Message: TMessage);
Begin
  If (Message.Msg=WM_SIZING) Or (Message.Msg=WM_SIZE) Then Begin
    Resize(Nil);
  End;
  FOldWindowProc(Message);
End;

Procedure TCustomSizer.ExcludeControl(ControlName:String);
Var Loop :Word;
    Found:Boolean;
Begin
  Found:=False;
  For Loop:=1 To FControlList.Count Do
    If TControlInfo(FControlList[Pred(Loop)]).ControlRef.Name=ControlName Then Begin
      TObject(FControlList[Pred(Loop)]).Free;
      FControlList.Delete(Pred(Loop));
      Found:=True;
      Break;
    End;
  Assert(Found,'Component not found '+ControlName);
End;

Type TFooClass=Class(TControl);

Procedure TCustomSizer.IncludeControl(AControl:TControl);
Var ControlInfo :TControlInfo;
Begin
  ControlInfo:=TControlInfo.Create;
  ControlInfo.ControlRef:=AControl;
  ControlInfo.Left  :=AControl.Left;
  ControlInfo.Top   :=AControl.Top;
  ControlInfo.Width :=AControl.Width;
  ControlInfo.Height:=AControl.Height;
  {**BODGE** FONTS}
  If TFooClass(AControl).Font<>Nil Then ControlInfo.FontSize  :=TFooClass(AControl).Font.Size;
  {***************}
  FControlList.Add(ControlInfo);
End;

Function TCustomSizer.ControlExists(AControl:TControl):Boolean;
Var
  Loop   :Word;
Begin
  Result:=False;
  For Loop:=1 To FControlList.Count Do
    If TControlInfo(FControlList[Pred(Loop)]).ControlRef=AControl Then Begin
      Result:=True;
      Break;
    End;
End;

Procedure TCustomSizer.ResizeIterator(Use:TControlInfo; FractionX,FractionY:Real);
Var NewBounds:TRect2;
Begin
  NewBounds:=Rect2(Use.Left,Use.Top,Use.Width,Use.Height);
  If Assigned(FOptions) Then Begin
    If FOptions.Position Then Begin
      NewBounds.Top :=Round(LongInt(Use.Top)*FractionY);
      NewBounds.Left:=Round(LongInt(Use.Left)*FractionX);
      If FOptions.Size Then Begin
        NewBounds.Height:=Round(LongInt(Use.Height+Use.Top)*FractionY)-NewBounds.Top;
        NewBounds.Width :=Round(LongInt(Use.Width+Use.Left)*FractionX)-NewBounds.Left;
      End;
    End
    Else If FOptions.Size Then Begin
      NewBounds.Height   :=Round(LongInt(Use.Height)*FractionY);
      NewBounds.Width    :=Round(LongInt(Use.Width)*FractionX);
    End;
    Use.ControlRef.SetBounds(NewBounds.Left,NewBounds.Top,NewBounds.Width,NewBounds.Height);
    With TFooClass(Use.ControlRef) Do
      If (ParentFont<>True) And (FOptions.Font) Then Begin
        If FractionX<FractionY Then
          Font.Size:=Round(LongInt(Use.FontSize)*FractionX)
        Else
          Font.Size:=Round(LongInt(Use.FontSize)*FractionY);
      End;
  End;
End;

Function TCustomSizer.FindControl(AControl:TControl; SearchIn:TControl):Boolean;

Function FindIterator(SearchControl:TControl):Boolean;
Var Loop2:Integer;
Begin
  Result:=SearchControl=AControl;
  If (Not Result) And (SearchControl is TWinControl) Then
    For Loop2:=1 To TWinControl(SearchControl).ControlCount Do
      If FindIterator(TWinControl(SearchControl).Controls[Pred(Loop2)]) Then Begin
        Result:=True;
        Break;
      End;
End;

Begin
  Result:=FindIterator(SearchIn);
End;

Procedure TCustomSizer.AddNewControls;

Procedure AddNewControlsIterator(AControl:TControl);
Var Loop:Integer;
Begin
  If Not ControlExists(AControl) Then IncludeControl(AControl);
  If AControl Is TWinControl Then
    For Loop:=1 To TWinControl(AControl).ControlCount Do
      AddNewControlsIterator(TWinControl(AControl).Controls[Pred(Loop)]);
End;

Var Loop:Integer;
Begin
  With TForm(Owner) Do
    For Loop:=1 To ControlCount Do
      AddNewControlsIterator(Controls[Pred(Loop)]);
End;

Procedure TCustomSizer.Resize(Sender: TObject);
Var
  Loop   :Word;
  FractionX,FractionY:Real;
Begin
  LockWindowUpdate(TForm(Owner).Handle);
  {Remove any deleted controls}
  For Loop:=FControlList.Count DownTo 1 Do
    If Not FindControl(TControlInfo(FControlList[Pred(Loop)]).ControlRef,TControl(Owner)) Then Begin
      TControlInfo(FControlList[Pred(Loop)]).Free;
      FControlList.Delete(Pred(Loop));
    End;
  {Add any new controls}
  AddNewControls;
  If Not(csDesigning in ComponentState) And (FLoaded) And (FActive) Then Begin
    {And now resize controls}
    FractionX:=TForm(Owner).ClientWidth/FFormWidth;
    FractionY:=TForm(Owner).ClientHeight/FFormHeight;
    If FractionX<FractionY Then TForm(Owner).Font.Size:=Round(LongInt(FFormFont)*FractionX)
    Else TForm(Owner).Font.Size:=Round(LongInt(FFormFont)*FractionX);
    For Loop:=1 To FControlList.Count Do
      ResizeIterator(FControlList[Pred(Loop)],FractionX,FractionY);
    If Assigned(FOnResize) Then FOnResize(Self,FractionX,FractionY);
    {Now notify all helpers that the form has been resized}
    With TForm(Owner) Do
      For Loop:=1 To ComponentCount Do
        If Components[Pred(Loop)] Is TSizerHelper Then
          TSizerHelper(Components[Pred(Loop)]).SizerResized(FractionX,FractionY,FOptions);
  End;
  LockWindowUpdate(0);
End;

Procedure TCustomSizer.SetActive(Value:Boolean);
Var
  Loop:Integer;
Begin
  If Value<>FActive Then Begin
    If Value=True Then Resize(Self)
    Else Begin
      With TForm(Owner) Do
        For Loop:=1 To ComponentCount Do
          If Components[Pred(Loop)] Is TSizerHelper Then
            TSizerHelper(Components[Pred(Loop)]).SizerResized(1.0,1.0,FOptions);
    End;
    FActive:=Value;
  End;
End;

{********** TSizer **********}

Constructor TSizer.Create(AOwner:TComponent);
Begin
  Inherited Create(AOwner);
  FSpecial:=TStringList.Create;
End;

Destructor TSizer.Destroy;
Begin
  While FSpecial.Count<>0 Do FSpecial.Delete(0);
  Inherited Destroy;
End;

procedure TSizer.SetSpecial(Value:TStringList);
Begin
  showmessage('Assigned');
  FSpecial.Assign(Value);
End;

Procedure TSizer.ResizeIterator(Use:TControlInfo; FractionX,FractionY:Real);
Var Loop   :Integer;
    OneItem,OneItemName,FindName:String;
    OldOptions:TSizerOptions;
    Found:Boolean;
Begin
  FindName:=UpperCase(TControl(Use.ControlRef).Name);
  If Assigned(FOptions) Then Begin
    Found:=False;
    For Loop:=1 To FSpecial.Count Do Begin
      OneItem:=UpperCase(FSpecial[Pred(Loop)]);
      OneItemName:=Copy(OneItem,4,Length(OneItem)-3);
      If OneItemName=FindName Then Begin
        Found:=True;
        Break;
      End;
    End;
    If Found Then Begin
      OldOptions:=Options;
      FOptions:=TSizerOptions.Create(Nil);
      FOptions.FPosition:=OneItem[1]='X';
      FOptions.FSize    :=OneItem[2]='X';
      FOptions.FFont    :=OneItem[3]='X';
    End;
    inherited ResizeIterator(Use,FractionX,FractionY);
    If Found Then Begin
      FOptions.Free;
      FOptions:=OldOptions;
    End;
  End;
End;


{********************Special Property Editor for TSizer**********************}

function TSpecialProperty.GetAttributes: TPropertyAttributes;
begin
  GetAttributes := [paDialog];
end;

function TSpecialProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Click here)';
end;

procedure TSpecialProperty.Edit;
Var SizerSpecialForm:TSizerSpecialForm;
begin
  SizerSpecialForm:=TSizerSpecialForm.Create(Nil);
  SizerSpecialForm.SetSizer(TSizer(GetComponent(0)));
  SizerSpecialForm.ShowModal;
  SizerSpecialForm.Release;
end;

end.
