unit RichEdSizer;

interface

Uses Windows,Sizer, Classes, ComCtrls, Controls, Messages;

type
    SizeArray = array[0..1] of Integer;

Type
  TRichEditSizerHelper=Class(TSizerHelper)
  private
    FEdit : TCustomRichEdit;
    FHeight : Integer;
    FWidth  : Integer;
    FSizes  : ^SizeArray;
    FCount  : Integer;
  protected
    Procedure SizerResized(AFractionX,AFractionY:Real; Options:TSizerOptions); Override;
    procedure SetEdit( anEdit : TCustomRichEdit );
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    procedure SetReady;
  published
    property Editor : TCustomRichEdit read FEdit write SetEdit;
  End;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('ATSystems', [TRichEditSizerHelper]);
end;

{******************* Tab Sizer *********************}

Type
  TExposeEdit=Class(TCustomRichEdit)
    property SelAttributes;
    property SelStart;
    property SelLength;
    property HideSelection;
  End;

procedure TRichEditSizerHelper.SetEdit( anEdit : TCustomRichEdit );
var
    j : Integer;
    saved : Boolean;
begin
    if anEdit<>FEdit then begin
        FEdit := anEdit;
        if FEdit<>nil then begin
            FHeight := FEdit.Height;
            FWidth  := FEdit.Width;
            FCount  := 0;
        end;
    end;
end;

procedure TRichEditSizerHelper.SetReady;
var j : Integer;
    saved : Boolean;
begin
    FCount := TExposeEdit(FEdit).GetTextLen;
    if FCount > 0 then begin
        if FSizes<>nil then FreeMem(Fsizes);
        GetMem(Fsizes,FCount*sizeof(Integer));
        if FSizes<>nil then begin
            saved := TExposeEdit(FEdit).HideSelection;
            TExposeEdit(FEdit).HideSelection := false;
            for j := 0 to FCount-1 do begin
                TExposeEdit(FEdit).SelStart  := j;
                TExposeEdit(FEdit).SelLength := 1;
                FSizes[j] := TExposeEdit(FEdit).SelAttributes.Height;
            end;
            TExposeEdit(FEdit).SelStart  := -1;
            TExposeEdit(FEdit).SelLength := 0;
            TExposeEdit(FEdit).HideSelection := saved;
        end;
    end;
end;

Procedure TRichEditSizerHelper.SizerResized(AFractionX,AFractionY:Real; Options:TSizerOptions);
Var saved : Boolean;
    j,sz  : Integer;
    old   : Real;
Begin
    if(FEdit<>nil) and (FCount <> 0) then begin
        saved := TExposeEdit(FEdit).HideSelection;
        TExposeEdit(FEdit).HideSelection := false;
        SendMessage(TExposeEdit(FEdit).Handle,wm_Setredraw,0,0);
        for j := 0  to TExposeEdit(FEdit).GetTextLen - 1 do begin
            TExposeEdit(FEdit).SelStart := j;
            TExposeEdit(FEdit).SelLength := 1;
            // this functionality could well be changed
            TExposeEdit(FEdit).SelAttributes.Height := Trunc(FSizes[j]*AFractionY); 
        end;
        SendMessage(TExposeEdit(FEdit).Handle,wm_Setredraw,1,0);
        TExposeEdit(FEdit).SelStart  := -1;
        TExposeEdit(FEdit).SelLength := 0;
        TExposeEdit(FEdit).HideSelection := saved;
        TExposeEdit(FEdit).Repaint;
    end;
End;

procedure TRichEditSizerHelper.Notification(AComponent: TComponent; Operation: TOperation);
begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) and (AComponent = FEdit) then begin
        if FSizes<>nil then FreeMem(FSizes);
        FSizes := nil;
    end;  
end;

end.

