unit listboxsizer;

interface

Uses Sizer, Classes, StdCtrls, Controls, Messages;

Type
  TListboxSizerHelper=Class(TSizerHelper)
  private
    FListBox:TCustomListbox;
    FItemHeight:Integer;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    Procedure SizerResized(AFractionX,AFractionY:Real; Options:TSizerOptions); Override;
    Procedure SetListbox(AListbox:TCustomListbox);
  published
    Property  Listbox:TCustomListbox read FListBox write SetListbox;
  End;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('ATSystems', [TListboxSizerHelper]);
end;

{******************* Tab Sizer *********************}

Type
  TExposeListbox=Class(TCustomListbox)
    property ItemHeight;
  End;

Procedure TListboxSizerHelper.SetListbox(AListbox:TCustomListbox);
Begin
  If FListbox<>AListbox Then Begin
    FListbox:=AListbox;
    If AListbox<>Nil Then FItemHeight:=TExposeListbox(FListbox).ItemHeight;
  End;
End;

Procedure TListboxSizerHelper.SizerResized(AFractionX,AFractionY:Real; Options:TSizerOptions);
Var Loop:Integer;
Begin
  If (FListbox<>Nil) And (Options.Size) Then Begin
    TExposeListbox(FListbox).ItemHeight:=Round(FItemHeight*AFractionY);
  End;
End;

procedure TListboxSizerHelper.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = FListBox) then FListBox := nil;
end;

end.
