unit ChooseControl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Sizer;

type
  TChooseControlForm = class(TForm)
    ListBox1: TListBox;
    Edit1: TEdit;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormShow(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    Sizer:TSizer;
  public
    { Public declarations }
    Procedure SetSizer(ASizer: TSizer);
  end;

implementation

{$R *.DFM}

Type TExposeSizer=Class(TSizer);

Procedure TChooseControlForm.SetSizer(ASizer: TSizer);
Begin
  Sizer:=ASizer;
End;

procedure TChooseControlForm.FormShow(Sender: TObject);
Var
  Loop,Loop2:Integer;
  ControlName,OneItem:String;
  TempList:TList;
  Temp    :TStrings;
  Found   :Boolean;
begin
  TempList:=TExposeSizer(Sizer).FControlList;
  Temp:=TExposeSizer(Sizer).FSpecial;
  For Loop:=1 To TempList.Count Do Begin
    ControlName:=TControlInfo(TempList[Pred(Loop)]).ControlRef.Name;
    Found:=False;
    For Loop2:=1 To Temp.Count Do Begin
      OneItem:=Temp[Pred(Loop2)];
      If UpperCase(Copy(OneItem,4,Length(OneItem)-3))=UpperCase(ControlName) Then
        Found:=True;
    End;
    If Not Found Then ListBox1.Items.Add(ControlName);
  End;
end;

procedure TChooseControlForm.ListBox1DblClick(Sender: TObject);
begin
  If ListBox1.ItemIndex<>-1 Then Begin
    Edit1.Text:=ListBox1.Items[ListBox1.ItemIndex];
    Close;
    Button1.Click;
  End;
end;

procedure TChooseControlForm.Button2Click(Sender: TObject);
begin
  Edit1.Text:='';
end;

procedure TChooseControlForm.ListBox1Click(Sender: TObject);
begin
  If ListBox1.ItemIndex<>-1 Then
    Edit1.Text:=ListBox1.Items[ListBox1.ItemIndex];
end;

procedure TChooseControlForm.Button1Click(Sender: TObject);
Var
  Temp :TStrings;
  Loop :Integer;
  TempName:String;
begin
  Edit1.Text:=Trim(Edit1.Text);
  Temp:=TExposeSizer(Sizer).FSpecial;
  If Edit1.Text='' Then Begin
    ShowMessage('You need to select a control, or enter a control name');
    ModalResult:=mrNone;
  End
  Else Begin
    For Loop:=1 To Temp.Count Do Begin
      TempName:=Copy(Temp[Pred(Loop)],4,Length(Temp[Pred(Loop)])-3);
      If UpperCase(TempName)=UpperCase(Edit1.Text) Then Begin
        ShowMessage('Special control already defined');
        ModalResult:=mrNone;
        Break;
      End;
    End;

  End;
End;

end.
