unit uSimpleEchoPipe;

interface

uses SysUtils, Windows, uService, uThreadPool;

const
  PipeName = '\\.\pipe\EchoPipe';

type
  TSimpleEchoPipeService = class(TService)
  private
    Pipe: THandle;
    Overlapped: TOverlapped;
    EventHandlesCount: integer;
    EventHandles: array[0..1] of THandle;
    SecAttrib: TSecurityAttributes;
    SecDesc: TSecurityDescriptor;
    ThreadPool: TThreadPool;

    procedure PipeProc(Pipe: pointer);
  protected
    procedure InitService; override;
    procedure DoneService; override;
    procedure RunService; override;
    function ProcessRequest(const Request: string): string; virtual;
  end;

implementation

procedure TSimpleEchoPipeService.InitService;
begin
  inherited;
  if not InitOK then exit;
  InitOK:=False;
  ThreadPool:=TThreadPool.Create(5,10,0); //max 10 thread
  Pipe:=INVALID_HANDLE_VALUE; //init
  InitializeSecurityDescriptor(@SecDesc,1);
  if not SetSecurityDescriptorDacl(@SecDesc,True,nil,True) then exit;
  SecAttrib.nLength:=sizeof(SecAttrib);
  SecAttrib.lpSecurityDescriptor:=@SecDesc;
  SecAttrib.bInheritHandle:=False;
  Overlapped.hEvent:=CreateEvent(nil,TRUE,False,nil);
  if Overlapped.hEvent=0 then exit;
  EventHandlesCount:=2;
  EventHandles[0]:=FServiceStopEventHandle;
  EventHandles[1]:=Overlapped.hEvent;
  InitOK:=True;
end;

procedure TSimpleEchoPipeService.DoneService;
begin
  try ThreadPool.Free; except end; //wait for ThreadPool threads
  if Pipe<>INVALID_HANDLE_VALUE then begin
    DisconnectNamedPipe(Pipe);
    CloseHandle(Pipe);
  end;
  CloseHandle(EventHandles[1]);
  inherited;
end;

procedure TSimpleEchoPipeService.RunService;
var
  WaitResult: DWord;
  TmpDWord: DWord;
begin
  // Service now running , perform work until shutdown
  while True do begin
    if Pipe=INVALID_HANDLE_VALUE then begin
      Pipe:=CreateNamedPipe(PChar(PipeName),
        PIPE_ACCESS_DUPLEX+FILE_FLAG_OVERLAPPED,
        PIPE_TYPE_MESSAGE+PIPE_READMODE_MESSAGE,
        10,16384,16384,500,@SecAttrib); //500 ms
    end;
    if Pipe<>INVALID_HANDLE_VALUE then
      ConnectNamedPipe(Pipe,@Overlapped)
    else
      ResetEvent(Overlapped.hEvent);
    if (Pipe<>INVALID_HANDLE_VALUE) and (GetLastError=ERROR_PIPE_CONNECTED) then begin
      if WaitForStop(0) then
        WaitResult:=WAIT_OBJECT_0
      else
        WaitResult:=WAIT_OBJECT_0+1;
    end
    else begin
      SetLastError(NO_ERROR); //clear error code (ERROR_IO_PENDING/CreateNamedPipe)
      //wait 60 s for cleanup ThreadPool
      WaitResult:=WaitForMultipleObjects(EventHandlesCount,@EventHandles,False,60*1000);
    end;
    case WaitResult of
      WAIT_OBJECT_0+1: begin //service called
        GetOverlappedResult(Pipe,Overlapped,TmpDWord,True);
        ThreadPool.ExecuteProc(PipeProc,pointer(Pipe));
        Pipe:=INVALID_HANDLE_VALUE;
      end;
      WAIT_TIMEOUT: begin
        ThreadPool.CleanUp;
      end
      else {WAIT_OBJECT_0:} break; //stop service
    end;
  end;
end;

procedure TSimpleEchoPipeService.PipeProc(Pipe: pointer);
type
  TExceptHandler = procedure(ExceptObject: TObject; ExceptAddr: Pointer);
var
  TmpDWord: DWord;
  Req: string;
  Ans: string;
begin
  try
    while (not WaitForStop(0)) do begin
      SetLength(Req,256);
      if not ReadFile(THandle(Pipe),Req[1],Length(Req),TmpDWord,nil) or (TmpDWord=0) then break;
      SetLength(Req,TmpDWord);

      Ans:=ProcessRequest(Req);

      if not WriteFile(THandle(Pipe),Ans[1],Length(Ans),TmpDWord,nil) or (TmpDWord=0) then break;
    end;
  except
    TExceptHandler(ExceptProc)(ExceptObject,ExceptAddr);
  end;
  FlushFileBuffers(THandle(Pipe));
  DisconnectNamedPipe(THandle(Pipe));
  CloseHandle(THandle(Pipe));
end;


function TSimpleEchoPipeService.ProcessRequest(const Request: string): string;
begin
  Result:=Request;
end;



end.

