unit fEchoPipeMainWnd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    BtnConnect: TButton;
    BtnDisconnect: TButton;
    BtnSend: TButton;
    Label1: TLabel;
    Label2: TLabel;
    EditReq: TEdit;
    EditAns: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure BtnConnectClick(Sender: TObject);
    procedure BtnDisconnectClick(Sender: TObject);
    procedure BtnSendClick(Sender: TObject);
  private
    { Private declarations }
    PipeHandle: THandle;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses WinSvc;

const
  PipeName = '\\.\pipe\EchoPipe';

function StartService: boolean;
var
  SCHandle: SC_HANDLE;
  ServHandle: SC_HANDLE;
  NullParam: PChar;
begin
  SetLastError(0);
  SCHandle:=OpenSCManager(nil,nil,SC_MANAGER_CONNECT);
  if (SCHandle<>0) then begin
    try
      ServHandle:=OpenService(SCHandle,'ECHOPIPESERV',SERVICE_START);
      if ServHandle<>0 then begin
        try
          NullParam:=nil;
          //it's not too intelligent, but simple. Intelligent way: QueryServiceStatus
          if WinSvc.StartService(ServHandle,0,NullParam) then begin
            Sleep(500);
            SetLastError(0);
          end;
        finally
          CloseServiceHandle(ServHandle);
        end;
      end;
    finally
      CloseServiceHandle(SCHandle);
    end;
  end;
  Result:=GetLastError=0;
end;



procedure TForm1.FormCreate(Sender: TObject);
begin
  Caption:=PipeName+' test';
end;

procedure TForm1.BtnConnectClick(Sender: TObject);
begin
  PipeHandle:=CreateFile(PipeName,GENERIC_READ+GENERIC_WRITE,0,nil,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
  if (PipeHandle=INVALID_HANDLE_VALUE) or (PipeHandle=0) then begin
    PipeHandle:=0;
    RaiseLastWin32Error;
  end;
  BtnConnect.Enabled:=False;
  BtnDisconnect.Enabled:=True;
  BtnSend.Enabled:=True;
end;

procedure TForm1.BtnDisconnectClick(Sender: TObject);
begin
  if PipeHandle<>0 then begin
    CloseHandle(PipeHandle);
    PipeHandle:=0;
  end;
  BtnConnect.Enabled:=True;
  BtnDisconnect.Enabled:=False;
  BtnSend.Enabled:=False;
end;

procedure TForm1.BtnSendClick(Sender: TObject);
var
  Ans: string;
  Req: string;
  nWritten: DWORD;
begin
  if PipeHandle<>0 then begin
    Req:=EditReq.Text;
    SetLength(Ans,16000);
    if WriteFile(PipeHandle,PChar(Req)^,Length(Req),nWritten,nil) and
       (nWritten=DWORD(Length(Req))) and
       ReadFile(PipeHandle,PChar(Ans)^,Length(Req),nWritten,nil) then
      SetLength(Ans,nWritten)
    else
      RaiseLastWin32Error;
    EditAns.Text:=Ans;
  end;
end;

end.

