program TermProc;

{$APPTYPE CONSOLE}

uses
  Windows,
  WinSvc,
  SysUtils,
  uService in 'uService.pas';

{x$xR *.RES}

type
  TCloseProcessServ = class(TService)
  private
    PID: integer;
  protected
    procedure ServiceMain(Argc: DWORD; Argv: PPChar); override;
    procedure RunService; override;
  end;

procedure TCloseProcessServ.ServiceMain(Argc: DWORD; Argv: PPChar);
var
  Args: PPChar;
begin
  PID:=-1;
  if (Argc>1) then begin
    Args:=Argv;
    inc(Args); //goto first param
    if Assigned(Args) and Assigned(Args^) then
      PID:=StrToIntDef(ArgS^,-1);
  end;
  inherited;
end;


procedure TCloseProcessServ.RunService;
var
  ProcHandle: THandle;
begin
  if PID<>-1 then begin
    ProcHandle:=OpenProcess(PROCESS_TERMINATE,False,PID);
    if (ProcHandle<>0) then
      if TerminateProcess(ProcHandle,0) then begin
        AddToMessageLog(Format('Process (%d) terminated.',[PID]),EVENTLOG_INFORMATION_TYPE,0,0);
        WaitForStop(1000);
        SetLastError(0); //Clear error flag
      end
      else
        AddToMessageLog(Format('Process (%d) not terminated.',[PID]),EVENTLOG_ERROR_TYPE,0,0)
    else
      AddToMessageLog(Format('OpenProcess (%d) failed.',[PID]),EVENTLOG_ERROR_TYPE,0,0);
  end
  else
    SetLastError(87);
end;


var
  Service: TCloseProcessServ;

begin
  Service:=TCloseProcessServ.Create('TERMPROC','Terminate process by PID',stManual,False);
  if not Service.ProcessCmdLine then 
    Service.Run;
  Service.Free;
end.

