program SimpleEchoPipeServ;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  Windows,
  uThreadPool in 'uThreadPool.pas',
  uService in 'uService.pas',
  uSimpleEchoPipe in 'uSimpleEchoPipe.pas';

var
  Service: TSimpleEchoPipeService;

procedure MyExceptHandler(ExceptObject: TObject; ExceptAddr: Pointer);
var
  Buffer: array[0..1023] of char;
begin
  ExceptionErrorMessage(ExceptObject,ExceptAddr,Buffer,sizeof(Buffer));
  Service.AddToMessageLog(Buffer,EVENTLOG_ERROR_TYPE,0,0);
  Halt(1);
end;

begin
  Service:=TSimpleEchoPipeService.Create('ECHOPIPESERV','Simple echo pipe service',stAuto,True);
  try
    if not Service.ProcessCmdLine then begin
      ExceptProc:=@MyExceptHandler;
      Service.Run;
    end;
  finally
    Service.Free;
  end;
end.
