unit Cshutd32;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, IniFiles, extctrls;

type
  TShutdown = class(TComponent)
  private
    FIniFilename : string;
    FMessage     : string;
    FCreated     : boolean;
    FTimes       : Integer;
    FErrorCount  : Integer;
  protected
    procedure SetIniFilename(Filename: string);
  public
    constructor Create(AOwner: TComponent);override;
    Destructor Destroy;override;
    procedure Check;
  published
    property ErrorCount: integer read FErrorCount;
    property IniFilename: string read FIniFilename write SetIniFilename;
    property MessageError: string read FMessage write FMessage;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TShutdown]);
end;

constructor TShutdown.Create(AOwner: TComponent);
begin
  inherited create(Aowner);
  FErrorCount:=0;
end;

destructor TShutdown.Destroy;
begin
  If FCreated then
  with TInifile.Create(FIniFilename) do
    try
      WriteInteger('SHUTDOWN','ERROR',0);
    finally
      Free;
    end;
  inherited Destroy;
end;

procedure TShutdown.SetIniFilename(Filename: string);
begin
  FIniFilename:=ExtractFilename(Filename);
end;

procedure TShutdown.Check;
begin
  if (FIniFilename<>'') and (not FCreated) then
  with TInifile.Create(FIniFilename) do
    try
      If (ReadInteger('SHUTDOWN','ERROR',0)=1) then
        begin
          FTimes:=ReadInteger('SHUTDOWN','ERRORCOUNT',0);
          Inc(FTimes);
          WriteInteger('SHUTDOWN','ERRORCOUNT',FTimes);
          MessageDlg(MessageError,mtError,[mbOk],0);
        end
      else
        WriteInteger('SHUTDOWN','ERROR',1);
      FErrorCount:=ReadInteger('SHUTDOWN','ERRORCOUNT',0);
      FCreated:=true;
    finally
      Free;
    end;
end;

end.
