{ ****************************************************************** }
{                                                                    }
{   VCL component TShowMessage                                       }
{                                                                    }
{   Displays a message box                                           }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\program files\component create\basic\showmsg.cd }
{   on 21 Aug 1999 at 0:33                                           }
{                                                                    }
{   Copyright  1999 by ...Irvsoft System Design                     }
{                                                                    }
{ ****************************************************************** }

unit Showmsg;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Dialogs;

type
  TShowMessage = class(TComponent)
    private
      { Private fields of TShowMessage }
        FBoxType : TMsgDlgType;
        FButtons : TMsgDlgButtons;
        FCaption : String;
        FText : String;

      { Private methods of TShowMessage }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;

    protected
      { Protected fields of TShowMessage }

      { Protected methods of TShowMessage }

    public
      { Public fields and properties of TShowMessage }

      { Public methods of TShowMessage }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        function Execute : Integer; virtual;

    published
      { Published properties of TShowMessage }
        property BoxType : TMsgDlgType
             read FBoxType write FBoxType
             default mtInformation;
        property Buttons : TMsgDlgButtons
             read FButtons write FButtons
             default [mbOK];
        property Caption : String read FCaption write FCaption;
        property Text : String read FText write FText;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TShowMessage with Irvsoft as its
       default page on the Delphi component palette }
     RegisterComponents('Irvsoft', [TShowMessage]);
end;

{ Method to set variable and property values and create objects }
procedure TShowMessage.AutoInitialize;
begin
     FBoxType := mtInformation;
     FButtons := [mbOK];
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TShowMessage.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

constructor TShowMessage.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;

     { Code to perform other tasks when the component is created }

end;

destructor TShowMessage.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

function TShowMessage.Execute : Integer;
var
   Dlg : TForm;
begin
     Result := 0;
     try
        Dlg := CreateMessageDialog(FText, FBoxType, FButtons);
        Dlg.Caption := FCaption;
        Dlg.FormStyle := fsStayOnTop;
        Dlg.ScaleBy(Screen.PixelsPerInch, 96);
        Result := Dlg.ShowModal;
     finally
        Dlg.Free;
     end
end;


end.
