// Seoane Remote Control
// by Domingo Seoane
// e-mail: d_seoane@hotmail.com
// See readme.txt ot leeme.txt for more details

program Remote;

uses
  Windows,
  Messages,
  Sysutils,
  ShellApi,
  ConstUnit in 'ConstUnit.pas';

var
  WinClass: TWndClassA;
  Msg: TMsg;

{ This procedure terminates the program }
procedure Terminar;
begin
  UnRegisterClass(WindowClassname,Inst);
  ExitProcess(Inst);
end;

{ This function processes messages sent to a window }
function WindowProc(hWnd, uMsg,	wParam,	lParam: Integer): Integer; stdcall;
begin
  Result := DefWindowProc(hWnd, uMsg, wParam, lParam);

  if uMsg = SEOANE_CLOSE_EVENT then
    begin
      Terminar;
    end;

  if (uMsg = WM_DESTROY) then
     begin
       Terminar;
     end;

   if uMsg = DM_REPOSITION then
    begin
      hTarget:= FindWindow('Winamp v1.x', nil);
      if isWindow(hTarget) then
        begin
          case wParam of
            Play:        SendMessage(hTarget, WM_COMMAND,WINAMP_BUTTON2, 0);
            Stop:        SendMessage(hTarget, WM_COMMAND,WINAMP_BUTTON4, 0);
            Pause:       SendMessage(hTarget, WM_COMMAND,WINAMP_BUTTON3, 0);
            Inc_Chann:   SendMessage(hTarget, WM_COMMAND,WINAMP_BUTTON5, 0);
            Dec_Chann:   SendMessage(hTarget, WM_COMMAND,WINAMP_BUTTON1, 0);
            Inc_Volumen: SendMessage(hTarget, WM_COMMAND,WINAMP_VOLUMEUP, 0);
            Dec_Volumen: SendMessage(hTarget, WM_COMMAND,WINAMP_VOLUMEDOWN, 0);
            Power:       SendMessage(hTarget, WM_CLOSE,0, 0);
          end;
        end else Terminar;
      if wParam = Power then Terminar;
    end;

end;

begin
  Inst := GetModuleHandle(nil);
  // This event close the application
  SEOANE_CLOSE_EVENT:=RegisterWindowMessage(SEOANE_CLOSE_EVENT_STR);
  // TVCapture98 remote control only sends messages to one window
  Sendmessage( HWND_BROADCAST, SEOANE_CLOSE_EVENT, handle, 0);

  with WinClass do
  begin
    style              := CS_PARENTDC;
    lpfnWndProc        := @WindowProc;
    hInstance          := Inst;
    hbrBackground      := 0;
    lpszClassname      := WindowClassname;
    hCursor            := 0;
  end; { with }
  RegisterClass(WinClass);

  // Create a window for receive messages from TVCapture98 remote control
  Handle := CreateWindowEx(0,                   // Extended window style
                           WindowClassname,     // Registered class name
                           WindowName,          // Window name
                           WindowStyle,         // Window style
                           x,y,Width,Height,
                           0,                   // handle of parent window
                           0,                   // handle of menu
                           Inst,                // handle of application instance
                           nil);                // Window-creation data

  // If exists a link to winamp in the program's directory then open winamp
  ShellExecute(handle,nil,'winamp.lnk',nil,nil,sw_show);

  { messages loop }
  while(GetMessage(Msg, Handle, 0, 0)>FALSE) do
  begin
    TranslateMessage(msg);
    DispatchMessage(msg);
  end; { while }
end.
