unit SEDReg;

interface

procedure Register;

implementation
uses
   SysUtils, Classes, DsgnIntf, Dialogs, Forms, FiltEdit, MaskProp, 
   TiledBmp, sFileUtils, sTrans, sCtrls, sPickDate, sEdits, sCombos,
   sBrowseFolder, sGlyphsList, sDBCtrls, sConsts, sMask, sMemo;

{$R TiledBmp.dcr}
{$R sCtrls.dcr}
{$R sEdits.dcr}
{$R sCombos.dcr}
{$R sPickDate.dcr}
{$R sGlyphList.dcr}
{$R sDBCtrls.dcr}
{$R BUTTONS.RES}

type
   TFilenameProperty = class(TStringProperty)
   protected
      function GetFilter: string; virtual;
   public
      procedure Edit; override;
      function GetAttributes: TPropertyAttributes; override;
   end;

   TDirnameProperty = class(TStringProperty)
   public
      procedure Edit; override;
      function GetAttributes: TPropertyAttributes; override;
   end;

function TFilenameProperty.GetFilter: string;
begin
   Result := SDefaultFilesFilter;
end;

procedure TFilenameProperty.Edit;
var
   FileOpen: TOpenDialog;
begin
   FileOpen := TOpenDialog.Create(Application);
   try
      FileOpen.Filename := GetValue;
      FileOpen.InitialDir := ExtractFilePath(FileOpen.Filename);
      if (ExtractFileName(FileOpen.Filename) = '') or not
         ValidFileName(ExtractFileName(FileOpen.Filename)) then
         FileOpen.Filename := '';
      FileOpen.Filter := GetFilter;
      FileOpen.Options := FileOpen.Options + [ofHideReadOnly];
      if FileOpen.Execute then
         SetValue(FileOpen.Filename);
   finally
      FileOpen.Free;
   end;
end;

function TFilenameProperty.GetAttributes: TPropertyAttributes;
begin
   Result := [paDialog, paRevertable];
end;

{ TDirnameProperty }

procedure TDirnameProperty.Edit;
var
   FolderName: string;
begin
   FolderName := GetValue;
   if BrowseDirectory(FolderName, SBrowseCaption) then
      SetValue(FolderName);
end;

function TDirnameProperty.GetAttributes: TPropertyAttributes;
begin
   Result := [paDialog, paRevertable];
end;

type
   TTransRefresher = class(TDefaultEditor)
   public
      procedure ExecuteVerb(Index : Integer); override;
      function GetVerb(Index : Integer): string; override;
      function GetVerbCount : Integer; override;
      procedure Edit; override;
   end;

procedure TTransRefresher.ExecuteVerb(Index: Integer);
begin
   if Index <> 0 then
      Exit;
   Edit;
end;

function TTransRefresher.GetVerb(Index: Integer): AnsiString;
begin
   Result := STransRefreshEditor;
end;

function TTransRefresher.GetVerbCount: Integer;
begin
   Result := 1;
end;

procedure TTransRefresher.Edit;
begin
   TsTransControl(Component).ForceRefresh;
//   RefreshTransControls(TsTransControl(Component).Parent);
end;

procedure Register;
begin
   RegisterComponents(SEditToolsPageCaption, [TsEdit, TsLinkEdit, TsMaskLinkEdit, TsDateEdit,
         TsNumberEdit, TsFilenameEdit, TsDirectoryEdit, TsMemo]);
   RegisterComponents(SEditToolsPageCaption, [TsComboBox, TsColorComboBox,
         TsFontComboBox, TsPathComboBox]);
   RegisterComponents(SEditToolsPageCaption, [TsCheckBox, TsRadioButton, TsLabel, TsSpeedButton,
         TsStatusBar]);
   RegisterComponents(SEditToolsPageCaption, [TsCalendar]);
   RegisterComponents(SEditToolsPageCaption, [TTiledBmp, TsGlyphList]);

   {Database components}
   RegisterComponents(sDBEditToolsPageCaption, [TsDBEdit, TsDBLinkEdit, TsDBDateEdit,
      TsDBNumberEdit, TsDBMaskLinkEdit,
   	TsDBCheckBox, TsDBText, TsDBMemo]);

   {Property editors}
   RegisterPropertyEditor( TypeInfo(string), TsFileNameEdit, 'Filter', TFilterProperty);
   RegisterPropertyEditor( TypeInfo(string), TsFileNameEdit, 'Path', TFilenameProperty);
   RegisterPropertyEditor( TypeInfo(string), TsDirectoryEdit, 'Path', TDirnameProperty);
   RegisterPropertyEditor( TypeInfo(string), TsFileDirEdit, 'InitialDir', TDirnameProperty);
   RegisterPropertyEditor( TypeInfo(string), TsPathComboBox, 'Path', TDirnameProperty);
   RegisterPropertyEditor( TypeInfo(string), TsCustomMaskEdit, 'EditMask', TMaskProperty);
   //RegisterPropertyEditor( TypeInfo(TsGlyphCollection), TsGlyphList, 'List', TGlyphListProperty);
	RegisterPropertyEditor( TypeInfo(Integer), TPersistent, 'GlyphListId', TGlyphIdProperty);

   {Component editors}
   RegisterComponentEditor(TsGlyphList, TGlyphsListEditor);
   RegisterComponentEditor(TsTransControl, TTransRefresher);
end;

end.
